/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.data;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.da.DaOpsumListBigDataReDomain;
import cn.com.qj.bff.domain.da.DaOpsumListDomain;
import cn.com.qj.bff.domain.da.DaOpsumListReDomain;
import cn.com.qj.bff.domain.da.DaOpsumReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.service.da.DaOpsumListService;
import cn.com.qj.bff.service.da.DaOpsumService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opsumlist"}, name="\u6c47\u603b\u6570\u636e\u660e\u7ec6")
public class OpsumlistCon
extends SpringmvcController {
    private static String CODE = "da.opsumlist.con";
    @Autowired
    private DaOpsumListService daOpsumListService;
    @Autowired
    private DaOpsumService daOpsumService;
    @Autowired
    private OcRefundService ocRefundService;
    @Autowired
    private OcContractService ocContractService;

    @Override
    protected String getContext() {
        return "opsumlist";
    }

    @RequestMapping(value={"saveOpsumlist.json"}, name="\u589e\u52a0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".saveOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListService.saveOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"getOpsumlist.json"}, name="\u83b7\u53d6\u6c47\u603b\u6570\u636e\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public DaOpsumListReDomain getOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".getOpsumlist", (Object)"param is null");
            return null;
        }
        return this.daOpsumListService.getOpsumList(opsumlistId);
    }

    @RequestMapping(value={"updateOpsumlist.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".updateOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListService.updateOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"deleteOpsumlist.json"}, name="\u5220\u9664\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".deleteOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListService.deleteOpsumList(opsumlistId);
    }

    @RequestMapping(value={"queryOpsumlistPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    @RequestMapping(value={"updateOpsumlistState.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlistState(String opsumlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsumlistId)) {
            this.logger.error(CODE + ".updateOpsumlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListService.updateOpsumListState(Integer.valueOf(opsumlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOpsumListPageForPlat.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u79df\u6237")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForPlat(HttpServletRequest request, String sumType) {
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(tenantCode, sumType, tenantCode, "\u79df\u6237");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForUser.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5356\u5bb6")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForUser(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request), "\u7528\u6237");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForYunying.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForYunying(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request), "\u8fd0\u8425");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    private Map<String, Object> queryOpsumListPageComm(String userPcode, String sumType, String tenantCode, String opsumDimname) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("opsumDate", formatDateLast);
        param.put("opsumType", sumType);
        param.put("opsumDimcode", userPcode);
        param.put("opsumDimname", opsumDimname);
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult = this.daOpsumService.queryOpsumPage(param);
        if (null == daOpsumReDomainSupQueryResult || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.info(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult", (Object)"result is null");
            this.logger.error(CODE + ".queryOpsumListPageComm.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
            return this.queryOpsumListPageCommToday(userPcode, sumType, tenantCode, resultMap);
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        map.put("opsumDate", formatDateLast);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultLast = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> daOpsumListReDomainSupQueryResult = this.daOpsumListService.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            List list = daOpsumListReDomainSupQueryResult.getList();
            for (DaOpsumListReDomain daOpsumListReDomain : list) {
                daOpsumListReDomain.setOpsumDate("\u6628\u65e5");
                daOpsumListReDomainsResultLast.add(daOpsumListReDomain);
            }
        }
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("order", true);
        paramToday.put("opsumDate", today);
        paramToday.put("opsumType", sumType);
        paramToday.put("opsumDimcode", userPcode);
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult2 = this.daOpsumService.queryOpsumPage(paramToday);
        if (null == daOpsumReDomainSupQueryResult2 || daOpsumReDomainSupQueryResult2.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult2", (Object)"result is null");
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", "0");
            return resultMap;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)daOpsumReDomainSupQueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, Object> mapmap = new HashMap<String, Object>();
        mapmap.put("opsumCode", opsumCodeToday);
        mapmap.put("tenantCode", tenantCode);
        mapmap.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> todayResult = this.daOpsumListService.queryOpsumListPage(mapmap);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    private Map<String, Object> queryOpsumListPageCommToday(String userPcode, String sumType, String tenantCode, Map<String, Object> resultMap) {
        SupQueryResult<DaOpsumReDomain> QueryResult2;
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        String pattern = "yyyy-MM-dd";
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("order", true);
            param.put("opsumDate", today);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", userPcode);
        }
        if (null == (QueryResult2 = this.daOpsumService.queryOpsumPage(param)) || QueryResult2.getList().isEmpty()) {
            this.logger.error(CODE + "queryOpsumListPageCommToday.QueryResult.QueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)QueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        paramToday.put("opsumCode", opsumCodeToday);
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> todayResult = this.daOpsumListService.queryOpsumListPage(paramToday);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", "0");
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumListNextPageForSeller.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForSeller(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForSellerparam is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForSellerresult is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForBusiness.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForBusiness(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusinessparam is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusinessresult is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForPlat.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForPlat(HttpServletRequest request, String sumType) {
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForPlatparam is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if ("091".equals(this.getProappCode(request))) {
            SupQueryResult<DaOpsumListReDomain> result = this.makeWaitTask(request, tenantCode);
            return result;
        }
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(tenantCode, sumType, tenantCode);
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForPlatresult is null");
            return null;
        }
        return result;
    }

    private SupQueryResult<DaOpsumListReDomain> makeWaitTask(HttpServletRequest request, String tenantCode) {
        UserSession userSession = this.getUserSession(request);
        SupQueryResult domainSupQueryResult = new SupQueryResult();
        if (userSession == null) {
            return null;
        }
        ArrayList<DaOpsumListReDomain> opsumListReDomains = new ArrayList<DaOpsumListReDomain>();
        CompletableFuture<DaOpsumListReDomain> unpaidFuture = CompletableFuture.supplyAsync(() -> {
            DaOpsumListReDomain unpaid = new DaOpsumListReDomain();
            HashMap<String, Object> ocParam = new HashMap<String, Object>();
            ocParam.put("memberCcode", userSession.getUserPcode());
            ocParam.put("dataState", 1);
            ocParam.put("tenantCode", tenantCode);
            SupQueryResult<OcContractReDomain> queryContractPage = this.ocContractService.queryContractPage(ocParam);
            if (queryContractPage != null && ListUtil.isNotEmpty((Collection)queryContractPage.getList())) {
                unpaid.setOpsetType("OcContract");
                unpaid.setOpsetName("OcContract");
                unpaid.setOpsumListNum(new BigDecimal(queryContractPage.getList().size()));
            }
            return unpaid;
        });
        CompletableFuture<DaOpsumListReDomain> goodsToBeDispatchedFuture = CompletableFuture.supplyAsync(() -> {
            DaOpsumListReDomain goodsToBeDispatched = new DaOpsumListReDomain();
            HashMap<String, Object> ocParam = new HashMap<String, Object>();
            ocParam.put("memberCcode", userSession.getUserPcode());
            ocParam.put("dataState", 2);
            ocParam.put("tenantCode", tenantCode);
            SupQueryResult<OcContractReDomain> queryContractPage = this.ocContractService.queryContractPage(ocParam);
            if (queryContractPage != null && ListUtil.isNotEmpty((Collection)queryContractPage.getList())) {
                goodsToBeDispatched.setOpsetType("OcContractSend");
                goodsToBeDispatched.setOpsetName("OcContractSend");
                goodsToBeDispatched.setOpsumListNum(new BigDecimal(queryContractPage.getList().size()));
            }
            return goodsToBeDispatched;
        });
        CompletableFuture<DaOpsumListReDomain> underReviewFuture = CompletableFuture.supplyAsync(() -> {
            DaOpsumListReDomain underReview = new DaOpsumListReDomain();
            HashMap<String, Object> ocParam = new HashMap<String, Object>();
            ocParam.put("memberCcode", userSession.getUserPcode());
            ocParam.put("dataState", 0);
            ocParam.put("tenantCode", tenantCode);
            SupQueryResult<OcRefundReDomain> queryRefundPage = this.ocRefundService.queryRefundPage(ocParam);
            if (queryRefundPage != null && ListUtil.isNotEmpty((Collection)queryRefundPage.getList())) {
                underReview.setOpsetType("OcRefund");
                underReview.setOpsetName("OcRefund");
                underReview.setOpsumListNum(new BigDecimal(queryRefundPage.getList().size()));
            }
            return underReview;
        });
        CompletableFuture.allOf(unpaidFuture, goodsToBeDispatchedFuture, underReviewFuture);
        try {
            opsumListReDomains.add(unpaidFuture.get());
            opsumListReDomains.add(goodsToBeDispatchedFuture.get());
            opsumListReDomains.add(underReviewFuture.get());
            domainSupQueryResult.setList(opsumListReDomains);
            domainSupQueryResult.setRows(opsumListReDomains);
            domainSupQueryResult.setTotal((long)opsumListReDomains.size());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return domainSupQueryResult;
    }

    private SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageComm(String opsumDimcode, String sumType, String tenantCode) {
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("order", true);
            param.put("tenantCode", tenantCode);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", opsumDimcode);
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumService.queryOpsumPage(param)) || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListNextPageForPlat.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumCode", opsumCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult<DaOpsumListReDomain> daOpsumListReDomainSupQueryResult = this.daOpsumListService.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            return daOpsumListReDomainSupQueryResult;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumlistPageNewForBus.json"}, name="\u67e5\u8be2\u8fd0\u8425\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForBus(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        String tenantCode = this.getTenantCode(request);
        String userPcode = this.getUserSession(request).getUserinfoParentCode();
        if (StringUtils.isBlank((String)userPcode)) {
            userPcode = this.getUserSession(request).getUserPcode();
        }
        param.put("opsumDimcode", userPcode);
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", "opsum_Date");
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", "all");
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", "all");
        }
        if (null == param.get("opsumDate") || StringUtils.isBlank((String)param.get("opsumDate").toString())) {
            param.put("opsumDate", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        param.put("tenantCode", tenantCode);
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageNewForPlat.json"}, name="\u67e5\u8be2\u5e73\u53f0\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        String tenantCode = this.getTenantCode(request);
        param.put("opsumDimcode", tenantCode);
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", "opsum_Date");
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", "all");
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", "all");
        }
        if (null != param.get("startDate") && null != param.get("endDate")) {
            Date startDate = DateUtil.getDateToString((String)String.valueOf(param.get("startDate")), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.getDateToString((String)String.valueOf(param.get("endDate")), (String)"yyyy-MM-dd");
            List<Date> dates = OpsumlistCon.findDates(startDate, endDate);
            String opsumDate = "";
            if (ListUtil.isNotEmpty(dates)) {
                for (Date date : dates) {
                    opsumDate = opsumDate + DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + ",";
                }
                opsumDate = opsumDate.substring(0, opsumDate.length() - 1);
            }
            param.put("opsumDate", opsumDate);
        } else {
            param.put("opsumDate", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        param.put("tenantCode", tenantCode);
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static void main(String[] args) {
        OpsumlistCon.findDates(new Date(), new Date());
    }

    @RequestMapping(value={"queryOpsumlistPageNewForUser.json"}, name="\u67e5\u8be2\u7528\u6237\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        String userPcode = this.getUserSession(request).getUserPcode();
        String tenantCode = this.getTenantCode(request);
        param.put("opsumDimcode", userPcode);
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", "opsum_Date");
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", "all");
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", "all");
        }
        if (null != param.get("startDate") && null != param.get("endDate")) {
            Date startDate = DateUtil.getDateToString((String)String.valueOf(param.get("startDate")), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.getDateToString((String)String.valueOf(param.get("endDate")), (String)"yyyy-MM-dd");
            List<Date> dates = OpsumlistCon.findDates(startDate, endDate);
            String opsumDate = "";
            if (ListUtil.isNotEmpty(dates)) {
                for (Date date : dates) {
                    opsumDate = opsumDate + DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + ",";
                }
                opsumDate = opsumDate.substring(0, opsumDate.length() - 1);
            }
            param.put("opsumDate", opsumDate);
        } else {
            param.put("opsumDate", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        param.put("tenantCode", tenantCode);
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageForAtPoPrice.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u6b63\u5411\u6ea2\u4ef7\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListBigDataReDomain> queryOpsumlistPageForAtPoPrice(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("opsetType", "PoAtGinfoPrice");
            param.put("groupByDate", true);
            param.put("opsumListNumSum", true);
        }
        return this.daOpsumListService.querySimpleOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageForAtRePrice.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u53cd\u5411\u6ea2\u4ef7\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListBigDataReDomain> queryOpsumlistPageForAtRePrice(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("opsetType", "ReAtGinfoPrice");
            param.put("groupByDate", true);
            param.put("opsumListNumSum", true);
        }
        return this.daOpsumListService.querySimpleOpsumListPage(param);
    }
}

