/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.domain.dd;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class DdTimeRangeResponse
implements Serializable {
    private String quarterlyStartTime;
    private String quarterlyEndTime;
    private String ratio;
    private String upperLimitSetting;
    private List<TimeRange> collectionTimeList;
    private String updateByName;

    public String getQuarterlyStartTime() {
        return this.quarterlyStartTime;
    }

    public void setQuarterlyStartTime(String quarterlyStartTime) {
        this.quarterlyStartTime = quarterlyStartTime;
    }

    public String getQuarterlyEndTime() {
        return this.quarterlyEndTime;
    }

    public void setQuarterlyEndTime(String quarterlyEndTime) {
        this.quarterlyEndTime = quarterlyEndTime;
    }

    public String getRatio() {
        return this.ratio;
    }

    public void setRatio(String ratio) {
        this.ratio = ratio;
    }

    public String getUpperLimitSetting() {
        return this.upperLimitSetting;
    }

    public void setUpperLimitSetting(String upperLimitSetting) {
        this.upperLimitSetting = upperLimitSetting;
    }

    public List<TimeRange> getCollectionTimeList() {
        return this.collectionTimeList;
    }

    public void setCollectionTimeList(List<TimeRange> collectionTimeList) {
        this.collectionTimeList = collectionTimeList;
    }

    public String getUpdateByName() {
        return this.updateByName;
    }

    public void setUpdateByName(String updateByName) {
        this.updateByName = updateByName;
    }

    public static boolean isCurrentTimeInCollectionTimeList(DdTimeRangeResponse ddTimeRangeResponse) {
        if (ddTimeRangeResponse == null || ddTimeRangeResponse.getCollectionTimeList() == null) {
            return false;
        }
        List<TimeRange> timeRanges = ddTimeRangeResponse.getCollectionTimeList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now();
        for (TimeRange range : timeRanges) {
            String startStr = range.getStartTime();
            String endStr = range.getEndTime();
            if (startStr == null || endStr == null) continue;
            try {
                LocalDate startDate = LocalDate.parse(startStr, formatter);
                LocalDate endDate = LocalDate.parse(endStr, formatter);
                if (now.isBefore(startDate) || now.isAfter(endDate)) continue;
                return true;
            }
            catch (Exception e) {
                System.err.println("\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u5931\u8d25\uff1astartTime=" + startStr + ", endTime=" + endStr);
                e.printStackTrace();
            }
        }
        return false;
    }

    public static class TimeRange {
        private String startTime;
        private String endTime;

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }
}

