/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wh;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreGoodsDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreReDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreSkuDomain;
import cn.com.qj.bff.domain.wh.WhOpstoreSkuReDomain;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.wh.WhOpstoreService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class WhOpstoreComCon
extends SpringmvcController {
    private static final String CODE = "wh.opstore.con";
    @Autowired
    private WhOpstoreService whOpstoreService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;

    @Override
    protected String getContext() {
        return "opstore";
    }

    public String make(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            return "error";
        }
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return "error";
        }
        if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            HashMap<String, WhOpstoreGoodsDomain> goodsmap = new HashMap<String, WhOpstoreGoodsDomain>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", whOpstoreDomain.getTenantCode());
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList;
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)goodsmap.get(whOpstoreSkuDomain.getGoodsCode());
                if (null == whOpstoreGoodsDomain) {
                    map.put("goodsCode", whOpstoreSkuDomain.getGoodsCode());
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                    if (null == rsResourceGoodsReDomain) {
                        return "error:" + ((Object)map).toString();
                    }
                    whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)rsResourceGoodsReDomain);
                    }
                    catch (Exception e) {
                        return "error1:" + ((Object)map).toString();
                    }
                    goodsmap.put(whOpstoreSkuDomain.getGoodsCode(), whOpstoreGoodsDomain);
                }
                if (null == (whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                    whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
                    whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
                }
                whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
            }
            if (MapUtil.isEmpty(goodsmap)) {
                return "error3";
            }
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            for (String goodsCode : goodsmap.keySet()) {
                whOpstoreGoodsDomainList.add((WhOpstoreGoodsDomain)goodsmap.get(goodsCode));
            }
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        }
        BigDecimal num = BigDecimal.ZERO;
        BigDecimal weight = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal mainnum = BigDecimal.ZERO;
        BigDecimal mainweight = BigDecimal.ZERO;
        BigDecimal mainamt = BigDecimal.ZERO;
        for (WhOpstoreGoodsDomain whOpstoreGoodsReDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            num = BigDecimal.ZERO;
            weight = BigDecimal.ZERO;
            amt = BigDecimal.ZERO;
            for (WhOpstoreSkuDomain whOpstoreSkuReDomain : whOpstoreGoodsReDomain.getWhOpstoreSkuDomainList()) {
                if (null == whOpstoreSkuReDomain.getGoodsNum()) {
                    whOpstoreSkuReDomain.setGoodsNum(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getGoodsWeight()) {
                    whOpstoreSkuReDomain.setGoodsWeight(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getPricesetNprice()) {
                    whOpstoreSkuReDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                num = num.add(whOpstoreSkuReDomain.getGoodsNum());
                weight = weight.add(whOpstoreSkuReDomain.getGoodsWeight());
                amt = amt.add(whOpstoreSkuReDomain.getPricesetNprice().multiply(whOpstoreSkuReDomain.getGoodsNum()));
            }
            whOpstoreGoodsReDomain.setGoodsNum(num);
            whOpstoreGoodsReDomain.setGoodsWeight(weight);
            mainnum = mainnum.add(num);
            mainweight = mainweight.add(weight);
            mainamt = mainamt.add(amt);
        }
        whOpstoreDomain.setGoodsNum(mainnum);
        whOpstoreDomain.setGoodsWeight(mainweight);
        whOpstoreDomain.setGoodsAmt(mainamt);
        return null;
    }

    protected HtmlJsonReBean saveOpstoreMain(HttpServletRequest request, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.opstore.con.saveOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession");
        }
        whOpstoreDomain.setMemberCode(userSession.getUserPcode());
        whOpstoreDomain.setMemberName(userSession.getMerberCompname());
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        String msg = this.make(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
        }
        this.logger.error("wh.opstore.con.saveOpstore", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return this.whOpstoreService.saveOpstore(whOpstoreDomain);
    }

    protected HtmlJsonReBean saveOpstoreStrMain(HttpServletRequest request, String whOpstoreDomainStr) {
        if (StringUtils.isBlank((String)whOpstoreDomainStr)) {
            this.logger.error("wh.opstore.con.saveOpstoreStrMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(whOpstoreDomainStr, WhOpstoreDomain.class);
        if (null == whOpstoreDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "whOpstoreDomain");
        }
        return this.saveOpstoreMain(request, whOpstoreDomain);
    }

    protected HtmlJsonReBean updateOpstoreStrMain(HttpServletRequest request, String whOpstoreDomainStr) {
        if (StringUtils.isBlank((String)whOpstoreDomainStr)) {
            this.logger.error("wh.opstore.con.updateOpstoreStrMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(whOpstoreDomainStr, WhOpstoreDomain.class);
        if (null == whOpstoreDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "whOpstoreDomain");
        }
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        return this.whOpstoreService.updateOpstore(whOpstoreDomain);
    }

    protected WhOpstoreReDomain getOpstoreMain(Integer opstoreId) {
        if (StringUtils.isBlank((Integer)opstoreId)) {
            this.logger.error("wh.opstore.con.getOpstoreMain", (Object)"param is null");
            return null;
        }
        return this.whOpstoreService.getOpstore(opstoreId);
    }

    protected HtmlJsonReBean updateOpstoreMain(HttpServletRequest request, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.opstore.con.updateOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        whOpstoreDomain.setTenantCode(this.getTenantCode(request));
        return this.whOpstoreService.updateOpstore(whOpstoreDomain);
    }

    protected HtmlJsonReBean deleteOpstoreMain(Integer opstoreId) {
        if (StringUtils.isBlank((Integer)opstoreId)) {
            this.logger.error("wh.opstore.con.deleteOpstoreMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whOpstoreService.deleteOpstore(opstoreId);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePageCom(HttpServletRequest request, String storeGoodsBtype) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)((String)param.get("storeGoodsBtype")))) {
                storeGoodsBtype = param.get("storeGoodsBtype").toString();
            }
            if (StringUtils.isNotBlank((String)storeGoodsBtype)) {
                param.put("storeGoodsBtype", storeGoodsBtype);
            }
        }
        return this.whOpstoreService.queryOpstorePage(param);
    }

    protected SupQueryResult<WhOpstoreReDomain> queryOpstorePageMain(HttpServletRequest request, String storeGoodsBtype) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)storeGoodsBtype)) {
                param.put("storeGoodsBtype", storeGoodsBtype);
            }
        }
        return this.whOpstoreService.queryOpstorePage(param);
    }

    protected SupQueryResult<WhOpstoreSkuReDomain> queryOpstoreSkuPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.whOpstoreService.queryOpstoreSkuPage(param);
    }

    protected HtmlJsonReBean updateOpstoreStateMain(String opstoreId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opstoreId)) {
            this.logger.error("wh.opstore.con.updateOpstoreStateMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.whOpstoreService.updateOpstoreState(Integer.valueOf(opstoreId), dataState, oldDataState, null);
    }
}

