/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.gd;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cs.CsConsultListReDomain;
import cn.com.qj.bff.domain.cs.CsConsultReDomain;
import cn.com.qj.bff.domain.gd.GdRsinfoDomain;
import cn.com.qj.bff.domain.gd.GdRsinfoFileDomain;
import cn.com.qj.bff.domain.gd.GdRsinfoReDomain;
import cn.com.qj.bff.service.cs.CsConsultService;
import cn.com.qj.bff.service.gd.GdRsinfoService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gd/rsinfo"}, name="\u7ade\u4ef7\u4f9b\u6c42")
public class RsinfoCon
extends SpringmvcController {
    private static String CODE = "gd.rsinfo.con";
    @Autowired
    private GdRsinfoService gdRsinfoService;
    @Autowired
    private CsConsultService csConsultService;

    @Override
    protected String getContext() {
        return "rsinfo";
    }

    @RequestMapping(value={"saveRsinfo.json"}, name="\u589e\u52a0\u7ade\u4ef7\u4f9b\u6c42")
    @ResponseBody
    public HtmlJsonReBean saveRsinfo(HttpServletRequest request, GdRsinfoDomain gdRsinfoDomain) {
        if (null == gdRsinfoDomain) {
            this.logger.error(CODE + ".saveRsinfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        gdRsinfoDomain.setTenantCode(this.getTenantCode(request));
        gdRsinfoDomain.setMemberCcode(userSession.getUserPcode());
        gdRsinfoDomain.setMemberCname(userSession.getMerberCompname());
        return this.gdRsinfoService.saveRsinfo(gdRsinfoDomain);
    }

    @RequestMapping(value={"getRsinfo.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u4f9b\u6c42\u4fe1\u606f")
    @ResponseBody
    public GdRsinfoReDomain getRsinfo(Integer rsinfoId) {
        if (StringUtils.isBlank((Integer)rsinfoId)) {
            this.logger.error(CODE + ".getRsinfo", (Object)"param is null");
            return null;
        }
        return this.gdRsinfoService.getRsinfo(rsinfoId);
    }

    @RequestMapping(value={"updateRsinfo.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4f9b\u6c42")
    @ResponseBody
    public HtmlJsonReBean updateRsinfo(HttpServletRequest request, GdRsinfoDomain gdRsinfoDomain) {
        if (null == gdRsinfoDomain) {
            this.logger.error(CODE + ".updateRsinfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        gdRsinfoDomain.setTenantCode(this.getTenantCode(request));
        return this.gdRsinfoService.updateRsinfo(gdRsinfoDomain);
    }

    @RequestMapping(value={"deleteRsinfo.json"}, name="\u5220\u9664\u7ade\u4ef7\u4f9b\u6c42")
    @ResponseBody
    public HtmlJsonReBean deleteRsinfo(Integer rsinfoId) {
        if (StringUtils.isBlank((Integer)rsinfoId)) {
            this.logger.error(CODE + ".deleteRsinfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gdRsinfoService.deleteRsinfo(rsinfoId);
    }

    @RequestMapping(value={"queryRsinfoPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u4f9b\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GdRsinfoReDomain> queryRsinfoPage(HttpServletRequest request) {
        return this.queryRsinfoPageModelBySort(request, null);
    }

    @RequestMapping(value={"updateRsinfoState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4f9b\u6c42\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRsinfoState(String rsinfoId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)rsinfoId)) {
            this.logger.error(CODE + ".updateRsinfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gdRsinfoService.updateRsinfoState(Integer.valueOf(rsinfoId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveRsinfoByJson.json"}, name="\u589e\u52a0\u7ade\u4ef7\u4f9b\u6c42")
    @ResponseBody
    public HtmlJsonReBean saveRsinfoByJson(HttpServletRequest request, String paramStr) {
        GdRsinfoDomain gdRsinfoDomain = (GdRsinfoDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, GdRsinfoDomain.class);
        if (null == gdRsinfoDomain) {
            this.logger.error(CODE + ".saveRsinfoByJson", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        gdRsinfoDomain.setTenantCode(tenantCode);
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        String memeberName = userSession.getUserName();
        gdRsinfoDomain.setMemberCode(memberCode);
        gdRsinfoDomain.setMemberName(memeberName);
        gdRsinfoDomain.setMemberCcode(memberCode);
        gdRsinfoDomain.setMemberCname(userSession.getMerberCompname());
        String channelCode = this.getChannelCode(request);
        gdRsinfoDomain.setChannelCode(channelCode);
        gdRsinfoDomain.setChannelName(this.getChannelName(channelCode, request));
        if (ListUtil.isNotEmpty(gdRsinfoDomain.getGdRsinfoFileDomainList())) {
            for (GdRsinfoFileDomain gdRsinfoFileDomain : gdRsinfoDomain.getGdRsinfoFileDomainList()) {
                gdRsinfoFileDomain.setTenantCode(tenantCode);
                gdRsinfoFileDomain.setMemberCode(memberCode);
                gdRsinfoFileDomain.setMemberName(memeberName);
            }
        }
        return this.gdRsinfoService.saveRsinfo(gdRsinfoDomain);
    }

    @RequestMapping(value={"updateRsinfoStateToSuccess.json"}, name="\u6279\u51c6\u5ba1\u6838\u4f9b\u6c42\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateRsinfoStateToSuccess(HttpServletRequest request, String rsinfoId) {
        if (StringUtils.isBlank((String)rsinfoId)) {
            this.logger.error(CODE + ".updateRsinfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserSession userSession = this.getUserSession(request);
        String memberCcode = userSession.getUserPcode();
        String memeberCname = userSession.getUserName();
        map.put("userCode", memberCcode);
        map.put("userName", memeberCname);
        return this.gdRsinfoService.updateRsinfoState(Integer.valueOf(rsinfoId), 0, 1, map);
    }

    @RequestMapping(value={"updateRsinfoStateToFail.json"}, name="\u62d2\u7edd\u5ba1\u6838\u4f9b\u6c42\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateRsinfoStateToFail(HttpServletRequest request, String rsinfoId) {
        if (StringUtils.isBlank((String)rsinfoId)) {
            this.logger.error(CODE + ".updateRsinfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserSession userSession = this.getUserSession(request);
        String memberCcode = userSession.getUserPcode();
        String memeberCname = userSession.getUserName();
        map.put("memberCcode", memberCcode);
        map.put("memeberCname", memeberCname);
        return this.gdRsinfoService.updateRsinfoState(Integer.valueOf(rsinfoId), 2, 1, map);
    }

    @RequestMapping(value={"updateRsinfoStateToReSubmit.json"}, name="\u91cd\u65b0\u63d0\u4ea4\u5ba1\u6838\u4f9b\u6c42\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateRsinfoStateToReSubmit(HttpServletRequest request, String paramStr) {
        GdRsinfoDomain gdRsinfoDomain = (GdRsinfoDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, GdRsinfoDomain.class);
        if (null == gdRsinfoDomain) {
            this.logger.error(CODE + ".updateRsinfoStateToReSubmit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        gdRsinfoDomain.setTenantCode(tenantCode);
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        String memeberName = userSession.getUserName();
        gdRsinfoDomain.setMemberCode(memberCode);
        gdRsinfoDomain.setMemberName(memeberName);
        gdRsinfoDomain.setMemberCcode(memberCode);
        gdRsinfoDomain.setMemberCname(userSession.getMerberCompname());
        String channelCode = this.getChannelCode(request);
        gdRsinfoDomain.setChannelCode(channelCode);
        gdRsinfoDomain.setChannelName(this.getChannelName(channelCode, request));
        if (ListUtil.isNotEmpty(gdRsinfoDomain.getGdRsinfoFileDomainList())) {
            for (GdRsinfoFileDomain gdRsinfoFileDomain : gdRsinfoDomain.getGdRsinfoFileDomainList()) {
                gdRsinfoFileDomain.setTenantCode(tenantCode);
                gdRsinfoFileDomain.setMemberCode(memberCode);
                gdRsinfoFileDomain.setMemberName(memeberName);
            }
        }
        return this.gdRsinfoService.updateRsinfo(gdRsinfoDomain);
    }

    @RequestMapping(value={"updateRsinfoSort.json"}, name="\u5ba1\u6838\u4f9b\u6c42\u4fe1\u606f\u6392\u5e8f")
    @ResponseBody
    public HtmlJsonReBean updateRsinfoSort(HttpServletRequest request, String rsinfoCode, Integer goodsSort) {
        String[] rsinfoCodeList;
        if (StringUtils.isBlank((String)rsinfoCode) || StringUtils.isBlank((Integer)goodsSort)) {
            this.logger.error(CODE + ".updateRsinfoSort", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String rsCode : rsinfoCodeList = rsinfoCode.split(",")) {
            this.gdRsinfoService.updateSotrByCode(this.getTenantCode(request), rsCode, goodsSort);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"updateOpbillstateByCode.json"}, name="\u4f9b\u6c42\u4fe1\u606f\u4e0a\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateOpbillstateByCode(HttpServletRequest request, String rsinfoCode, Integer dataOpbillstate) {
        String[] rsinfoCodeList;
        if (StringUtils.isBlank((String)rsinfoCode) || StringUtils.isBlank((Integer)dataOpbillstate)) {
            this.logger.error(CODE + ".updateOpbillstateByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String rsCode : rsinfoCodeList = rsinfoCode.split(",")) {
            this.gdRsinfoService.updateOpbillstateByCode(this.getTenantCode(request), rsCode, dataOpbillstate);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"deleteRsinfoBatch.json"}, name="\u6279\u91cf\u5220\u9664\u7ade\u4ef7\u4f9b\u6c42")
    @ResponseBody
    public HtmlJsonReBean deleteRsinfoBatch(String rsinfoIdStr) {
        String[] rsinfoIdList;
        if (StringUtils.isBlank((String)rsinfoIdStr)) {
            this.logger.error(CODE + ".deleteRsinfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String rsId : rsinfoIdList = rsinfoIdStr.split(",")) {
            this.gdRsinfoService.deleteRsinfo(Integer.valueOf(rsId));
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"queryRsinfoPageByMem.json"}, name="\u67e5\u8be2\u7528\u6237\u7ade\u4ef7\u4f9b\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GdRsinfoReDomain> queryRsinfoPageByMem(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCode", userSession.getUserPcode());
            param.put("orderStr", "GMT_MODIFIED DESC");
        }
        return this.gdRsinfoService.queryRsinfoPage(param);
    }

    @RequestMapping(value={"queryRsinfoPageByPC.json"}, name="\u67e5\u8be2PC\u5168\u90e8\u7ade\u4ef7\u4f9b\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GdRsinfoReDomain> queryRsinfoPageByPC(HttpServletRequest request) {
        return this.queryRsinfoPageModelBySort(request, null);
    }

    private SupQueryResult<GdRsinfoReDomain> queryRsinfoPageModelBySort(HttpServletRequest request, Integer dataState) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            String[] classtreeCodeList;
            param.put("order", true);
            param.put("fuzzy", true);
            if (null != dataState) {
                param.put("dataState", dataState);
            }
            param.put("orderStr", "GOODS_SORT DESC,GMT_MODIFIED DESC");
            String classtreeCodeStr = (String)param.get("classtreeCodeStr");
            param.remove("classtreeCodeStr");
            if (StringUtils.isNotBlank((String)classtreeCodeStr) && (classtreeCodeList = classtreeCodeStr.split(",")).length > 0) {
                param.put("classtreeCodeStr", classtreeCodeList);
            }
        }
        return this.gdRsinfoService.queryRsinfoPage(param);
    }

    @RequestMapping(value={"queryRsinfoPageByForPcAt.json"}, name="\u67e5\u8be2PC\u9996\u9875\u5ba1\u6838\u901a\u8fc7\u4f9b\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GdRsinfoReDomain> queryRsinfoPageByForPcAt(HttpServletRequest request) {
        return this.queryRsinfoPageModelBySort(request, 0);
    }

    @RequestMapping(value={"queryRsinfoPageByForPc.json"}, name="\u67e5\u8be2\u4f9b\u6c42\u4fe1\u606f\u54a8\u8be2")
    @ResponseBody
    public SupQueryResult<CsConsultReDomain> queryRsinfoPageByForPc(HttpServletRequest request, Integer type) {
        List list;
        Map<String, Object> maps = this.assemMapMemberParam(request);
        ArrayList<String> consultOpcodeStr = new ArrayList<String>();
        if (type != null) {
            maps.put("rsinfoType", type.toString());
        }
        if (ListUtil.isEmpty((Collection)(list = this.gdRsinfoService.queryRsinfoPage(maps).getList()))) {
            return null;
        }
        for (GdRsinfoReDomain gdRsinfoReDomain : list) {
            consultOpcodeStr.add(gdRsinfoReDomain.getRsinfoCode());
        }
        maps.put("consultOpcodeStr", consultOpcodeStr);
        maps.remove("memberCode");
        maps.remove("rsinfoType");
        SupQueryResult<CsConsultReDomain> csConsultReDomainSupQueryResult = this.csConsultService.queryConsultPage(maps);
        this.getConsultReDomainSupQueryResult(request, csConsultReDomainSupQueryResult);
        return csConsultReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryRsinfoPageBuyer.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u4f9b\u6c42\u4fe1\u606f\u54a8\u8be2")
    @ResponseBody
    public SupQueryResult<CsConsultReDomain> queryRsinfoPageBuyer(HttpServletRequest request, Integer type) {
        if (StringUtils.isBlank((Integer)type)) {
            this.logger.error(CODE + ".queryRsinfoPageBuyer", (Object)"type is null");
            return null;
        }
        Map<String, Object> maps = this.assemMapParam(request);
        maps.put("memberBcode", this.getMerchantCode(request));
        ArrayList<String> consultOpcodeStr = new ArrayList<String>();
        maps.put("rsinfoType", type.toString());
        List list = this.gdRsinfoService.queryRsinfoPage(maps).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        for (GdRsinfoReDomain gdRsinfoReDomain : list) {
            consultOpcodeStr.add(gdRsinfoReDomain.getRsinfoCode());
        }
        maps.put("consultOpcodeStr", consultOpcodeStr);
        maps.remove("memberCode");
        maps.remove("rsinfoType");
        SupQueryResult<CsConsultReDomain> csConsultReDomainSupQueryResult = this.csConsultService.queryConsultPage(maps);
        this.getConsultReDomainSupQueryResult(request, csConsultReDomainSupQueryResult);
        return csConsultReDomainSupQueryResult;
    }

    private void getConsultReDomainSupQueryResult(HttpServletRequest request, SupQueryResult<CsConsultReDomain> csConsultReDomainSupQueryResult) {
        if (ListUtil.isNotEmpty((Collection)csConsultReDomainSupQueryResult.getList())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", this.getTenantCode(request));
            for (CsConsultReDomain csConsultReDomain : csConsultReDomainSupQueryResult.getList()) {
                map.put("consultCode", csConsultReDomain.getConsultCode());
                SupQueryResult<CsConsultListReDomain> csConsultListReDomainSupQueryResult = this.csConsultService.queryConsultListPage(map);
                if (!ListUtil.isNotEmpty((Collection)csConsultListReDomainSupQueryResult.getList())) continue;
                csConsultReDomain.setCsConsultListReDomainList(csConsultListReDomainSupQueryResult.getList());
            }
        }
    }
}

