/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.cms;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cms.CmsAdvertiseDomain;
import cn.com.qj.bff.domain.cms.CmsAdvertiseReDomain;
import cn.com.qj.bff.domain.cms.CmsTginfoMenuReDomain;
import cn.com.qj.bff.service.cms.CmsAdvertiseService;
import cn.com.qj.bff.service.cms.CmsTginfoMenuService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cms/advertiseBusiness"}, name="\u95e8\u6237\u5e7f\u544a\u670d\u52a1")
public class AdvertiseBusCon
extends SpringmvcController {
    private static String CODE = "cms.advertise.con";
    @Autowired
    private CmsAdvertiseService cmsAdvertiseService;
    @Autowired
    private CmsTginfoMenuService cmsTginfoMenuService;

    @Override
    protected String getContext() {
        return "advertise";
    }

    @RequestMapping(value={"saveAdvertise.json"}, name="\u589e\u52a0\u95e8\u6237\u5e7f\u544a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveAdvertise(HttpServletRequest request, CmsAdvertiseDomain cmsAdvertiseDomain) {
        if (null == cmsAdvertiseDomain) {
            this.logger.error(CODE + ".saveAdvertise", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (!StringUtils.isEmpty((String)cmsAdvertiseDomain.getTginfoMenuCode())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("menuOpcode", cmsAdvertiseDomain.getTginfoMenuCode());
            param.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<CmsTginfoMenuReDomain> result = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
            if (null == result.getList() || result.getList().size() == 0) {
                this.logger.error(CODE + ".saveAdvertise", (Object)"\u680f\u76ee\u4e0d\u5b58\u5728\uff01");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u680f\u76ee\u4e0d\u5b58\u5728\uff01");
            }
        }
        cmsAdvertiseDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsAdvertiseService.saveadvertise(cmsAdvertiseDomain);
    }

    @RequestMapping(value={"getAdvertise.json"}, name="\u83b7\u53d6\u95e8\u6237\u5e7f\u544a\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CmsAdvertiseReDomain getAdvertise(Integer advertiseId) {
        if (StringUtils.isBlank((Integer)advertiseId)) {
            this.logger.error(CODE + ".getAdvertise", (Object)"param is null");
            return null;
        }
        return this.cmsAdvertiseService.getadvertise(advertiseId);
    }

    @RequestMapping(value={"updateAdvertise.json"}, name="\u66f4\u65b0\u95e8\u6237\u5e7f\u544a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateAdvertise(HttpServletRequest request, CmsAdvertiseDomain cmsAdvertiseDomain) {
        if (null == cmsAdvertiseDomain) {
            this.logger.error(CODE + ".updateAdvertise", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsAdvertiseDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsAdvertiseService.updateadvertise(cmsAdvertiseDomain);
    }

    @RequestMapping(value={"deleteAdvertise.json"}, name="\u5220\u9664\u95e8\u6237\u5e7f\u544a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteAdvertise(Integer advertiseId) {
        if (StringUtils.isBlank((Integer)advertiseId)) {
            this.logger.error(CODE + ".deleteAdvertise", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsAdvertiseService.deleteadvertise(advertiseId);
    }

    @RequestMapping(value={"queryAdvertisePage.json"}, name="\u67e5\u8be2\u95e8\u6237\u5e7f\u544a\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsAdvertiseReDomain> queryAdvertisePage(HttpServletRequest request) {
        SupQueryResult<CmsAdvertiseReDomain> result;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != (result = this.cmsAdvertiseService.queryadvertisePage(param)).getList() && result.getList().size() > 0) {
            String tenantCode = this.getTenantCode(request);
            for (CmsAdvertiseReDomain cmsAdvertiseReDomain : result.getList()) {
                String tginfoMenuCode = cmsAdvertiseReDomain.getTginfoMenuCode();
                CmsTginfoMenuReDomain menu = this.cmsTginfoMenuService.getTginfoMenuByCode(tenantCode, tginfoMenuCode);
                if (null == menu || null == menu.getTginfoMenuName()) continue;
                cmsAdvertiseReDomain.setTginfoMenuName(menu.getTginfoMenuName());
            }
        }
        return result;
    }

    @RequestMapping(value={"updateAdvertiseState.json"}, name="\u66f4\u65b0\u95e8\u6237\u5e7f\u544a\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAdvertiseState(String advertiseId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)advertiseId)) {
            this.logger.error(CODE + ".updateAdvertiseState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsAdvertiseService.updateadvertiseState(Integer.valueOf(advertiseId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateReleaseadvertise.json"}, name="\u53d1\u5e03\u5e7f\u544a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateReleaseadvertise(HttpServletRequest request, String advertiseId) {
        if (StringUtils.isBlank((String)advertiseId)) {
            this.logger.error(CODE + ".updateReleaseadvertise", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userCode = this.getUserInfo(request).getUserCode();
        return this.cmsAdvertiseService.updateReleaseadvertise(Integer.valueOf(advertiseId), userCode, 2);
    }

    @RequestMapping(value={"disableAdvertiseState.json"}, name="\u505c\u7528\u5e7f\u544a\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean disableAdvertiseState(String advertiseId) {
        if (StringUtils.isBlank((String)advertiseId)) {
            this.logger.error(CODE + ".disableTginfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsAdvertiseService.updateadvertiseState(Integer.valueOf(advertiseId), 0, 2);
    }
}

