/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.at;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.at.AtAuctionCommissionDomain;
import cn.com.qj.bff.domain.at.AtAuctionEnrollReDomain;
import cn.com.qj.bff.domain.at.AtAuctionGinfoReDomain;
import cn.com.qj.bff.domain.at.AtAuctionReDomain;
import cn.com.qj.bff.domain.at.AtAuctionUserginfoReDomain;
import cn.com.qj.bff.domain.at.AtAuctionWinReDomain;
import cn.com.qj.bff.domain.at.AtAuctiondtChildDomain;
import cn.com.qj.bff.domain.at.AtAuctiondtDomain;
import cn.com.qj.bff.domain.at.AtAuctiondtReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoSimpleDomain;
import cn.com.qj.bff.domain.vd.VdFaccountInfo;
import cn.com.qj.bff.domain.vd.VdFaccountOuterSubsetDomain;
import cn.com.qj.bff.service.at.AtAuctionEnrollService;
import cn.com.qj.bff.service.at.AtAuctionService;
import cn.com.qj.bff.service.at.AtAuctionUserginfoService;
import cn.com.qj.bff.service.at.AtAuctionWinService;
import cn.com.qj.bff.service.at.AtAuctiondtService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.vd.VdFaccountService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctiondt"}, name="\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
public class AuctiondtCon
extends SpringmvcController {
    private static String CODE = "at.auctiondt.con";
    @Autowired
    private AtAuctiondtService atAuctiondtService;
    @Autowired
    private VdFaccountService vdFaccountService;
    @Autowired
    private AtAuctionEnrollService atAuctionEnrollService;
    @Autowired
    private AtAuctionService atAuctionService;
    @Autowired
    private AtAuctionUserginfoService atAuctionUserginfoService;
    @Autowired
    private AtAuctionWinService atAuctionWinService;
    @Autowired
    private UserService userService;

    @Override
    protected String getContext() {
        return "auctiondt";
    }

    @RequestMapping(value={"getAuctionCommissionInfoByCode.json"}, name="\u6839\u636e\u4e70\u5bb6\u53f7\u3001\u573a\u6b21\u53f7\u67e5\u8be2\u7ade\u4ef7\u4f63\u91d1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getAuctionCommissionInfo(HttpServletRequest request, String auctionCode, String memberBcode) {
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain auctionReDomain = this.atAuctionService.getatAuctionByCode(tenantCode, auctionCode);
        if (null == auctionReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u65e0\u516c\u544a\u4fe1\u606f\uff01");
        }
        Integer auctionruleBuydp = auctionReDomain.getAuctionruleBuydp();
        BigDecimal depositAmount = this.getUserDepositAmount(auctionCode, memberBcode, tenantCode, "1");
        AtAuctionCommissionDomain commissionDomain = new AtAuctionCommissionDomain();
        commissionDomain.setAuctionCode(auctionReDomain.getAuctionCode());
        commissionDomain.setAuctionName(auctionReDomain.getAuctionName());
        commissionDomain.setAuctionruleBuydp(auctionruleBuydp);
        commissionDomain.setAuctionruleDptype(auctionReDomain.getAuctionruleDptype());
        commissionDomain.setTenantCode(auctionReDomain.getTenantCode());
        if (auctionruleBuydp == 0) {
            commissionDomain.setAuctionruleDpnum(depositAmount.longValue());
            commissionDomain.setAuctionruleBuydpnum(new BigDecimal("0.00"));
        } else if (auctionruleBuydp == 1) {
            BigDecimal auctionDtDpnum = this.getUserCommissionAmount(memberBcode, auctionCode, tenantCode);
            commissionDomain.setAuctionruleDpnum(depositAmount.longValue());
            commissionDomain.setAuctionruleBuydpnum(auctionDtDpnum);
        } else if (auctionruleBuydp == 2) {
            commissionDomain.setAuctionruleDpnum(depositAmount.longValue());
            commissionDomain.setAuctionruleBuydpnum(auctionReDomain.getAuctionruleBuydpnum());
        }
        return new HtmlJsonReBean((Object)commissionDomain);
    }

    @RequestMapping(value={"saveAuctiondtCommission.json"}, name="\u4f63\u91d1\u6536\u53d6\u9012\u4ea4\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean saveAuctiondtCommission(HttpServletRequest request, Integer auctionWinId, String memberBcode, String auctionCode) {
        if (null == memberBcode || null == auctionCode || null == auctionWinId) {
            this.logger.error(CODE + ".saveAuctiondt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is missing");
        }
        String tenantCode = this.getTenantCode(request);
        AtAuctionWinReDomain atAuctionWinReDomain = this.atAuctionWinService.getatAuctionWin(auctionWinId);
        if (atAuctionWinReDomain.getDataState() == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u5ba1\u6838");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.getAtAuctionEnrollReDomain(auctionCode, memberBcode, tenantCode);
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u62a5\u540d\u4fe1\u606f\u5931\u8d25,\u8bf7\u6838\u5bf9\u53c2\u6570");
        }
        String auctionEnrollCode = atAuctionEnrollReDomain.getAuctionEnrollCode();
        return this.getHtmlJsonReBean(auctionWinId, memberBcode, auctionEnrollCode, auctionCode, tenantCode, atAuctionWinReDomain);
    }

    private HtmlJsonReBean getHtmlJsonReBean(Integer auctionWinId, String memberBcode, String auctionEnrollCode, String auctionCode, String tenantCode, AtAuctionWinReDomain atAuctionWinReDomain) {
        AtAuctionReDomain auctionReDomain = this.atAuctionService.getatAuctionByCode(tenantCode, auctionCode);
        if (null == auctionReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u65e0\u516c\u544a\u4fe1\u606f\uff01");
        }
        Integer auctionruleBuydp = auctionReDomain.getAuctionruleBuydp();
        AtAuctiondtDomain atAuctiondtDomain = new AtAuctiondtDomain();
        BigDecimal depositAmount = this.getUserDepositAmount(auctionCode, memberBcode, tenantCode, "1");
        if (auctionruleBuydp == 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u573a\u6b21\u4e0d\u6536\u53d6\u8d39\u7528\uff01");
        }
        if (auctionruleBuydp == 1) {
            BigDecimal auctionDtDpnum = this.getUserCommissionAmount(memberBcode, auctionCode, tenantCode);
            atAuctiondtDomain.setAuctionDtDpnum(auctionDtDpnum);
            if (auctionDtDpnum.compareTo(depositAmount) > 0) {
                atAuctiondtDomain.setAuctionDtSdpnum(depositAmount);
            } else {
                atAuctiondtDomain.setAuctionDtSdpnum(auctionDtDpnum);
            }
        } else if (auctionruleBuydp == 2) {
            atAuctiondtDomain.setAuctionDtDpnum(auctionReDomain.getAuctionruleBuydpnum());
            if (auctionReDomain.getAuctionruleBuydpnum().compareTo(depositAmount) > 0) {
                atAuctiondtDomain.setAuctionDtSdpnum(depositAmount);
            } else {
                atAuctiondtDomain.setAuctionDtSdpnum(auctionReDomain.getAuctionruleBuydpnum());
            }
        }
        String userinfoCode = "";
        String userinfoName = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoQuality", "plat");
        List umUserInfos = this.userService.queryStoreBySimpleObjPage(paramMap).getList();
        if (ListUtil.isNotEmpty((Collection)umUserInfos)) {
            userinfoCode = ((UmUserinfoSimpleDomain)umUserInfos.get(0)).getUserinfoCode();
            userinfoName = ((UmUserinfoSimpleDomain)umUserInfos.get(0)).getUserinfoCompname();
        }
        atAuctiondtDomain.setMemberCode(userinfoCode);
        atAuctiondtDomain.setMemberName(userinfoName);
        atAuctiondtDomain.setMemberCname(atAuctionWinReDomain.getMemberCname());
        atAuctiondtDomain.setAuctionCode(auctionCode);
        atAuctiondtDomain.setAuctionType(auctionReDomain.getAuctionType());
        atAuctiondtDomain.setAuctionName(atAuctionWinReDomain.getAuctionName());
        atAuctiondtDomain.setMemberBcode(atAuctionWinReDomain.getMemberBcode());
        atAuctiondtDomain.setMemberBname(atAuctionWinReDomain.getMemberBname());
        atAuctiondtDomain.setTenantCode(tenantCode);
        atAuctiondtDomain.setDataState(0);
        atAuctiondtDomain.setAuctionDtType("2");
        atAuctiondtDomain.setAuctionEnrollCode(auctionEnrollCode);
        atAuctiondtDomain.setAuctionWinId(auctionWinId);
        atAuctiondtDomain.setAppmanageIcode(auctionReDomain.getAppmanageIcode());
        return this.atAuctiondtService.saveAuctiondt(atAuctiondtDomain);
    }

    private BigDecimal getUserCommissionAmount(String memberBcode, String auctionCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("contractNbillcode", auctionCode);
        param.put("memberBcode", memberBcode);
        param.put("tenantCode", tenantCode);
        BigDecimal auctionDtDpnum = new BigDecimal("0.00");
        return auctionDtDpnum;
    }

    private BigDecimal getUserDepositAmount(String auctionCode, String memberBcode, String tenantCode, String auctionDtType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("auctionCode", auctionCode);
        param.put("memberBcode", memberBcode);
        param.put("auctionDtType", auctionDtType);
        param.put("tenantCode", tenantCode);
        SupQueryResult<AtAuctiondtReDomain> atResult = this.atAuctiondtService.queryAuctiondtPage(param);
        List atAuctiondtReDomains = atResult.getList();
        BigDecimal depositAmount = new BigDecimal("0.00");
        for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomains) {
            if (atAuctiondtReDomain.getDataState() == 2) continue;
            depositAmount = depositAmount.add(new BigDecimal(atAuctiondtReDomain.getAuctionruleDpnum()));
        }
        return depositAmount;
    }

    @RequestMapping(value={"saveAuctiondtReturnCommission.json"}, name="\u4f63\u91d1\u8fd4\u8fd8\u9012\u4ea4\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean saveAuctiondtReturnCommission(HttpServletRequest request, BigDecimal returnCommiss, Integer auctionDtId) {
        BigDecimal depositAmount;
        if (null == auctionDtId || null == returnCommiss) {
            this.logger.error(CODE + ".saveAuctiondtReturnCommission", (Object)"param is missing");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionDtId or returnCommiss is missing");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        if (null == auctiondt) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        if (returnCommiss.compareTo(auctiondt.getAuctionDtDpnum()) > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8fd4\u8fd8\u4f63\u91d1\u4e0d\u5f97\u8d85\u8fc7\u6536\u53d6\u7684\u4f63\u91d1");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberBcode", auctiondt.getMemberBcode());
        map.put("auctionCode", auctiondt.getAuctionCode());
        map.put("auctionDtType", "3");
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtReDomainSupQueryResult = this.atAuctiondtService.queryAuctiondtPage(map);
        List returnCommissList = atAuctiondtReDomainSupQueryResult.getList();
        BigDecimal returnCommissUp = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((Collection)returnCommissList)) {
            for (AtAuctiondtReDomain reDomain : returnCommissList) {
                returnCommissUp = returnCommissUp.add(reDomain.getAuctionDtDpnum());
            }
        }
        if ((returnCommissUp = returnCommissUp.add(returnCommiss)).compareTo(depositAmount = this.getUserDepositAmount(auctiondt.getAuctionCode(), auctiondt.getMemberBcode(), tenantCode, "1")) > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7d2f\u8ba1\u8fd4\u8fd8\u4f63\u91d1\u4e0d\u80fd\u8d85\u51fa\u7f34\u7eb3\u7684\u4fdd\u8bc1\u91d1\u91d1\u989d");
        }
        if (returnCommissUp.compareTo(auctiondt.getAuctionDtDpnum()) > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7d2f\u8ba1\u8fd4\u8fd8\u4f63\u91d1\u4e0d\u80fd\u8d85\u51fa\u6536\u53d6\u7684\u4f63\u91d1\u91d1\u989d");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.getAtAuctionEnrollReDomain(auctiondt.getAuctionCode(), auctiondt.getMemberBcode(), tenantCode);
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u62a5\u540d\u4fe1\u606f\u5931\u8d25,\u8bf7\u6838\u5bf9\u53c2\u6570");
        }
        AtAuctiondtDomain atAuctiondtDomain = new AtAuctiondtDomain();
        atAuctiondtDomain.setAuctionDtDpnum(returnCommiss);
        atAuctiondtDomain.setMemberCode(auctiondt.getMemberCode());
        atAuctiondtDomain.setMemberName(auctiondt.getMemberName());
        atAuctiondtDomain.setMemberCname(auctiondt.getMemberCname());
        atAuctiondtDomain.setAuctionCode(auctiondt.getAuctionCode());
        atAuctiondtDomain.setAuctionType(auctiondt.getAuctionType());
        atAuctiondtDomain.setAuctionName(auctiondt.getAuctionName());
        atAuctiondtDomain.setMemberBcode(auctiondt.getMemberBcode());
        atAuctiondtDomain.setMemberBname(auctiondt.getMemberBname());
        atAuctiondtDomain.setTenantCode(tenantCode);
        atAuctiondtDomain.setAuctionEnrollCode(atAuctionEnrollReDomain.getAuctionEnrollCode());
        atAuctiondtDomain.setDataState(0);
        atAuctiondtDomain.setAuctionDtType("3");
        atAuctiondtDomain.setAppmanageIcode(auctiondt.getAppmanageIcode());
        return this.atAuctiondtService.saveAuctiondt(atAuctiondtDomain);
    }

    @RequestMapping(value={"queryAuctiondtCommission.json"}, name="\u67e5\u8be2\u4f63\u91d1\u6536\u53d6\u5ba1\u6838\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryAuctiondtCommission(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            String auctionDtType = "2";
            param.put("auctionDtType", auctionDtType);
        }
        return this.atAuctiondtService.queryAuctiondtPage(param);
    }

    @RequestMapping(value={"queryAuctiondtReturnCommission.json"}, name="\u67e5\u8be2\u4f63\u91d1\u8fd4\u8fd8\u5ba1\u6838\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryAuctiondtReturnCommission(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            String auctionDtType = "3";
            param.put("auctionDtType", auctionDtType);
        }
        return this.atAuctiondtService.queryAuctiondtPage(param);
    }

    @RequestMapping(value={"updateAuctiondtCommissState.json"}, name="\u4f63\u91d1\u6536\u53d6\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateAuctiondtCommissState(HttpServletRequest request, Integer auctionDtId) {
        if (null == auctionDtId) {
            this.logger.error(CODE + ".updateAuctiondtCommissState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionDtId is missing");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        if (null == auctiondt) {
            this.logger.error(CODE + ".updateAuctiondtCommissState", (Object)"parameter error ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "parameter error ");
        }
        Integer oldDataState = auctiondt.getDataState();
        if ("1".equals(oldDataState)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u8bb0\u5f55\u5df2\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u9012\u4ea4");
        }
        Integer dataState = 1;
        Map<String, Object> map = this.assemMapParam(request);
        String userPcode = this.getUserSession(request).getUserPcode();
        String userName = this.getUserSession(request).getUserName();
        map.put("userCode", userPcode);
        map.put("userName", userName);
        return this.atAuctiondtService.updateAuctiondtCommissState(auctionDtId, dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctiondtReturnCommissState.json"}, name="\u4f63\u91d1\u8fd4\u8fd8\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateAuctiondtReturnCommissState(HttpServletRequest request, Integer auctionDtId) {
        if (null == auctionDtId) {
            this.logger.error(CODE + ".updateAuctiondtReturnCommissState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        if (null == auctiondt) {
            this.logger.error(CODE + ".updateAuctiondtReturnCommissState", (Object)"parameter error ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "parameter error ");
        }
        Integer oldDataState = auctiondt.getDataState();
        if (oldDataState == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u8bb0\u5f55\u5df2\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u9012\u4ea4");
        }
        Integer dataState = 1;
        Map<String, Object> map = this.assemMapParam(request);
        String userPcode = this.getUserSession(request).getUserPcode();
        String userName = this.getUserSession(request).getUserName();
        map.put("userCode", userPcode);
        map.put("userName", userName);
        return this.atAuctiondtService.updateAuctiondtReturnCommissState(auctionDtId, dataState, oldDataState, map);
    }

    @RequestMapping(value={"saveAuctiondt.json"}, name="\u589e\u52a0\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
    @ResponseBody
    public HtmlJsonReBean saveAuctiondt(HttpServletRequest request, AtAuctiondtDomain atAuctiondtDomain) {
        if (null == atAuctiondtDomain) {
            this.logger.error(CODE + ".saveAuctiondt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String auctionEnrollCode = atAuctiondtDomain.getAuctionEnrollCode();
        if (StringUtils.isEmpty((String)auctionEnrollCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionEnrollCode is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnrollByCode(tenantCode, auctionEnrollCode);
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "atAuctionEnrollReDomain is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberBcode", this.getUserSession(request).getUserPcode());
        map.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
        map.put("fuzzy", true);
        map.put("dataState", "1");
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtReDomainSupQueryResult = this.atAuctiondtService.queryAuctiondtPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u4fdd\u8bc1\u91d1");
        }
        try {
            BeanUtils.copyAllPropertys((Object)atAuctiondtDomain, (Object)atAuctionEnrollReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveAuctiondt" + e);
        }
        atAuctiondtDomain.setTenantCode(tenantCode);
        atAuctiondtDomain.setDataState(0);
        atAuctiondtDomain.setAuctionDtType("0");
        atAuctiondtDomain.setAuctionEnrollCode(auctionEnrollCode);
        atAuctiondtDomain.setAuctionruleDpnum(atAuctionEnrollReDomain.getAuctionruleDpnum());
        return this.atAuctiondtService.saveAuctiondt(atAuctiondtDomain);
    }

    @RequestMapping(value={"saveAuctiondtBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
    @ResponseBody
    public HtmlJsonReBean saveAuctiondtBatch(HttpServletRequest request, String paramStr) {
        List atAuctiondtList = JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctiondtDomain.class);
        if (ListUtil.isEmpty((Collection)atAuctiondtList)) {
            this.logger.error(CODE + ".saveAuctiondtBatch", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        String auctionEnrollCode = ((AtAuctiondtDomain)atAuctiondtList.get(0)).getAuctionEnrollCode();
        String auctionDtPayType = ((AtAuctiondtDomain)atAuctiondtList.get(0)).getAuctionDtPayType();
        if (StringUtils.isEmpty((String)auctionEnrollCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionEnrollCode is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnrollByCode(tenantCode, auctionEnrollCode);
        if (null == atAuctionEnrollReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
        map.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
        map.put("fuzzy", true);
        map.put("dataState", "1");
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtReDomainSupQueryResult = this.atAuctiondtService.queryAuctiondtPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u4fdd\u8bc1\u91d1");
        }
        map.remove("dataState");
        SupQueryResult<AtAuctionUserginfoReDomain> atAuctionUserginfoResult = this.atAuctionUserginfoService.queryatAuctionUserginfoPage(map);
        if (ListUtil.isEmpty((Collection)atAuctionUserginfoResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userginfoList is null");
        }
        ArrayList<AtAuctiondtDomain> atAuctiondtListNew = new ArrayList<AtAuctiondtDomain>();
        for (AtAuctionUserginfoReDomain userginfoReDomain : atAuctionUserginfoResult.getList()) {
            if (1 == userginfoReDomain.getDataState()) continue;
            AtAuctiondtDomain atAuctiondtDomain = new AtAuctiondtDomain();
            try {
                BeanUtils.copyAllPropertys((Object)atAuctiondtDomain, (Object)userginfoReDomain);
                BeanUtils.copyAllPropertys((Object)atAuctiondtDomain, (Object)atAuctionEnrollReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuctiondt" + e);
            }
            atAuctiondtDomain.setAuctionDtRemark(userginfoReDomain.getAuctionGinfoCode());
            atAuctiondtDomain.setAuctionDtDpnum(userginfoReDomain.getAuctionruleDpamount());
            atAuctiondtDomain.setAuctionruleDpnum(userginfoReDomain.getAuctionruleDpamount().longValue());
            atAuctiondtDomain.setAuctionDtType("0");
            atAuctiondtDomain.setAuctionDtPayType(auctionDtPayType);
            atAuctiondtDomain.setDataState(0);
            atAuctiondtDomain.setAuctionEnrollCode(atAuctionEnrollReDomain.getAuctionEnrollCode());
            atAuctiondtListNew.add(atAuctiondtDomain);
        }
        HtmlJsonReBean htmlJsonReBean = this.atAuctiondtService.saveAuctiondtBatch(atAuctiondtListNew);
        htmlJsonReBean.setMsg("\u62a5\u540d\u6210\u529f! \u8bf7\u4fdd\u8bc1\u5e73\u53f0\u4e2a\u4eba\u8d26\u53f7\u4e2d\u7684\u4f59\u989d\u5145\u8db3\uff0c\u5426\u5219\u5c06\u65e0\u6cd5\u901a\u8fc7\u5ba1\u6838\uff01");
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateAuctiondtToWaitForReturn.json"}, name="\u7533\u8bf7\u63d0\u73b0\u91ca\u653e\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
    @ResponseBody
    public HtmlJsonReBean updateAuctiondtToWaitForReturn(HttpServletRequest request, AtAuctiondtDomain atAuctiondtDomain) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        if (null == atAuctiondtDomain) {
            this.logger.error(CODE + ".updateAuctiondtToWaitForReturn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String memberCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        atAuctiondtDomain.setTenantCode(tenantCode);
        atAuctiondtDomain.setAuctionCode("88888888");
        atAuctiondtDomain.setMemberBcode(memberCode);
        atAuctiondtDomain.setMemberBname(userSession.getMerberCompname());
        atAuctiondtDomain.setAuctionDtType("2");
        String type = memberCode.substring(0, 1);
        String basic = "101";
        if ("2".equals(type)) {
            basic = "201";
        }
        Map<String, VdFaccountInfo> vd = this.getVd(memberCode, tenantCode, basic);
        VdFaccountInfo vdFaccountInfo = vd.get(basic);
        BigDecimal amount = null;
        if (ListUtil.isEmpty(vdFaccountInfo.getSubsetList())) {
            return null;
        }
        for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : vdFaccountInfo.getSubsetList()) {
            if (!"01".equals(vdFaccountOuterSubsetDomain.getFundType())) continue;
            amount = vdFaccountOuterSubsetDomain.getFaccountAmount();
        }
        if (amount.compareTo(atAuctiondtDomain.getAuctionDtDpnum()) < 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ef\u63d0\u73b0\u91d1\u989d\u4e0d\u8db3");
        }
        return this.atAuctiondtService.saveAuctiondt(atAuctiondtDomain);
    }

    @RequestMapping(value={"updateForzenAuctiondtToWaitForReturn.json"}, name="\u7533\u8bf7\u89e3\u51bb\u91ca\u653e\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
    @ResponseBody
    public HtmlJsonReBean updateForzenAuctiondtToWaitForReturn(HttpServletRequest request, Integer auctionDtId, String auctionDtUrl) {
        if (null == auctionDtId) {
            this.logger.error(CODE + ".updateAuctiondtToWaitForReturnById", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain auctionReDomain = this.atAuctionService.getatAuctionByCode(tenantCode, auctiondt.getAuctionCode());
        if (null == auctionReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u65e0\u516c\u544a\u4fe1\u606f\uff01");
        }
        if (auctionReDomain.getAuctionruleBuydp() > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("auctionDtType", "2");
            paramMap.put("auctionCode", auctiondt.getAuctionCode());
            paramMap.put("memberBcode", auctiondt.getMemberBcode());
            paramMap.put("tenantCode", auctiondt.getTenantCode());
            List auctiondtReDomains = this.atAuctiondtService.queryAuctiondtPage(paramMap).getList();
            if (ListUtil.isEmpty((Collection)auctiondtReDomains)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6b64\u6b21\u7ade\u62cd\u5c1a\u672a\u9012\u4ea4\u4f63\u91d1\u5ba1\u6838");
            }
            AtAuctiondtReDomain atAuctiondtReDomain = (AtAuctiondtReDomain)auctiondtReDomains.get(0);
            if (atAuctiondtReDomain.getDataState() != 1) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u7b49\u5f85\u5e73\u53f0\u6536\u53d6\u4f63\u91d1\u4e4b\u540e\u518d\u7533\u8bf7\u89e3\u51bb:");
            }
        }
        auctiondt.setAuctionDtUrl(auctionDtUrl);
        auctiondt.setAuctionDtType("1");
        ((AtAuctiondtDomain)auctiondt).setDataState(0);
        auctiondt.setUserCode(null);
        auctiondt.setUserName(null);
        return this.atAuctiondtService.updateAuctiondt(auctiondt);
    }

    @RequestMapping(value={"queryAuctiondtPageForReturn.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u5f85\u91ca\u653e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryAuctiondtPageForReturn(HttpServletRequest request) {
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_MODIFIED DESC");
            param.put("auctionDtType", "1");
            if (null == param.get("dataState")) {
                param.put("dataStateStr", "0,1,2,4,5,6");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        if (null != param.get("contractBillcode")) {
            String atDtCode;
            map.put("contractBillcode", param.get("contractBillcode").toString());
            ocContractReDomainSupQueryResult = this.atAuctionWinService.queryContractPageReDomain(map);
            if (ListUtil.isNotEmpty((Collection)ocContractReDomainSupQueryResult.getList()) && StringUtils.isNotBlank((String)(atDtCode = ((OcContractReDomain)ocContractReDomainSupQueryResult.getList().get(0)).getContractObillcode()))) {
                param.put("auctionDtCode", atDtCode);
            }
        }
        param.put("auctionDtDpnumNotZero", 0);
        this.logger.info(CODE + "queryAuctiondtPageForReturn.json\u67e5\u8be2\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u5f85\u91ca\u653e\u5206\u9875\u5217\u8868,map:", param);
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtReDomainSupQueryResult = this.atAuctiondtService.queryAuctiondtPage(param);
        if (ListUtil.isEmpty((Collection)atAuctiondtReDomainSupQueryResult.getList())) {
            return atAuctiondtReDomainSupQueryResult;
        }
        for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomainSupQueryResult.getList()) {
            String orderMemo = "";
            map.clear();
            map.put("tenantCode", this.getTenantCode(request));
            map.put("auctionCode", atAuctiondtReDomain.getAuctionCode());
            map.put("memberBcode", atAuctiondtReDomain.getMemberBcode());
            SupQueryResult<AtAuctionWinReDomain> atAuctionWinResult = this.atAuctionWinService.queryatAuctionWinPage(map);
            if (ListUtil.isEmpty((Collection)atAuctionWinResult.getList())) continue;
            for (AtAuctionWinReDomain atAuctionWinReDomain1 : atAuctionWinResult.getList()) {
                AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionService.getatAuctionGinfoByCode(this.getTenantCode(request), atAuctionWinReDomain1.getAuctionGinfoCode());
                if (null == atAuctionGinfoReDomain) continue;
                map.clear();
                map.put("contractNbillcode", atAuctiondtReDomain.getAuctionCode());
                map.put("contractNbbillcode", atAuctionGinfoReDomain.getAuctionGinfoCode());
                map.put("tenantCode", this.getTenantCode(request));
                ocContractReDomainSupQueryResult = this.atAuctionWinService.queryContractPageReDomain(map);
                if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) continue;
                for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResult.getList()) {
                    if (StringUtils.isNotBlank((String)orderMemo)) {
                        orderMemo = orderMemo + ",";
                    }
                    orderMemo = orderMemo + ocContractReDomain.getContractBillcode();
                }
            }
            atAuctiondtReDomain.setMemo(orderMemo);
        }
        return atAuctiondtReDomainSupQueryResult;
    }

    @RequestMapping(value={"getAuctiondtAndAmount.json"}, name="\u83b7\u53d6\u4fdd\u8bc1\u91d1\u62a5\u540d\u8d26\u6237\u4ee5\u53ca\u573a\u6b21\u91d1\u989d\u4fe1\u606f")
    @ResponseBody
    public AtAuctiondtDomain getAuctiondtAndAmount(HttpServletRequest request, String auctionEnrollCode, String auctionCode, String fundType) {
        if (StringUtils.isBlank((String)auctionEnrollCode) || StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuctiondtAndAmount", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        AtAuctiondtDomain atAuctiondtDomain = new AtAuctiondtDomain();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", userSession.getTenantCode());
        map.put("memberBcode", userSession.getUserPcode());
        map.put("auctionCode", auctionCode);
        map.put("auctionEnrollCode", auctionEnrollCode);
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain atAuctionReDomain = this.atAuctionService.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return null;
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollService.getatAuctionEnrollByCode(tenantCode, auctionEnrollCode);
        if (null == atAuctionEnrollReDomain) {
            return null;
        }
        BigDecimal amount = this.getMemVd(request, atAuctionEnrollReDomain, fundType);
        BigDecimal dtDpnum = null;
        ArrayList<AtAuctiondtChildDomain> atAuctiondtChildDomains = new ArrayList<AtAuctiondtChildDomain>();
        if (0 == atAuctionEnrollReDomain.getAuctionruleDptype()) {
            dtDpnum = new BigDecimal(atAuctionReDomain.getAuctionruleDpnum());
        } else if (ListUtil.isNotEmpty(atAuctionEnrollReDomain.getAtAuctionUserginfoList())) {
            dtDpnum = new BigDecimal(0);
            for (AtAuctionUserginfoReDomain atAuctionUserginfoDomain : atAuctionEnrollReDomain.getAtAuctionUserginfoList()) {
                if (null == atAuctionUserginfoDomain.getAuctionruleDpamount() || 1 == atAuctionUserginfoDomain.getDataState()) continue;
                AtAuctiondtChildDomain atAuctiondtChildDomain = new AtAuctiondtChildDomain();
                atAuctiondtChildDomain.setAuctionDtDpnum(atAuctionUserginfoDomain.getAuctionruleDpamount());
                atAuctiondtChildDomain.setAuctionDtRemark(atAuctionUserginfoDomain.getAuctionGinfoCode());
                dtDpnum = atAuctionUserginfoDomain.getAuctionruleDpamount().add(dtDpnum);
                atAuctiondtChildDomains.add(atAuctiondtChildDomain);
            }
        }
        atAuctiondtDomain.setChildDomainList(atAuctiondtChildDomains);
        atAuctiondtDomain.setAuctionDtDpnum(dtDpnum);
        atAuctiondtDomain.setAuctionDtSdpnum(amount);
        return atAuctiondtDomain;
    }

    @RequestMapping(value={"getAuctiondt.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u4fe1\u606f")
    @ResponseBody
    public AtAuctiondtReDomain getAuctiondt(Integer auctionDtId) {
        if (StringUtils.isBlank((Integer)auctionDtId)) {
            this.logger.error(CODE + ".getAuctiondt", (Object)"param is null");
            return null;
        }
        return this.atAuctiondtService.getAuctiondt(auctionDtId);
    }

    @RequestMapping(value={"updateAuctiondt.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
    @ResponseBody
    public HtmlJsonReBean updateAuctiondt(HttpServletRequest request, AtAuctiondtDomain atAuctiondtDomain) {
        if (null == atAuctiondtDomain) {
            this.logger.error(CODE + ".updateAuctiondt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctiondtDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctiondtService.updateAuctiondt(atAuctiondtDomain);
    }

    @RequestMapping(value={"deleteAuctiondt.json"}, name="\u5220\u9664\u7ade\u4ef7\u4fdd\u8bc1\u91d1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctiondt(Integer auctionDtId) {
        if (StringUtils.isBlank((Integer)auctionDtId)) {
            this.logger.error(CODE + ".deleteAuctiondt", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctiondtService.deleteAuctiondt(auctionDtId);
    }

    @RequestMapping(value={"queryAuctiondtPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryAuctiondtPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctiondtService.queryAuctiondtPage(param);
    }

    @RequestMapping(value={"updateAuctiondtState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctiondtState(String auctionDtId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionDtId)) {
            this.logger.error(CODE + ".updateAuctiondtState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctiondtService.updateAuctiondtState(Integer.valueOf(auctionDtId), dataState, oldDataState, null);
    }

    public void shenghe(HttpServletRequest request, String auctionDtId) {
        String tenantCode;
        Map<String, VdFaccountInfo> vd;
        VdFaccountInfo vdFaccountInfo;
        if (auctionDtId == null) {
            return;
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(Integer.valueOf(auctionDtId));
        String memberCode = auctiondt.getMemberCode();
        String type = memberCode.substring(0, 1);
        String basic = "101";
        if ("2".equals(type)) {
            basic = "201";
        }
        if (null == (vdFaccountInfo = (vd = this.getVd(memberCode, tenantCode = auctiondt.getTenantCode(), basic)).get(basic))) {
            return;
        }
        for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : vdFaccountInfo.getSubsetList()) {
            vdFaccountOuterSubsetDomain.getFundType().equals("01");
            vdFaccountOuterSubsetDomain.getFaccountAmount();
        }
    }

    private BigDecimal getMemVd(HttpServletRequest request, AtAuctionEnrollReDomain atAuctionEnrollReDomain, String fundType) {
        String tenantCode;
        Map<String, VdFaccountInfo> vd;
        if (null == atAuctionEnrollReDomain) {
            return null;
        }
        String memberCode = atAuctionEnrollReDomain.getMemberBcode();
        String type = memberCode.substring(0, 1);
        String basic = "101";
        String basicType = "01";
        if (null == fundType) {
            if ("2".equals(type)) {
                basic = "201";
            }
        } else if (fundType.equals("05")) {
            basic = "105";
            if ("2".equals(type)) {
                basic = "205";
            }
            basicType = "05";
        }
        if (null == (vd = this.getVd(memberCode, tenantCode = atAuctionEnrollReDomain.getTenantCode(), basic))) {
            return null;
        }
        VdFaccountInfo vdFaccountInfo = vd.get(basic);
        if (null == vdFaccountInfo) {
            return null;
        }
        BigDecimal amount = null;
        if (ListUtil.isEmpty(vdFaccountInfo.getSubsetList())) {
            return null;
        }
        for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : vdFaccountInfo.getSubsetList()) {
            if (!basicType.equals(vdFaccountOuterSubsetDomain.getFundType())) continue;
            amount = vdFaccountOuterSubsetDomain.getFaccountAmount();
        }
        return amount;
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List<VdFaccountInfo> vdList = this.vdFaccountService.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    @RequestMapping(value={"queryMemAuctiondtPage.json"}, name="\u67e5\u8be2\u6211\u7684\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryMemAuctiondtPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("orderStr", "GMT_MODIFIED DESC");
        param.put("auctionDtDpnumNotZero", 0);
        param.put("memberBcode", userSession.getUserPcode());
        return this.atAuctiondtService.queryAuctiondtPage(param);
    }

    @RequestMapping(value={"getFreezeDtNumBymem.json"}, name="\u67e5\u8be2\u7528\u6237\u4fdd\u8bc1\u91d1\u51bb\u7ed3\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean getFreezeDtNumBymem(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberBcode", userSession.getUserPcode());
        BigDecimal freezeDt = new BigDecimal(0);
        BigDecimal unFreezeDt = new BigDecimal(0);
        BigDecimal failFreezeDt = new BigDecimal(0);
        BigDecimal ableFreezeDt = new BigDecimal(0);
        param.put("auctionDtType", "0");
        param.put("dataStateStr", "1,3,4,5,6");
        List atAuctiondtReDomainList = this.atAuctiondtService.queryAuctiondtPage(param).getList();
        if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomainList)) {
            for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomainList) {
                freezeDt = freezeDt.add(atAuctiondtReDomain.getAuctionDtDpnum());
            }
        }
        param.remove("dataStateStr");
        param.put("auctionDtType", "1");
        param.put("dataState", "0");
        atAuctiondtReDomainList = this.atAuctiondtService.queryAuctiondtPage(param).getList();
        if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomainList)) {
            for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomainList) {
                unFreezeDt = unFreezeDt.add(atAuctiondtReDomain.getAuctionDtDpnum());
            }
        }
        param.put("auctionDtType", "1");
        param.put("dataState", "3");
        atAuctiondtReDomainList = this.atAuctiondtService.queryAuctiondtPage(param).getList();
        if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomainList)) {
            for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomainList) {
                ableFreezeDt = ableFreezeDt.add(atAuctiondtReDomain.getAuctionDtDpnum());
            }
        }
        param.put("dataState", "2");
        atAuctiondtReDomainList = this.atAuctiondtService.queryAuctiondtPage(param).getList();
        if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomainList)) {
            for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomainList) {
                failFreezeDt = failFreezeDt.add(atAuctiondtReDomain.getAuctionDtDpnum());
            }
        }
        return new HtmlJsonReBean((Object)("freezeDt:" + freezeDt + ",unFreezeDt:" + unFreezeDt + ",failFreezeDt:" + failFreezeDt + ",ableFreezeDt:" + ableFreezeDt));
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByWithDraw.json"}, name="\u5ba1\u6838\u57fa\u672c\u6237\u91d1\u989d\u63d0\u73b0")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByWithDraw(HttpServletRequest request, Integer auctionDtId) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        if (null == auctionDtId) {
            return new HtmlJsonReBean("error", "id is null");
        }
        if (0 != auctionDtId) {
            return new HtmlJsonReBean("error", "id is null");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        if (null == auctiondt || 0 != auctiondt.getDataState()) {
            return new HtmlJsonReBean("error", "\u72b6\u6001\u9519\u8bef");
        }
        auctiondt.setUserCode(userSession.getUserPcode());
        auctiondt.setUserName(userSession.getUserRelname());
        return this.atAuctiondtService.updateAuctionEnrollAuditByWithDraw(auctiondt);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditWithDrawFail.json"}, name="\u5ba1\u6838\u57fa\u672c\u6237\u91d1\u989d\u63d0\u73b0\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditWithDrawFail(HttpServletRequest request, Integer auctionDtId) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        if (null == auctionDtId) {
            return new HtmlJsonReBean("error", "id is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserRelname());
        return this.atAuctiondtService.updateAuctiondtState(auctionDtId, 2, 0, map);
    }

    @RequestMapping(value={"queryCurrentAuctiondtPage.json"}, name="\u67e5\u8be2\u5f53\u524d\u62a5\u540d\u4fdd\u8bc1\u91d1\u6240\u7f34\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryCurrentAuctiondtPage(HttpServletRequest request, String auctionDtCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberBcode", userSession.getUserPcode());
        AtAuctiondtReDomain atAuctiondt = this.atAuctiondtService.getAuctiondtByCode(userSession.getTenantCode(), auctionDtCode);
        if (null == atAuctiondt) {
            return null;
        }
        param.put("auctionCode", atAuctiondt.getAuctionCode());
        param.put("auctionDtType", "0");
        param.remove("auctionDtCode");
        SupQueryResult<AtAuctiondtReDomain> atAuctiondtResult = this.atAuctiondtService.queryAuctiondtPage(param);
        if (ListUtil.isEmpty((Collection)atAuctiondtResult.getList())) {
            return null;
        }
        BigDecimal valSum = new BigDecimal(0);
        for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtResult.getList()) {
            valSum = valSum.add(atAuctiondtReDomain.getAuctionDtDpnum());
            atAuctiondtReDomain.setAuctionDtSdpnum(valSum);
        }
        return atAuctiondtResult;
    }

    @RequestMapping(value={"queryAuctiondtPageForForzen.json"}, name="\u67e5\u8be2\u51bb\u7ed3\u7ade\u4ef7\u4fdd\u8bc1\u91d1\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryAuctiondtPageForForzen(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionDtDpnumNotZero", 0);
            String exportFlag = null == param || null == param.get("forzenStr") ? "false" : (String)param.get("forzenStr");
            Boolean flag = Boolean.valueOf(exportFlag);
            if (flag.booleanValue()) {
                param.put("forzenStr", true);
            }
        }
        return this.atAuctiondtService.queryAuctiondtPage(param);
    }

    @RequestMapping(value={"saveAuctiondtConfiscateDeposit.json"}, name="\u4fdd\u8bc1\u91d1\u7f5a\u6ca1\u9012\u4ea4\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean saveAuctiondtConfiscateDeposit(HttpServletRequest request, String auctionDtUrl, String remark, BigDecimal confiscateDeposit, Integer auctionDtId) {
        if (null == auctionDtId || null == confiscateDeposit) {
            this.logger.error(CODE + ".saveAuctiondtConfiscateDeposit", (Object)"param is missing");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionDtId or confiscateDeposit is missing");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        if (null == auctiondt) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        Integer oldDataState = auctiondt.getDataState();
        if (oldDataState == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u8bb0\u5f55\u5df2\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u9012\u4ea4");
        }
        if (confiscateDeposit.compareTo(auctiondt.getAuctionDtDpnum()) > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7f5a\u6ca1\u91d1\u989d\u8d85\u51fa\u4fdd\u8bc1\u91d1\u7684\u91d1\u989d");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.getAtAuctionEnrollReDomain(auctiondt.getAuctionCode(), auctiondt.getMemberBcode(), auctiondt.getTenantCode());
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u62a5\u540d\u4fe1\u606f\u5931\u8d25,\u8bf7\u6838\u5bf9\u53c2\u6570");
        }
        String tenantCode = this.getTenantCode(request);
        AtAuctiondtDomain atAuctiondtDomain = new AtAuctiondtDomain();
        atAuctiondtDomain.setAuctionDtDpnum(confiscateDeposit);
        atAuctiondtDomain.setMemberCode(auctiondt.getMemberCode());
        atAuctiondtDomain.setMemberName(auctiondt.getMemberName());
        atAuctiondtDomain.setMemberCname(auctiondt.getMemberCname());
        atAuctiondtDomain.setAuctionCode(auctiondt.getAuctionCode());
        atAuctiondtDomain.setAuctionType(auctiondt.getAuctionType());
        atAuctiondtDomain.setAuctionName(auctiondt.getAuctionName());
        atAuctiondtDomain.setMemberBcode(auctiondt.getMemberBcode());
        atAuctiondtDomain.setMemberBname(auctiondt.getMemberBname());
        atAuctiondtDomain.setTenantCode(tenantCode);
        atAuctiondtDomain.setAuctionEnrollCode(atAuctionEnrollReDomain.getAuctionEnrollCode());
        atAuctiondtDomain.setAuctionDtUrl(auctionDtUrl);
        atAuctiondtDomain.setAuctionDtRemark(remark);
        atAuctiondtDomain.setDataState(0);
        atAuctiondtDomain.setAuctionDtType("4");
        atAuctiondtDomain.setAppmanageIcode(auctiondt.getAppmanageIcode());
        return this.atAuctiondtService.saveAuctiondt(atAuctiondtDomain);
    }

    @RequestMapping(value={"updateAuctiondtConfiscateDeposit.json"}, name="\u4fdd\u8bc1\u91d1\u7f5a\u6ca1\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateAuctiondtConfiscateDeposit(HttpServletRequest request, Integer auditFlag, Integer auctionDtId) {
        if (null == auctionDtId || null == auditFlag) {
            this.logger.error(CODE + ".updateAuctiondtConfiscateDeposit", (Object)"param is missing");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionDtId or confiscateDeposit is missing");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtService.getAuctiondt(auctionDtId);
        if (null == auctiondt) {
            this.logger.error(CODE + ".updateAuctiondtConfiscateDeposit", (Object)"parameter error ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "parameter error ");
        }
        Integer oldDataState = auctiondt.getDataState();
        if (oldDataState == 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u8bb0\u5f55\u5df2\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u9012\u4ea4");
        }
        Map<String, Object> map = this.assemMapParam(request);
        String userPcode = this.getUserSession(request).getUserPcode();
        String userName = this.getUserSession(request).getUserName();
        map.put("userCode", userPcode);
        map.put("userName", userName);
        Integer dataState = auditFlag == 0 ? 2 : 1;
        return this.atAuctiondtService.updateAuctiondtConfiscateDeposit(auctionDtId, dataState, oldDataState, map);
    }

    @RequestMapping(value={"queryAuctiondtConfiscateDeposits.json"}, name="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f5a\u6ca1\u5ba1\u6838\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctiondtReDomain> queryAuctiondtConfiscateDeposits(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            String auctionDtType = "4";
            param.put("auctionDtType", auctionDtType);
        }
        return this.atAuctiondtService.queryAuctiondtPage(param);
    }

    private AtAuctionEnrollReDomain getAtAuctionEnrollReDomain(String auctionCode, String memberBcode, String tenantCode) {
        HashMap<String, Object> parMap = new HashMap<String, Object>();
        parMap.put("auctionCode", auctionCode);
        parMap.put("memberBcode", memberBcode);
        parMap.put("dataStateNot", "2");
        parMap.put("tenantCode", tenantCode);
        List enrollReDomains = this.atAuctionEnrollService.queryatAuctionEnrollPage(parMap).getList();
        if (ListUtil.isEmpty((Collection)enrollReDomains)) {
            this.logger.error(CODE + "getAtAuctionEnrollReDomain.\u83b7\u53d6\u62a5\u540d\u4fe1\u606f\u5931\u8d25\uff0cgetAtAuctionEnrollReDomain", (Object)enrollReDomains.size());
            return null;
        }
        return (AtAuctionEnrollReDomain)enrollReDomains.get(0);
    }
}

