/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static Logger logger = LoggerFactory.getLogger(IpUtils.class);

    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress = null;
        try {
            ipAddress = request.getHeader("X-Forwarded-For");
            if (ipAddress != null && ipAddress.length() != 0 && !"unknown".equalsIgnoreCase(ipAddress) && ipAddress.contains(",")) {
                ipAddress = ipAddress.split(",")[0];
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("HTTP_CLIENT_IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            logger.error("IPUtils ERROR ", (Throwable)e);
        }
        return ipAddress;
    }

    public static String getMacAddress() throws Exception {
        byte[] macAddressBytes = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < macAddressBytes.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(macAddressBytes[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().trim().toUpperCase();
    }
}

