/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMap {
    private static final Logger log = LoggerFactory.getLogger(CacheMap.class);
    private static Cache<String, Object> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(60L, TimeUnit.SECONDS).initialCapacity(10).removalListener((RemovalListener)new RemovalListener<String, Object>(){

        public void onRemoval(RemovalNotification<String, Object> rn) {
            if (log.isInfoEnabled()) {
                log.info("\u88ab\u79fb\u9664\u7f13\u5b58{}:{}", rn.getKey(), rn.getValue());
            }
        }
    }).build();

    public static Object get(String key) {
        return StringUtils.isNotEmpty((CharSequence)key) ? cache.getIfPresent((Object)key) : null;
    }

    public static void put(String key, Object value) {
        if (StringUtils.isNotEmpty((CharSequence)key) && value != null) {
            cache.put((Object)key, value);
        }
    }

    public static void remove(String key) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            cache.invalidate((Object)key);
        }
    }

    public static void remove(List<String> keys) {
        if (keys != null && keys.size() > 0) {
            cache.invalidateAll(keys);
        }
    }
}

