/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.hl.utils;

import com.yqbsoft.laser.bus.ext.data.hl.domain.RsSkuReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.utils.EncryptUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class BusBaseService
extends BaseServiceImpl {
    public static final String SYS_CODE = "BusBaseService";

    protected QueryResult<RsSkuReDomain> querySkuOnePage(Map<String, Object> map) {
        String apiCode = "rs.sku.querySkuOnePage";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, param, RsSkuReDomain.class);
    }

    protected String verify(String content) {
        String tenantCode = BusBaseService.getDdFlag("00000000", "tenantCode", "tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("BusBaseService.verify tenantCode is null");
            return null;
        }
        String secretkey = BusBaseService.getDdFlag(tenantCode, "hlSecretkey", "hlSecretkey");
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("BusBaseService.verify", (Object)(content + "-" + tenantCode));
            return null;
        }
        String data = null;
        try {
            data = EncryptUtil.aesDecrypt(content, secretkey);
        }
        catch (Exception e) {
            this.logger.error("BusBaseService.verify.e", (Throwable)e);
            return null;
        }
        return data;
    }

    protected String makeResult(Boolean flag, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", flag);
        resultMap.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    protected static String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    protected static String getRequestUrl(String tenantCode, String urlKeyPrefix, String urlKey) {
        return BusBaseService.getDdFlag(tenantCode, urlKeyPrefix, urlKeyPrefix) + BusBaseService.getDdFlag(tenantCode, urlKey, urlKey);
    }

    protected Map<String, Object> getDdMap(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String json = BusBaseService.getDdFlag(tenantCode, flagSettingType, flagSettingCode);
        return JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
    }

    protected String getTenantCodeBuUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String s = url.replace("http://", "").replace("https://", "");
        String[] str = s.split("/");
        if (str.length <= 6) {
            return null;
        }
        return str[6];
    }

    protected String getTeananMemberCode(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }
}

