/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.hl.utils;

import com.yqbsoft.laser.bus.ext.data.hl.utils.BusBaseService;
import com.yqbsoft.laser.bus.ext.data.hl.utils.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.hl.utils.SslUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils
extends BusBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String doPostJSON(String path, String bodys, String tenantCode) throws Exception {
        LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u660e\u6587\uff1apath={},bodys={}", (Object)path, (Object)bodys);
        CloseableHttpClient httpClient = HttpUtils.createSSLClientTrustAll();
        HttpPost request = new HttpPost(path);
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-type", "application/json");
        String basicAuth = HttpUtils.buildBasicAuthHeader("PO_SIMS", "SIMS@2024");
        request.setHeader("Authorization", basicAuth);
        if (bodys != null) {
            HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(bodys).build();
            request.setEntity(entity);
        }
        SslUtil.ignoreSsl();
        String result = EntityUtils.toString((HttpEntity)httpClient.execute((HttpUriRequest)request).getEntity(), (String)"UTF-8");
        LOGGER.error("\u8bf7\u6c42\u54cd\u5e94\u53c2\u6570\uff1apath={},result={}", (Object)path, (Object)result);
        return result;
    }

    private static String buildBasicAuthHeader(String username, String password) {
        String auth = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes());
    }

    public static String doGetWithQuery(String path, Map<String, String> queryParams, String tenantCode) throws Exception {
        LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u660e\u6587\uff1apath={}, queryParams={}", (Object)path, queryParams);
        CloseableHttpClient httpClient = HttpUtils.createSSLClientTrustAll();
        URIBuilder uriBuilder = new URIBuilder(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet request = new HttpGet(uriBuilder.build());
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-Type", "application/json");
        SslUtil.ignoreSsl();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        LOGGER.error("\u8bf7\u6c42\u54cd\u5e94\u53c2\u6570\uff1apath={}, result={}", (Object)path, (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPostSslFalse(String path, Map<String, String> headers, String bodys) throws Exception {
        CloseableHttpClient sslClientTrustAll = HttpUtils.createSSLClientTrustAll();
        try {
            HttpPost request = new HttpPost(path);
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    request.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (bodys != null) {
                StringEntity entity = new StringEntity(bodys, "utf-8");
                request.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse closeableHttpResponse = sslClientTrustAll.execute((HttpUriRequest)request);
            return closeableHttpResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                sslClientTrustAll.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static CloseableHttpClient createSSLClientTrustAll() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkClientTrusted(java.security.cert.X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(java.security.cert.X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            sslContext.init(null, trustManagers, new SecureRandom());
            String[] supportedProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, supportedProtocols, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return HttpClients.createDefault();
        }
    }

    public static void main(String[] args) {
        long timeStamp = System.currentTimeMillis();
        String toLowerCase = MD5Util.MD5((String)("DJZKJ" + timeStamp + "DJZKJ_3U")).toLowerCase();
        System.out.println(toLowerCase);
        System.out.println(timeStamp);
    }
}

