/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.hl.service.impl;

import com.alibaba.fastjson2.JSON;
import com.yqbsoft.laser.bus.ext.data.hl.domain.EditSkuDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.OcContractReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.OcRefundReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.RsSkuDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.RsSkuReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.SgSendgoodsBean;
import com.yqbsoft.laser.bus.ext.data.hl.domain.SgSendgoodsGoodsBean;
import com.yqbsoft.laser.bus.ext.data.hl.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.service.DataHlApiService;
import com.yqbsoft.laser.bus.ext.data.hl.utils.BusBaseService;
import com.yqbsoft.laser.bus.ext.data.hl.utils.EncryptUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.stereotype.Service;

@Service
public class DataHlApiServiceImpl
extends BusBaseService
implements DataHlApiService {
    private static final String SYS_CODE = "dataHlApiServiceImpl";

    @Override
    public String receivedRefundStatus(String content) {
        Map jsonToMap;
        this.logger.info("dataHlApiServiceImpl.receivedRefundStatus.content", (Object)content);
        String data = this.verify(content);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.verify error");
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        try {
            jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.json.error.e", (Throwable)e);
            return this.makeResult(false, "\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        Integer dataState = (Integer)jsonToMap.get("dataState");
        String refundCode = jsonToMap.get("refundCode").toString();
        if (dataState == null || StringUtil.isBlank((String)refundCode)) {
            return this.makeResult(false, "\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        String tenantCode = DataHlApiServiceImpl.getDdFlag("00000000", "tenantCode", "tenantCode");
        OcRefundReDomain refundByCode = this.getRefundByCode(refundCode);
        if (refundByCode == null) {
            return this.makeResult(false, "\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        }
        OcContractReDomain contractByCode = this.getContractByCode(refundByCode.getContractBillcode());
        if (contractByCode == null) {
            return this.makeResult(false, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (contractByCode.getDataState() == -1) {
            return this.makeResult(false, "\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        switch (dataState) {
            case 1: {
                if (refundByCode.getDataState() != 0) {
                    this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.getDataState.1", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                if ("B02".equals(refundByCode.getRefundType())) {
                    if (jsonToMap.get("goodsReceiptMem") == null || jsonToMap.get("goodsReceiptPhone") == null || jsonToMap.get("goodsReceiptArrdess") == null) {
                        this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.getDataState.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
                        return this.makeResult(false, "\u7f3a\u5c11\u5730\u5740\u4fe1\u606f");
                    }
                    if (StringUtil.isBlank((String)jsonToMap.get("goodsReceiptMem").toString()) || StringUtil.isBlank((String)jsonToMap.get("goodsReceiptPhone").toString()) || StringUtil.isBlank((String)jsonToMap.get("goodsReceiptArrdess").toString())) {
                        this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.getDataState.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
                        return this.makeResult(false, "\u5b58\u5728\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    refundByCode.setGoodsReceiptMem(jsonToMap.get("goodsReceiptMem").toString());
                    refundByCode.setGoodsReceiptPhone(jsonToMap.get("goodsReceiptPhone").toString());
                    refundByCode.setGoodsReceiptArrdess(jsonToMap.get("goodsReceiptArrdess").toString());
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)refundByCode));
                    String result = this.inInvokeApi("oc.refund.updateRefund", param);
                    this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.updateRefund.1", (Object)result);
                }
                this.sendRefundNext(refundCode, tenantCode, jsonToMap);
                break;
            }
            case -2: {
                if (refundByCode.getDataState() != 0) {
                    this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.getDataState.2", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                this.sendRefundBack(refundCode, tenantCode, jsonToMap);
                break;
            }
            case 8: {
                if (refundByCode.getDataState() != 2) {
                    this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.getDataState.3", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                this.sendRefundNext(refundCode, tenantCode, jsonToMap);
                break;
            }
            case 6: {
                if (refundByCode.getDataState() != 2) {
                    this.logger.error("dataHlApiServiceImpl.receivedRefundStatus.getDataState.4", (Object)refundByCode.getDataState());
                    return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
                }
                this.sendRefundBack(refundCode, tenantCode, jsonToMap);
                break;
            }
            default: {
                return this.makeResult(false, "\u72b6\u6001\u9519\u8bef");
            }
        }
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public String receivedOrderStatus(String content) {
        this.logger.error("dataHlApiServiceImpl.receivedOrderStatus.content", (Object)content);
        if (StringUtil.isBlank((String)content)) {
            this.logger.error("dataHlApiServiceImpl.receivedOrderStatus.content is null");
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String data = this.verify(content);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("dataHlApiServiceImpl.receivedOrderStatus.verify error");
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        return this.handleGoods(data);
    }

    public String handleGoods(String data) {
        SgSendgoodsBean sgSendgoodsBean = null;
        try {
            sgSendgoodsBean = (SgSendgoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(data, SgSendgoodsBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeResult(false, "\u6570\u636e\u683c\u5f0f\u5f02\u5e38");
        }
        OcContractReDomain contractReDomain = this.getContractByCode(sgSendgoodsBean.getContractBillcode());
        if (contractReDomain == null) {
            this.logger.error("dataHlApiServiceImpl.handleGoods.contractReDomain");
            return this.makeResult(false, "\u53d1\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (contractReDomain.getDataState() != 2 && contractReDomain.getDataState() != 8) {
            this.logger.error("dataHlApiServiceImpl.handleGoods.json.error.getDataState", (Object)contractReDomain.getDataState());
            return this.makeResult(false, "\u8ba2\u5355\u5df2\u53d1\u8d27");
        }
        String tenantCode = DataHlApiServiceImpl.getDdFlag("00000000", "tenantCode", "tenantCode");
        if (null == sgSendgoodsBean) {
            this.logger.error("dataHlApiServiceImpl.handleGoods", (Object)"param is null");
            return this.makeResult(false, "");
        }
        sgSendgoodsBean.setTenantCode(tenantCode);
        if (ListUtil.isEmpty(sgSendgoodsBean.getSgSendgoodsGoodsBeanList())) {
            this.logger.error("dataHlApiServiceImpl.handleGoods.goodsList", (Object)"goodsList is null");
            return this.makeResult(false, "\u53d1\u8d27\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{sgSendgoodsBean.getContractBillcode(), tenantCode});
        QueryResult<OcRefundReDomain> refundReDomainlist = this.queryRefundReDomainPage(getContractMap);
        if (ListUtil.isNotEmpty((Collection)refundReDomainlist.getList())) {
            for (OcRefundReDomain refund : refundReDomainlist.getList()) {
                if (refund.getDataState() != 0) continue;
                return this.makeResult(false, "\u8ba2\u5355\u6709\u672a\u5ba1\u6838\u7684\u552e\u540e\uff0c\u8bf7\u5148\u53bb\u5ba1\u6838");
            }
        }
        SgSendgoodsReDomain sgSendgoodsDomain = new SgSendgoodsReDomain();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", sgSendgoodsBean.getContractBillcode());
        map.put("tenantCode", sgSendgoodsBean.getTenantCode());
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsDomain, (Object)contractReDomain);
            BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsDomain, (Object)sgSendgoodsBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeResult(false, "\u64cd\u4f5c\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((String)sgSendgoodsBean.getWarehouseName())) {
            sgSendgoodsDomain.setWarehouseName(sgSendgoodsBean.getWarehouseName());
        }
        sgSendgoodsDomain.setGoodsWeight(sgSendgoodsBean.getGoodsCweight());
        if (ListUtil.isEmpty(contractReDomain.getGoodsList())) {
            this.logger.error("dataHlApiServiceImpl.handleGoods.goodsList", (Object)"goodsList is null");
            return this.makeResult(false, "\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        Map<String, OcContractGoodsDomain> goodsMap = this.makeMap(contractReDomain.getGoodsList());
        if (MapUtil.isEmpty(goodsMap)) {
            this.logger.error("dataHlApiServiceImpl.handleGoods.goodsMap", (Object)"goodsMap is null");
            return this.makeResult(false, "\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        ArrayList<SgSendgoodsGoodsDomain> sendgoodslist = new ArrayList<SgSendgoodsGoodsDomain>();
        BigDecimal sum = BigDecimal.ZERO;
        for (SgSendgoodsGoodsBean sgSendgoodsGoodsBean : sgSendgoodsBean.getSgSendgoodsGoodsBeanList()) {
            BigDecimal goodsSurplusNum;
            SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
            OcContractGoodsDomain ocContractGoodsDomain = goodsMap.get(sgSendgoodsGoodsBean.getContractGoodsCode());
            if (null == ocContractGoodsDomain) {
                this.logger.error("dataHlApiServiceImpl.handleGoods.ocContractGoodsDomain", (Object)sgSendgoodsGoodsBean.getContractGoodsCode());
                return this.makeResult(false, "\u8ba2\u5355\u5546\u54c1\u5f02\u5e38");
            }
            if (ocContractGoodsDomain.getContractGoodsSendnum() == null) {
                ocContractGoodsDomain.setContractGoodsSendnum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getContractGoodsRefnum() == null) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if ((goodsSurplusNum = ocContractGoodsDomain.getGoodsCamount().subtract(ocContractGoodsDomain.getContractGoodsSendnum()).subtract(ocContractGoodsDomain.getContractGoodsRefnum())).compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.error("dataHlApiServiceImpl.handleGoods.goodsNum", (Object)goodsSurplusNum);
                return this.makeResult(false, "\u5546\u54c1\u5df2\u53d1\u5b8c");
            }
            if (goodsSurplusNum.compareTo(sgSendgoodsGoodsBean.getSendgoodsGoodsCamount()) < 0) {
                this.logger.error("dataHlApiServiceImpl.handleGoods.goodsNum", (Object)(goodsSurplusNum + "--" + sgSendgoodsGoodsBean.getSendgoodsGoodsCamount()));
                return this.makeResult(false, "\u5546\u54c1\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)contractReDomain);
                BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
                BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)sgSendgoodsGoodsBean);
            }
            catch (Exception e) {
                this.logger.error("dataHlApiServiceImpl.handleGoods.goodsList", (Object)"fileList is null");
                return this.makeResult(false, "\u53d1\u8d27\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sgSendgoodsGoodsDomain.setGoodsNum(sgSendgoodsGoodsBean.getSendgoodsGoodsCamount());
            sum = sum.add(ocContractGoodsDomain.getContractGoodsPrice().multiply(sgSendgoodsGoodsBean.getSendgoodsGoodsCamount()));
            sgSendgoodsGoodsDomain.setPackageCode(this.getLockUUID());
            sendgoodslist.add(sgSendgoodsGoodsDomain);
        }
        sgSendgoodsDomain.setGoodsMoney(sum);
        sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sendgoodslist);
        sgSendgoodsDomain.setTenantCode(tenantCode);
        sgSendgoodsDomain.setContractType("03");
        sgSendgoodsDomain.setGoodsClass("welfare");
        this.logger.error("dataHlApiServiceImpl.handleGoods.sgSendgoodsDomain", (Object)JSON.toJSONString((Object)sgSendgoodsDomain));
        return this.sendsaveSgSendgoods(sgSendgoodsDomain);
    }

    @Override
    public String updateSkuEdits(String content) {
        this.logger.error("dataHlApiServiceImpl.updateSkuEdits.content", (Object)content);
        if (StringUtil.isBlank((String)content)) {
            this.logger.error("dataHlApiServiceImpl.updateSkuEdits.content is null");
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String verify = this.verify(content);
        Map map = (Map)JSON.parseObject((String)verify, Map.class);
        if (StringUtil.isBlank((String)verify) || MapUtil.isEmpty((Map)map)) {
            this.logger.error("dataHlApiServiceImpl.updateSkuEdits.param is null");
            return null;
        }
        if (!map.containsKey("skuId") || !map.containsKey("goodsSupplynum") || StringUtil.isBlank((String)map.get("skuId").toString()) || StringUtil.isBlank((String)map.get("goodsSupplynum").toString())) {
            this.logger.error("dataHlApiServiceImpl.updateSkuEdits.map is null");
            return this.makeResult(false, "\u5b58\u5728\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        RsSkuDomain skuNo = this.getSkuBySkuId(Integer.valueOf(map.get("skuId").toString()));
        if (skuNo == null) {
            this.logger.error("dataHlApiServiceImpl.updateSkuEdits.skuNo is null");
            return this.makeResult(false, "sku\u4e0d\u5b58\u5728");
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)editSkuDomain, (Object)skuNo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        editSkuDomain.setGoodsSupplynum(new BigDecimal(map.get("goodsSupplynum").toString()));
        this.sendUpdateSkuEdit(editSkuDomain);
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public SupQueryResult<OcRefundReDomain> OcRefundReDomain(String content) {
        this.logger.error("dataHlApiServiceImpl.OcRefundReDomain.content", (Object)content);
        String verify = this.verify(content);
        Map map = (Map)JSON.parseObject((String)verify, Map.class);
        if (StringUtil.isBlank((String)verify) || MapUtil.isEmpty((Map)map)) {
            this.logger.error("dataHlApiServiceImpl.OcRefundReDomain.param is null");
            return null;
        }
        if (!map.containsKey("page") || !map.containsKey("rows")) {
            this.logger.error("dataHlApiServiceImpl.OcRefundReDomain.page is null");
            return null;
        }
        map.put("refundType", "B01,B02");
        map.put("dataState", "0,2");
        this.makeDefPage(map);
        return this.queryRefundReDomainPage(map);
    }

    @Override
    public SupQueryResult<OcContractReDomain> queryContractPageReDomain(String content) {
        this.logger.error("dataHlApiServiceImpl.queryContractPageReDomain.content", (Object)content);
        String verify = this.verify(content);
        Map map = (Map)JSON.parseObject((String)verify, Map.class);
        if (StringUtil.isBlank((String)verify) || MapUtil.isEmpty((Map)map)) {
            this.logger.error("dataHlApiServiceImpl.queryContractPageReDomain.param is null");
            return null;
        }
        if (!map.containsKey("page") || !map.containsKey("rows")) {
            this.logger.error("dataHlApiServiceImpl.queryContractPageReDomain.page is null");
            return null;
        }
        map.put("dataState", 2);
        map.put("childFlag", true);
        this.makeDefPage(map);
        return this.queryContractPageReDomain(map);
    }

    @Override
    public SupQueryResult<RsSkuReDomain> querySkuListPage(String content) {
        this.logger.error("dataHlApiServiceImpl.querySkuPage.content", (Object)content);
        String verify = this.verify(content);
        Map map = (Map)JSON.parseObject((String)verify, Map.class);
        if (StringUtil.isBlank((String)verify) || MapUtil.isEmpty((Map)map)) {
            throw new ApiException(this.makeResult(false, "\u53c2\u6570\u9519\u8bef"));
        }
        if (!map.containsKey("page") || !map.containsKey("rows")) {
            this.logger.error("dataHlApiServiceImpl.queryContractPageReDomain.page is null");
            return null;
        }
        this.makeDefPage(map);
        return this.querySkuOnePage(map);
    }

    @Override
    public String aesEncrypt(String content, String apiKey) {
        if (StringUtil.isBlank((String)content) || StringUtil.isBlank((String)apiKey)) {
            return this.makeResult(false, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            return EncryptUtil.aesEncrypt(content, apiKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeResult(false, e.getMessage());
        }
    }
}

