/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.hl.utils;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.bus.ext.data.hl.domain.EditSkuDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.OcContractReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.OcRefundReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.RsSkuDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.RsSkuReDomain;
import com.yqbsoft.laser.bus.ext.data.hl.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.bus.ext.data.hl.utils.EncryptUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public abstract class BusBaseService
extends BaseServiceImpl {
    public static final String SYS_CODE = "BusBaseService";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    protected void makeDefPage(Map<String, Object> param) {
        param.put("tenantCode", BusBaseService.getDdFlag("00000000", "tenantCode", "tenantCode"));
        this.logger.debug("SupperFacade.makeDefPage.", param);
        if (null != param) {
            int page = 1;
            int rows = 10;
            if (null == param.get("page")) {
                param.put("page", page);
                param.put("rows", rows);
                param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
                param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            } else {
                rows = Integer.valueOf(String.valueOf(param.get("rows")));
                page = Integer.valueOf(String.valueOf(param.get("page")));
                if (rows > 100) {
                    rows = 100;
                    param.put("rows", rows);
                }
                param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
                param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            }
        }
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    protected void sendRefundNext(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.inInvokeApi("oc.refundEngine.sendRefundNext", param);
    }

    protected void sendRefundBack(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        map.put("backType", "1");
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.logger.error("BusBaseService.sendRefundBack.param", (Object)JSON.toJSONString(param));
        String result = this.inInvokeApi("oc.refundEngine.sendRefundBack", param);
        this.logger.error("BusBaseService.sendRefundBack.result", (Object)result);
    }

    public synchronized String getLockUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public QueryResult<OcRefundReDomain> queryRefundReDomainPage(Map<String, Object> map) {
        String apiCode = "oc.refund.queryRefundReDomainPage";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, pmap, OcRefundReDomain.class);
    }

    public String sendsaveSgSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        String apiCode = "sg.sendgoodsEngine.sendsaveSgSendgoods";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        return this.internalInvoke(apiCode, pmap);
    }

    protected Map<String, OcContractGoodsDomain> makeMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("BusBaseService.makeMap", (Object)"goodsList is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    protected RsSkuDomain getSkuBySkuId(Integer skuId) {
        String apiCode = "rs.sku.getSku";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("skuId", String.valueOf(skuId));
        return (RsSkuDomain)this.getForObject(apiCode, RsSkuDomain.class, paramMap);
    }

    public RsSkuDomain getSkuBySkuNo(String skuNo) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        String tenantCode = BusBaseService.getDdFlag("00000000", "tenantCode", "tenantCode");
        mapP.put("skuNo", skuNo);
        mapP.put("tenantCode", tenantCode);
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String skuStr = (String)internalRouter.inInvoke("rs.sku.getSkuBySkuNo", mapP);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)skuStr)) {
            return null;
        }
        return (RsSkuDomain)JsonUtil.buildNormalBinder().getJsonToObject(skuStr, RsSkuDomain.class);
    }

    protected OcRefundReDomain getRefundByCode(String refundCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.refund.getRefundByCode";
        param.put("refundCode", refundCode);
        param.put("tenantCode", BusBaseService.getDdFlag("00000000", "tenantCode", "tenantCode"));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, OcRefundReDomain.class);
        return ocRefundReDomain;
    }

    protected OcContractReDomain getContractByCode(String contractBillcode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.getContractByCode";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", BusBaseService.getDdFlag("00000000", "tenantCode", "tenantCode"));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        OcContractReDomain contractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, OcContractReDomain.class);
        return contractReDomain;
    }

    public String sendUpdateSkuEdit(EditSkuDomain editSkuDomain) {
        String apiCode = "rs.resource.sendUpdateSkuEdit";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        return this.internalInvoke(apiCode, pmap);
    }

    public QueryResult<OcContractReDomain> queryContractPageReDomain(Map<String, Object> map) {
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, pmap, OcContractReDomain.class);
    }

    protected QueryResult<RsSkuReDomain> querySkuOnePage(Map<String, Object> map) {
        String apiCode = "rs.sku.querySkuOnePage";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, param, RsSkuReDomain.class);
    }

    protected String verify(String content) {
        String tenantCode = BusBaseService.getDdFlag("00000000", "tenantCode", "tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("BusBaseService.verify tenantCode is null");
            return null;
        }
        String secretkey = BusBaseService.getDdFlag(tenantCode, "hlSecretkey", "hlSecretkey");
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("BusBaseService.verify", (Object)(content + "-" + tenantCode));
            return null;
        }
        String data = null;
        try {
            data = EncryptUtil.aesDecrypt(content, secretkey);
            this.logger.error("BusBaseService.verify.data", (Object)data);
        }
        catch (Exception e) {
            this.logger.error("BusBaseService.verify.e", (Throwable)e);
            return null;
        }
        return data;
    }

    protected String makeResult(Boolean flag, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", flag);
        resultMap.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    protected static boolean areMapValuesNonEmpty(Map map, String ... key) {
        for (String mapKey : key) {
            if (map.containsKey(mapKey)) continue;
            return false;
        }
        return true;
    }

    protected static String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    protected static String getRequestUrl(String tenantCode, String urlKeyPrefix, String urlKey) {
        return BusBaseService.getDdFlag(tenantCode, urlKeyPrefix, urlKeyPrefix) + BusBaseService.getDdFlag(tenantCode, urlKey, urlKey);
    }

    protected Map<String, Object> getDdMap(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String json = BusBaseService.getDdFlag(tenantCode, flagSettingType, flagSettingCode);
        return JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
    }

    protected String getTenantCodeBuUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String s = url.replace("http://", "").replace("https://", "");
        String[] str = s.split("/");
        if (str.length <= 6) {
            return null;
        }
        return str[6];
    }

    protected String getTeananMemberCode(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }
}

