/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.hl.aop;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.yqbsoft.laser.bus.ext.data.hl.domain.DisChannel;
import com.yqbsoft.laser.bus.ext.data.hl.utils.BusBaseService;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jsoup.helper.StringUtil;

@Aspect
public class DecryptAndVerifyAspect
extends BusBaseService {
    private static final String SYS_CODE = "decryptAndVerifyAspect";

    @Around(value="@annotation(DecryptAndVerify) && args(appId, encryptedContent, ..)")
    public Object decryptAndVerify(ProceedingJoinPoint joinPoint, String appId, String encryptedContent) throws Throwable {
        if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)encryptedContent)) {
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String logPrefix = joinPoint.getTarget().getClass().getName() + "." + signature.getName();
        this.logger.error(SYS_CODE + logPrefix + "decryptAndVerify.appId", (Object)appId);
        this.logger.error(SYS_CODE + logPrefix + "decryptAndVerify.encryptedContent", (Object)encryptedContent);
        String tenantCode = DecryptAndVerifyAspect.getDdFlag("00000000", "tenantCode", "tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            return this.makeResult(false, "\u64cd\u4f5c\u5931\u8d25");
        }
        String secretkey = this.getDdFalgSetting(tenantCode, "hlapi", "secretkey", appId);
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error(SYS_CODE + logPrefix + ".verify appId", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        DisChannel disChannel = this.getChannelSup(appId, tenantCode);
        if (null == disChannel) {
            this.logger.error(SYS_CODE + logPrefix + "disChannel is null", (Object)(appId + "-" + tenantCode));
            return this.makeResult(false, "\u6e20\u9053\u4e3a\u7a7a");
        }
        String decryptedContent = null;
        try {
            decryptedContent = this.verify(encryptedContent, secretkey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        if (StringUtil.isBlank((String)decryptedContent)) {
            return this.makeResult(false, "param is null");
        }
        Map map = null;
        try {
            map = (Map)JSON.parseObject((String)decryptedContent, (TypeReference)new TypeReference<Map<String, Object>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.makeResult(false, "\u7b7e\u540d\u9519\u8bef");
        }
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error(SYS_CODE + logPrefix + "map is null", (Object)decryptedContent);
            return this.makeResult(false, "param is null");
        }
        this.logger.error(SYS_CODE + logPrefix + "decryptedContent", (Object)decryptedContent);
        Object[] args = new Object[]{appId, decryptedContent, disChannel, map};
        return joinPoint.proceed(args);
    }
}

