/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.RefundUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.RefundResponseData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.RefundResponseDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.RefundUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.RefundService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.RequestUrl;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RefundServiceImpl
extends DateBaseService
implements RefundService {
    private static String SYS_CODE = "jst.RefundServiceImpl";

    @Override
    public String saveRefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            logger.error(SYS_CODE + ".saveRefund ocRefundDomain is null");
            return "error";
        }
        if (null == ocRefundDomain.getGmtCreate()) {
            ocRefundDomain.setGmtCreate(new Date());
        }
        if (null == ocRefundDomain.getGmtModified()) {
            ocRefundDomain.setGmtModified(ocRefundDomain.getGmtCreate());
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            logger.error(SYS_CODE + ".saveRefund getOcRefundGoodsDomainList is null");
            return "error";
        }
        String access_token = RefundServiceImpl.gettoken(ocRefundDomain.getMemberCcode(), ocRefundDomain.getTenantCode());
        if (StringUtils.isBlank((String)access_token)) {
            return "token\u5931\u6548";
        }
        List<RefundUploadRequest> refundUploadRequests = this.makeRefundUploadRequest(ocRefundDomain);
        if (ListUtil.isEmpty(refundUploadRequests)) {
            logger.error(SYS_CODE + ".saveRefund refundUploadRequests is null");
            return "error";
        }
        String appkey = RequestUrl.jstappkey;
        String secret = RequestUrl.jstsecret;
        String url = RequestUrl.jstUrl + "/open/aftersale/upload";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(refundUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = RefundServiceImpl.buildQuery(params);
        String responseStr = RefundServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error(SYS_CODE + ".saveRefund responseStr is null");
            return "error";
        }
        RefundUploadResponse refundUploadResponse = (RefundUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, RefundUploadResponse.class);
        if (null == refundUploadResponse) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponse is null", (Object)responseStr);
            return "error";
        }
        if (0 != refundUploadResponse.getCode()) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponse is error", (Object)refundUploadResponse.getMsg());
            return "error";
        }
        RefundResponseData refundUploadResponseData = refundUploadResponse.getData();
        if (null == refundUploadResponseData) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponseData is null", (Object)responseStr);
            return "error";
        }
        List<RefundResponseDatas> datas = refundUploadResponseData.getDatas();
        if (ListUtil.isEmpty(datas)) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponseDatas is null", (Object)responseStr);
            return "error";
        }
        for (RefundResponseDatas data : datas) {
            if (data.isIssuccess()) {
                this.updateRefundNcode(data.getOuter_as_id(), data.getAs_id(), ocRefundDomain.getTenantCode(), null, 1);
                continue;
            }
            logger.error(SYS_CODE + ".saveRefund data is error", (Object)responseStr);
            this.updateRefundNcode(ocRefundDomain.getRefundCode(), null, ocRefundDomain.getTenantCode(), data.getMsg(), -1);
            return "error";
        }
        return "success";
    }

    private List<RefundUploadRequest> makeRefundUploadRequest(OcRefundReDomain ocRefundDomain) {
        UmUserinfo user = this.getUser(ocRefundDomain.getTenantCode(), ocRefundDomain.getMemberCcode());
        if (null == user) {
            logger.error(SYS_CODE + ".saveRefund getUser is null");
            return null;
        }
        String shopId = user.getCompanyCode();
        if (StringUtils.isBlank((String)shopId)) {
            logger.error(SYS_CODE + ".saveRefund shopId is null");
            return null;
        }
        OcContractReDomain contractDomain = this.getContractDomain(ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode());
        if (null == contractDomain) {
            logger.error(SYS_CODE + ".saveRefund getContractDomain is null");
            return null;
        }
        ArrayList<RefundUploadRequest> refundUploadRequests = new ArrayList<RefundUploadRequest>();
        RefundUploadRequest refundUploadRequest = new RefundUploadRequest();
        refundUploadRequest.setShop_id(Integer.parseInt(shopId));
        refundUploadRequest.setOuter_as_id(ocRefundDomain.getRefundCode());
        refundUploadRequest.setSo_id(ocRefundDomain.getContractBillcode());
        refundUploadRequest.setType(RefundServiceImpl.getRefundType(ocRefundDomain.getRefundType()));
        refundUploadRequest.setLogistics_company(ocRefundDomain.getPackageName());
        refundUploadRequest.setL_id(ocRefundDomain.getPackageBillno());
        refundUploadRequest.setShop_status(RefundServiceImpl.getShopStatus(ocRefundDomain.getDataState()));
        refundUploadRequest.setGood_status(RefundServiceImpl.getGoodStatus(ocRefundDomain.getDataState(), ocRefundDomain.getRefundType()));
        refundUploadRequest.setQuestion_type(ocRefundDomain.getRefundEx());
        refundUploadRequest.setTotal_amount(contractDomain.getContractMoney());
        refundUploadRequest.setRefund(ocRefundDomain.getRefundMoney());
        refundUploadRequest.setPayment(new BigDecimal(0));
        refundUploadRequests.add(refundUploadRequest);
        ArrayList<RefundGoodsDomain> refundGoodsDomains = new ArrayList<RefundGoodsDomain>();
        refundUploadRequest.setItems(refundGoodsDomains);
        RefundGoodsDomain refundGoodsDomain = null;
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            refundGoodsDomain = new RefundGoodsDomain();
            refundGoodsDomains.add(refundGoodsDomain);
            if (null == ocRefundGoodsDomain.getRefundGoodsAmt()) {
                ocRefundGoodsDomain.setRefundGoodsAmt(BigDecimal.ZERO);
            }
            if (null == ocRefundGoodsDomain.getRefundGoodsNum()) {
                ocRefundGoodsDomain.setRefundGoodsNum(BigDecimal.ZERO);
            }
            refundGoodsDomain.setAmount(ocRefundGoodsDomain.getRefundGoodsAmt());
            refundGoodsDomain.setSku_id(ocRefundGoodsDomain.getSkuNo());
            refundGoodsDomain.setQty(ocRefundGoodsDomain.getRefundGoodsNum().intValue());
            refundGoodsDomain.setOuter_oi_id(ocRefundGoodsDomain.getGoodsOldcode());
            refundGoodsDomain.setType(RefundServiceImpl.getRefundGoodsType(ocRefundDomain.getRefundType()));
        }
        return refundUploadRequests;
    }

    public static void main(String[] args) {
        String ocJosn = "{\n    \"refundId\": 33,\n    \"refundCode\": \"1005514183843762255\",\n    \"refundNcode\": \"11061708\",\n    \"refundOcode\": null,\n    \"refundType\": \"B02\",\n    \"refundMoney\": 0.01000000,\n    \"refundUsertype\": \"0\",\n    \"channelCode\": \"985905555124039746\",\n    \"channelName\": \"\u6d77\u4eae\u521d\u7ea7\u4e2d\u5b66\",\n    \"contractBillcode\": \"1005774005935788092\",\n    \"contractNbillcode\": \"5606157\",\n    \"contractNbbillcode\": null,\n    \"memberCode\": \"20000210528421\",\n    \"memberMcode\": \"20021000097768\",\n    \"memberMname\": \"13200000000\",\n    \"memberName\": \"\u6d77\u4eae\u521d\u7ea7\u4e2d\u5b66\",\n    \"memberBcode\": \"10000210529666\",\n    \"memberBname\": \"12321\",\n    \"memberCcode\": \"20000210525451\",\n    \"memberCname\": \"\u5b81\u6ce2\u91d1\u9e1f\u670d\u9970\u6709\u9650\u516c\u53f8\",\n    \"ptradeSeqno\": \"1005774010876678198\",\n    \"contractBbillcode\": \"1005774005935788092\",\n    \"contractType\": \"00\",\n    \"contractTypepro\": \"0\",\n    \"contractPmode\": \"0\",\n    \"contractPumode\": \"0\",\n    \"goodsNum\": 1.00000000,\n    \"goodsWeight\": 0E-8,\n    \"contractMoney\": 0.01000000,\n    \"contractPaymoney\": 0E-8,\n    \"ddTypeCurrency\": null,\n    \"contractRemark\": null,\n    \"goodsLogmoney\": 0E-8,\n    \"appmanageIcode\": \"097\",\n    \"tenantCode\": \"2023072819990101\",\n    \"packageMode\": null,\n    \"packageBillno\": null,\n    \"packageName\": null,\n    \"refundReceiptPhone\": null,\n    \"refundReceiptArrdess\": null,\n    \"refundReceiptMem\": null,\n    \"refundZip\": null,\n    \"refundPakedes\": null,\n    \"refundPake\": null,\n    \"refundEmail\": null,\n    \"refundTel\": null,\n    \"refundPhone\": null,\n    \"refundArrdess\": null,\n    \"refundArrdesscode\": null,\n    \"refundMem\": null,\n    \"goodsReceiptMem\": \"\u552e\u540e\u4ed3\u5e93\",\n    \"goodsReceiptArrdess\": \"\u6cb3\u5357\u9e64\u58c1\u5e02\u6dc7\u53bfXXX\u53f7\",\n    \"goodsReceiptPhone\": \"13366665555\",\n    \"cashback\": 0.01000000,\n    \"fchannelCode\": null,\n    \"faccountName\": null,\n    \"refundEx\": \"\u4e0b\u9519\u5355\",\n    \"packageCode\": null,\n    \"refundMeo\": \"\",\n    \"addressCode\": null,\n    \"contractState\": 3,\n    \"dataOpnextbillstate\": 1,\n    \"refundInvstate\": 0,\n    \"refundDate\": null,\n    \"pricesetCurrency\": null,\n    \"pricesetCurrency1\": null,\n    \"refundAudate\": 1754533109000,\n    \"refundUex\": null,\n    \"refundUcode\": null,\n    \"refundUname\": null,\n    \"refundPmmoney\": null,\n    \"refundClass\": null,\n    \"refundPumode\": null,\n    \"memberGcode\": null,\n    \"memberGname\": null,\n    \"refundCtrlSeqno\": null,\n    \"dataStatestr\": \"61\",\n    \"ocRefundSettlDomainList\": null,\n    \"ocRefundGoodsDomainList\": null,\n    \"ocRefundFileDomainList\": null,\n    \"refundCreate\": null,\n    \"gmtCreate\": 1754531663000,\n    \"gmtModified\": 1754533109000,\n    \"memo\": null,\n    \"dataState\": 8,\n    \"ocContractproDomainList\": null,\n    \"goodsList\": null,\n    \"erpCode\": null,\n    \"erpDate\": null,\n    \"erpAmt\": null,\n    \"ocRefundGoodsDomainList\": [\n        {\n            \"refundGoodsId\": 37,\n            \"refundGoodsType\": 0,\n            \"refundGoodsOldcode\": null,\n            \"refundGoodsCode\": \"760388600a0f4ecb8a13d406f819b502\",\n            \"refundCode\": \"1005514183843762255\",\n            \"contractBillcode\": \"1005774005935788092\",\n            \"contractGoodsCode\": \"5d74070c7ac34296899be8e6f2edb307\",\n            \"memberCode\": \"20000210528421\",\n            \"memberName\": \"\u6d77\u4eae\u521d\u7ea7\u4e2d\u5b66\",\n            \"memberCcode\": \"20000210525451\",\n            \"memberCname\": \"\u5b81\u6ce2\u91d1\u9e1f\u670d\u9970\u6709\u9650\u516c\u53f8\",\n            \"memberBcode\": \"10000210529666\",\n            \"memberBname\": \"12321\",\n            \"goodsCode\": \"1004772793697423390\",\n            \"goodsName\": \"\u91d1\u9e1f\u805a\u6c34\u6f6d\",\n            \"goodsCamount\": 1.000000,\n            \"goodsCweight\": null,\n            \"goodsOrigin\": \"11\",\n            \"goodsPro\": \"0\",\n            \"goodsType\": \"00\",\n            \"contractGoodsGtype\": \"0\",\n            \"skuCode\": \"1005121666702888993\",\n            \"skuOldcode\": null,\n            \"goodsOldcode\": null,\n            \"spuCode\": \"562af5e9e4914281995a7eacfa7e538d\",\n            \"skuName\": \"\u5c0f\u53f7\",\n            \"skuEocode\": null,\n            \"goodsEocode\": null,\n            \"classtreeCode\": \"985917551622475777\",\n            \"classtreeShopcode\": null,\n            \"classtreeName\": null,\n            \"classtreeShopname\": null,\n            \"pntreeName\": \"\u4e66\u5305\",\n            \"partsnameName\": null,\n            \"productareaName\": null,\n            \"goodsMaterial\": null,\n            \"goodsMinnum\": 1.00000000,\n            \"goodsOneweight\": 1.00000000,\n            \"refundGoodsAmt\": 0.01000000,\n            \"refundGoodsPrice\": 0.01000000,\n            \"refundGoodsWeight\": null,\n            \"refundGoodsNum\": 1.00000000,\n            \"goodsWeight\": 0E-8,\n            \"goodsNum\": 1.00000000,\n            \"goodsSupplynum\": 994.00000000,\n            \"goodsSupplyweight\": 33.00000000,\n            \"goodsAhnum\": 0E-8,\n            \"goodsAhweight\": 0E-8,\n            \"goodsHangnum\": 992.00000000,\n            \"goodsHangweight\": 33.00000000,\n            \"goodsTopnum\": null,\n            \"goodsTopweight\": null,\n            \"goodsOrdnum\": 1.00000000,\n            \"goodsOrdweight\": 0E-8,\n            \"partsnameNumunit\": \"\u4ef6\",\n            \"partsnameWeightunit\": \"\u4e2a\",\n            \"pricesetNprice\": 0.01000000,\n            \"pricesetMakeprice\": 0.01000000,\n            \"pricesetBaseprice\": 0E-8,\n            \"pricesetAsprice\": 0.01000000,\n            \"pricesetType\": null,\n            \"pricesetRefrice\": 0E-8,\n            \"pricesetPrefprice\": 0E-8,\n            \"pricesetInsideprice\": 0E-8,\n            \"warehouseName\": null,\n            \"contractGoodsBoxnum\": null,\n            \"contractGoodsBoxprice\": null,\n            \"contractGoodsBoxamt\": 0E-8,\n            \"skuNo\": \"jnjst1\",\n            \"skuBarcode\": \"\",\n            \"goodsNo\": \"jnjst\",\n            \"skuShowno\": \"jnjst1\",\n            \"goodsShowno\": \"jnjst\",\n            \"areaName\": null,\n            \"areaCode\": null,\n            \"warehouseCode\": null,\n            \"goodsContract\": null,\n            \"dataPic\": \"/paas/shop/2023072819990101//B6413103244000.jpg\",\n            \"dataPicpath\": null,\n            \"memberContact\": null,\n            \"memberContactPhone\": null,\n            \"dataOpbillstate\": 0,\n            \"memberContactQq\": null,\n            \"appmanageIcode\": null,\n            \"tenantCode\": \"2023072819990101\",\n            \"mschannelCode\": null,\n            \"mschannelName\": null,\n            \"goodsRemark\": \"\",\n            \"pricesetCurrency\": null,\n            \"pricesetCurrency1\": null,\n            \"goodsSpec\": null,\n            \"goodsSpec1\": null,\n            \"goodsSpec2\": null,\n            \"goodsSpec3\": null,\n            \"goodsSpec4\": null,\n            \"goodsSpec5\": null,\n            \"goodsProperty\": \"\",\n            \"goodsProperty1\": null,\n            \"goodsProperty2\": null,\n            \"goodsProperty3\": null,\n            \"goodsProperty4\": null,\n            \"goodsProperty5\": null,\n            \"ocRefundPmGoodsDomainList\": null,\n            \"goodsClass\": null,\n            \"memberMcode\": \"20021000097768\",\n            \"memberMname\": \"13200000000\",\n            \"goodsDay\": null,\n            \"goodsDayinfo\": null,\n            \"ginfoCode\": null\n        }\n    ],\n    \"ocRefundFileList\": []\n}";
        OcRefundReDomain ocRefundDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocJosn, OcRefundReDomain.class);
        ArrayList<RefundUploadRequest> refundUploadRequests = new ArrayList<RefundUploadRequest>();
        RefundUploadRequest refundUploadRequest = new RefundUploadRequest();
        refundUploadRequest.setShop_id(Integer.parseInt("10411258"));
        refundUploadRequest.setOuter_as_id(ocRefundDomain.getRefundCode());
        refundUploadRequest.setSo_id(ocRefundDomain.getContractBillcode());
        refundUploadRequest.setType(RefundServiceImpl.getRefundType(ocRefundDomain.getRefundType()));
        refundUploadRequest.setLogistics_company(ocRefundDomain.getPackageName());
        refundUploadRequest.setL_id(ocRefundDomain.getPackageBillno());
        refundUploadRequest.setShop_status(RefundServiceImpl.getShopStatus(ocRefundDomain.getDataState()));
        refundUploadRequest.setGood_status(RefundServiceImpl.getGoodStatus(ocRefundDomain.getDataState(), ocRefundDomain.getRefundType()));
        refundUploadRequest.setQuestion_type(ocRefundDomain.getRefundEx());
        refundUploadRequest.setTotal_amount(new BigDecimal("0.01"));
        refundUploadRequest.setRefund(ocRefundDomain.getRefundMoney());
        refundUploadRequest.setPayment(new BigDecimal(0));
        refundUploadRequests.add(refundUploadRequest);
        ArrayList<RefundGoodsDomain> refundGoodsDomains = new ArrayList<RefundGoodsDomain>();
        refundUploadRequest.setItems(refundGoodsDomains);
        RefundGoodsDomain refundGoodsDomain = null;
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            refundGoodsDomain = new RefundGoodsDomain();
            refundGoodsDomains.add(refundGoodsDomain);
            if (null == ocRefundGoodsDomain.getRefundGoodsAmt()) {
                ocRefundGoodsDomain.setRefundGoodsAmt(BigDecimal.ZERO);
            }
            if (null == ocRefundGoodsDomain.getRefundGoodsNum()) {
                ocRefundGoodsDomain.setRefundGoodsNum(BigDecimal.ZERO);
            }
            refundGoodsDomain.setAmount(ocRefundGoodsDomain.getRefundGoodsAmt());
            refundGoodsDomain.setSku_id(ocRefundGoodsDomain.getSkuNo());
            refundGoodsDomain.setQty(ocRefundGoodsDomain.getRefundGoodsNum().intValue());
            refundGoodsDomain.setOuter_oi_id(ocRefundGoodsDomain.getGoodsOldcode());
            refundGoodsDomain.setType(RefundServiceImpl.getRefundGoodsType(ocRefundDomain.getRefundType()));
        }
        if (ListUtil.isEmpty(refundUploadRequests)) {
            // empty if block
        }
        String appkey = RequestUrl.jstappkey;
        String access_token = "edde3effe6ef441bb7e9118f3cc90f45";
        String secret = RequestUrl.jstsecret;
        String url = RequestUrl.jstUrl + "/open/aftersale/upload";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        String json = JsonUtil.buildNonNullBinder().toJson(refundUploadRequests);
        System.out.println(json);
        params.put("biz", json);
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = RefundServiceImpl.buildQuery(params);
        String responseStr = RefundServiceImpl.execute(parmStr, url);
        System.out.println(responseStr);
    }

    private static String getRefundType(String refundType) {
        if ("B02".equals(refundType) || "F082".equals(refundType) || "F002".equals(refundType)) {
            return "\u666e\u901a\u9000\u8d27";
        }
        if ("B01".equals(refundType) || "F081".equals(refundType) || "F001".equals(refundType)) {
            return "\u4ec5\u9000\u6b3e";
        }
        return "\u5176\u5b83";
    }

    private static String getRefundGoodsType(String refundType) {
        if ("B02".equals(refundType) || "F082".equals(refundType) || "F002".equals(refundType)) {
            return "\u9000\u8d27";
        }
        return "\u5176\u5b83";
    }

    private static String getShopStatus(Integer dataState) {
        if (0 == dataState) {
            return "WAIT_SELLER_AGREE";
        }
        if (1 == dataState) {
            return "WAIT_BUYER_RETURN_GOODS";
        }
        if (8 == dataState) {
            return "SUCCESS";
        }
        if (-1 == dataState) {
            return "SELLER_REFUSE_BUYER";
        }
        if (2 == dataState) {
            return "WAIT_SELLER_CONFIRM_GOODS";
        }
        if (6 == dataState) {
            return "SELLER_REFUSE_BUYER";
        }
        return "error";
    }

    private static String getGoodStatus(Integer dataState, String refundType) {
        if ("B01".equals(refundType)) {
            return "BUYER_NOT_RECEIVED";
        }
        return "BUYER_RECEIVED";
    }

    private void updateRefundNcode(String refundCode, String refundNcode, String tenantCode, String memo, Integer dataOpnextbillstate) {
        String apiCode = "oc.refund.updateRefundNcodeMap";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("refundNcode", refundNcode);
        param.put("dataOpnextbillstate", dataOpnextbillstate);
        param.put("memo", memo);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.internalInvoke(apiCode, map);
    }
}

