/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.common;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class ErpRequestParams {
    private String appkey;
    private String sessionkey;
    private String method;
    private String sign;
    private Map<String, Object> bizParams = new HashMap<String, Object>();

    public ErpRequestParams() {
    }

    public ErpRequestParams(String appkey, String sessionkey, String method) {
        this.appkey = appkey;
        this.sessionkey = sessionkey;
        this.method = method;
    }

    public ErpRequestParams addBizParam(String key, Object value) {
        this.bizParams.put(key, value);
        return this;
    }

    public ErpRequestParams addBizParams(Map<String, Object> params) {
        if (params != null) {
            this.bizParams.putAll(params);
        }
        return this;
    }

    public String generateSign(String secret) {
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        allParams.put("appkey", this.appkey);
        allParams.put("sessionkey", this.sessionkey);
        allParams.put("method", this.method);
        allParams.putAll(this.bizParams);
        String jsonStr = JsonUtil.buildNormalBinder().toJson(allParams);
        String signStr = secret + jsonStr + secret;
        this.sign = DigestUtils.md5Hex((String)signStr).toUpperCase();
        return signStr;
    }

    public Map<String, Object> toRequestMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("appkey", this.appkey);
        result.put("sessionkey", this.sessionkey);
        result.put("method", this.method);
        result.put("sign", this.sign);
        result.putAll(this.bizParams);
        return result;
    }

    public String toJsonString() {
        return JsonUtil.buildNormalBinder().toJson(this.toRequestMap());
    }

    public String getAppkey() {
        return this.appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getSessionkey() {
        return this.sessionkey;
    }

    public void setSessionkey(String sessionkey) {
        this.sessionkey = sessionkey;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public Map<String, Object> getBizParams() {
        return this.bizParams;
    }

    public void setBizParams(Map<String, Object> bizParams) {
        this.bizParams = bizParams;
    }
}

