/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.data.util.UserInfo;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import org.apache.poi.xwpf.converter.pdf.PdfConverter;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class WordUtil1 {
    private static final Configuration CONFIGURATION = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public static String generate(String templateFileName, Object templateParam) throws ApiException {
        try {
            Template t = CONFIGURATION.getTemplate(templateFileName, "utf-8");
            ByteArrayOutputStream wordOutputStream = new ByteArrayOutputStream();
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)wordOutputStream, StandardCharsets.UTF_8), 10240);){
                t.process(templateParam, (Writer)out);
            }
            ByteArrayInputStream wordInputStream = new ByteArrayInputStream(wordOutputStream.toByteArray());
            ByteArrayOutputStream pdfOutputStream = new ByteArrayOutputStream();
            XWPFDocument doc = new XWPFDocument((InputStream)wordInputStream);
            PdfConverter.getInstance().convert(doc, (OutputStream)pdfOutputStream, null);
            String s = WordUtil1.encodePdfToBase64(pdfOutputStream.toByteArray());
            return s;
        }
        catch (Exception e) {
            throw new ApiException("\u751f\u6210Word\u6587\u6863\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private static String encodePdfToBase64(byte[] pdfBytes) throws ApiException {
        try {
            return Base64.getEncoder().encodeToString(pdfBytes);
        }
        catch (Exception e) {
            throw new ApiException("\u5bf9PDF\u6587\u4ef6\u8fdb\u884cBase64\u7f16\u7801\u65f6\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Object> templateParam = new HashMap<String, Object>(5);
            templateParam.put("date", "2024-11-19");
            templateParam.put("\u603b\u91d1\u989d", 1);
            ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
            UserInfo userInfo = new UserInfo();
            userInfo.setId("c1");
            userInfo.setName("c2");
            userInfo.setNumber("c4");
            userInfo.setPrice("c5");
            userInfo.setAmount("c6");
            userInfo.setAmountIncludingTax("c6");
            userInfo.setDeliveryTime("111");
            userInfo.setMaterialCode("c2");
            userInfo.setContractGoodsRemark("1");
            UserInfo userInfo11 = new UserInfo();
            userInfo11.setId("c11");
            userInfo11.setName("c21");
            userInfo11.setNumber("c14");
            userInfo11.setPrice("c51");
            userInfo11.setAmount("c61");
            userInfo11.setAmountIncludingTax("c61");
            userInfo11.setDeliveryTime("111");
            userInfo11.setMaterialCode("c21");
            userInfo11.setContractGoodsRemark("1");
            userList.add(userInfo11);
            userList.add(userInfo);
            templateParam.put("total", userList.size());
            templateParam.put("businessOrderno", "908416100693377064");
            templateParam.put("orderNumber", "908416100693377064");
            templateParam.put("sellers", "\u5546\u5bb6\u8d26\u53f7\u6f14\u793a");
            templateParam.put("buyers", "18516533888");
            templateParam.put("placeOfSigning", "\u4e0a\u6d77");
            templateParam.put("dateOfSigning", "2024-11-14  17:38:03");
            templateParam.put("totalAmount", 35.8);
            templateParam.put("totalAmountIncludingTax", "w8");
            templateParam.put("rate", "1");
            templateParam.put("totalAmountUpper", 35.8);
            templateParam.put("seller", "xxx");
            templateParam.put("domicile1", "xxx");
            templateParam.put("representative", "xxx");
            templateParam.put("agent1", "xxx");
            templateParam.put("phone1", "xxx");
            templateParam.put("fax1", "xxx");
            templateParam.put("tax1", "xxx");
            templateParam.put("bank1", "xxx");
            templateParam.put("account1", "xxx");
            templateParam.put("zipCode1", "xxx");
            templateParam.put("buyer", "xxx");
            templateParam.put("domicile2", "xxx");
            templateParam.put("head", "xxx");
            templateParam.put("agent2", "xxx");
            templateParam.put("phone2", "xxx");
            templateParam.put("fax2", "xxx");
            templateParam.put("tax2", "xxx");
            templateParam.put("bank2", "xxx");
            templateParam.put("account2", "xxx");
            templateParam.put("zipCode2", "xxx");
            templateParam.put("total", userList.size());
            templateParam.put("userList", userList);
            String base64EncodedPdf = WordUtil1.generate("generate_word_test.xml", templateParam);
            System.out.println("Base64\u7f16\u7801\u540e\u7684PDF\u5185\u5bb9: " + base64EncodedPdf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        CONFIGURATION.setDefaultEncoding("utf-8");
        CONFIGURATION.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(WordUtil1.class, "/templates"));
    }

    public static class PdfToBase64EncodingException
    extends Exception {
        public PdfToBase64EncodingException(String message) {
            super(message);
        }
    }

    public static class WordGenerationException
    extends Exception {
        public WordGenerationException(String message) {
            super(message);
        }
    }
}

