/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.OcContractDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundDomain;
import com.yqbsoft.laser.service.pos.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.pos.domain.RsSkuDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosCancelOrderRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosSaveOrderRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosOrderResponse;
import com.yqbsoft.laser.service.pos.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.pos.service.ContractService;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsPos.ContractServiceImpl";
    String queryUserinfoPageApiCode = "um.user.queryUserinfoPage";
    String queryResourceGoodsPageByMapApiCode = "rs.resourceGoods.queryResourceGoodsPage";
    String queryUserinfoListApiCode = "um.userbase.queryUserinfoList";
    String sendsaveContractApiCode = "oc.contractEngine.sendsaveContract";
    String sendSaveRefundApiCode = "oc.refundEngine.sendSaveRefund";
    String sendupdateRefundStateByCodeApiCode = "oc.refundEngine.sendupdateRefundStateByCode";

    @Override
    public String sendContractAssignment(OcContractDomain ocContractDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendContractAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/saveOrder?accessToken=ACCESS_TOKEN";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosSaveOrderRequest jbsPosSaveOrderRequest = new JbsPosSaveOrderRequest();
            jbsPosSaveOrderRequest.setMemberBcode(this.getStoreCode(ocContractDomain.getMemberBcode()));
            BeanUtils.copyAllPropertys((Object)jbsPosSaveOrderRequest, (Object)ocContractDomain);
            execute = httpFormfacade.execute(jbsPosSaveOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendContractAssignment Exception", null);
        }
    }

    @Override
    public String sendRefundAssignment(OcRefundDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/cancelRefundOrder?accessToken=ACCESS_TOKEN";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosSaveOrderRequest jbsPosSaveOrderRequest = new JbsPosSaveOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosSaveOrderRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosSaveOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundAssignment Exception", null);
        }
    }

    @Override
    public String sendCancelShipment(OcContractDomain ocContractDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", null);
        }
        this.logger.error(this.SYS_CODE + "sendCancelShipment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/cancelOrder?accessToken=ACCESS_TOKEN";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)ocContractDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getPosErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", "", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getPosErrorMap("send sendCancelShipment Exception", "", null);
        }
    }

    @Override
    public String sendRefundCompleted(OcRefundDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendRefundCompleted \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/refundOrder?accessToken=ACCESS_TOKEN";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundCompleted Exception", null);
        }
    }

    @Override
    public String sendRefundRevoke(OcRefundDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundRevoke \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/order/cancelRefundOrder?accessToken=ACCESS_TOKEN";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getPosErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", "", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundRevoke Exception", null);
        }
    }

    @Override
    public String sendOrderFrom(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcContractDomain.class);
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getPosErrorMap("ocContractDomain is null", "", "");
        }
        ocContractDomain.setTenantCode("2019071800001392");
        String goodsList = JsonUtil.buildNormalBinder().toJson(ocContractDomain.getGoodsList());
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
        try {
            paramsMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            System.out.println("------" + paramsMap);
            return JbsUtils.getPosSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendOrderFrom is fail");
            return JbsUtils.getPosErrorMap("save data is fail", "", data);
        }
    }

    @Override
    public String sendRefundOrderFrom(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            this.logger.error(this.SYS_CODE, (Object)"ocRefundDomain or refundType is null");
            return JbsUtils.getPosErrorMap("ocRefundDomain or refundType is null", "", "");
        }
        ocRefundDomain.setTenantCode("2019071800001392");
        String goodsList = JsonUtil.buildNormalBinder().toJson(ocRefundDomain.getOcRefundGoodsDomainList());
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
        try {
            paramsMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.getInternalRouter().inInvoke(this.sendSaveRefundApiCode, paramsMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundOrderFrom is fail");
            return JbsUtils.getPosErrorMap("save data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendRefundState(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        Map paramsMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)paramsMap)) {
            this.logger.error(this.SYS_CODE, (Object)"paramsMap is null");
            return JbsUtils.getPosErrorMap("paramsMap is null", "", "");
        }
        try {
            paramsMap.put("tenantCode", "2019071800001392");
            paramsMap.put("map", null);
            this.getInternalRouter().inInvoke(this.sendupdateRefundStateByCodeApiCode, paramsMap);
            return JbsUtils.getPosSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
    }

    @Override
    public String sendRefundReceipt(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        Map paramsMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)paramsMap)) {
            this.logger.error(this.SYS_CODE, (Object)"paramsMap is null");
            return JbsUtils.getPosErrorMap("paramsMap is null", "", "");
        }
        try {
            paramsMap.put("tenantCode", "2019071800001392");
            paramsMap.put("map", null);
            this.getInternalRouter().inInvoke(this.sendupdateRefundStateByCodeApiCode, paramsMap);
            return JbsUtils.getPosSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
    }

    private HtmlJsonReBean checkUser(String memberBcode, String memberBname) {
        if (null == memberBcode || StringUtils.isEmpty((Object)memberBcode) || StringUtils.isEmpty((Object)memberBname)) {
            this.logger.error(this.SYS_CODE + ".checkUser", (Object)"memberBcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberBcode null");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("userinfoOcode", memberBcode);
        paramsMap.put("tenantCode", "2019071800001392");
        List storeList = (List)this.getInternalRouter().inInvoke(this.queryUserinfoListApiCode, paramsMap);
        if (storeList.size() == 0 || storeList == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "storeList non-existent : " + memberBcode);
        }
        return new HtmlJsonReBean("success");
    }

    private HtmlJsonReBean checkOrderGoodsByMap(List<Map<String, Object>> goodsList) {
        if (null == goodsList || goodsList.size() == 0) {
            this.logger.error(this.SYS_CODE + ".checkGoodsByMap", (Object)"goodsList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goodsList null");
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        ArrayList<String> noGoodsEoCodeList = new ArrayList<String>();
        ArrayList<String> goodsEoCodeList = new ArrayList<String>();
        for (Map<String, Object> map : goodsList) {
            paramsMap.put("goodsEocode", map.get("goodsEocode"));
            paramsMap.put("tenantCode", "2019071800001392");
            SupQueryResult rsResourceGoodsList = (SupQueryResult)this.getInternalRouter().inInvoke(this.queryResourceGoodsPageByMapApiCode, paramsMap);
            if (null != rsResourceGoodsList.getList() || rsResourceGoodsList.getList().size() > 0) {
                goodsEoCodeList.add(((RsResourceGoodsReDomain)rsResourceGoodsList.getList().get(0)).getGoodsEocode());
            }
            noGoodsEoCodeList.add(map.get("goodsEocode") == null ? null : map.get("goodsEocode").toString());
        }
        if (noGoodsEoCodeList.size() == 0 || noGoodsEoCodeList == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goodsEoCode non-existent : " + JsonUtil.buildNormalBinder().toJson(noGoodsEoCodeList));
        }
        return new HtmlJsonReBean("success");
    }

    private String makeOrderParam(String orderNo) {
        ArrayList reqList = new ArrayList();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        String modifyDate = df.format(calendar.getTime());
        paramMap.put("dataKey", orderNo);
        paramMap.put("orderNo", orderNo);
        paramMap.put("modifyDate", modifyDate);
        paramMap.put("mender", null);
        reqList.add(paramMap);
        return JsonUtil.buildNormalBinder().toJson(reqList);
    }

    private String makeSaveStoreSku(Map<String, Object> map, RsResourceGoodsDomain rsResourceGoodsDomain, Boolean flag) {
        ArrayList list = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsDomain.getRsSkuDomainList();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            paramMap.put("dataKey", null);
            paramMap.put("storeCode", rsSkuDomain.getMemberCode());
            paramMap.put("skuCode", rsSkuDomain.getSkuEocode());
            paramMap.put("createDate", null);
            if (flag.booleanValue()) {
                paramMap.put("opType", 0);
                paramMap.put("supCode", rsSkuDomain.getMemberCcode());
                paramMap.put("deliveryType", null);
                paramMap.put("discount", null);
                paramMap.put("skuStatus", 0);
                paramMap.put("safeStockDays", null);
                paramMap.put("maxStockDays", null);
                paramMap.put("minStock", null);
                paramMap.put("createDate", null);
                paramMap.put("minOrderNum", null);
                paramMap.put("maxReplenishNum", null);
                paramMap.put("doBargain", null);
                paramMap.put("doDiscount", null);
                paramMap.put("doPresent", null);
                paramMap.put("changPrice", null);
                paramMap.put("doScore", null);
                paramMap.put("mangeStock", null);
                paramMap.put("isAdvice", null);
                paramMap.put("modifyDate", null);
            } else {
                paramMap.put("barcode", null);
                paramMap.put("unit", rsSkuDomain.getPartsnameWeightunit());
                paramMap.put("salePrice", rsSkuDomain.getPricesetMakeprice());
                paramMap.put("vipPrice", null);
                paramMap.put("vipPrice1", null);
                paramMap.put("vipPrice2", null);
                paramMap.put("purchasePrice", rsSkuDomain.getPricesetNprice());
                paramMap.put("creator", null);
            }
            list.add(paramMap);
        }
        return JsonUtil.buildNormalBinder().toJson(list);
    }

    private String makeGoods(Map<String, Object> map, RsResourceGoodsDomain rsResourceGoodsDomain) {
        ArrayList list = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList defaultUnitList = new ArrayList();
        HashMap<String, Object> defaultUnitMap = new HashMap<String, Object>();
        ArrayList imgList = new ArrayList();
        HashMap<String, String> imgMap = new HashMap<String, String>();
        paramMap.put("dataKey", null);
        paramMap.put("opType", 0);
        paramMap.put("skuCode", rsResourceGoodsDomain.getGoodsEocode());
        paramMap.put("skuName", rsResourceGoodsDomain.getGoodsShowname());
        paramMap.put("barcode", map.get("skuBarcode"));
        paramMap.put("unit", rsResourceGoodsDomain.getGoodsProperty1());
        paramMap.put("brandCode", rsResourceGoodsDomain.getBrandCode());
        paramMap.put("icatCode", null);
        paramMap.put("saleType", null);
        paramMap.put("itemType", null);
        paramMap.put("codeType", null);
        paramMap.put("maxStockDays", null);
        paramMap.put("maxStockDays", null);
        paramMap.put("maxReplenishNum", null);
        paramMap.put("purchaseTax", null);
        paramMap.put("saleTax", null);
        paramMap.put("mangeStock", null);
        paramMap.put("doPresent", null);
        paramMap.put("doPresent", null);
        paramMap.put("doScore", null);
        paramMap.put("changPrice", null);
        paramMap.put("unitWeight", null);
        paramMap.put("changPrice", null);
        paramMap.put("creator", null);
        paramMap.put("createDate", null);
        paramMap.put("modifyDate", null);
        paramMap.put("creator", null);
        paramMap.put("specMemo", rsResourceGoodsDomain.getGoodsSpec());
        paramMap.put("location", rsResourceGoodsDomain.getPartsnameName());
        paramMap.put("validDays", rsResourceGoodsDomain.getRsSkuDomainList().get(0).getGinfoCode());
        defaultUnitMap.put("plusCode", null);
        defaultUnitMap.put("unit", rsResourceGoodsDomain.getGoodsProperty1());
        defaultUnitMap.put("unitType", 0);
        defaultUnitMap.put("unitNum", null);
        defaultUnitMap.put("salePrice", null);
        defaultUnitMap.put("plusCode", null);
        defaultUnitMap.put("vipPrice1", null);
        defaultUnitMap.put("vipPrice2", null);
        defaultUnitMap.put("weiPrice", null);
        defaultUnitMap.put("purchasePrice", null);
        defaultUnitMap.put("wholesalePrice", null);
        defaultUnitMap.put("deliverPrice", null);
        defaultUnitMap.put("score", null);
        defaultUnitList.add(defaultUnitMap);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)paramMap.get("unit").toString())) {
            paramMap.put("defaultUnitList", null);
        }
        paramMap.put("defaultUnitList", defaultUnitList);
        if (rsResourceGoodsDomain.getRsGoodsFileDomainList() != null || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() > 0) {
            for (RsGoodsFileDomain goodsFileDomain : rsResourceGoodsDomain.getRsGoodsFileDomainList()) {
                imgMap.put("imgPath", goodsFileDomain.getGoodsFileUrl());
                imgList.add(imgMap);
            }
        }
        imgMap.put("imgPath", rsResourceGoodsDomain.getDataPic());
        imgList.add(imgMap);
        paramMap.put("imgList", imgList);
        list.add(paramMap);
        return JsonUtil.buildNormalBinder().toJson(list);
    }

    private String getStoreCode(String memberBcode) {
        String storeCode = null;
        HashMap paramsMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userInfoCode", memberBcode);
        map.put("tenantCode", "2019071800001392");
        paramsMap.put("map", map);
        String queryUserinfoPageStr = (String)this.getInternalRouter().inInvoke(this.queryUserinfoPageApiCode, paramsMap);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)queryUserinfoPageStr)) {
            return "";
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryUserinfoPageStr, QueryResult.class);
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            return "";
        }
        List userList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)queryResult.getList()), UmUserinfoReDomainBean.class);
        if (ListUtil.isNotEmpty((Collection)userList)) {
            storeCode = ((UmUserinfoReDomainBean)userList.get(0)).getUserinfoOcode();
            return storeCode;
        }
        return storeCode;
    }
}

