/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.RsSku;
import com.yqbsoft.laser.service.pos.domain.RsSkuDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosSaveItemRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosStorePriceRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosStoreSkuRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosGoodsResponse;
import com.yqbsoft.laser.service.pos.service.GoodsService;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class GoodsServiceImpl
extends BaseServiceImpl
implements GoodsService {
    String querySkuOnePageApiCode = "rs.sku.querySkuOnePage";
    private String SYS_CODE = "jbsPos.SendGoodsServiceImpl";

    @Override
    public String sendResourceGoods(Map<String, Object> map, RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (EmptyUtil.isEmpty((Object)rsResourceGoodsDomain) || MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/base/saveItem";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsPosGoodsResponse execute = null;
        JbsPosSaveItemRequest jbsPosSaveItemRequest = new JbsPosSaveItemRequest();
        try {
            BeanUtils.copyAllPropertys((Object)jbsPosSaveItemRequest, (Object)rsResourceGoodsDomain);
            execute = httpFormfacade.execute(jbsPosSaveItemRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            HashMap<String, String> goodsMap = new HashMap<String, String>();
            goodsMap.put("goodsCode", jbsPosSaveItemRequest.getGoodsCode());
            goodsMap.put("goodsEocode", jbsPosSaveItemRequest.getGoodsCode());
            goodsMap.put("tenantCode", jbsPosSaveItemRequest.getTenantCode());
            this.internalInvoke("rs.resourceGoods.updateGoodsEocode", goodsMap);
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("sendResourceGoods is error------" + JsonUtil.buildNormalBinder().toJson(null)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendResourceGoods Exception", null);
        }
    }

    @Override
    public String sendResourceGoodsStoreData(Map<String, Object> map, RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (EmptyUtil.isEmpty((Object)rsResourceGoodsDomain) || MapUtil.isEmpty(map) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsClass()) || !"store".equals(rsResourceGoodsDomain.getGoodsClass())) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getSuccessMap("param is null");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", rsResourceGoodsDomain.getMemberCode());
        paramMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        String userInfoStr = this.internalInvoke("um.user.getUserinfoByUserCode", paramMap);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userInfoStr)) {
            return JbsUtils.getSuccessMap(null);
        }
        JSONObject jsonObject = JSONObject.json2object((String)userInfoStr);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("userinfoOcode"))) {
            return JbsUtils.getSuccessMap(null);
        }
        rsResourceGoodsDomain.setMemberCode(jsonObject.getString("userinfoOcode"));
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSkuDomainList())) {
            boolean flag = false;
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsDomain.getRsSkuDomainList()) {
                if (rsSkuDomain.getPricesetNprice().compareTo(rsSkuDomain.getGoodsTopweight()) == 0) continue;
                flag = true;
            }
            if (flag) {
                this.sendResourceGoodsPriceData(map, rsResourceGoodsDomain);
            }
        }
        String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/base/saveStoreSku";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsPosStoreSkuRequest jbsPosStoreSkuRequest = new JbsPosStoreSkuRequest();
        try {
            BeanUtils.copyAllPropertys((Object)jbsPosStoreSkuRequest, (Object)rsResourceGoodsDomain);
            JbsPosGoodsResponse execute = httpFormfacade.execute(jbsPosStoreSkuRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            HashMap<String, String> goodsMap = new HashMap<String, String>();
            for (RsSkuDomain rsSkuDomain : jbsPosStoreSkuRequest.getRsSkuDomainList()) {
                goodsMap.put("skuCode", rsSkuDomain.getSkuCode());
                goodsMap.put("skuEocode", rsSkuDomain.getSkuCode());
                goodsMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
                this.internalInvoke("rs.resourceGoods.updateSkuEocode", goodsMap);
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendResourceGoodsStoreData Exception", null);
        }
    }

    @Override
    public String sendResourceGoodsPriceData(Map<String, Object> map, RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (EmptyUtil.isEmpty((Object)rsResourceGoodsDomain) || MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/base/adjustSkuPrice";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsPosGoodsResponse execute = null;
        JbsPosStorePriceRequest jbsPosStorePriceRequest = new JbsPosStorePriceRequest();
        try {
            BeanUtils.copyAllPropertys((Object)jbsPosStorePriceRequest, (Object)rsResourceGoodsDomain);
            execute = httpFormfacade.execute(jbsPosStorePriceRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            HashMap<String, String> goodsMap = new HashMap<String, String>();
            for (RsSkuDomain rsSkuDomain : jbsPosStorePriceRequest.getRsSkuDomainList()) {
                RsSkuDomain skuDomain = new RsSkuDomain();
                skuDomain.setSkuId(rsSkuDomain.getSkuId());
                skuDomain.setGoodsTopweight(rsSkuDomain.getPricesetNprice());
                goodsMap.put("rsSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)skuDomain));
                this.internalInvoke("rs.resourceGoods.updateSku", goodsMap);
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendResourceGoodsPriceData Exception", null);
        }
    }

    @Override
    public String sendUpdateShelveSoldOutSkuFrom(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE + "data is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        this.logger.error(this.SYS_CODE + "sendUpdateShelveSoldOutSkuFrom\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)data));
        JSONArray dataStr = JSONArray.json2array((String)data);
        if (EmptyUtil.isEmpty((Object)dataStr)) {
            this.logger.error(this.SYS_CODE + "dataStr is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Integer> upSukIds = new ArrayList<Integer>();
        ArrayList<Integer> sukIds = new ArrayList<Integer>();
        for (JSONObject goods : dataStr) {
            if (EmptyUtil.isEmpty((Object)goods.get((Object)"skuCode")) || EmptyUtil.isEmpty((Object)goods.get((Object)"type")) || EmptyUtil.isEmpty((Object)goods.get((Object)"storeCode"))) {
                this.logger.error(this.SYS_CODE + ".sendUpdateShelveSoldOutSkuFrom.param is null", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goods));
                return JbsUtils.getPosErrorMap("skuCode/type/storeCode is null", "", JsonUtil.buildNonDefaultBinder().toJson((Object)goods));
            }
            String memberCode = "";
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)goods.getString("storeCode"))) {
                paramsMap.put("userinfoOcode", goods.getString("storeCode"));
                paramsMap.put("tenantCode", "2019071800001392");
                map.put("map", JsonUtil.buildNormalBinder().toJson(paramsMap));
                String json = this.internalInvoke("um.user.queryUserinfoList", map);
                List umUserinfoDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(json, UmUserinfoDomainBean.class);
                if (ListUtil.isEmpty((Collection)umUserinfoDomainList)) {
                    this.logger.error(this.SYS_CODE + ".sendUpdateShelveSoldOutSkuFrom.\u8bf7\u68c0\u67e5storeCode\u662f\u5426\u6b63\u786e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goods));
                    return JbsUtils.getPosErrorMap("\u8bf7\u68c0\u67e5storeCode\u662f\u5426\u6b63\u786e", "", JsonUtil.buildNonDefaultBinder().toJson((Object)goods));
                }
                memberCode = ((UmUserinfoDomainBean)umUserinfoDomainList.get(0)).getUserinfoOcode();
            }
            paramsMap.clear();
            map.clear();
            paramsMap.put("skuNo", goods.get((Object)"skuCode"));
            paramsMap.put("tenantCode", "2019071800001392");
            paramsMap.put("memberCode", memberCode);
            map.put("map", JsonUtil.buildNonNullBinder().toJson(paramsMap));
            String rsSkuStr = this.internalInvoke(this.querySkuOnePageApiCode, map);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)rsSkuStr)) {
                this.logger.error(this.SYS_CODE + ".sendUpdateShelveSoldOutSkuFrom.rsSkuStr is null");
                return JbsUtils.getPosErrorMap("goods is notExist", "", data);
            }
            QueryResult querySkuResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuStr, QueryResult.class);
            if (ListUtil.isEmpty((Collection)querySkuResult.getList())) {
                this.logger.error(this.SYS_CODE + ".sendUpdateShelveSoldOutSkuFrom.querySkuResult is null");
                return JbsUtils.getPosErrorMap("querySkuResult is notExist", "", querySkuResult);
            }
            List rsSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)querySkuResult.getList()), RsSku.class);
            if (ListUtil.isEmpty((Collection)rsSkuList)) continue;
            for (RsSku rsSku : rsSkuList) {
                if (rsSku.getDataState() == -1 && "1".equals(goods.getString("type"))) {
                    return JbsUtils.getPosErrorMap("\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u51bb\u7ed3\uff0c\u4e0d\u53ef\u4e0a\u67b6\uff01", "", JsonUtil.buildNonDefaultBinder().toJson((Object)goods));
                }
                if ("1".equals(goods.getString("type")) && rsSku.getDataState() != 2) {
                    upSukIds.add(rsSku.getSkuId());
                }
                if (!"2".equals(goods.getString("type")) || rsSku.getDataState() != 2) continue;
                sukIds.add(rsSku.getSkuId());
            }
        }
        try {
            if (ListUtil.isNotEmpty(sukIds)) {
                paramsMap.clear();
                paramsMap.put("skuIdList", JsonUtil.buildNormalBinder().toJson(sukIds));
                this.internalInvoke("rs.resource.sendUpdateSoldOutBatchSku", paramsMap);
            }
            if (ListUtil.isNotEmpty(upSukIds)) {
                paramsMap.clear();
                paramsMap.put("skuIdList", JsonUtil.buildNormalBinder().toJson(upSukIds));
                this.internalInvoke("rs.resource.sendUpdateShelveBatchSku", paramsMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendUpdateShelveSoldOutSkuFrom", (Object)e.getMessage());
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0a\u4e0b\u67b6\u5f02\u5e38", "", e.getMessage());
        }
        return JbsUtils.getPosErrorMap("", "", "");
    }
}

