/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosExWhNoticeRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosInWhNoticeRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosQueryStoreWhRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosInWhNoticeResponse;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosQueryStoreWhResponse;
import com.yqbsoft.laser.service.pos.model.WhOpstore;
import com.yqbsoft.laser.service.pos.model.WhOpstoreSku;
import com.yqbsoft.laser.service.pos.service.JbsPosWarehouseService;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsPosWarehouseServiceImpl
extends BaseServiceImpl
implements JbsPosWarehouseService {
    public static final String SYS_CODE = "jbsPos.JbsPosWarehouseServiceImpl";

    @Override
    public String receiveRequireGoodsBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveRequireGoodsBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)dataStr));
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplto transformation is null");
            return JbsUtils.getPosErrorMap("to transformation is null", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)(whOpstoreDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreDomain.getGoodsWeight() + ""))) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u603b\u6570\u91cf\u548c\u5546\u54c1\u603b\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            whOpstoreDomain.setStoreGoodsBtype("D1");
            whOpstoreDomain.setStoreGoodsType("2");
            whOpstoreDomain.setMemberCode("2019071800001392");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("2019071800001392");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsWeight() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameWeightunit() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
            }
            try {
                this.logger.error(SYS_CODE, (Object)("==========receiveRequireGoodsBill===" + new Date() + "======"));
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl\u63a5\u6536\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (!checkDetail.booleanValue()) continue;
                paramsMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", paramsMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4e2d\u53f0\u5165\u5e93\u5f02\u5e38");
                this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String receiveReturnGoodsBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveReturnGoodsBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)dataStr));
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplto transformation is null");
            return JbsUtils.getPosErrorMap("to transformation is null", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)(whOpstoreDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreDomain.getGoodsWeight() + ""))) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u603b\u6570\u91cf\u548c\u5546\u54c1\u603b\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            whOpstoreDomain.setStoreGoodsBtype("D3");
            whOpstoreDomain.setStoreGoodsType("2");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsWeight() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be6\u60c5\u5217\u8868\u4e2d\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
            }
            try {
                this.logger.error(SYS_CODE, (Object)("==========receiveReturnGoodsBill===" + new Date() + "======"));
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl\u63a5\u6536\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (!checkDetail.booleanValue()) continue;
                paramsMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", paramsMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4e2d\u53f0\u5165\u5e93\u5f02\u5e38");
                this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String inWhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplinWhNoticeBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/erp/saveDeliverGoodsOrder";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosInWhNoticeResponse execute = null;
            JbsPosInWhNoticeRequest jbsPosInWhNoticeRequest = new JbsPosInWhNoticeRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosInWhNoticeRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsPosInWhNoticeRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("send inWhNoticeBill \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("send inWhNoticeBill Exception" + e));
            return JbsUtils.getErrorMap("send inWhNoticeBill Exception", null);
        }
    }

    @Override
    public String receiveInWhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveInWhConfirmBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)dataStr));
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error(SYS_CODE, (Object)"dataStr \u8f6c\u6362\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("dataStr \u8f6c\u6362\u4e3a\u7a7a", "", "");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)(whOpstoreDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreDomain.getGoodsWeight() + ""))) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsBtype("D8");
            whOpstoreDomain.setStoreGoodsType("1");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsWeight() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameWeightunit() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsWeight() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u548c\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameWeightunit() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumber()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u91cd\u91cf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumberunit()) || !EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u91cd\u91cf\u5355\u4f4d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if ((BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffNumber()) != 0 || BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffWeight()) != 0) && EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffRemark())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u539f\u56e0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuDomain.setPartsnameName(whOpstoreSkuDomain.getBatchNumber());
                    whOpstoreSkuDomain.setPricesetPrefprice(whOpstoreSkuDomain.getDiffNumber());
                    whOpstoreSkuDomain.setClasstreeCode(whOpstoreSkuDomain.getDiffNumberunit());
                    whOpstoreSkuDomain.setPricesetInsideprice(whOpstoreSkuDomain.getDiffWeight());
                    whOpstoreSkuDomain.setTargetChannelCode(whOpstoreSkuDomain.getDiffWeightunit());
                    whOpstoreSkuDomain.setPntreeCode(whOpstoreSkuDomain.getDiffRemark());
                    whOpstoreSkuDomain.setSkuEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setGoodsEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setMemberCcode("20021000276227");
                    whOpstoreSkuDomain.setMemberCname("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            if (this.checkBatch(whOpstoreDomain).booleanValue()) {
                return JbsUtils.getPosErrorMap("\u6279\u6b21\u6570\u636e\u4e0d\u5339\u914d", "", "\u6279\u6b21\u7ea7\u6570\u636e\u9519\u8bef \u6570\u91cf/\u91cd\u91cf/\u6279\u6b21\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            try {
                this.logger.error(SYS_CODE, (Object)("==========receiveInWhConfirmBill===" + new Date() + "======"));
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl\u63a5\u6536\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (!checkDetail.booleanValue()) continue;
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4e2d\u53f0\u5165\u5e93\u5f02\u5e38");
                this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    private Boolean checkBatch(WhOpstoreDomain whOpstoreDomain) {
        Boolean checkDetail = true;
        HashMap<String, String> map = new HashMap<String, String>();
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getWhOpstoreGoodsDomainList().get(0)) || EmptyUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList().get(0).getWhOpstoreSkuDomainList())) {
            checkDetail = false;
        }
        HashMap<String, WhOpstoreSkuDomain> checkMap = new HashMap<String, WhOpstoreSkuDomain>();
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                checkMap.put(whOpstoreDomain.getOpstoreOcode() + "-" + whOpstoreSkuDomain.getGoodsEocode() + "-" + whOpstoreSkuDomain.getPartsnameName(), whOpstoreSkuDomain);
            }
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
        queryMap.put("tenantCode", "2019071800001392");
        queryMap.put("order", "true");
        map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
        QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", queryMap, WhOpstore.class);
        if (queryStoreResult != null && ListUtil.isEmpty((Collection)queryStoreResult.getList())) {
            checkDetail = false;
        }
        for (WhOpstore whOpstore : queryStoreResult.getList()) {
            queryMap.clear();
            queryMap.put("opstoreCode", whOpstore.getOpstoreCode());
            queryMap.put("tenantCode", "2019071800001392");
            queryMap.put("order", "true");
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult querySkuResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreSkuPage", map, WhOpstoreSku.class);
            if (querySkuResult != null && ListUtil.isEmpty((Collection)querySkuResult.getList())) {
                checkDetail = false;
                continue;
            }
            for (WhOpstoreSku whOpstoreSku : querySkuResult.getList()) {
                String key = whOpstore.getOpstoreOcode() + "-" + whOpstoreSku.getGoodsEocode() + "-" + whOpstoreSku.getPartsnameName();
                if (!checkMap.containsKey(key)) {
                    checkDetail = false;
                    continue;
                }
                if (new BigDecimal("-1").compareTo(((WhOpstoreSkuDomain)checkMap.get(key)).getGoodsNum()) != 0) {
                    ((WhOpstoreSkuDomain)checkMap.get(key)).setGoodsNum(whOpstoreSku.getGoodsNum());
                    ((WhOpstoreSkuDomain)checkMap.get(key)).setPartsnameNumunit(whOpstoreSku.getPartsnameNumunit());
                }
                if (((WhOpstoreSkuDomain)checkMap.get(key)).getGoodsNum().add(((WhOpstoreSkuDomain)checkMap.get(key)).getDiffNumber()).compareTo(whOpstoreSku.getGoodsNum()) != 0) {
                    checkDetail = false;
                }
                if (((WhOpstoreSkuDomain)checkMap.get(key)).getGoodsWeight().add(((WhOpstoreSkuDomain)checkMap.get(key)).getDiffWeight()).compareTo(whOpstoreSku.getGoodsWeight()) != 0) {
                    checkDetail = false;
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            if (checkDetail.booleanValue()) continue;
            break;
        }
        return checkDetail;
    }

    @Override
    public String exWhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplexWhNoticeBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/erp/saveReDistributionDelivery";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosInWhNoticeResponse execute = null;
            JbsPosExWhNoticeRequest jbsPosExWhNoticeRequest = new JbsPosExWhNoticeRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosExWhNoticeRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsPosExWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("send exWhNoticeBill\u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("send exWhNoticeBill Exception" + e));
            return JbsUtils.getErrorMap("send exWhNoticeBill Exception", null);
        }
    }

    @Override
    public String receiveExWhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveExWhConfirmBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)dataStr));
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error(SYS_CODE, (Object)"dataStr \u8f6c\u6362\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("dataStr \u8f6c\u6362\u4e3a\u7a7a", "", "");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)(whOpstoreDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreDomain.getGoodsWeight() + ""))) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsBtype("D7");
            whOpstoreDomain.setStoreGoodsType("1");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsWeight() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameWeightunit() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsWeight() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u548c\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameWeightunit() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumber()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u91cd\u91cf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumberunit()) || !EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u91cd\u91cf\u5355\u4f4d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if ((BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffNumber()) != 0 || BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffWeight()) != 0) && EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffRemark())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u539f\u56e0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuDomain.setSkuEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setGoodsEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setPartsnameName(whOpstoreSkuDomain.getBatchNumber());
                    whOpstoreSkuDomain.setPricesetPrefprice(whOpstoreSkuDomain.getDiffNumber());
                    whOpstoreSkuDomain.setChannelCode(whOpstoreSkuDomain.getDiffNumberunit());
                    whOpstoreSkuDomain.setPricesetInsideprice(whOpstoreSkuDomain.getDiffWeight());
                    whOpstoreSkuDomain.setTargetChannelCode(whOpstoreSkuDomain.getDiffWeightunit());
                    whOpstoreSkuDomain.setPntreeCode(whOpstoreSkuDomain.getDiffRemark());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setMemberCcode("20021000276227");
                    whOpstoreSkuDomain.setMemberCname("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            if (this.checkBatch(whOpstoreDomain).booleanValue()) {
                return JbsUtils.getPosErrorMap("\u6279\u6b21\u6570\u636e\u4e0d\u5339\u914d", "", "\u6279\u6b21\u7ea7\u6570\u636e\u9519\u8bef \u6570\u91cf/\u91cd\u91cf/\u6279\u6b21\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            try {
                this.logger.error(SYS_CODE, (Object)("==========receiveExWhConfirmBill===" + new Date() + "======"));
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl\u63a5\u6536\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (!checkDetail.booleanValue()) continue;
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4e2d\u53f0\u5165\u5e93\u5f02\u5e38");
                this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String receiveDeliveryDiffBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveDeliveryDiffBill\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)dataStr));
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplto transformation is null");
            return JbsUtils.getPosErrorMap("to transformation is null", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)(whOpstoreDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreDomain.getGoodsWeight() + ""))) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            whOpstoreDomain.setStoreGoodsBtype("T1");
            whOpstoreDomain.setStoreGoodsType("2");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsWeight() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameWeightunit() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsWeight() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u548c\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameWeightunit() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuDomain.setSkuEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setGoodsEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setMemberCcode("20021000276227");
                    whOpstoreSkuDomain.setMemberCname("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            try {
                this.logger.error(SYS_CODE, (Object)("==========receiveDeliveryDiffBill===" + new Date() + "======"));
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl\u63a5\u6536\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (!checkDetail.booleanValue()) continue;
                paramsMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", paramsMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4e2d\u53f0\u5165\u5e93\u5f02\u5e38");
                this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String receiveAdjustInventory(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveAdjustInventory\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)dataStr));
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplto transformation is null");
            return JbsUtils.getPosErrorMap("to transformation is null", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)(whOpstoreDomain.getGoodsNum() + "")) && StringUtils.isBlank((String)(whOpstoreDomain.getGoodsWeight() + ""))) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"T8,T4,P2,T2".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getGoodsWeight() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u548c\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreGoodsDomain.getPartsnameWeightunit() + ""))) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsNum() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getGoodsWeight() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u548c\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameNumunit() + "")) || StringUtils.isBlank((String)(whOpstoreSkuDomain.getPartsnameWeightunit() + ""))) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuDomain.setSkuEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setGoodsEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setMemberCcode("20021000276227");
                    whOpstoreSkuDomain.setMemberCname("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            try {
                this.logger.error(SYS_CODE, (Object)("==========receiveAdjustInventory\u6570\u636e===" + new Date() + "======"));
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl\u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (!checkDetail.booleanValue()) continue;
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", paramsMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4e2d\u53f0\u5165\u5e93\u5f02\u5e38");
                this.logger.error(SYS_CODE, (Object)("save whOpstoreDomain Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String queryPosStoreInventory(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsPos.JbsPosWarehouseServiceImplqueryPosStoreInventory>>>paramsMap>>>> " + JsonUtil.buildNormalBinder().toJson(paramsMap));
        List skuNoList = (List)paramsMap.get("skuNoList");
        List warhouseCodeList = (List)paramsMap.get("warhouseCode");
        String skus = "";
        if (ListUtil.isNotEmpty((Collection)skuNoList)) {
            for (Object str : skuNoList) {
                skus = skus + (String)str + ",";
            }
        }
        String whs = "";
        if (ListUtil.isNotEmpty((Collection)warhouseCodeList)) {
            for (String str : warhouseCodeList) {
                whs = whs + str + ",";
            }
        }
        try {
            String url = "http://3a0fc1fce1b441edb3d94f9cab03f8ca-cn-shanghai.alicloudapi.com/api/erp/getSkuStockList";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsPosQueryStoreWhResponse execute = null;
            JbsPosQueryStoreWhRequest jbsPosQueryStoreWhRequest = new JbsPosQueryStoreWhRequest();
            if (StringUtils.isNotBlank((String)skus)) {
                jbsPosQueryStoreWhRequest.setSkuCodeStr(skus.substring(0, skus.length() - 1));
            }
            if (StringUtils.isNotBlank((String)whs)) {
                jbsPosQueryStoreWhRequest.setStoreCodeStr(whs.substring(0, whs.length() - 1));
            }
            if (null == (execute = httpFormfacade.execute(jbsPosQueryStoreWhRequest)) || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u63a8\u9001\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplqueryPosStoreInventory Exception>>>> " + e);
            return JbsUtils.getErrorMap("queryPosStoreInventory Exception", "");
        }
    }

    @Override
    public String queryWmsDCInventory(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(SYS_CODE, (Object)("queryWmsDCInventory>>>> paramsMap:" + JsonUtil.buildNormalBinder().toJson(paramsMap)));
        try {
            String returnJson = (String)this.getInternalRouter().inInvoke("jbsWms.warehouse.sendQueryWhInfo", paramsMap);
            if (StringUtils.isBlank((String)returnJson)) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
            }
            return JbsUtils.getSuccessMap(returnJson);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("queryInventoryInfo Exception:" + e));
            return JbsUtils.getErrorMap("queryInventoryInfo Exception", "");
        }
    }
}

