/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.OcContract;
import com.yqbsoft.laser.service.pos.domain.OcContractDomain;
import com.yqbsoft.laser.service.pos.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcContractReDomain;
import com.yqbsoft.laser.service.pos.domain.OcPackageDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefund;
import com.yqbsoft.laser.service.pos.domain.OcRefundDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.pos.domain.RsSku;
import com.yqbsoft.laser.service.pos.domain.SgOccontractDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsPackageReDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosCancelOrderRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosContractAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosOrderDownwardRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundDataRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosOrderResponse;
import com.yqbsoft.laser.service.pos.service.ContractService;
import com.yqbsoft.laser.service.pos.utils.AddressResolution;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsPos.ContractServiceImpl";

    @Override
    public String sendContractAssignment(SgSendgoodsDomain sgSendgoodsDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendContractAssignment \u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        try {
            String msg = this.checkContractAssignment(sgSendgoodsDomain);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain.getContractBillcode()));
            }
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/saveOrder");
            JbsPosOrderResponse execute = null;
            JbsPosContractAssignmentRequest jbsPosContractAssignmentRequest = new JbsPosContractAssignmentRequest();
            String storeOcode = this.checkUserAndStoreCode(sgSendgoodsDomain.getMemberCcode(), "code");
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeOcode)) {
                return JbsUtils.getErrorMap("\u5916\u7cfb\u7edf\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeOcode));
            }
            sgSendgoodsDomain.setMemberCcode(storeOcode);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)sgSendgoodsDomain.getGoodsReceiptArrdess())) {
                Map<String, String> addressMap = AddressResolution.addressResolution(sgSendgoodsDomain.getGoodsReceiptArrdess());
                sgSendgoodsDomain.setProvinceName(addressMap.get("province"));
                sgSendgoodsDomain.setCityName(addressMap.get("city"));
                sgSendgoodsDomain.setAreaName(addressMap.get("county"));
            }
            BeanUtils.copyAllPropertys((Object)jbsPosContractAssignmentRequest, (Object)sgSendgoodsDomain);
            this.logger.error(this.SYS_CODE + "sgSendgoodsDomain\u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            execute = httpFormfacade.execute(jbsPosContractAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendContractAssignment Exception", sgSendgoodsDomain.getSendgoodsCode());
        }
    }

    @Override
    public String sendRefundAssignment(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/saveOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundAssignmentRequest jbsPosRefundAssignmentRequest = new JbsPosRefundAssignmentRequest();
            String storeOcode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCode(), "code");
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeOcode)) {
                return JbsUtils.getErrorMap("\u5916\u7cfb\u7edf\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeOcode));
            }
            ocRefundDomain.setMemberCode(storeOcode);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)ocRefundDomain.getGoodsReceiptArrdess())) {
                Map<String, String> addressMap = AddressResolution.addressResolution(ocRefundDomain.getGoodsReceiptArrdess());
                ocRefundDomain.setProvinceName(addressMap.get("province"));
                ocRefundDomain.setCityName(addressMap.get("city"));
                ocRefundDomain.setAreaName(addressMap.get("county"));
            }
            BeanUtils.copyAllPropertys((Object)jbsPosRefundAssignmentRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment Exception--" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundAssignment Exception", null);
        }
    }

    @Override
    public String sendOrderDownward(OcContractReDomain ocContractDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getErrorMap("ocContractDomain is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendOrderDownward \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractDomain.getContractBillcode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)ocContractDomain.getDataState())) {
            return JbsUtils.getErrorMap("ContractBillcode or DataStatestr is null", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            if (ocContractDomain.getDataState().equals("4")) {
                httpFormfacade.setOutsideApiUrl("/api/order/finishOrder");
            } else if (ocContractDomain.getDataState().equals("7")) {
                httpFormfacade.setOutsideApiUrl("/api/order/deliverGoodsOrder");
            }
            JbsPosOrderResponse execute = null;
            JbsPosOrderDownwardRequest jbsPosOrderDownwardRequest = new JbsPosOrderDownwardRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosOrderDownwardRequest, (Object)ocContractDomain);
            execute = httpFormfacade.execute(jbsPosOrderDownwardRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendOrderDownward \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendOrderDownward Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendOrderDownward Exception", null);
        }
    }

    @Override
    public String sendCancelShipment(SgSendgoodsDomain sgSendgoodsDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"sgSendgoodsReDomain is null");
            return JbsUtils.getErrorMap("sgSendgoodsReDomain is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendCancelShipment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getSendgoodsCode())) {
            return JbsUtils.getErrorMap("SendgoodsCode is null", null);
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelOrder");
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)sgSendgoodsDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendCancelShipment Exception", null);
        }
    }

    @Override
    public String sendRefundCompleted(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendRefundCompleted \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)ocRefundDomain.getDataState())) {
            return JbsUtils.getErrorMap("RefundCode or DataStatestr is null", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/refundOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundCompleted Exception", null);
        }
    }

    @Override
    public String sendRefundRevoke(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundRevoke \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode()) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((Integer)ocRefundDomain.getDataState())) {
            return JbsUtils.getErrorMap("RefundCode or DataStatestr is null", JsonUtil.getNotDefJsonUtil().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelRefundOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundRevoke Exception", null);
        }
    }

    @Override
    public String sendOrderFrom(String data) {
        this.logger.error(this.SYS_CODE + "sendOrderFrom \u6570\u636e>>>>>>> " + data);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcContractDomain.class);
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getPosErrorMap("ocContractDomain is null", "", "");
        }
        List<OcContract> queryResut = this.checkOccontract(ocContractDomain.getContractBillcode());
        if (ListUtil.isNotEmpty(queryResut)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", "", ocContractDomain.getContractBillcode());
        }
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            String goodsList = JsonUtil.buildNormalBinder().toJson(ocPackageDomain.getContractGoodsList());
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goodsList)) {
                return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
            }
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
            List<Object> orderGoodsList = this.checkOrderGoodsByMap(list);
            if (!ListUtil.isNotEmpty(orderGoodsList)) continue;
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        String storeCode = this.checkUserAndStoreCode(ocContractDomain.getMemberCcode(), "oCode");
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeCode)) {
            return JbsUtils.getErrorMap("\u672a\u7ef4\u62a4\u5916\u7cfb\u7edf\u95e8\u5e97\u7f16\u7801", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
        }
        String userInfoCode = this.checkUserAndStoreCode(ocContractDomain.getGoodsReceiptPhone(), "phone");
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userInfoCode)) {
            userInfoCode = this.checkUser(ocContractDomain.getGoodsReceiptMem(), ocContractDomain.getGoodsReceiptPhone());
        }
        ocContractDomain.setMemberBcode(userInfoCode);
        ocContractDomain.setMemberBname(ocContractDomain.getGoodsReceiptMem());
        ocContractDomain.setMemberCode("20021000262816");
        ocContractDomain.setMemberName("Swift\u7535\u5546");
        ocContractDomain.setMemberCcode(storeCode);
        try {
            paramsMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            this.getInternalRouter().inInvoke("oc.contract.sendsaveContract", paramsMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendOrderFrom is fail", (Object)e, (Throwable)e);
            return JbsUtils.getPosErrorMap("save data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendRefundOrderFrom(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            this.logger.error(this.SYS_CODE, (Object)"ocRefundDomain or refundType is null");
            return JbsUtils.getPosErrorMap("ocRefundDomain or refundType is null", "", "");
        }
        List<OcRefund> queryResut = this.checkRefund(ocRefundDomain.getRefundCode());
        if (ListUtil.isNotEmpty(queryResut)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u9000\u5355\u53f7\u5df2\u5b58\u5728", "", ocRefundDomain.getRefundCode());
        }
        String goodsList = JsonUtil.buildNormalBinder().toJson(ocRefundDomain.getOcRefundGoodsDomainList());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goodsList)) {
            return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
        List<Object> orderGoodsList = this.checkOrderGoodsByMap(list);
        if (ListUtil.isNotEmpty(orderGoodsList)) {
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        String storeCode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCcode(), "oCode");
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeCode)) {
            return JbsUtils.getErrorMap("\u672a\u7ef4\u62a4\u5916\u7cfb\u7edf\u95e8\u5e97\u7f16\u7801", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
        }
        String userInfoCode = this.checkUserAndStoreCode(ocRefundDomain.getGoodsReceiptPhone(), "phone");
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userInfoCode)) {
            userInfoCode = this.checkUser(ocRefundDomain.getGoodsReceiptMem(), ocRefundDomain.getGoodsReceiptPhone());
        }
        ocRefundDomain.setMemberBcode(userInfoCode);
        ocRefundDomain.setMemberBname(ocRefundDomain.getGoodsReceiptMem());
        ocRefundDomain.setMemberCode("20021000262816");
        ocRefundDomain.setMemberName("Swift\u7535\u5546");
        ocRefundDomain.setMemberCcode(storeCode);
        try {
            paramsMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendsaveRefund", paramsMap);
        }
        catch (Exception e) {
            return JbsUtils.getPosErrorMap("save data is fail", "", e.getMessage());
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendOrderUplink(String dataStr) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", dataStr);
        }
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, SgOccontractDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(this.SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + ".sendOrderUplink", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        String errorCodes = "";
        String msg = "";
        for (SgOccontractDomain sgOccontractDomain : jsonToList) {
            sgOccontractDomain.setTenantCode("2019071800001392");
            msg = this.checkSgOccontract(sgOccontractDomain);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain.getContractBillcode()));
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            try {
                String sendGoods = this.getSgSendGoods(sgOccontractDomain.getSendgoodsCode());
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sendGoods)) {
                    return JbsUtils.getErrorMap("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728", sgOccontractDomain.getContractBillcode());
                }
                paramMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
                paramMap.put("tenantCode", sgOccontractDomain.getTenantCode());
                paramMap.put("map", null);
                if ("0".equals(sgOccontractDomain.getDataStatestr())) {
                    String ocContract = this.getOcContract(sgOccontractDomain.getContractBillcode());
                    if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContract)) {
                        return JbsUtils.getErrorMap("\u9500\u552e\u5355\u4e0d\u5b58\u5728", sgOccontractDomain.getContractBillcode());
                    }
                    OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContract, OcContractDomain.class);
                    OcRefundDomain ocRefundDomain = new OcRefundDomain();
                    this.makeOcRefund(ocRefundDomain, ocContractDomain);
                    sendMap.put("ocRefundDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
                    this.internalInvoke("oc.refundEngine.sendsaveRefund", sendMap);
                    this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsBack", paramMap);
                }
                if ("9".equals(sgOccontractDomain.getDataStatestr()) || "7".equals(sgOccontractDomain.getDataStatestr())) {
                    this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsNext", paramMap);
                }
                if (!"10".equals(sgOccontractDomain.getDataStatestr())) continue;
                msg = this.checkSgOccontractDomain(sgOccontractDomain);
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
                    return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain.getContractBillcode()));
                }
                HashMap<String, SgSendgoodsGoodsDomain> goodsReDomainMap = new HashMap<String, SgSendgoodsGoodsDomain>();
                HashMap<String, SgSendgoodsPackageReDomain> packageReDomainMap = new HashMap<String, SgSendgoodsPackageReDomain>();
                SgSendgoodsDomain sgSendgoodsDomain = (SgSendgoodsDomain)JsonUtil.buildNonNullBinder().getJsonToObject(sendGoods, SgSendgoodsDomain.class);
                this.logger.error(this.SYS_CODE, (Object)("----" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)));
                for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                    if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsGoodsDomain.getSendgoodsGoodsOldcode())) continue;
                    goodsReDomainMap.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), sgSendgoodsGoodsDomain);
                }
                if (ListUtil.isNotEmpty(sgSendgoodsDomain.getSgSendgoodsPackageReDomainList())) {
                    for (SgSendgoodsPackageReDomain sgSendgoodsPackageReDomain : sgSendgoodsDomain.getSgSendgoodsPackageReDomainList()) {
                        packageReDomainMap.put(sgSendgoodsPackageReDomain.getSendgoodsPackageCode(), sgSendgoodsPackageReDomain);
                    }
                }
                sendMap.clear();
                ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
                ArrayList<SgSendgoodsPackageReDomain> sendgoodsPackageReDomains = new ArrayList<SgSendgoodsPackageReDomain>();
                for (OcPackageDomain ocPackageDomain : sgOccontractDomain.getPackageList()) {
                    for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                        this.assDataSendgoodsGoods(sgSendgoodsGoodsDomains, goodsReDomainMap, ocContractGoodsDomain);
                    }
                    if (!packageReDomainMap.containsKey(ocPackageDomain.getPackageCode())) continue;
                    SgSendgoodsPackageReDomain sgSendgoodsPackageReDomain = new SgSendgoodsPackageReDomain();
                    BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsPackageReDomain, goodsReDomainMap.get(ocPackageDomain.getPackageCode()));
                    sgSendgoodsPackageReDomain.setSendgoodsPackageCode(ocPackageDomain.getPackageCode());
                    sgSendgoodsPackageReDomain.setWarehouseCode(ocPackageDomain.getWarehouseCode());
                    sgSendgoodsPackageReDomain.setWarehouseName(ocPackageDomain.getWarehouseName());
                    sgSendgoodsPackageReDomain.setPackageBillno(ocPackageDomain.getPackageBillno());
                    sgSendgoodsPackageReDomain.setGoodsReceiptMem(ocPackageDomain.getGoodsReceiptMem());
                    sgSendgoodsPackageReDomain.setGoodsReceiptPhone(ocPackageDomain.getGoodsReceiptPhone());
                    sgSendgoodsPackageReDomain.setGoodsReceiptArrdess(ocPackageDomain.getGoodsReceiptArrdess());
                    sgSendgoodsPackageReDomain.setExpressCode(ocPackageDomain.getExpressCode());
                    sgSendgoodsPackageReDomain.setExpressName(ocPackageDomain.getExpressName());
                    sendgoodsPackageReDomains.add(sgSendgoodsPackageReDomain);
                }
                this.logger.error(this.SYS_CODE, (Object)("sgSendgoodsGoodsDomains--------" + JsonUtil.buildNormalBinder().toJson(sgSendgoodsGoodsDomains)));
                sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
                sgSendgoodsDomain.setSgSendgoodsPackageReDomainList(sendgoodsPackageReDomains);
                this.logger.error(this.SYS_CODE, (Object)("sgSendgoodsDomain----" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)));
                sendMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
                this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsAndNext", sendMap);
            }
            catch (Exception e) {
                errorCodes = errorCodes + sgOccontractDomain.getContractBillcode() + ">\u5f02\u5e38;";
                e.printStackTrace();
                this.logger.error(this.SYS_CODE, (Object)"save Data Exception");
            }
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorWhNo:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendRefundState(String data) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        JSONObject invokeMap = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(data, JSONObject.class);
        if (MapUtil.isEmpty((Map)invokeMap)) {
            return JbsUtils.getPosErrorMap("paramsMap is null", "", "");
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("dataState")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("tenantCode")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("refundCode")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("refundPumode"))) {
            return JbsUtils.getPosErrorMap("refundCode\uff0ctenantCode\uff0cdataState, refundPumode", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        OcRefund ocRefund = this.getOcRefund(invokeMap.getString("refundCode"), invokeMap.getString("tenantCode"));
        if (null == ocRefund) {
            return JbsUtils.getPosErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap.getString("refundCode")));
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        try {
            this.logger.error(this.SYS_CODE, (Object)(".toService--invokeMap" + JsonUtil.buildNormalBinder().toJson((Object)invokeMap)));
            if ("0".equals(invokeMap.getString("dataState"))) {
                sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson((Object)invokeMap));
                this.internalInvoke("oc.refundEngine.sendRefundBack", (Map)invokeMap);
            }
            if ("1".equals(invokeMap.getString("dataState"))) {
                sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson((Object)invokeMap));
                this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", (Map)invokeMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendRefundReceipt(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        JSONObject invokeMap = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(data, JSONObject.class);
        if (MapUtil.isEmpty((Map)invokeMap)) {
            return JbsUtils.getPosErrorMap("invokeMap is null", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("dataState")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("tenantCode")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("refundCode"))) {
            return JbsUtils.getPosErrorMap("refundCode\uff0ctenantCode\uff0cdataState", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        OcRefund ocRefund = this.getOcRefund(invokeMap.getString("refundCode"), invokeMap.getString("tenantCode"));
        if (null == ocRefund) {
            return JbsUtils.getPosErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap.getString("refundCode")));
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        try {
            sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson((Object)invokeMap));
            this.logger.error(this.SYS_CODE, (Object)(".toService--invokeMap" + JsonUtil.buildNormalBinder().toJson((Object)invokeMap)));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", (Map)invokeMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    private void assDataSendgoodsGoods(List<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains, Map<String, SgSendgoodsGoodsDomain> goodsReDomainMap, OcContractGoodsDomain ocContractGoodsDomain) throws Exception {
        SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
        SgSendgoodsGoodsDomain sgSendgoodsGoods = null;
        if (goodsReDomainMap.containsKey(ocContractGoodsDomain.getContractGoodsCode())) {
            sgSendgoodsGoods = goodsReDomainMap.get(ocContractGoodsDomain.getContractGoodsCode());
            BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)sgSendgoodsGoods);
        }
        this.logger.error(this.SYS_CODE, (Object)("assDataSendgoodsGoods--------" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsGoods)));
        sgSendgoodsGoodsDomain.setSendgoodsGoodsId(null);
        sgSendgoodsGoodsDomain.setContractBillcode(sgSendgoodsGoods.getContractBillcode());
        sgSendgoodsGoodsDomain.setSendgoodsCode(ocContractGoodsDomain.getContractBillcode());
        sgSendgoodsGoodsDomain.setGoodsTopnum(ocContractGoodsDomain.getContractGoodsSendnum());
        sgSendgoodsGoodsDomain.setGoodsTopweight(ocContractGoodsDomain.getContractGoodsSendweight());
        sgSendgoodsGoodsDomain.setContractGoodsCode(ocContractGoodsDomain.getContractGoodsCode());
        sgSendgoodsGoodsDomain.setPackageCode(ocContractGoodsDomain.getPackageCode());
        sgSendgoodsGoodsDomain.setMemberContact(ocContractGoodsDomain.getMemberContact());
        sgSendgoodsGoodsDomain.setMemberContactPhone(ocContractGoodsDomain.getMemberContactPhone());
        sgSendgoodsGoodsDomain.setMemberContactQq(ocContractGoodsDomain.getMemberContactQq());
        sgSendgoodsGoodsDomain.setWarehouseCode(ocContractGoodsDomain.getWarehouseCode());
        sgSendgoodsGoodsDomain.setWarehouseName(ocContractGoodsDomain.getWarehouseName());
        String goodsCode = sgSendgoodsGoodsDomain.getSendgoodsGoodsCode();
        sgSendgoodsGoodsDomain.setSendgoodsGoodsOldcode(goodsCode);
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCode(null);
        sgSendgoodsGoodsDomain.setGoodsSpec4(ocContractGoodsDomain.getGoodsSpec4());
        sgSendgoodsGoodsDomain.setGoodsSpec5(ocContractGoodsDomain.getGoodsSpec5());
        sgSendgoodsGoodsDomain.setTenantCode("2019071800001392");
        sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
    }

    private String getSgSendGoods(String sendgoodsCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramMap.put("sendgoodsCode", sendgoodsCode);
        paramMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String sendGoods = this.internalInvoke("sg.sendgoods.getSgSendGoods", sendMap);
        return sendGoods;
    }

    private String checkUser(String userName, String userPhone) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userName) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userPhone)) {
            return JbsUtils.getPosErrorMap("\u6536\u4ef6\u4eba or \u6536\u4ef6\u624b\u673a\u53f7\u4e3a\u7a7a", "", userName + ":" + userPhone);
        }
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        umUserDomainBean.setUserinfoPhone(userPhone);
        umUserDomainBean.setUserName(userName);
        umUserDomainBean.setTenantCode("2019071800001392");
        sendMap.put("UmUserDomainBean", JsonUtil.buildNonDefaultBinder().toJson((Object)umUserDomainBean));
        String userinfoCode = (String)this.getInternalRouter().inInvoke("um.userbase.saveOpenUserinfo", sendMap);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        return userinfoCode;
    }

    private void makeOcRefund(OcRefundDomain ocRefundDomain, OcContractDomain ocContractDomain) throws Exception {
        this.logger.error(this.SYS_CODE, (Object)("ocContractDomain-----" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain)));
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractDomain);
        ocRefundDomain.setRefundType("POSJD");
        ocRefundDomain.setRefundMoney(ocContractDomain.getContractMoney());
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (!ListUtil.isNotEmpty(contractGoodsList)) continue;
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                ocRefundGoodsDomain.setRefundGoodsPrice(ocContractGoodsDomain.getContractGoodsPrice());
                ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsNum());
                ocRefundGoodsDomain.setRefundGoodsWeight(ocContractGoodsDomain.getGoodsWeight());
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
    }

    private String getOcContract(String contractBillcode) {
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String ocContract = this.internalInvoke("oc.contract.getContract", invokeMap);
        return ocContract;
    }

    private OcRefund getOcRefund(String refundCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)refundCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("refundCode", refundCode);
        sendMap.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.sendReSupObject("oc.refund.queryRefundPage", invokeMap, OcRefund.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OcRefund)queryResutl.getList().get(0);
    }

    private List<OcRefund> checkRefund(String refundCode) {
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult queryResut = this.sendReSupObject("oc.refund.queryRefundPage", invokeMap, OcRefund.class);
        return queryResut.getList();
    }

    private List<OcContract> checkOccontract(String contractBillcode) {
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult queryResut = this.sendReSupObject("oc.contract.queryContractPage", invokeMap, OcContract.class);
        return queryResut.getList();
    }

    private String checkUserAndStoreCode(String userinfo, String type) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)userinfo)) {
            this.logger.error(this.SYS_CODE + ".checkUserAndStoreCode", (Object)"userinfo is null");
            return null;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramsMap.put("userinfoQuality", "store");
        if ("code".equals(type)) {
            paramsMap.put("userinfoCode", userinfo);
        } else if ("oCode".equals(type)) {
            paramsMap.put("userinfoOcode", userinfo);
        } else if ("phone".equals(type)) {
            paramsMap.put("userinfoPhone", userinfo);
            paramsMap.put("userinfoQuality", "buy");
        }
        paramsMap.put("fuzzy", "true");
        paramsMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramsMap));
        String umUserinfo = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", sendMap);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)umUserinfo)) {
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(umUserinfo, QueryResult.class);
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        List userList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)queryResult.getList()), UmUserinfoReDomainBean.class);
        if (ListUtil.isEmpty((Collection)userList) && com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)((UmUserinfoReDomainBean)userList.get(0)).getUserinfoOcode())) {
            return null;
        }
        if ("code".equals(type)) {
            return ((UmUserinfoReDomainBean)userList.get(0)).getUserinfoOcode();
        }
        return ((UmUserinfoReDomainBean)userList.get(0)).getUserinfoCode();
    }

    private List<Object> checkOrderGoodsByMap(List<Map<String, Object>> goodsList) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        ArrayList<Object> noGoodsEoCodeList = new ArrayList<Object>();
        ArrayList<String> goodsEoCodeList = new ArrayList<String>();
        for (Map<String, Object> map : goodsList) {
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)String.valueOf(map.get("skuNo")))) continue;
            paramsMap.put("skuNo", map.get("skuNo"));
            paramsMap.put("tenantCode", "2019071800001392");
            invokeMap.put("map", JsonUtil.buildNormalBinder().toJson(paramsMap));
            QueryResult queryResut = this.sendReSupObject("rs.sku.querySkuOnePage", invokeMap, RsSku.class);
            if (ListUtil.isNotEmpty((Collection)queryResut.getList())) {
                goodsEoCodeList.add(((RsSku)queryResut.getList().get(0)).getGoodsEocode());
                continue;
            }
            noGoodsEoCodeList.add(map.get("skuNo"));
        }
        return noGoodsEoCodeList;
    }

    private String checkSgOccontract(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getDataStatestr())) {
            msg = msg + "DataStatestr\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkSgOccontractDomain(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        List<OcPackageDomain> packageList = sgOccontractDomain.getPackageList();
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsCode())) {
                    msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendnum())) {
                    msg = msg + "ContractGoodsSendnum\u4e3a\u7a7a;";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendweight())) {
                    msg = msg + "ContractGoodsSendweight\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
                    msg = msg + "ContractBillcode\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsCode())) {
                    msg = msg + "GoodsCode\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsName())) {
                    msg = msg + "GoodsName\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsSpec4())) {
                    msg = msg + "GoodsSpec4\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsSpec5())) {
                    msg = msg + "GoodsSpec5\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContact())) {
                    msg = msg + "GoodsSpec5\u4e3a\u7a7a;";
                }
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContactPhone())) {
                    msg = msg + "MemberContactPhone\u4e3a\u7a7a;";
                }
                if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContactQq())) continue;
                msg = msg + "MemberContactQq\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocPackageDomain.getGoodsWeight())) {
                msg = msg + "GoodsWeight\u4e3a\u7a7a;";
            }
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocPackageDomain.getContractBillcode())) continue;
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getDataStatestr())) {
            msg = msg + "DataStatestr\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkContractAssignment(SgSendgoodsDomain sgSendgoodsDomain) {
        List<SgSendgoodsGoodsDomain> goodsList;
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getContractType())) {
            msg = msg + "ContractType\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptPhone())) {
            msg = msg + "GoodsReceiptPhone\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptArrdess())) {
            msg = msg + "GoodsReceiptArrdess\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptMem())) {
            msg = msg + "GoodsReceiptMem\u4e3a\u7a7a;";
        }
        if ((goodsList = sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()).size() == 0 || ListUtil.isEmpty(goodsList)) {
            msg = msg + "SgSendgoodsGoodsReDomainList\u4e3a\u7a7a;";
        }
        for (SgSendgoodsGoodsDomain goods : goodsList) {
            if (goods.getGoodsNum() == null) {
                msg = msg + "GoodsNum\u4e3a\u7a7a;";
            }
            if (goods.getGoodsWeight() == null) {
                msg = msg + "GoodsWeight\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goods.getSendgoodsGoodsCode())) {
                msg = msg + "SendgoodsGoodsCode\u4e3a\u7a7a;";
            }
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goods.getGoodsCode())) continue;
            msg = msg + "GoodsCode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }
}

