/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.DisChannel;
import com.yqbsoft.laser.service.pos.domain.OcContractDomain;
import com.yqbsoft.laser.service.pos.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcPackageDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoods;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.pos.domain.RsSku;
import com.yqbsoft.laser.service.pos.domain.RsSkuDomain;
import com.yqbsoft.laser.service.pos.domain.SgContractproDomain;
import com.yqbsoft.laser.service.pos.domain.SgOccontractDomain;
import com.yqbsoft.laser.service.pos.domain.SgOccontractGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.pos.domain.WhWarehouseReDomain;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosCancelOrderRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosContractAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosOrderDownwardRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundDataRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosOrderResponse;
import com.yqbsoft.laser.service.pos.service.ContractService;
import com.yqbsoft.laser.service.pos.utils.AddressResolution;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.pos.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsPos.ContractServiceImpl";

    @Override
    public String sendContractAssignment(SgSendgoodsDomain sgSendgoodsDomain) {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE + ".sendContractAssignment", (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendContractAssignment \u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        try {
            String msg = this.checkContractAssignment(sgSendgoodsDomain);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
                this.logger.error(this.SYS_CODE + ".sendContractAssignment.checkContractAssignment", (Object)msg);
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain.getContractBillcode()));
            }
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/saveOrder");
            JbsPosOrderResponse execute = null;
            JbsPosContractAssignmentRequest jbsPosContractAssignmentRequest = new JbsPosContractAssignmentRequest();
            String storeOcode = this.checkUserAndStoreCode(sgSendgoodsDomain.getMemberCode(), "code", null);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeOcode)) {
                this.logger.error(this.SYS_CODE + ".sendContractAssignment.checkUserAndStoreCode", (Object)sgSendgoodsDomain.getMemberCode());
                return JbsUtils.getErrorMap("\u5916\u7cfb\u7edf\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeOcode));
            }
            sgSendgoodsDomain.setMemberCode(storeOcode);
            sgSendgoodsDomain.setMemberCcode(storeOcode);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)sgSendgoodsDomain.getGoodsReceiptArrdess())) {
                Map<String, String> addressMap = AddressResolution.addressResolution(sgSendgoodsDomain.getGoodsReceiptArrdess());
                sgSendgoodsDomain.setProvinceName(addressMap.get("province"));
                sgSendgoodsDomain.setCityName(addressMap.get("city"));
                sgSendgoodsDomain.setAreaName(addressMap.get("county"));
            }
            BeanUtils.copyAllPropertys((Object)jbsPosContractAssignmentRequest, (Object)sgSendgoodsDomain);
            if (!"1".equals(sgSendgoodsDomain.getContractPumode())) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("tenantCode", sgSendgoodsDomain.getTenantCode());
                paramMap.put("contractBillcode", sgSendgoodsDomain.getContractBillcode());
                String json = this.internalInvoke("oc.contractpro.querycontractproByOrderCode", paramMap);
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)json)) {
                    List proList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, SgContractproDomain.class);
                    jbsPosContractAssignmentRequest.setOcContractproDomainList(proList);
                }
            }
            this.logger.error(this.SYS_CODE + "sgSendgoodsDomain\u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            execute = httpFormfacade.execute(jbsPosContractAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendContractAssignment Exception", sgSendgoodsDomain.getSendgoodsCode());
        }
    }

    @Override
    public String sendRefundAssignment(OcRefundReDomain ocRefundDomain) {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/saveOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundAssignmentRequest jbsPosRefundAssignmentRequest = new JbsPosRefundAssignmentRequest();
            String storeOcode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCode(), "code", null);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeOcode)) {
                return JbsUtils.getErrorMap("\u5916\u7cfb\u7edf\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeOcode));
            }
            ocRefundDomain.setMemberCode(storeOcode);
            ocRefundDomain.setMemberCcode(storeOcode);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)ocRefundDomain.getGoodsReceiptArrdess())) {
                Map<String, String> addressMap = AddressResolution.addressResolution(ocRefundDomain.getGoodsReceiptArrdess());
                ocRefundDomain.setProvinceName(addressMap.get("province"));
                ocRefundDomain.setCityName(addressMap.get("city"));
                ocRefundDomain.setAreaName(addressMap.get("county"));
            }
            BeanUtils.copyAllPropertys((Object)jbsPosRefundAssignmentRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment Exception--" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundAssignment Exception", null);
        }
    }

    @Override
    public String sendOrderDownward(SgSendgoodsDomain sgSendgoodsDomain) {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getErrorMap("ocContractDomain is null", "");
        }
        this.logger.info(this.SYS_CODE + "sendOrderDownward \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        String sendGoods = this.getSgSendGoods(sgSendgoodsDomain.getSendgoodsCode());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sendGoods)) {
            this.logger.error(this.SYS_CODE, (Object)("sendGoods is null,sendgoodsCode=" + sgSendgoodsDomain.getSendgoodsCode()));
        }
        try {
            SgSendgoodsReDomain reDomain = (SgSendgoodsReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(sendGoods, SgSendgoodsReDomain.class);
            this.logger.info(this.SYS_CODE + "SgSendgoodsReDomain \u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)reDomain));
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsPosOrderDownwardRequest jbsPosOrderDownwardRequest = new JbsPosOrderDownwardRequest();
            BeanUtils.copyAllPropertysNotNull((Object)jbsPosOrderDownwardRequest, (Object)reDomain);
            this.logger.info(this.SYS_CODE + "-SgSendgoodsReDomain.getDataState \u6570\u636e>>>>>>> ", (Object)reDomain.getDataState());
            if (reDomain.getDataState() == 10) {
                httpFormfacade.setOutsideApiUrl("/api/order/saveRiderInfoToOrder");
                jbsPosOrderDownwardRequest.setDeliverer("\u6d4b\u8bd5\u4eba\u5458");
                jbsPosOrderDownwardRequest.setDelivererPhone("15111156958");
            } else if (reDomain.getDataState() == 7) {
                httpFormfacade.setOutsideApiUrl("/api/order/finishOrder");
            } else if (reDomain.getDataState() == 13) {
                httpFormfacade.setOutsideApiUrl("/api/order/deliverGoodsOrder");
            }
            JbsPosOrderResponse execute = httpFormfacade.execute(jbsPosOrderDownwardRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendOrderDownward \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendOrderDownward Exception" + e), (Throwable)e);
            return "error";
        }
    }

    @Override
    public String sendCancelShipment(SgSendgoodsDomain sgSendgoodsDomain) {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"sgSendgoodsReDomain is null");
            return JbsUtils.getErrorMap("sgSendgoodsReDomain is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendCancelShipment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getSendgoodsCode())) {
            return JbsUtils.getErrorMap("SendgoodsCode is null", null);
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelOrder");
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)sgSendgoodsDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendCancelShipment Exception", null);
        }
    }

    @Override
    public String sendRefundCompleted(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendRefundCompleted \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            return JbsUtils.getErrorMap("RefundCode is null", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/refundOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundCompleted Exception", null);
        }
    }

    @Override
    public String sendRefundRevoke(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundRevoke \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            return JbsUtils.getErrorMap("RefundCode is null", JsonUtil.getNotDefJsonUtil().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelRefundOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundRevoke Exception", null);
        }
    }

    @Override
    public String sendOrderFrom(String data) {
        this.logger.error(this.SYS_CODE + "sendOrderFrom \u6570\u636e>>>>>>> " + data);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcContractDomain.class);
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"ocContractDomain is null");
            return JbsUtils.getPosErrorMap("ocContractDomain is null", "", "");
        }
        ocContractDomain.setTenantCode("2019071800001392");
        if ("X1".equals(ocContractDomain.getContractTypepro())) {
            try {
                this.createWhOpStore(data);
                return JbsUtils.getPosSuccessMap("");
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendOrderFrom", (Object)e.toString(), (Throwable)e);
                return JbsUtils.getPosErrorMap("\u5e93\u5b58\u6263\u51cf\u5931\u8d25", "", "");
            }
        }
        String ocContract = this.getOcContract(ocContractDomain.getContractBillcode(), true);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)ocContract)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", "", ocContractDomain.getContractBillcode());
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            return JbsUtils.getPosErrorMap("\u5305\u88f9\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", "", ocContractDomain.getContractBillcode());
        }
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            String goodsList = JsonUtil.buildNormalBinder().toJson(ocPackageDomain.getContractGoodsList());
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goodsList)) {
                return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
            }
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
            List<Object> orderGoodsList = this.checkOrderGoodsByMap(list, ocContractDomain);
            if (!ListUtil.isNotEmpty(orderGoodsList)) continue;
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        try {
            String storeCode = this.checkUserAndStoreCode(ocContractDomain.getMemberCode(), "oCode", ocContractDomain);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeCode)) {
                return JbsUtils.getErrorMap("\u672a\u7ef4\u62a4\u5916\u7cfb\u7edf\u95e8\u5e97\u7f16\u7801", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
            }
            ocContractDomain.setMemberCode(storeCode);
            ocContractDomain.setMemberCcode(storeCode);
        }
        catch (ApiException e) {
            return JbsUtils.getErrorMap("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage(), ocContractDomain.getContractBillcode());
        }
        ocContractDomain.setGoodsClass("store");
        ocContractDomain.setMemberCname(ocContractDomain.getMemberName());
        DisChannel memchannel = this.getChannel(ocContractDomain.getChannelCode(), ocContractDomain.getTenantCode());
        if (null != memchannel) {
            ocContractDomain.setChannelCode(memchannel.getChannelCode());
            ocContractDomain.setChannelName(memchannel.getChannelName());
            ocContractDomain.setGoodsClass(memchannel.getGoodsClass());
            ocContractDomain.setMemberMcode(memchannel.getMemberMcode());
            ocContractDomain.setMemberMname(memchannel.getMemberMname());
        }
        try {
            paramsMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            this.getInternalRouter().inInvoke("oc.contract.sendsaveContract", paramsMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendOrderFrom is fail", (Object)e, (Throwable)e);
            return JbsUtils.getPosErrorMap("save data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)channelCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private void checkStoreChannelInfo(UmUserinfoDomain umUserinfoDomain, OcContractDomain ocContractDomain) {
        if (!EmptyUtil.isEmpty((Object)umUserinfoDomain) && com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)umUserinfoDomain.getUserinfoCode())) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            HashMap<String, String> sendMap = new HashMap<String, String>();
            paramsMap.put("memberCode", umUserinfoDomain.getUserinfoCode());
            paramsMap.put("tenantCode", "2019071800001392");
            sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramsMap));
            QueryResult queryResutl = this.getQueryResutl("dis.channel.queryChannelPage", sendMap, DisChannel.class);
            if (!EmptyUtil.isEmpty((Object)queryResutl) && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
                DisChannel disChannel = (DisChannel)queryResutl.getList().get(0);
                ocContractDomain.setChannelCode(disChannel.getChannelCode());
                ocContractDomain.setChannelName(disChannel.getChannelName());
            } else {
                throw new ApiException("\u95e8\u5e97\u6e20\u9053\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
            }
        }
    }

    @Override
    public String sendRefundOrderFrom(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            this.logger.error(this.SYS_CODE, (Object)"ocRefundDomain or refundType is null");
            return JbsUtils.getPosErrorMap("ocRefundDomain or refundType is null", "", "");
        }
        OcRefundReDomain ocRefund = this.getOcRefund(ocRefundDomain.getRefundCode());
        if (!EmptyUtil.isEmpty((Object)ocRefund)) {
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u9000\u5355\u53f7\u5df2\u5b58\u5728", "", ocRefundDomain.getRefundCode());
        }
        String goodsList = JsonUtil.buildNormalBinder().toJson(ocRefundDomain.getOcRefundGoodsDomainList());
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goodsList)) {
            return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
        List<Object> orderGoodsList = this.checkOrderGoodsByMap(list, null);
        if (ListUtil.isNotEmpty(orderGoodsList)) {
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        String storeCode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCode(), "oCode", null);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)storeCode)) {
            return JbsUtils.getErrorMap("\u672a\u7ef4\u62a4\u5916\u7cfb\u7edf\u95e8\u5e97\u7f16\u7801", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
        }
        ocRefundDomain.setMemberCode(storeCode);
        ocRefundDomain.setMemberCcode(storeCode);
        ocRefundDomain.setMemberCname(ocRefundDomain.getMemberName());
        try {
            paramsMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendsaveRefund", paramsMap);
        }
        catch (Exception e) {
            return JbsUtils.getPosErrorMap("save data is fail", "", e.getMessage());
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String sendOrderUplink(String dataStr) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", dataStr);
        }
        SgOccontractDomain sgOccontractDomain = (SgOccontractDomain)JsonUtil.buildNormalBinder().getJsonToObject(dataStr, SgOccontractDomain.class);
        if (EmptyUtil.isEmpty((Object)sgOccontractDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cObject \u4e3a null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        if ("X1".equals(sgOccontractDomain.getContractTypepro())) {
            try {
                this.createWhOpStore(dataStr);
                return JbsUtils.getPosSuccessMap("");
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendOrderFrom", (Object)dataStr);
                return JbsUtils.getPosErrorMap("\u5e93\u5b58\u6263\u51cf\u5931\u8d25", "", "");
            }
        }
        this.logger.info(this.SYS_CODE + ".sendOrderUplink", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain)));
        sgOccontractDomain.setTenantCode("2019071800001392");
        String msg = this.checkSgOccontract(sgOccontractDomain);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain.getContractBillcode()));
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> reMap = new HashMap<String, String>();
        try {
            String sendGoods = this.getSgSendGoods(sgOccontractDomain.getSendgoodsCode());
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sendGoods)) {
                return JbsUtils.getErrorMap("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728", sgOccontractDomain.getContractBillcode());
            }
            paramMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
            paramMap.put("tenantCode", sgOccontractDomain.getTenantCode());
            if ("0".equals(sgOccontractDomain.getDataStatestr())) {
                String ocContract = this.getOcContract(sgOccontractDomain.getContractBillcode(), false);
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContract)) {
                    return JbsUtils.getErrorMap("\u9500\u552e\u5355\u4e0d\u5b58\u5728", sgOccontractDomain.getContractBillcode());
                }
                OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContract, OcContractDomain.class);
                OcRefundDomain ocRefundDomain = new OcRefundDomain();
                this.makeOcRefund(ocRefundDomain, ocContractDomain);
                sendMap.put("ocRefundDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
                this.internalInvoke("oc.refundEngine.sendsaveRefund", sendMap);
                this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsBack", paramMap);
            } else if ("9".equals(sgOccontractDomain.getDataStatestr()) || "7".equals(sgOccontractDomain.getDataStatestr()) || "11".equals(sgOccontractDomain.getDataStatestr()) || "12".equals(sgOccontractDomain.getDataStatestr())) {
                reMap.put("sendgoodsLogName", sgOccontractDomain.getDataStatestr());
                reMap.put("sendgoodsLogMsg", sgOccontractDomain.getDataStatestr());
                reMap.put("tenantCode", sgOccontractDomain.getTenantCode());
                reMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
                paramMap.put("map", JsonUtil.buildNormalBinder().toJson(reMap));
                this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsNext", paramMap);
            } else if ("10".equals(sgOccontractDomain.getDataStatestr())) {
                msg = this.checkSgOccontractDomain(sgOccontractDomain);
                if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
                    return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain.getContractBillcode()));
                }
                HashMap<String, SgSendgoodsGoodsDomain> goodsReDomainMap = new HashMap<String, SgSendgoodsGoodsDomain>();
                SgSendgoodsDomain sgSendgoodsDomain = (SgSendgoodsDomain)JsonUtil.buildNonNullBinder().getJsonToObject(sendGoods, SgSendgoodsDomain.class);
                this.logger.info(this.SYS_CODE, (Object)("----" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)));
                for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                    if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsGoodsDomain.getSendgoodsGoodsOldcode())) continue;
                    goodsReDomainMap.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), sgSendgoodsGoodsDomain);
                }
                sendMap.clear();
                ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
                for (SgOccontractGoodsDomain ocContractGoodsDomain : sgOccontractDomain.getSgOccontractGoodsDomainList()) {
                    this.assDataSendgoodsGoods(sgSendgoodsGoodsDomains, goodsReDomainMap, ocContractGoodsDomain);
                }
                reMap.put("sendgoodsLogName", sgOccontractDomain.getDataStatestr());
                reMap.put("sendgoodsLogMsg", sgOccontractDomain.getDataStatestr());
                reMap.put("tenantCode", sgOccontractDomain.getTenantCode());
                reMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
                paramMap.put("map", JsonUtil.buildNormalBinder().toJson(reMap));
                sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
                this.logger.info(this.SYS_CODE, (Object)("sgSendgoodsDomain----" + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain)));
                sendMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
                this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsAndNext", sendMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(this.SYS_CODE, (Object)"save Data Exception", (Throwable)e);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendRefundState(String data) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        JSONObject invokeMap = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(data, JSONObject.class);
        if (MapUtil.isEmpty((Map)invokeMap)) {
            return JbsUtils.getPosErrorMap("paramsMap is null", "", "");
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("dataState")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("tenantCode")) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)invokeMap.getString("refundCode"))) {
            return JbsUtils.getPosErrorMap("refundCode\uff0ctenantCode\uff0cdataState", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        OcRefundReDomain ocRefund = this.getOcRefund(invokeMap.getString("refundCode"));
        if (null == ocRefund) {
            return JbsUtils.getPosErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap.getString("refundCode")));
        }
        invokeMap.put("map", null);
        try {
            this.logger.error(this.SYS_CODE, (Object)(".toService--invokeMap" + JsonUtil.buildNormalBinder().toJson((Object)invokeMap)));
            if ("0".equals(invokeMap.getString("dataState"))) {
                this.internalInvoke("oc.refundEngine.sendRefundBack", (Map)invokeMap);
            }
            if ("1".equals(invokeMap.getString("dataState"))) {
                this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", (Map)invokeMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + "sendRefundState is fail");
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
        return "success";
    }

    @Override
    public String sendRefundReceipt(String data) throws Exception {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cocRefundDomain \u4e3a null");
            return JbsUtils.getErrorMap("param is null", data);
        }
        this.logger.error(this.SYS_CODE + ".receiveChargebackReceiving", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain)));
        String msg = this.checkOcRefundDomain(ocRefundDomain);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain.getRefundCode()));
        }
        OcRefundReDomain ocRefundReDomain = this.getOcRefund(ocRefundDomain.getRefundCode());
        if (EmptyUtil.isEmpty((Object)ocRefundReDomain)) {
            return JbsUtils.getErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain.getRefundCode()));
        }
        this.logger.error(this.SYS_CODE + ".receiveChargebackReceiving", (Object)("\u5bf9\u5e94\u67e5\u8be2\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain)));
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        Collection ocRefundGoodsList = null;
        if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                this.makeOcRefundGoods((List<OcRefundGoodsDomain>)ocRefundGoodsList, ocRefundGoodsDomain);
            }
            if (ListUtil.isEmpty(ocRefundGoodsList)) {
                this.logger.error(this.SYS_CODE + ".sendRefundReceipt", (Object)("\u7ec4\u5408\u5b9e\u6536\n" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundGoodsList)));
                return JbsUtils.getErrorMap("\u7ec4\u5408\u5b9e\u6536\u53c2\u6570\u95ee\u9898", data);
            }
            ocRefundGoodsList.parallelStream().forEach(item -> {
                try {
                    invokeMap.put("ocRefundGoodsDomain", (String)item);
                    this.getInternalRouter().inInvoke("oc.refund.updateRefundGoods", invokeMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error(this.SYS_CODE, (Object)"\u5b9e\u9645\u6536\u8d27\u5546\u54c1", (Throwable)e);
                }
            });
        }
        try {
            invokeMap.clear();
            invokeMap.put("refundCode", ocRefundDomain.getRefundCode());
            invokeMap.put("tenantCode", "2019071800001392");
            invokeMap.put("map", null);
            this.logger.error(this.SYS_CODE, (Object)(".toService--jsonObject" + JsonUtil.buildNormalBinder().toJson(invokeMap)));
            if ("0".equals(ocRefundDomain.getDataStatestr())) {
                this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundBack", invokeMap);
            }
            if ("1".equals(ocRefundDomain.getDataStatestr())) {
                this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", invokeMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(this.SYS_CODE, (Object)"\u62d2\u63a5/\u63a5\u6536\u65e5\u5fd7", (Throwable)e);
        }
        return JbsUtils.getSuccessMap("");
    }

    private void makeOcRefundGoods(List<OcRefundGoodsDomain> ocRefundGoodsList, OcRefundGoodsDomain ocRefundGoodsDomain) throws Exception {
        OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
        BeanUtils.copyAllPropertysNotNull((Object)refundGoodsDomain, (Object)ocRefundGoodsDomain);
        refundGoodsDomain.setRefundGoodsCode(null);
        refundGoodsDomain.setRefundGoodsId(null);
        refundGoodsDomain.setRefundGoodsOldcode(ocRefundGoodsDomain.getRefundGoodsCode());
        ocRefundGoodsList.add(refundGoodsDomain);
    }

    private void assDataSendgoodsGoods(List<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains, Map<String, SgSendgoodsGoodsDomain> goodsReDomainMap, SgOccontractGoodsDomain ocContractGoodsDomain) throws Exception {
        SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
        SgSendgoodsGoodsDomain sgSendgoodsGoods = null;
        if (goodsReDomainMap.containsKey(ocContractGoodsDomain.getContractGoodsCode())) {
            sgSendgoodsGoods = goodsReDomainMap.get(ocContractGoodsDomain.getContractGoodsCode());
            BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)sgSendgoodsGoods);
        }
        sgSendgoodsGoodsDomain.setSendgoodsGoodsId(null);
        sgSendgoodsGoodsDomain.setContractBillcode(sgSendgoodsGoods.getContractBillcode());
        sgSendgoodsGoodsDomain.setSendgoodsCode(sgSendgoodsGoods.getSendgoodsCode());
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCamount(ocContractGoodsDomain.getContractGoodsSendnum());
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCweight(ocContractGoodsDomain.getContractGoodsSendweight());
        sgSendgoodsGoodsDomain.setGoodsTopnum(ocContractGoodsDomain.getContractGoodsSendnum());
        sgSendgoodsGoodsDomain.setGoodsTopweight(ocContractGoodsDomain.getContractGoodsSendweight());
        sgSendgoodsGoodsDomain.setContractGoodsCode(ocContractGoodsDomain.getContractGoodsCode());
        sgSendgoodsGoodsDomain.setPackageCode(ocContractGoodsDomain.getPackageCode());
        sgSendgoodsGoodsDomain.setMemberContact(ocContractGoodsDomain.getMemberContact());
        sgSendgoodsGoodsDomain.setMemberContactPhone(ocContractGoodsDomain.getMemberContactPhone());
        sgSendgoodsGoodsDomain.setMemberContactQq(ocContractGoodsDomain.getMemberContactQq());
        sgSendgoodsGoodsDomain.setWarehouseCode(ocContractGoodsDomain.getWarehouseCode());
        sgSendgoodsGoodsDomain.setWarehouseName(ocContractGoodsDomain.getWarehouseName());
        String goodsCode = sgSendgoodsGoodsDomain.getSendgoodsGoodsCode();
        sgSendgoodsGoodsDomain.setSendgoodsGoodsOldcode(goodsCode);
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCode(null);
        sgSendgoodsGoodsDomain.setGoodsSpec4(ocContractGoodsDomain.getGoodsSpec4());
        sgSendgoodsGoodsDomain.setGoodsSpec5(ocContractGoodsDomain.getGoodsSpec5());
        sgSendgoodsGoodsDomain.setTenantCode("2019071800001392");
        sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
    }

    private void makeOcRefund(OcRefundDomain ocRefundDomain, OcContractDomain ocContractDomain) throws Exception {
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractDomain);
        ocRefundDomain.setRefundType("POSJD");
        ocRefundDomain.setRefundMoney(ocContractDomain.getContractMoney());
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (!ListUtil.isNotEmpty(contractGoodsList)) continue;
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                ocRefundGoodsDomain.setRefundGoodsPrice(ocContractGoodsDomain.getContractGoodsPrice());
                ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsNum());
                ocRefundGoodsDomain.setRefundGoodsWeight(ocContractGoodsDomain.getGoodsWeight());
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
    }

    private String getSgSendGoods(String sendgoodsCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramMap.put("sendgoodsCode", sendgoodsCode);
        paramMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.internalInvoke("sg.sendgoods.getSgSendGoods", sendMap);
    }

    private OcRefundReDomain getOcRefund(String refundCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)refundCode)) {
            return null;
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("refundCode", refundCode);
        sendMap.put("tenantCode", "2019071800001392");
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.sendReSupObject("oc.refund.queryRefundReDomainPage", invokeMap, OcRefundReDomain.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (OcRefundReDomain)queryResutl.getList().get(0);
    }

    private String getOcContract(String contractBillcode, boolean flag) {
        String url = flag ? "oc.contract.getContractOneByCode" : "oc.contract.getContractByCode";
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String ocContract = this.internalInvoke(url, invokeMap);
        return ocContract;
    }

    private String checkUserAndStoreCode(String userinfo, String type, Object obj) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)userinfo)) {
            this.logger.error(this.SYS_CODE + ".checkUserAndStoreCode", (Object)"userinfo is null");
            return null;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramsMap.put("userinfoQuality", "store");
        if ("code".equals(type)) {
            paramsMap.put("userinfoCode", userinfo);
        } else if ("oCode".equals(type)) {
            paramsMap.put("userinfoOcode", userinfo);
        }
        paramsMap.put("fuzzy", "true");
        paramsMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramsMap));
        QueryResult umUserinfoResutl = this.getQueryResutl("um.userbase.queryUserinfoPage", sendMap, UmUserinfoReDomainBean.class);
        if (!EmptyUtil.isEmpty((Object)umUserinfoResutl) && ListUtil.isEmpty((Collection)umUserinfoResutl.getList())) {
            return null;
        }
        List umUserinfoDomainList = umUserinfoResutl.getList();
        if (ListUtil.isNotEmpty((Collection)umUserinfoDomainList)) {
            UmUserinfoReDomainBean umUserinfo = (UmUserinfoReDomainBean)umUserinfoDomainList.get(0);
            if ("code".equals(type)) {
                return umUserinfo.getUserinfoOcode();
            }
            if (!EmptyUtil.isEmpty((Object)obj) && obj instanceof OcContractDomain) {
                this.checkStoreChannelInfo(umUserinfo, (OcContractDomain)obj);
            }
            return umUserinfo.getUserinfoCode();
        }
        return null;
    }

    private List<Object> checkOrderGoodsByMap(List<Map<String, Object>> goodsList, OcContractDomain ocContractDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap querySkuResultMap = new HashMap();
        ArrayList<Object> noGoodsEoCodeList = new ArrayList<Object>();
        ArrayList<String> goodsEoCodeList = new ArrayList<String>();
        for (Map<String, Object> map : goodsList) {
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)String.valueOf(map.get("skuNo")))) continue;
            paramsMap.put("skuNo", map.get("skuNo"));
            paramsMap.put("tenantCode", "2019071800001392");
            invokeMap.put("map", JsonUtil.buildNormalBinder().toJson(paramsMap));
            QueryResult queryResut = this.sendReSupObject("rs.sku.querySkuOnePage", invokeMap, RsSku.class);
            if (ListUtil.isNotEmpty((Collection)queryResut.getList())) {
                goodsEoCodeList.add(((RsSku)queryResut.getList().get(0)).getGoodsEocode());
                querySkuResultMap.put(map.get("skuNo") + "", queryResut.getList().get(0));
                continue;
            }
            noGoodsEoCodeList.add(map.get("skuNo"));
        }
        if (!EmptyUtil.isEmpty((Object)ocContractDomain) && ListUtil.isNotEmpty(ocContractDomain.getPackageList())) {
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                if (!ListUtil.isNotEmpty(ocPackageDomain.getContractGoodsList())) continue;
                ocPackageDomain.getContractGoodsList().forEach(obj -> {
                    if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)obj.getSkuNo()) && !EmptyUtil.isEmpty(querySkuResultMap.get(obj.getSkuNo()))) {
                        obj.setGoodsCode(((RsSku)querySkuResultMap.get(obj.getSkuNo())).getGoodsCode());
                        obj.setMschannelName(((RsSku)querySkuResultMap.get(obj.getSkuNo())).getSkuName());
                    }
                });
            }
        }
        return noGoodsEoCodeList;
    }

    private String checkOcRefundDomain(OcRefundDomain ocRefundDomain) {
        List<OcRefundGoodsDomain> list;
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            msg = msg + "RefundCode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getContractType())) {
            msg = msg + "ContractType\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getRefundPumode())) {
            msg = msg + "RefundPumode\u4e3a\u7a7a;";
        }
        if (ListUtil.isEmpty(list = ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "OcRefundGoodsDomainList\u4e3a\u7a7a;";
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : list) {
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsCode())) {
                msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
            }
            if (ocRefundGoodsDomain.getGoodsNum() == null) {
                msg = msg + "GoodsNum\u4e3a\u7a7a;";
            }
            if (ocRefundGoodsDomain.getGoodsWeight() != null) continue;
            msg = msg + "GoodsWeight\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkSgOccontract(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getDataStatestr())) {
            msg = msg + "DataStatestr\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkSgOccontractDomain(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        List<SgOccontractGoodsDomain> contractGoodsList = sgOccontractDomain.getSgOccontractGoodsDomainList();
        for (SgOccontractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsCode())) {
                msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendnum())) {
                msg = msg + "ContractGoodsSendnum\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendweight())) {
                msg = msg + "ContractGoodsSendweight\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
                msg = msg + "ContractBillcode\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsName())) {
                msg = msg + "GoodsName\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsSpec4())) {
                msg = msg + "GoodsSpec4\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsSpec5())) {
                msg = msg + "GoodsSpec5\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContact())) {
                msg = msg + "GoodsSpec5\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContactPhone())) {
                msg = msg + "MemberContactPhone\u4e3a\u7a7a;";
            }
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContactQq())) continue;
            msg = msg + "MemberContactQq\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getDataStatestr())) {
            msg = msg + "DataStatestr\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkContractAssignment(SgSendgoodsDomain sgSendgoodsDomain) {
        List<SgSendgoodsGoodsDomain> goodsList;
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getContractType())) {
            msg = msg + "ContractType\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptPhone()) && "0".equals(sgSendgoodsDomain.getContractPumode())) {
            msg = msg + "GoodsReceiptPhone\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptArrdess())) {
            msg = msg + "GoodsReceiptArrdess\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptMem()) && "0".equals(sgSendgoodsDomain.getContractPumode())) {
            msg = msg + "GoodsReceiptMem\u4e3a\u7a7a;";
        }
        if ((goodsList = sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()).size() == 0 || ListUtil.isEmpty(goodsList)) {
            msg = msg + "SgSendgoodsGoodsReDomainList\u4e3a\u7a7a;";
        }
        for (SgSendgoodsGoodsDomain goods : goodsList) {
            if (goods.getGoodsNum() == null) {
                msg = msg + "GoodsNum\u4e3a\u7a7a;";
            }
            if (goods.getGoodsWeight() == null) {
                msg = msg + "GoodsWeight\u4e3a\u7a7a;";
            }
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goods.getSendgoodsGoodsCode())) {
                msg = msg + "SendgoodsGoodsCode\u4e3a\u7a7a;";
            }
            if (!com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)goods.getGoodsCode())) continue;
            msg = msg + "GoodsCode\u4e3a\u7a7a;";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void createWhOpStore(String dataStr) throws Exception {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)dataStr)) {
            return;
        }
        JSONObject jsonObject = JSONObject.json2object((String)dataStr);
        ArrayList<WhOpstoreDomain> whOpstoreDomainList = new ArrayList<WhOpstoreDomain>();
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        ArrayList whOpstoreSkuDomainList = new ArrayList();
        WhOpstoreDomain whOpstoreDomain = this.assWhOpstoreDomain(jsonObject);
        if (null == whOpstoreDomain) {
            throw new ApiException("Json to Obj is null");
        }
        whOpstoreDomainList.add(whOpstoreDomain);
        this.logger.error(this.SYS_CODE + ".createWhOpStore.JsonObj", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonObject));
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("packageList")) && com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("sgOccontractGoodsDomainList"))) {
            this.logger.error(this.SYS_CODE + ".createWhOpStore.checkJsonObj", (Object)"X1\u7c7b\u578b\u4e0bpackageList\u3001sgOccontractGoodsDomainList\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            throw new ApiException("X1\u7c7b\u578b\u4e0bpackageList\u3001sgOccontractGoodsDomainList\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)jsonObject.getString("sgOccontractGoodsDomainList"))) {
            JSONArray packageList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"packageList")));
            packageList.stream().forEach(p -> {
                JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(p.get((Object)"contractGoodsList")));
                this.assMap(contractGoodsList, map);
            });
        } else {
            JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"sgOccontractGoodsDomainList")));
            this.logger.error(this.SYS_CODE + ".createWhOpStore.sgOccontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractGoodsList));
            this.assMap(contractGoodsList, map);
        }
        map.keySet().stream().forEach(key -> {
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain(jsonObject, (JSONObject)cg, whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain));
            whOpstoreGoodsDomain.setOpstoreDir("0");
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType("1");
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.assWhOpstoreDomain(whOpstoreDomain);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
    }

    private void assMap(JSONArray contractGoodsList, Map<String, JSONArray> map) {
        contractGoodsList.stream().forEach(c -> {
            if (map.containsKey(c.getString("skuNo"))) {
                ((JSONArray)map.get(c.getString("skuNo"))).add(c);
            } else {
                JSONArray array = new JSONArray();
                array.add(c);
                map.put(c.getString("skuNo"), array);
            }
        });
    }

    public void assWhOpstoreDomain(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap<String, String> whMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        whMap.put("warehouseCode", whOpstoreDomain.getWarehouseCode());
        whMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(whMap));
        QueryResult qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
        if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
            throw new ApiException("checkGoodsClass.warehouseCode", whMap.toString());
        }
        WhWarehouseReDomain whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        String goodsClass = "plat";
        String memberCode = whWarehouseReDomain.getMemberCode();
        whOpstoreDomain.setMemberCode(memberCode);
        whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        if ("0".equals(whWarehouseReDomain.getWarehouseCtype()) || "1".equals(whWarehouseReDomain.getWarehouseCtype())) {
            goodsClass = "pos";
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList;
            Object rsResourceGoods;
            whOpstoreGoodsDomain.setGoodsEocode(whOpstoreGoodsDomain.getGoodsNo());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            HashMap<String, String> paramSendMap = new HashMap<String, String>();
            paramMap.put("goodsClass", goodsClass);
            paramMap.put("skuNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCcode", memberCode);
            paramMap.put("tenantCode", "2019071800001392");
            paramSendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResutl = this.getQueryResutl("rs.sku.querySkuPage", paramSendMap, RsSkuDomain.class);
            this.logger.error(this.SYS_CODE + ".assWhOpstoreDomain.querySkuPage", (Object)(JsonUtil.buildNormalBinder().toJson(paramSendMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)queryResutl)));
            if (null != queryResutl && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
                RsSkuDomain rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                paramMap.clear();
                paramMap.put("goodsCode", rsSkuDomain.getGoodsCode());
                paramMap.put("tenantCode", "2019071800001392");
                QueryResult queryGoodsResutl = this.getQueryResutl("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, RsResourceGoods.class);
                this.logger.error(this.SYS_CODE + ".assWhOpstoreDomain.getResourceGoodsByCodeStr", (Object)(JsonUtil.buildNormalBinder().toJson(paramMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)queryGoodsResutl)));
                if (null == queryGoodsResutl || !ListUtil.isNotEmpty((Collection)queryGoodsResutl.getList())) continue;
                rsResourceGoods = (RsResourceGoods)queryGoodsResutl.getList().get(0);
                whOpstoreGoodsDomain.setClasstreeCode(((RsResourceGoods)rsResourceGoods).getClasstreeCode());
                whOpstoreGoodsDomain.setClasstreeName(((RsResourceGoods)rsResourceGoods).getClasstreeName());
                whOpstoreGoodsDomain.setGoodsSpec5(((RsResourceGoods)rsResourceGoods).getGoodsProperty2());
                whOpstoreGoodsDomain.setGoodsCode(((RsResourceGoods)rsResourceGoods).getGoodsCode());
                whOpstoreGoodsDomain.setGoodsNo(((RsResourceGoods)rsResourceGoods).getGoodsNo());
                whOpstoreGoodsDomain.setSpuCode(((RsResourceGoods)rsResourceGoods).getSpuCode());
                whOpstoreGoodsDomain.setGoodsProperty(((RsResourceGoods)rsResourceGoods).getGoodsProperty3());
                whOpstoreGoodsDomain.setGoodsEocode(((RsResourceGoods)rsResourceGoods).getGoodsEocode());
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                whOpstoreGoodsDomain.setMemberName(whOpstoreDomain.getMemberName());
                this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
                this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
                whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
                    whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
                    whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
                    whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
                    whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
                    whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
                    whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
                    whOpstoreSkuDomain.setSkuName(rsSkuDomain.getSkuName());
                    whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
                    whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                    whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                    whOpstoreSkuDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                    whOpstoreSkuDomain.setMemberName(whOpstoreDomain.getMemberName());
                    whOpstoreSkuDomain.setStoreType("0");
                    whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                    this.checkNegative(whOpstoreSkuDomain.getGoodsNum());
                    this.checkNegative(whOpstoreSkuDomain.getGoodsWeight());
                }
                continue;
            }
            paramMap.clear();
            HashMap<String, String> sendMap = new HashMap<String, String>();
            paramMap.put("goodsClass", goodsClass);
            paramMap.put("goodsNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCcode", memberCode);
            paramMap.put("tenantCode", "2019071800001392");
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResult = this.sendReSupObject("rs.resourceGoods.queryResourceGoodsPage", sendMap, RsResourceGoodsReDomain.class);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                throw new ApiException(whOpstoreGoodsDomain.getGoodsNo() + ":\u8be5\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            rsResourceGoods = (RsResourceGoodsReDomain)queryResult.getList().get(0);
            whOpstoreGoodsDomain.setClasstreeCode(((RsResourceGoodsDomain)rsResourceGoods).getClasstreeCode());
            whOpstoreGoodsDomain.setClasstreeName(((RsResourceGoodsDomain)rsResourceGoods).getClasstreeName());
            whOpstoreGoodsDomain.setGoodsSpec5(((RsResourceGoodsDomain)rsResourceGoods).getGoodsProperty2());
            whOpstoreGoodsDomain.setGoodsCode(((RsResourceGoodsDomain)rsResourceGoods).getGoodsCode());
            whOpstoreGoodsDomain.setSpuCode(((RsResourceGoodsDomain)rsResourceGoods).getSpuCode());
            whOpstoreGoodsDomain.setGoodsNo(((RsResourceGoodsDomain)rsResourceGoods).getGoodsNo());
            whOpstoreGoodsDomain.setGoodsProperty(((RsResourceGoodsDomain)rsResourceGoods).getGoodsProperty3());
            whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
            whOpstoreGoodsDomain.setMemberCode(whOpstoreDomain.getMemberCode());
            whOpstoreGoodsDomain.setMemberName(whOpstoreDomain.getMemberName());
            whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                whOpstoreSkuDomain.setClasstreeCode(((RsResourceGoodsDomain)rsResourceGoods).getClasstreeCode());
                whOpstoreSkuDomain.setClasstreeName(((RsResourceGoodsDomain)rsResourceGoods).getClasstreeName());
                whOpstoreSkuDomain.setGoodsCode(((RsResourceGoodsDomain)rsResourceGoods).getGoodsCode());
                whOpstoreSkuDomain.setSpuCode(((RsResourceGoodsDomain)rsResourceGoods).getSpuCode());
                whOpstoreSkuDomain.setGoodsNo(((RsResourceGoodsDomain)rsResourceGoods).getGoodsNo());
                whOpstoreSkuDomain.setStoreType("0");
                whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                this.checkNegative(whOpstoreSkuDomain.getGoodsNum());
                this.checkNegative(whOpstoreSkuDomain.getGoodsWeight());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreSkuDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                whOpstoreSkuDomain.setMemberName(whOpstoreDomain.getMemberName());
            }
        }
    }

    private void checkNegative(BigDecimal data) throws Exception {
        if (!EmptyUtil.isEmpty((Object)data) && BigDecimal.ZERO.compareTo(data) > 0) {
            throw new ApiException("\u5546\u54c1\u6570\u91cf\u6216\u91cd\u91cf\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
    }

    private WhOpstoreDomain assWhOpstoreDomain(JSONObject jsonObject) {
        if (null == jsonObject && null == jsonObject.get((Object)"memberCode")) {
            return null;
        }
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        whOpstoreDomain.setWarehouseCode(jsonObject.get((Object)"memberCode") + "");
        whOpstoreDomain.setStoreGoodsBtype("X1");
        whOpstoreDomain.setStoreGoodsType("1");
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setTenantCode("2019071800001392");
        whOpstoreDomain.setOpstoreOcode(jsonObject.getString("contractBillcode"));
        return whOpstoreDomain;
    }

    private void assWhOpstoreGoodsDomain(JSONObject jsonObject, List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == jsonObject) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreGoodsDomain.setGoodsNo(jsonObject.getString("skuNo"));
        whOpstoreGoodsDomain.setTenantCode("2019071800001392");
        whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
    }

    private void assWhOpstoreSkuDomain(JSONObject jsonObj, JSONObject jsonObject, List<WhOpstoreSkuDomain> whOpstoreSkuDomainList, WhOpstoreDomain whOpstoreDomain, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == jsonObject || null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            return;
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsWeight()) {
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsAmt()) {
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreSkuDomain.setGoodsNum(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsNum")));
        whOpstoreSkuDomain.setGoodsWeight(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsWeight")));
        whOpstoreSkuDomain.setOpstoreDir("0");
        whOpstoreSkuDomain.setStoreType("0");
        whOpstoreSkuDomain.setStoreGoodsType("1");
        whOpstoreSkuDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsNo());
        whOpstoreDomain.setMemberCcode(whOpstoreSkuDomain.getMemberCcode());
        whOpstoreDomain.setMemberCname(whOpstoreSkuDomain.getMemberCname());
        whOpstoreDomain.setChannelCode(whOpstoreSkuDomain.getChannelCode());
        whOpstoreDomain.setChannelName(whOpstoreSkuDomain.getChannelName());
        whOpstoreDomain.setMemberMcode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberMname(whOpstoreSkuDomain.getMemberName());
        whOpstoreDomain.setMemberCode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberName(whOpstoreSkuDomain.getMemberName());
        String storeLocal = this.handleStoreWhlocal(jsonObj);
        whOpstoreSkuDomain.setStoreWhlocal(storeLocal);
        whOpstoreSkuDomain.setSkuBarcode((String)jsonObject.get((Object)"memberContactQq"));
        whOpstoreSkuDomain.setTenantCode("2019071800001392");
        if (null == whOpstoreSkuDomain.getGoodsNum()) {
            whOpstoreSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreSkuDomain.getGoodsWeight()) {
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        whOpstoreDomain.setGoodsNum(whOpstoreDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreDomain.setGoodsWeight(whOpstoreDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreGoodsDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
    }

    private String handleStoreWhlocal(JSONObject jsonObject) {
        JSONArray ocContractSettlList;
        String whLocal = "1001";
        if (null != jsonObject && null != (ocContractSettlList = jsonObject.getJSONArray("ocContractSettlList"))) {
            for (JSONObject object : ocContractSettlList) {
                if (EmptyUtil.isEmpty((Object)object.get((Object)"goodsContract")) || "null".equals(object.get((Object)"goodsContract"))) continue;
                whLocal = object.get((Object)"goodsContract") + "";
                break;
            }
        }
        return whLocal;
    }
}

