/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.DisChannel;
import com.yqbsoft.laser.service.pos.domain.GoodsBean;
import com.yqbsoft.laser.service.pos.domain.OcContractDomain;
import com.yqbsoft.laser.service.pos.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcPackageDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoods;
import com.yqbsoft.laser.service.pos.domain.RsSku;
import com.yqbsoft.laser.service.pos.domain.RsSkuDomain;
import com.yqbsoft.laser.service.pos.domain.SgContractproDomain;
import com.yqbsoft.laser.service.pos.domain.SgOccontractDomain;
import com.yqbsoft.laser.service.pos.domain.SgOccontractGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.pos.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.pos.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.pos.domain.WhWarehouseReDomain;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosCancelOrderRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosCancelPayOrderRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosContractAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosOrderDownwardRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundAssignmentRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosRefundDataRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosOrderResponse;
import com.yqbsoft.laser.service.pos.service.ContractService;
import com.yqbsoft.laser.service.pos.utils.AddressResolution;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.pos.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContractServiceImpl
extends BaseServiceImpl
implements ContractService {
    private String SYS_CODE = "jbsPos.ContractServiceImpl";

    @Override
    public String sendContractAssignment(SgSendgoodsDomain sgSendgoodsDomain) {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE + ".sendContractAssignment", (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendContractAssignment \u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        try {
            String msg = this.checkContractAssignment(sgSendgoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error(this.SYS_CODE + ".sendContractAssignment.checkContractAssignment", (Object)msg);
                return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain.getContractBillcode()));
            }
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/saveOrder");
            JbsPosOrderResponse execute = null;
            JbsPosContractAssignmentRequest jbsPosContractAssignmentRequest = new JbsPosContractAssignmentRequest();
            String storeOcode = this.checkUserAndStoreCode(sgSendgoodsDomain.getMemberCode(), "code", null);
            if (StringUtils.isBlank((String)storeOcode)) {
                this.logger.error(this.SYS_CODE + ".sendContractAssignment.checkUserAndStoreCode", (Object)sgSendgoodsDomain.getMemberCode());
                return JbsUtils.getErrorMap("\u5916\u7cfb\u7edf\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeOcode));
            }
            sgSendgoodsDomain.setMemberCode(storeOcode);
            sgSendgoodsDomain.setMemberCcode(storeOcode);
            if (StringUtils.isNotBlank((String)sgSendgoodsDomain.getGoodsReceiptArrdess())) {
                Map<String, String> addressMap = AddressResolution.addressResolution(sgSendgoodsDomain.getGoodsReceiptArrdess());
                sgSendgoodsDomain.setProvinceName(addressMap.get("province"));
                sgSendgoodsDomain.setCityName(addressMap.get("city"));
                sgSendgoodsDomain.setAreaName(addressMap.get("county"));
            }
            BeanUtils.copyAllPropertys((Object)jbsPosContractAssignmentRequest, (Object)sgSendgoodsDomain);
            String ocContract = this.getOcContract(sgSendgoodsDomain.getContractBillcode(), true);
            if (StringUtils.isBlank((String)ocContract)) {
                return JbsUtils.getPosErrorMap("\u8ba2\u5355\u4e0d\u5b58\u5728", "", sgSendgoodsDomain.getContractBillcode());
            }
            OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContract, OcContractDomain.class);
            if (ocContractDomain != null) {
                jbsPosContractAssignmentRequest.setPackingCharge(ocContractDomain.getEmployeeCode());
            }
            if (!"1".equals(sgSendgoodsDomain.getContractPumode())) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("tenantCode", sgSendgoodsDomain.getTenantCode());
                paramMap.put("contractBillcode", sgSendgoodsDomain.getContractBillcode());
                String json = this.internalInvoke("oc.contractpro.querycontractproByOrderCode", paramMap);
                if (StringUtils.isNotBlank((String)json)) {
                    List proList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, SgContractproDomain.class);
                    jbsPosContractAssignmentRequest.setOcContractproDomainList(proList);
                }
            }
            this.logger.error(this.SYS_CODE + "sgSendgoodsDomain\u6570\u636e>>>>>>> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            execute = httpFormfacade.execute(jbsPosContractAssignmentRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendContractAssignment Exception" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendContractAssignment Exception", sgSendgoodsDomain.getSendgoodsCode());
        }
    }

    @Override
    public String sendRefundAssignment(OcRefundReDomain ocRefundDomain) {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundAssignment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/saveOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundAssignmentRequest jbsPosRefundAssignmentRequest = new JbsPosRefundAssignmentRequest();
            String storeOcode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCcode(), "code", null);
            if (StringUtils.isBlank((String)storeOcode)) {
                return JbsUtils.getErrorMap("\u5916\u7cfb\u7edf\u95e8\u5e97\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)storeOcode));
            }
            ocRefundDomain.setMemberCode(storeOcode);
            ocRefundDomain.setMemberCcode(storeOcode);
            if (StringUtils.isNotBlank((String)ocRefundDomain.getGoodsReceiptArrdess())) {
                Map<String, String> addressMap = AddressResolution.addressResolution(ocRefundDomain.getGoodsReceiptArrdess());
                ocRefundDomain.setProvinceName(addressMap.get("province"));
                ocRefundDomain.setCityName(addressMap.get("city"));
                ocRefundDomain.setAreaName(addressMap.get("county"));
            }
            BeanUtils.copyAllPropertys((Object)jbsPosRefundAssignmentRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundAssignmentRequest);
            this.logger.error(this.SYS_CODE + ".sendRefundAssignment.send", (Object)("\u6570\u636e:" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundAssignment Exception--" + e), (Throwable)e);
            return JbsUtils.getErrorMap("send sendRefundAssignment Exception", null);
        }
    }

    @Override
    public String sendOrderDownward(SgSendgoodsDomain sgSendgoodsDomain) {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE + ".sendOrderDownward.null", (Object)"ocContractDomain is null");
            return JbsUtils.getErrorMap("ocContractDomain is null", "");
        }
        String sendGoods = this.getSgSendGoods(sgSendgoodsDomain.getSendgoodsCode());
        if (StringUtils.isBlank((String)sendGoods)) {
            this.logger.error(this.SYS_CODE + ".sendOrderDownward.sendGoods", (Object)("sendGoods is null,sendgoodsCode=" + sgSendgoodsDomain.getSendgoodsCode()));
            return JbsUtils.getErrorMap("ocContractDomain is null", sgSendgoodsDomain.getSendgoodsCode());
        }
        try {
            SgSendgoodsReDomain reDomain = (SgSendgoodsReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(sendGoods, SgSendgoodsReDomain.class);
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsPosOrderDownwardRequest jbsPosOrderDownwardRequest = new JbsPosOrderDownwardRequest();
            BeanUtils.copyAllPropertysNotNull((Object)jbsPosOrderDownwardRequest, (Object)reDomain);
            this.logger.info(this.SYS_CODE + ".sendOrderDownward.sendDataState", (Object)reDomain.getDataState());
            if (reDomain.getDataState() == 3 || reDomain.getDataState() == 10) {
                httpFormfacade.setOutsideApiUrl("/api/order/saveRiderInfoToOrder");
                List<SgSendgoodsLogDomain> sgSendgoodsLogDomainList = sgSendgoodsDomain.getSgSendgoodsLogDomainList();
                if (ListUtil.isEmpty(sgSendgoodsLogDomainList)) {
                    this.logger.error(this.SYS_CODE + ".sendOrderDownward.sgSendgoodsLogDomainList", (Object)("sgSendgoodsLogDomainList is null,sendgoodsCode=" + sgSendgoodsDomain.getSendgoodsCode()));
                    return JbsUtils.getErrorMap("sgSendgoodsLogDomainList is null", "");
                }
                for (SgSendgoodsLogDomain sgSendgoodsLogDomain : sgSendgoodsLogDomainList) {
                    if (StringUtils.isNotBlank((String)sgSendgoodsLogDomain.getSendgoodsLogSendmem())) {
                        jbsPosOrderDownwardRequest.setDeliverer(sgSendgoodsLogDomain.getSendgoodsLogSendmem());
                    }
                    if (!StringUtils.isNotBlank((String)sgSendgoodsLogDomain.getSendgoodsLogPhone())) continue;
                    jbsPosOrderDownwardRequest.setDelivererPhone(sgSendgoodsLogDomain.getSendgoodsLogPhone());
                }
            } else if (reDomain.getDataState() == 7) {
                httpFormfacade.setOutsideApiUrl("/api/order/finishOrder");
            } else if (reDomain.getDataState() == 13) {
                httpFormfacade.setOutsideApiUrl("/api/order/deliverGoodsOrder");
            }
            JbsPosOrderResponse execute = httpFormfacade.execute(jbsPosOrderDownwardRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE + ".sendOrderDownward.execute", (Object)("send sendOrderDownward \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendOrderDownward.e", (Throwable)e);
            return "error";
        }
    }

    @Override
    public String sendCancelShipment(SgSendgoodsDomain sgSendgoodsDomain) {
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"sgSendgoodsReDomain is null");
            return JbsUtils.getErrorMap("sgSendgoodsReDomain is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendCancelShipment \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getSendgoodsCode())) {
            return JbsUtils.getErrorMap("SendgoodsCode is null", null);
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelOrder");
            JbsPosOrderResponse execute = null;
            JbsPosCancelOrderRequest jbsPosCancelOrderRequest = new JbsPosCancelOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelOrderRequest, (Object)sgSendgoodsDomain);
            execute = httpFormfacade.execute(jbsPosCancelOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendCancelShipment Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendCancelShipment Exception", null);
        }
    }

    @Override
    public String sendRefundCompleted(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error(this.SYS_CODE + "sendRefundCompleted \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            return JbsUtils.getErrorMap("RefundCode is null", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/refundOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundCompleted Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundCompleted Exception", null);
        }
    }

    @Override
    public String sendRefundRevoke(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendRefundRevoke \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            return JbsUtils.getErrorMap("RefundCode is null", JsonUtil.getNotDefJsonUtil().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelRefundOrder");
            JbsPosOrderResponse execute = null;
            JbsPosRefundDataRequest jbsPosRefundDataRequest = new JbsPosRefundDataRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosRefundDataRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosRefundDataRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke \u6570\u636e\u5904\u7406\u5931\u8d25" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("send sendRefundRevoke Exception" + e), (Throwable)e);
            e.printStackTrace();
            return JbsUtils.getErrorMap("send sendRefundRevoke Exception", null);
        }
    }

    @Override
    public String sendOrderFrom(String data) {
        this.logger.error(this.SYS_CODE + ".sendOrderFrom", (Object)data);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.null", (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcContractDomain.class);
        if (EmptyUtil.isEmpty((Object)ocContractDomain)) {
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.ocContractDomain", (Object)"ocContractDomain is null");
            return JbsUtils.getPosErrorMap("ocContractDomain is null", "", "");
        }
        ocContractDomain.setTenantCode("2019071800001392");
        if ("X1".equals(ocContractDomain.getContractTypepro())) {
            try {
                this.createWhOpStore(data);
                return JbsUtils.getPosSuccessMap("");
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendOrderFrom.e", (Object)e.toString(), (Throwable)e);
                return JbsUtils.getPosErrorMap("\u5e93\u5b58\u6263\u51cf\u5931\u8d25:" + e.getMessage(), "", "");
            }
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.packageList", (Object)ocContractDomain.getContractBillcode());
            return JbsUtils.getPosErrorMap("\u5305\u88f9\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", "", ocContractDomain.getContractBillcode());
        }
        String ocContract = this.getOcContract(ocContractDomain.getContractBillcode(), true);
        if (StringUtils.isNotBlank((String)ocContract)) {
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.ocContract", (Object)ocContractDomain.getContractBillcode());
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", "", ocContractDomain.getContractBillcode());
        }
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                ocContractGoodsDomain.setGoodsTopnum(ocContractGoodsDomain.getGoodsCamount());
                ocContractGoodsDomain.setGoodsTopweight(ocContractGoodsDomain.getGoodsCweight());
            }
            String goodsList = JsonUtil.buildNormalBinder().toJson(ocPackageDomain.getContractGoodsList());
            if (StringUtils.isBlank((String)goodsList)) {
                this.logger.error(this.SYS_CODE + ".sendOrderFrom.goodsList", (Object)ocContractDomain.getContractBillcode());
                return JbsUtils.getPosErrorMap("\u8ba2\u5355\u5546\u54c1\u65e0\u6570\u636e", "", goodsList);
            }
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsList, Map.class);
            List<Object> orderGoodsList = this.checkOrderGoodsByMap(list, ocContractDomain);
            if (!ListUtil.isNotEmpty(orderGoodsList)) continue;
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.orderGoodsList", (Object)ocContractDomain.getContractBillcode());
            return JbsUtils.getPosErrorMap("\u5546\u54c1\u4e0d\u5b58\u5728", "", orderGoodsList);
        }
        try {
            String storeCode = this.checkUserAndStoreCode(ocContractDomain.getMemberCode(), "oCode", ocContractDomain);
            if (StringUtils.isBlank((String)storeCode)) {
                this.logger.error(this.SYS_CODE + ".sendOrderFrom.storeCode", (Object)ocContractDomain.getContractBillcode());
                return JbsUtils.getErrorMap("\u672a\u7ef4\u62a4\u5916\u7cfb\u7edf\u95e8\u5e97\u7f16\u7801", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
            }
            ocContractDomain.setMemberCode(storeCode);
            ocContractDomain.setMemberCcode(storeCode);
        }
        catch (ApiException e) {
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.save.e", (Throwable)e);
            return JbsUtils.getErrorMap("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage(), ocContractDomain.getContractBillcode());
        }
        ocContractDomain.setGoodsClass("store");
        ocContractDomain.setMemberCname(ocContractDomain.getMemberName());
        DisChannel memchannel = this.getChannel(ocContractDomain.getChannelCode(), ocContractDomain.getTenantCode());
        if (null != memchannel) {
            ocContractDomain.setChannelCode(memchannel.getChannelCode());
            ocContractDomain.setChannelName(memchannel.getChannelName());
            ocContractDomain.setGoodsClass(memchannel.getGoodsClass());
            ocContractDomain.setMemberMcode(memchannel.getMemberMcode());
            ocContractDomain.setMemberMname(memchannel.getMemberMname());
        }
        try {
            paramsMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            this.getInternalRouter().inInvoke("oc.contractEngine.sendsaveContract", paramsMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendOrderFrom.send.e", (Throwable)e);
            return JbsUtils.getPosErrorMap("save data is fail", "", data);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private void checkStoreChannelInfo(UmUserinfoDomain umUserinfoDomain, OcContractDomain ocContractDomain) {
        if (!EmptyUtil.isEmpty((Object)umUserinfoDomain) && StringUtils.isNotBlank((String)umUserinfoDomain.getUserinfoCode())) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            HashMap<String, String> sendMap = new HashMap<String, String>();
            paramsMap.put("memberCode", umUserinfoDomain.getUserinfoCode());
            paramsMap.put("tenantCode", "2019071800001392");
            sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramsMap));
            QueryResult queryResutl = this.getQueryResutl("dis.channel.queryChannelPage", sendMap, DisChannel.class);
            if (!EmptyUtil.isEmpty((Object)queryResutl) && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
                DisChannel disChannel = (DisChannel)queryResutl.getList().get(0);
                ocContractDomain.setChannelCode(disChannel.getChannelCode());
                ocContractDomain.setChannelName(disChannel.getChannelName());
            } else {
                throw new ApiException("\u95e8\u5e97\u6e20\u9053\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
            }
        }
    }

    private String checkOcRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            return "contractBillcode\u4e3a\u7a7a";
        }
        return "";
    }

    @Override
    public String sendRefundOrderFrom(String data) {
        if (StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        this.logger.info(this.SYS_CODE + ".sendRefundOrderFrom.param", (Object)data);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain) || StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.ocRefundDomain", (Object)data);
            return JbsUtils.getPosErrorMap("ocRefundDomain or refundType is null", "", "");
        }
        String msg = this.checkOcRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.msg", (Object)msg);
            return JbsUtils.getErrorMap(msg, data);
        }
        String ocContract = this.getOcContract(ocRefundDomain.getContractBillcode(), true);
        if (StringUtils.isBlank((String)ocContract)) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.ocContract", (Object)data);
            return JbsUtils.getPosErrorMap("\u5f53\u524d\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "", ocRefundDomain.getContractBillcode());
        }
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        if (ListUtil.isEmpty(ocRefundGoodsDomainList)) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.ocRefundGoodsDomainList", (Object)data);
            return JbsUtils.getPosErrorMap(ocRefundDomain.getRefundCode() + ":\u9000\u5355\u5546\u54c1\u65e0\u6570\u636e", "", "");
        }
        List<OcRefundGoodsDomain> orderGoodsList = this.checkRefundGoodsData(ocRefundGoodsDomainList);
        if (ListUtil.isEmpty(orderGoodsList)) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.orderGoodsList", (Object)data);
            return JbsUtils.getPosErrorMap("\u9000\u5355\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", "", "");
        }
        ocRefundDomain.setOcRefundGoodsDomainList(orderGoodsList);
        String storeCode = this.checkUserAndStoreCode(ocRefundDomain.getMemberCode(), "oCode", null);
        if (StringUtils.isBlank((String)storeCode)) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.storeCode", (Object)data);
            return JbsUtils.getErrorMap("\u672a\u7ef4\u62a4\u5916\u7cfb\u7edf\u95e8\u5e97\u7f16\u7801", JsonUtil.buildNormalBinder().toJson((Object)storeCode));
        }
        ocRefundDomain.setMemberCode(storeCode);
        ocRefundDomain.setMemberCcode(storeCode);
        ocRefundDomain.setMemberCname(ocRefundDomain.getMemberName());
        try {
            paramsMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendsaveRefund", paramsMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendRefundOrderFrom.e", (Throwable)e);
            return JbsUtils.getPosErrorMap("save data is fail", "", e.getMessage());
        }
        return JbsUtils.getPosSuccessMap("");
    }

    private List<OcRefundGoodsDomain> checkRefundGoodsData(List<OcRefundGoodsDomain> ocRefundGoodsDomainList) {
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomains = new ArrayList<OcRefundGoodsDomain>();
        if (ListUtil.isNotEmpty(ocRefundGoodsDomainList)) {
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
                GoodsBean goodsBean = this.querySkuInfo(ocRefundGoodsDomain.getSkuNo(), "pos", "2019071800001392", "");
                if (null == goodsBean || null == goodsBean.getRsSkuDomain() || null == goodsBean.getRsResourceGoods()) {
                    this.logger.error(this.SYS_CODE + ".checkRefundGoodsData.goodsBean", (Object)ocRefundGoodsDomain.getSkuNo());
                    return null;
                }
                RsSkuDomain rsSkuDomain = goodsBean.getRsSkuDomain();
                RsResourceGoods rsResourceGoods = goodsBean.getRsResourceGoods();
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)rsResourceGoods);
                    BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".checkRefundGoodsData.e", (Object)ocRefundGoodsDomain.getSkuNo());
                }
                ocRefundGoodsDomain.setSkuName(rsSkuDomain.getSkuName());
                ocRefundGoodsDomain.setGoodsProperty2(rsResourceGoods.getGoodsProperty2());
                ocRefundGoodsDomain.setSkuNo(ocRefundGoodsDomain.getSkuCode());
                ocRefundGoodsDomains.add(ocRefundGoodsDomain);
            }
        }
        return ocRefundGoodsDomains;
    }

    @Override
    public String sendOrderUplink(String dataStr) {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", dataStr);
        }
        this.logger.info(this.SYS_CODE + ".sendOrderUplink.dataStr", (Object)dataStr);
        SgOccontractDomain sgOccontractDomain = (SgOccontractDomain)JsonUtil.buildNormalBinder().getJsonToObject(dataStr, SgOccontractDomain.class);
        if (EmptyUtil.isEmpty((Object)sgOccontractDomain)) {
            this.logger.error(this.SYS_CODE + ".sendOrderUplink.sgOccontractDomain", (Object)"\u63a5\u6536\u6570\u636e\u8f6cObject \u4e3a null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        if ("X1".equals(sgOccontractDomain.getContractTypepro())) {
            try {
                this.createWhOpStore(dataStr);
                return JbsUtils.getPosSuccessMap("");
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendOrderFrom", (Object)dataStr);
                return JbsUtils.getPosErrorMap("\u5e93\u5b58\u6263\u51cf\u5931\u8d25", "", "");
            }
        }
        sgOccontractDomain.setTenantCode("2019071800001392");
        String msg = this.checkSgOccontract(sgOccontractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error(this.SYS_CODE + ".sendOrderUplink.msg", (Object)msg);
            return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain.getContractBillcode()));
        }
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> reMap = new HashMap<String, String>();
        try {
            String sendGoods = this.getSgSendGoods(sgOccontractDomain.getSendgoodsCode());
            if (StringUtils.isBlank((String)sendGoods)) {
                this.logger.error(this.SYS_CODE + ".sendOrderUplink.sendGoods", (Object)sgOccontractDomain.getSendgoodsCode());
                return JbsUtils.getErrorMap("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728", sgOccontractDomain.getContractBillcode());
            }
            paramMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
            paramMap.put("tenantCode", sgOccontractDomain.getTenantCode());
            if ("0".equals(sgOccontractDomain.getDataStatestr())) {
                String ocContract = this.getOcContract(sgOccontractDomain.getContractBillcode(), false);
                if (StringUtils.isBlank((String)ocContract)) {
                    this.logger.error(this.SYS_CODE + ".sendOrderUplink.ocContract", (Object)sgOccontractDomain.getContractBillcode());
                    return JbsUtils.getErrorMap("\u9500\u552e\u5355\u4e0d\u5b58\u5728", sgOccontractDomain.getContractBillcode());
                }
                OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContract, OcContractDomain.class);
                OcRefundDomain ocRefundDomain = new OcRefundDomain();
                this.makeOcRefund(ocRefundDomain, ocContractDomain);
                sendMap.put("ocRefundDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
                this.logger.info(this.SYS_CODE + ".sendOrderUplink.0", sendMap);
                this.internalInvoke("oc.refundEngine.sendsaveRefund", sendMap);
            } else if ("9".equals(sgOccontractDomain.getDataStatestr()) || "7".equals(sgOccontractDomain.getDataStatestr()) || "11".equals(sgOccontractDomain.getDataStatestr()) || "12".equals(sgOccontractDomain.getDataStatestr())) {
                reMap.put("sendgoodsLogName", sgOccontractDomain.getDataStatestr());
                reMap.put("sendgoodsLogMsg", sgOccontractDomain.getDataStatestr());
                reMap.put("tenantCode", sgOccontractDomain.getTenantCode());
                reMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
                paramMap.put("map", JsonUtil.buildNormalBinder().toJson(reMap));
                this.logger.info(this.SYS_CODE + ".sendOrderUplink.9-7-11-12", paramMap);
                this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsNext", paramMap);
            } else if ("10".equals(sgOccontractDomain.getDataStatestr())) {
                msg = this.checkSgOccontractDomain(sgOccontractDomain);
                if (StringUtils.isNotBlank((String)msg)) {
                    this.logger.error(this.SYS_CODE + ".sendOrderUplink.msg", (Object)msg);
                    return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)sgOccontractDomain.getContractBillcode()));
                }
                HashMap<String, SgSendgoodsGoodsDomain> goodsReDomainMap = new HashMap<String, SgSendgoodsGoodsDomain>();
                SgSendgoodsDomain sgSendgoodsDomain = (SgSendgoodsDomain)JsonUtil.buildNonNullBinder().getJsonToObject(sendGoods, SgSendgoodsDomain.class);
                for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                    if (!StringUtils.isBlank((String)sgSendgoodsGoodsDomain.getSendgoodsGoodsOldcode())) continue;
                    goodsReDomainMap.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), sgSendgoodsGoodsDomain);
                }
                sendMap.clear();
                ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
                for (SgOccontractGoodsDomain ocContractGoodsDomain : sgOccontractDomain.getSgOccontractGoodsDomainList()) {
                    this.assDataSendgoodsGoods(sgSendgoodsGoodsDomains, goodsReDomainMap, ocContractGoodsDomain);
                }
                reMap.put("sendgoodsLogName", sgOccontractDomain.getDataStatestr());
                reMap.put("sendgoodsLogMsg", sgOccontractDomain.getDataStatestr());
                reMap.put("tenantCode", sgOccontractDomain.getTenantCode());
                reMap.put("sendgoodsCode", sgOccontractDomain.getSendgoodsCode());
                sendMap.put("map", JsonUtil.buildNormalBinder().toJson(reMap));
                sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
                sendMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
                this.logger.info(this.SYS_CODE + ".sendOrderUplink.10", sendMap);
                this.internalInvoke("sg.sendgoodsEngine.sendSendgoodsAndNext", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendOrderUplink.e", (Object)"save Data Exception", (Throwable)e);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendRefundState(String data) {
        this.logger.info(this.SYS_CODE + ".sendRefundState.dataStr", (Object)data);
        if (StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE + ".sendRefundState.param", (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", data);
        }
        JSONObject invokeMap = (JSONObject)JsonUtil.buildNormalBinder().getJsonToObject(data, JSONObject.class);
        if (MapUtil.isEmpty((Map)invokeMap)) {
            this.logger.error(this.SYS_CODE + ".sendRefundState.data", (Object)"data is null");
            return JbsUtils.getPosErrorMap("paramsMap is null", "", "");
        }
        if (StringUtils.isBlank((String)invokeMap.getString("auditStatus")) || StringUtils.isBlank((String)invokeMap.getString("tenantCode")) || StringUtils.isBlank((String)invokeMap.getString("refundCode")) || StringUtils.isBlank((String)invokeMap.getString("refundPumode"))) {
            this.logger.error(this.SYS_CODE + ".sendRefundState.auditStatus", (Object)data);
            return JbsUtils.getPosErrorMap("\u53c2\u6570\u9519\u8bef", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        }
        OcRefundReDomain ocRefund = this.getOcRefund(invokeMap.getString("refundCode"));
        if (null == ocRefund) {
            this.logger.error(this.SYS_CODE + ".sendRefundState.ocRefund", (Object)data);
            return JbsUtils.getPosErrorMap("\u9000\u5355\u53f7\u6570\u636e\u4e0d\u5b58\u5728", "", JsonUtil.buildNormalBinder().toJson((Object)invokeMap.getString("refundCode")));
        }
        invokeMap.put("map", (Object)JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
        try {
            this.logger.info(this.SYS_CODE + ".sendRefundState.send", (Object)JsonUtil.buildNormalBinder().toJson((Object)invokeMap));
            if ("0".equals(invokeMap.getString("auditStatus"))) {
                this.internalInvoke("oc.refundEngine.sendRefundBack", (Map)invokeMap);
            }
            if ("1".equals(invokeMap.getString("auditStatus"))) {
                this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", (Map)invokeMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendRefundState.e", (Object)data, (Throwable)e);
            return JbsUtils.getPosErrorMap("updata data is fail", "", data);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendRefundReceipt(String data) throws Exception {
        if (StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE + ".sendRefundReceipt.data", (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info(this.SYS_CODE + ".sendRefundReceipt.data", (Object)data);
        OcRefundReDomain ocRefundDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, OcRefundReDomain.class);
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE + ".sendRefundReceipt.ocRefundDomain", (Object)"");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cocRefundDomain \u4e3a null", "");
        }
        this.logger.info(this.SYS_CODE + ".sendRefundReceipt.data", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        String msg = this.checkOcRefundReDomain(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error(this.SYS_CODE + ".sendRefundReceipt.msg", (Object)msg);
            return JbsUtils.getErrorMap(msg, JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain.getRefundCode()));
        }
        OcRefundReDomain queryOcRefundReDomain = this.getOcRefund(ocRefundDomain.getRefundCode());
        if (EmptyUtil.isEmpty((Object)queryOcRefundReDomain)) {
            this.logger.error(this.SYS_CODE + ".sendRefundReceipt.queryOcRefundReDomain", (Object)ocRefundDomain.getRefundCode());
            return JbsUtils.getErrorMap("\u9000\u5355\u6570\u636e\u6216\u9000\u5355\u5546\u54c1\u4e0d\u5b58\u5728", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain.getRefundCode()));
        }
        HashMap<String, OcRefundGoodsDomain> ocRefundGoodsMap = new HashMap<String, OcRefundGoodsDomain>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : queryOcRefundReDomain.getOcRefundGoodsDomainList()) {
            ocRefundGoodsMap.put(ocRefundGoodsDomain.getRefundCode() + "-" + ocRefundGoodsDomain.getRefundGoodsCode(), ocRefundGoodsDomain);
        }
        try {
            ArrayList<OcRefundGoodsDomain> ocRefundGoodsList = new ArrayList<OcRefundGoodsDomain>();
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                    String key = ocRefundGoodsDomain.getRefundCode() + "-" + ocRefundGoodsDomain.getRefundGoodsCode();
                    OcRefundGoodsDomain dbRefundGoods = (OcRefundGoodsDomain)ocRefundGoodsMap.get(key);
                    if (EmptyUtil.isEmpty((Object)dbRefundGoods)) {
                        throw new ApiException(ocRefundGoodsDomain.getRefundGoodsCode() + "\uff1a\u672a\u627e\u5230\u9000\u8d27\u5355\u5546\u54c1\u6570\u636e");
                    }
                    this.makeOcRefundGoods(ocRefundGoodsList, dbRefundGoods, ocRefundGoodsDomain);
                }
                if (ListUtil.isEmpty(ocRefundGoodsList)) {
                    this.logger.error(this.SYS_CODE + ".sendRefundReceipt.ocRefundGoodsList", (Object)data);
                    return JbsUtils.getErrorMap("\u7ec4\u88c5\u9000\u8d27\u5355\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", data);
                }
                ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsList);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            hashMap.put("map", null);
            this.logger.info(this.SYS_CODE + ".sendRefundReceipt.send", (Object)JsonUtil.buildNormalBinder().toJson(hashMap));
            this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundGoodsAndNext", hashMap);
            return JbsUtils.getSuccessMap("");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendRefundReceipt", (Object)"\u63a5\u6536POS\u9000\u8d27\u5165\u5e93\u5931\u8d25", (Throwable)e);
            return JbsUtils.getErrorMap("\u63a5\u6536POS\u9000\u8d27\u5165\u5e93\u5931\u8d25", e.getMessage());
        }
    }

    @Override
    public String sendCancelPayOrder(OcRefundReDomain ocRefundDomain) throws IOException {
        if (EmptyUtil.isEmpty((Object)ocRefundDomain)) {
            this.logger.error(this.SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.error(this.SYS_CODE + "sendCancelPayOrder \u6570\u636e>>>>>>> " + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            return JbsUtils.getErrorMap("contractBillcode is null", JsonUtil.getNotDefJsonUtil().toJson((Object)ocRefundDomain));
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/order/cancelPayOrder");
            JbsPosOrderResponse execute = null;
            JbsPosCancelPayOrderRequest jbsPosCancelPayOrderRequest = new JbsPosCancelPayOrderRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosCancelPayOrderRequest, (Object)ocRefundDomain);
            execute = httpFormfacade.execute(jbsPosCancelPayOrderRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error(this.SYS_CODE + ".sendCancelPayOrder \u6570\u636e\u5904\u7406\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendCancelPayOrder.Exception", (Object)e.toString(), (Throwable)e);
            return JbsUtils.getErrorMap(" sendCancelPayOrder Exception", null);
        }
    }

    private void makeOcRefundGoods(List<OcRefundGoodsDomain> ocRefundGoodsList, OcRefundGoodsDomain ocRefundGoodsDomain) throws Exception {
        OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
        BeanUtils.copyAllPropertysNotNull((Object)refundGoodsDomain, (Object)ocRefundGoodsDomain);
        refundGoodsDomain.setRefundGoodsCode(null);
        refundGoodsDomain.setRefundGoodsId(null);
        refundGoodsDomain.setRefundGoodsOldcode(ocRefundGoodsDomain.getRefundGoodsCode());
        ocRefundGoodsList.add(refundGoodsDomain);
    }

    private void assDataSendgoodsGoods(List<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains, Map<String, SgSendgoodsGoodsDomain> goodsReDomainMap, SgOccontractGoodsDomain ocContractGoodsDomain) throws Exception {
        SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
        SgSendgoodsGoodsDomain sgSendgoodsGoods = null;
        if (goodsReDomainMap.containsKey(ocContractGoodsDomain.getContractGoodsCode())) {
            sgSendgoodsGoods = goodsReDomainMap.get(ocContractGoodsDomain.getContractGoodsCode());
            BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsGoodsDomain, (Object)sgSendgoodsGoods);
        }
        sgSendgoodsGoodsDomain.setSendgoodsGoodsId(null);
        sgSendgoodsGoodsDomain.setContractBillcode(sgSendgoodsGoods.getContractBillcode());
        sgSendgoodsGoodsDomain.setSendgoodsCode(sgSendgoodsGoods.getSendgoodsCode());
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCamount(ocContractGoodsDomain.getContractGoodsSendnum());
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCweight(ocContractGoodsDomain.getContractGoodsSendweight());
        sgSendgoodsGoodsDomain.setGoodsTopnum(ocContractGoodsDomain.getContractGoodsSendnum());
        sgSendgoodsGoodsDomain.setGoodsTopweight(ocContractGoodsDomain.getContractGoodsSendweight());
        sgSendgoodsGoodsDomain.setContractGoodsCode(ocContractGoodsDomain.getContractGoodsCode());
        sgSendgoodsGoodsDomain.setPackageCode(ocContractGoodsDomain.getPackageCode());
        sgSendgoodsGoodsDomain.setMemberContact(ocContractGoodsDomain.getMemberContact());
        sgSendgoodsGoodsDomain.setMemberContactPhone(ocContractGoodsDomain.getMemberContactPhone());
        sgSendgoodsGoodsDomain.setMemberContactQq(ocContractGoodsDomain.getMemberContactQq());
        sgSendgoodsGoodsDomain.setWarehouseCode(ocContractGoodsDomain.getWarehouseCode());
        sgSendgoodsGoodsDomain.setWarehouseName(ocContractGoodsDomain.getWarehouseName());
        String goodsCode = sgSendgoodsGoodsDomain.getSendgoodsGoodsCode();
        sgSendgoodsGoodsDomain.setSendgoodsGoodsOldcode(goodsCode);
        sgSendgoodsGoodsDomain.setSendgoodsGoodsCode(null);
        sgSendgoodsGoodsDomain.setGoodsSpec4(ocContractGoodsDomain.getGoodsSpec4());
        sgSendgoodsGoodsDomain.setGoodsSpec5(ocContractGoodsDomain.getGoodsSpec5());
        sgSendgoodsGoodsDomain.setTenantCode("2019071800001392");
        sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
    }

    private void makeOcRefund(OcRefundDomain ocRefundDomain, OcContractDomain ocContractDomain) throws Exception {
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractDomain);
        ocRefundDomain.setRefundType("POSJD");
        ocRefundDomain.setRefundMoney(ocContractDomain.getContractMoney());
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (!ListUtil.isNotEmpty(contractGoodsList)) continue;
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                ocRefundGoodsDomain.setRefundGoodsPrice(ocContractGoodsDomain.getContractGoodsPrice());
                ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsNum());
                ocRefundGoodsDomain.setRefundGoodsWeight(ocContractGoodsDomain.getGoodsWeight());
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
    }

    private String getSgSendGoods(String sendgoodsCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramMap.put("sendgoodsCode", sendgoodsCode);
        paramMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.internalInvoke("sg.sendgoods.getSgSendGoods", sendMap);
    }

    private OcRefundReDomain getOcRefund(String refundCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("oc.refund.queryRefundReDomainPage", sendMap, OcRefundReDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            throw new ApiException("\u67e5\u627e\u9000\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)queryResutl.getList().get(0);
        QueryResult queryRefundGoodsResutl = this.getQueryResutl("oc.refund.queryRefundGoodsPage", sendMap, OcRefundGoodsDomain.class);
        if (null == queryRefundGoodsResutl || ListUtil.isEmpty((Collection)queryRefundGoodsResutl.getList())) {
            throw new ApiException("\u67e5\u627e\u9000\u5355\u5546\u54c1\u6570\u636e\u4e3a\u7a7a");
        }
        ocRefundReDomain.setOcRefundGoodsDomainList(queryRefundGoodsResutl.getList());
        this.logger.info(this.SYS_CODE + ".getOcRefund", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain));
        return ocRefundReDomain;
    }

    private String getOcContract(String contractBillcode, boolean flag) {
        String url = flag ? "oc.contract.getContractOneByCode" : "oc.contract.getContractByCode";
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String ocContract = this.internalInvoke(url, invokeMap);
        return ocContract;
    }

    private String checkUserAndStoreCode(String userinfo, String type, Object obj) {
        if (StringUtils.isEmpty((String)userinfo)) {
            this.logger.error(this.SYS_CODE + ".checkUserAndStoreCode", (Object)"userinfo is null");
            return null;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        paramsMap.put("userinfoQuality", "store");
        if ("code".equals(type)) {
            paramsMap.put("userinfoCode", userinfo);
        } else if ("oCode".equals(type)) {
            paramsMap.put("userinfoOcode", userinfo);
        }
        paramsMap.put("fuzzy", "true");
        paramsMap.put("tenantCode", "2019071800001392");
        sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramsMap));
        QueryResult umUserinfoResutl = this.getQueryResutl("um.userbase.queryUserinfoPage", sendMap, UmUserinfoReDomainBean.class);
        if (!EmptyUtil.isEmpty((Object)umUserinfoResutl) && ListUtil.isEmpty((Collection)umUserinfoResutl.getList())) {
            return null;
        }
        List umUserinfoDomainList = umUserinfoResutl.getList();
        if (ListUtil.isNotEmpty((Collection)umUserinfoDomainList)) {
            UmUserinfoReDomainBean umUserinfo = (UmUserinfoReDomainBean)umUserinfoDomainList.get(0);
            if ("code".equals(type)) {
                return umUserinfo.getUserinfoOcode();
            }
            if (!EmptyUtil.isEmpty((Object)obj) && obj instanceof OcContractDomain) {
                this.checkStoreChannelInfo(umUserinfo, (OcContractDomain)obj);
            }
            return umUserinfo.getUserinfoCode();
        }
        return null;
    }

    private List<Object> checkOrderGoodsByMap(List<Map<String, Object>> goodsList, OcContractDomain ocContractDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        HashMap querySkuResultMap = new HashMap();
        ArrayList<Object> noGoodsEoCodeList = new ArrayList<Object>();
        ArrayList<String> goodsEoCodeList = new ArrayList<String>();
        for (Map<String, Object> map : goodsList) {
            if (!StringUtils.isNotBlank((String)String.valueOf(map.get("skuNo")))) continue;
            paramsMap.put("skuNo", map.get("skuNo"));
            paramsMap.put("goodsClass", "pos");
            paramsMap.put("tenantCode", "2019071800001392");
            invokeMap.put("map", JsonUtil.buildNormalBinder().toJson(paramsMap));
            QueryResult queryResut = this.sendReSupObject("rs.sku.querySkuOnePage", invokeMap, RsSku.class);
            if (ListUtil.isNotEmpty((Collection)queryResut.getList())) {
                goodsEoCodeList.add(((RsSku)queryResut.getList().get(0)).getGoodsEocode());
                querySkuResultMap.put(map.get("skuNo") + "", queryResut.getList().get(0));
                continue;
            }
            noGoodsEoCodeList.add(map.get("skuNo"));
        }
        if (!EmptyUtil.isEmpty((Object)ocContractDomain) && ListUtil.isNotEmpty(ocContractDomain.getPackageList())) {
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                if (!ListUtil.isNotEmpty(ocPackageDomain.getContractGoodsList())) continue;
                ocPackageDomain.getContractGoodsList().forEach(obj -> {
                    if (StringUtils.isNotBlank((String)obj.getSkuNo()) && !EmptyUtil.isEmpty(querySkuResultMap.get(obj.getSkuNo()))) {
                        RsSku rsSku = (RsSku)querySkuResultMap.get(obj.getSkuNo());
                        try {
                            BeanUtils.copyAllPropertys((Object)obj, (Object)rsSku);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        obj.setGoodsNum(obj.getGoodsCamount());
                        obj.setGoodsWeight(obj.getGoodsCweight());
                        obj.setGoodsTopnum(obj.getGoodsCamount());
                        obj.setGoodsTopweight(obj.getGoodsCweight());
                    }
                });
            }
        }
        return noGoodsEoCodeList;
    }

    private GoodsBean querySkuInfo(String skuNo, String goodsClass, String tenantCode, String memberCode) {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)goodsClass) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("querySkuInfo.param is null");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> paramSendMap = new HashMap<String, String>();
        paramMap.put("goodsClass", goodsClass);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        paramSendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("rs.sku.querySkuPage", paramSendMap, RsSkuDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".querySkuInfo", (Object)(JsonUtil.buildNormalBinder().toJson(paramSendMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)queryResutl)));
            throw new ApiException(skuNo + ":\u8be5\u8d27\u54c1Sku\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RsSkuDomain rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
        paramMap.clear();
        paramMap.put("goodsCode", rsSkuDomain.getGoodsCode());
        paramMap.put("tenantCode", tenantCode);
        RsResourceGoods rsResourceGoods = (RsResourceGoods)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, "object", new Object[]{RsResourceGoods.class});
        if (null == rsResourceGoods) {
            this.logger.error(this.SYS_CODE + ".querySkuInfo.rsResourceGoods", (Object)(JsonUtil.buildNormalBinder().toJson(paramMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods)));
            throw new ApiException(skuNo + ":\u8be5\u8d27\u54c1Goods\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setRsSkuDomain(rsSkuDomain);
        goodsBean.setRsResourceGoods(rsResourceGoods);
        return goodsBean;
    }

    private String checkOcRefundDomain(OcRefundDomain ocRefundDomain) {
        List<OcRefundGoodsDomain> list;
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            msg = msg + "RefundCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getContractType())) {
            msg = msg + "ContractType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundPumode())) {
            msg = msg + "RefundPumode\u4e3a\u7a7a;";
        }
        if (ListUtil.isEmpty(list = ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "OcRefundGoodsDomainList\u4e3a\u7a7a;";
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : list) {
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsCode())) {
                msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
            }
            if (ocRefundGoodsDomain.getRefundGoodsNum() == null) {
                msg = msg + "RefundGoodsNum\u4e3a\u7a7a;";
            }
            if (ocRefundGoodsDomain.getRefundGoodsWeight() == null) {
                msg = msg + "RefundGoodsWeight\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getMemberContact())) {
                msg = msg + "MemberContact\u4e3a\u7a7a;";
            }
            if (!StringUtils.isBlank((String)ocRefundGoodsDomain.getMemberContactQq())) continue;
            msg = msg + "MemberContactQq\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkSgOccontract(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        if (StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgOccontractDomain.getDataStatestr())) {
            msg = msg + "DataStatestr\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkSgOccontractDomain(SgOccontractDomain sgOccontractDomain) {
        String msg = "";
        List<SgOccontractGoodsDomain> contractGoodsList = sgOccontractDomain.getSgOccontractGoodsDomainList();
        for (SgOccontractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsCode())) {
                msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendnum())) {
                msg = msg + "ContractGoodsSendnum\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsSendweight())) {
                msg = msg + "ContractGoodsSendweight\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
                msg = msg + "ContractBillcode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsName())) {
                msg = msg + "GoodsName\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsSpec4())) {
                msg = msg + "GoodsSpec4\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsSpec5())) {
                msg = msg + "GoodsSpec5\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContact())) {
                msg = msg + "GoodsSpec5\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContactPhone())) {
                msg = msg + "MemberContactPhone\u4e3a\u7a7a;";
            }
            if (!StringUtils.isBlank((String)ocContractGoodsDomain.getMemberContactQq())) continue;
            msg = msg + "MemberContactQq\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgOccontractDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgOccontractDomain.getDataStatestr())) {
            msg = msg + "DataStatestr\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgOccontractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkContractAssignment(SgSendgoodsDomain sgSendgoodsDomain) {
        List<SgSendgoodsGoodsDomain> goodsList;
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractType())) {
            msg = msg + "ContractType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptPhone()) && "0".equals(sgSendgoodsDomain.getContractPumode())) {
            msg = msg + "GoodsReceiptPhone\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptArrdess())) {
            msg = msg + "GoodsReceiptArrdess\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getGoodsReceiptMem()) && "0".equals(sgSendgoodsDomain.getContractPumode())) {
            msg = msg + "GoodsReceiptMem\u4e3a\u7a7a;";
        }
        if ((goodsList = sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()).size() == 0 || ListUtil.isEmpty(goodsList)) {
            msg = msg + "SgSendgoodsGoodsReDomainList\u4e3a\u7a7a;";
        }
        for (SgSendgoodsGoodsDomain goods : goodsList) {
            if (goods.getGoodsNum() == null) {
                msg = msg + "GoodsNum\u4e3a\u7a7a;";
            }
            if (goods.getGoodsWeight() == null) {
                msg = msg + "GoodsWeight\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)goods.getSendgoodsGoodsCode())) {
                msg = msg + "SendgoodsGoodsCode\u4e3a\u7a7a;";
            }
            if (!StringUtils.isBlank((String)goods.getGoodsCode())) continue;
            msg = msg + "GoodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void createWhOpStore(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            return;
        }
        JSONObject jsonObject = JSONObject.json2object((String)dataStr);
        ArrayList<WhOpstoreDomain> whOpstoreDomainList = new ArrayList<WhOpstoreDomain>();
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        WhOpstoreDomain whOpstoreDomain = this.assWhOpstoreDomain(jsonObject);
        if (null == whOpstoreDomain) {
            throw new ApiException("\u7ec4\u88c5\u5355\u636e\u5931\u8d25");
        }
        whOpstoreDomainList.add(whOpstoreDomain);
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        if (StringUtils.isBlank((String)jsonObject.getString("packageList")) && StringUtils.isBlank((String)jsonObject.getString("sgOccontractGoodsDomainList"))) {
            throw new ApiException("X1\u7c7b\u578b\u4e0bpackageList\u3001sgOccontractGoodsDomainList\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)jsonObject.getString("sgOccontractGoodsDomainList"))) {
            JSONArray packageList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"packageList")));
            packageList.stream().forEach(p -> {
                JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(p.get((Object)"contractGoodsList")));
                this.assMap(contractGoodsList, map);
            });
        } else {
            JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"sgOccontractGoodsDomainList")));
            this.assMap(contractGoodsList, map);
        }
        map.keySet().stream().forEach(key -> {
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain(jsonObject, (JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain));
            whOpstoreGoodsDomain.setOpstoreDir("0");
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType("1");
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.assWhOpstoreDomain(whOpstoreDomain);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
    }

    private void assMap(JSONArray contractGoodsList, Map<String, JSONArray> map) {
        contractGoodsList.stream().forEach(c -> {
            String skuNo = "";
            if (c.containsKey((Object)"skuNo")) {
                skuNo = c.getString("skuNo");
            } else if (c.containsKey((Object)"skuEocode")) {
                skuNo = c.getString("skuEocode");
            } else {
                throw new ApiException("skuEocode,skuNo is null");
            }
            if (StringUtils.isBlank((String)skuNo)) {
                throw new ApiException("skuNo is null");
            }
            if (map.containsKey(skuNo)) {
                ((JSONArray)map.get(skuNo)).add(c);
            } else {
                JSONArray array = new JSONArray();
                array.add(c);
                map.put(skuNo, array);
            }
        });
    }

    public void assWhOpstoreDomain(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap<String, String> whMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        whMap.put("warehouseCode", whOpstoreDomain.getWarehouseCode());
        whMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(whMap));
        QueryResult qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
        if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
            throw new ApiException("checkGoodsClass.warehouseCode", whMap.toString());
        }
        WhWarehouseReDomain whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        String goodsClass = "plat";
        String memberCode = whWarehouseReDomain.getMemberCode();
        whOpstoreDomain.setMemberCode(memberCode);
        whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        if ("0".equals(whWarehouseReDomain.getWarehouseCtype()) || "1".equals(whWarehouseReDomain.getWarehouseCtype())) {
            goodsClass = "store";
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                throw new ApiException("assWhOpstoreDomain.goodsNo.null");
            }
            whOpstoreGoodsDomain.setGoodsEocode(whOpstoreGoodsDomain.getGoodsNo());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            HashMap<String, String> paramSendMap = new HashMap<String, String>();
            paramMap.put("goodsClass", goodsClass);
            paramMap.put("skuNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCode", memberCode);
            paramMap.put("tenantCode", "2019071800001392");
            paramSendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResutl = this.getQueryResutl("rs.sku.querySkuPage", paramSendMap, RsSkuDomain.class);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList()) || queryResutl.getList().size() > 1) {
                throw new ApiException("checkGoodsClass.queryResutl", paramMap.toString());
            }
            RsSkuDomain rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
            paramMap.clear();
            paramMap.put("goodsCode", rsSkuDomain.getGoodsCode());
            paramMap.put("tenantCode", "2019071800001392");
            RsResourceGoods rsResourceGoods = (RsResourceGoods)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, "object", new Object[]{RsResourceGoods.class});
            if (null == rsResourceGoods) {
                this.logger.error(this.SYS_CODE + ".assWhOpstoreDomain.getResourceGoodsByCodeStr", (Object)(JsonUtil.buildNormalBinder().toJson(paramMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods)));
                throw new ApiException("checkGoodsClass.rsResourceGoods", paramMap.toString());
            }
            whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
            whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
            whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
            whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
            whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
            whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
            whOpstoreGoodsDomain.setGoodsProperty(rsResourceGoods.getGoodsProperty3());
            whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
            whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
            whOpstoreGoodsDomain.setMemberCode(rsResourceGoods.getMemberCode());
            whOpstoreGoodsDomain.setMemberName(rsResourceGoods.getMemberName());
            whOpstoreGoodsDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
            whOpstoreGoodsDomain.setMemberCname(rsResourceGoods.getMemberCname());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
                whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
                whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
                whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
                whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
                whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
                whOpstoreSkuDomain.setSkuEocode(rsSkuDomain.getSkuEocode());
                whOpstoreSkuDomain.setSkuNo(rsSkuDomain.getSkuNo());
                whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
                whOpstoreSkuDomain.setSkuName(rsSkuDomain.getSkuName());
                whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreSkuDomain.setMemberCode(rsResourceGoods.getMemberCode());
                whOpstoreSkuDomain.setMemberName(rsResourceGoods.getMemberName());
                whOpstoreSkuDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
                whOpstoreSkuDomain.setMemberCname(rsResourceGoods.getMemberCname());
                whOpstoreSkuDomain.setStoreType("0");
                whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                this.checkNegative(whOpstoreSkuDomain.getGoodsNum());
                this.checkNegative(whOpstoreSkuDomain.getGoodsWeight());
            }
        }
    }

    private void checkNegative(BigDecimal data) throws Exception {
        if (!EmptyUtil.isEmpty((Object)data) && BigDecimal.ZERO.compareTo(data) > 0) {
            throw new ApiException("\u5546\u54c1\u6570\u91cf\u6216\u91cd\u91cf\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
    }

    private WhOpstoreDomain assWhOpstoreDomain(JSONObject jsonObject) {
        if (null == jsonObject) {
            return null;
        }
        String warehouseCode = this.getJsonWhCode(jsonObject);
        if (StringUtils.isBlank((String)warehouseCode)) {
            return null;
        }
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        whOpstoreDomain.setWarehouseCode(warehouseCode);
        whOpstoreDomain.setStoreGoodsBtype("X1");
        whOpstoreDomain.setStoreGoodsType("1");
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setTenantCode("2019071800001392");
        whOpstoreDomain.setOpstoreOcode(jsonObject.getString("contractBillcode"));
        return whOpstoreDomain;
    }

    private String getJsonWhCode(JSONObject jsonObject) {
        if (null == jsonObject) {
            throw new ApiException("getJsonWhCode is null");
        }
        this.logger.error(this.SYS_CODE + ".getJsonWhCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonObject));
        String jsonMemberCode = jsonObject.getString("memberCode");
        if (StringUtils.isNotBlank((String)jsonMemberCode) && !"null".equals(jsonMemberCode)) {
            return jsonMemberCode;
        }
        String jsonSgOccontractGoodsDomainList = jsonObject.getString("sgOccontractGoodsDomainList");
        if (StringUtils.isBlank((String)jsonSgOccontractGoodsDomainList) || "null".equals(jsonSgOccontractGoodsDomainList)) {
            throw new ApiException("\u4f20\u5165\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONArray sgOccontractGoodsDomainList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"sgOccontractGoodsDomainList")));
        this.logger.error(this.SYS_CODE + ".getJsonWhCode2", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgOccontractGoodsDomainList));
        if (null != sgOccontractGoodsDomainList) {
            for (JSONObject object : sgOccontractGoodsDomainList) {
                if (EmptyUtil.isEmpty((Object)object.get((Object)"warehouseCode")) || "null".equals(object.get((Object)"warehouseCode"))) continue;
                return object.getString("warehouseCode");
            }
        } else {
            throw new ApiException("\u4f20\u5165\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    private void assWhOpstoreGoodsDomain(JSONObject jsonObject, List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == jsonObject) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsonObject.containsKey((Object)"skuNo")) {
            whOpstoreGoodsDomain.setGoodsNo(jsonObject.getString("skuNo"));
        } else {
            whOpstoreGoodsDomain.setGoodsNo(jsonObject.getString("skuEocode"));
        }
        whOpstoreGoodsDomain.setTenantCode("2019071800001392");
        whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
    }

    private void assWhOpstoreSkuDomain(JSONObject jsonObj, JSONObject jsonObject, List<WhOpstoreSkuDomain> whOpstoreSkuDomainList, WhOpstoreDomain whOpstoreDomain, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == jsonObject || null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            return;
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsWeight()) {
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsAmt()) {
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsonObject.containsKey((Object)"goodsNum")) {
            whOpstoreSkuDomain.setGoodsNum(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsNum")));
            whOpstoreSkuDomain.setGoodsWeight(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsWeight")));
        } else if (jsonObject.containsKey((Object)"contractGoodsSendnum")) {
            whOpstoreSkuDomain.setGoodsNum(ParamsUtils.getBigDecimal(jsonObject.get((Object)"contractGoodsSendnum")));
            whOpstoreSkuDomain.setGoodsWeight(ParamsUtils.getBigDecimal(jsonObject.get((Object)"contractGoodsSendweight")));
        } else {
            throw new ApiException("\u6570\u91cf\u5f02\u5e38");
        }
        whOpstoreSkuDomain.setOpstoreDir("0");
        whOpstoreSkuDomain.setStoreType("0");
        whOpstoreSkuDomain.setStoreGoodsType("1");
        whOpstoreSkuDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsNo());
        whOpstoreDomain.setMemberCcode(whOpstoreSkuDomain.getMemberCcode());
        whOpstoreDomain.setMemberCname(whOpstoreSkuDomain.getMemberCname());
        whOpstoreDomain.setChannelCode(whOpstoreSkuDomain.getChannelCode());
        whOpstoreDomain.setChannelName(whOpstoreSkuDomain.getChannelName());
        whOpstoreDomain.setMemberMcode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberMname(whOpstoreSkuDomain.getMemberName());
        whOpstoreDomain.setMemberCode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberName(whOpstoreSkuDomain.getMemberName());
        String storeLocal = this.handleStoreWhlocal(jsonObject, jsonObj);
        whOpstoreSkuDomain.setStoreWhlocal(storeLocal);
        whOpstoreSkuDomain.setSkuBarcode((String)jsonObject.get((Object)"memberContactQq"));
        whOpstoreSkuDomain.setTenantCode("2019071800001392");
        if (null == whOpstoreSkuDomain.getGoodsNum()) {
            whOpstoreSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreSkuDomain.getGoodsWeight()) {
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        whOpstoreDomain.setGoodsNum(whOpstoreDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreDomain.setGoodsWeight(whOpstoreDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreGoodsDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
    }

    private String handleStoreWhlocal(JSONObject jsonObjectsku, JSONObject jsonObject) {
        String whLocal = "";
        if (null != jsonObjectsku && StringUtils.isNotBlank((String)jsonObjectsku.getString("memberContact"))) {
            return jsonObjectsku.getString("memberContact");
        }
        if (null != jsonObject) {
            String sgOccontractGoodsDomainListStr = jsonObject.getString("sgOccontractGoodsDomainList");
            if (StringUtils.isNotBlank((String)sgOccontractGoodsDomainListStr)) {
                JSONArray sgOccontractGoodsDomainList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"sgOccontractGoodsDomainList")));
                if (null != sgOccontractGoodsDomainList) {
                    for (JSONObject object : sgOccontractGoodsDomainList) {
                        if (EmptyUtil.isEmpty((Object)object.get((Object)"memberContact")) || "null".equals(object.get((Object)"memberContact"))) continue;
                        whLocal = object.get((Object)"memberContact") + "";
                        break;
                    }
                }
            } else if (StringUtils.isNotBlank((String)jsonObject.getString("ocContractSettlList"))) {
                JSONArray ocContractSettlList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"ocContractSettlList")));
                if (null != ocContractSettlList) {
                    for (JSONObject object : ocContractSettlList) {
                        if (EmptyUtil.isEmpty((Object)object.get((Object)"goodsContract")) || "null".equals(object.get((Object)"goodsContract"))) continue;
                        whLocal = object.get((Object)"goodsContract") + "";
                        break;
                    }
                }
            } else {
                this.logger.error(this.SYS_CODE + ".handleStoreWhlocal.jsonObject", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonObject));
                throw new ApiException("\u5e93\u4f4d\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a");
            }
        }
        return whLocal;
    }

    private String checkOcRefundReDomain(OcRefundReDomain ocRefundDomain) {
        List<OcRefundGoodsDomain> list;
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundCode())) {
            msg = msg + "RefundCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            msg = msg + "contractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundPumode())) {
            msg = msg + "refundPumode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (ListUtil.isEmpty(list = ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "OcRefundGoodsDomainList\u4e3a\u7a7a;";
            return msg;
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : list) {
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getRefundCode())) {
                msg = msg + "ocRefundGoodsDomainList.refundCode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getRefundGoodsCode())) {
                msg = msg + "ocRefundGoodsDomainList.refundGoodsCode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractBillcode())) {
                msg = msg + "ocRefundGoodsDomainList.contractBillcode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsCode())) {
                msg = msg + "ocRefundGoodsDomainList.contractGoodsCode\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocRefundGoodsDomain.getRefundGoodsNum())) {
                msg = msg + "ocRefundGoodsDomainList.refundGoodsNum\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocRefundGoodsDomain.getRefundGoodsWeight())) {
                msg = msg + "ocRefundGoodsDomainList.refundGoodsWeight\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocRefundGoodsDomain.getSkuNo())) {
                msg = msg + "ocRefundGoodsDomainList.skuNo\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocRefundGoodsDomain.getWarehouseCode())) {
                msg = msg + "ocRefundGoodsDomainList.warehouseCode\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocRefundGoodsDomain.getMemberContact())) {
                msg = msg + "ocRefundGoodsDomainList.memberContact\u4e3a\u7a7a;";
            }
            if (EmptyUtil.isEmpty((Object)ocRefundGoodsDomain.getMemberContactQq())) {
                msg = msg + "ocRefundGoodsDomainList.memberContactQq\u4e3a\u7a7a;";
            }
            ocRefundGoodsDomain.setStoreWhlocal(ocRefundGoodsDomain.getMemberContact());
        }
        return msg;
    }

    private void makeOcRefundGoods(List<OcRefundGoodsDomain> ocRefundGoodsList, OcRefundGoodsDomain dbRefundGoods, OcRefundGoodsDomain ocRefundGoodsDomain) throws Exception {
        OcRefundGoodsDomain newOcRefundGoodsDomain = new OcRefundGoodsDomain();
        BeanUtils.copyAllPropertys((Object)newOcRefundGoodsDomain, (Object)dbRefundGoods);
        newOcRefundGoodsDomain.setRefundGoodsCode(null);
        newOcRefundGoodsDomain.setRefundGoodsId(null);
        newOcRefundGoodsDomain.setRefundGoodsOldcode(ocRefundGoodsDomain.getRefundGoodsCode());
        newOcRefundGoodsDomain.setGoodsNum(ocRefundGoodsDomain.getRefundGoodsNum());
        newOcRefundGoodsDomain.setGoodsWeight(ocRefundGoodsDomain.getRefundGoodsWeight());
        newOcRefundGoodsDomain.setRefundGoodsAmt(ocRefundGoodsDomain.getRefundGoodsAmt());
        newOcRefundGoodsDomain.setRefundGoodsNum(ocRefundGoodsDomain.getRefundGoodsNum());
        newOcRefundGoodsDomain.setRefundGoodsWeight(ocRefundGoodsDomain.getRefundGoodsWeight());
        newOcRefundGoodsDomain.setMemberContact(ocRefundGoodsDomain.getMemberContact());
        newOcRefundGoodsDomain.setMemberContactPhone(ocRefundGoodsDomain.getMemberContactPhone());
        newOcRefundGoodsDomain.setMemberContactQq(ocRefundGoodsDomain.getMemberContactQq());
        newOcRefundGoodsDomain.setSkuBarcode(ocRefundGoodsDomain.getSkuBarcode());
        newOcRefundGoodsDomain.setWarehouseCode(ocRefundGoodsDomain.getWarehouseCode());
        newOcRefundGoodsDomain.setWarehouseName(ocRefundGoodsDomain.getWarehouseName());
        ocRefundGoodsList.add(newOcRefundGoodsDomain);
    }
}

