/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.domain.RsResourceGoods;
import com.yqbsoft.laser.service.pos.domain.RsSkuDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.pos.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.pos.domain.WhWarehouseReDomain;
import com.yqbsoft.laser.service.pos.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosExWhNoticeRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosInWhNoticeRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosQueryStoreWhRequest;
import com.yqbsoft.laser.service.pos.facade.request.JbsPosSyncOrderStateRequest;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosInWhNoticeResponse;
import com.yqbsoft.laser.service.pos.facade.response.JbsPosQueryStoreWhResponse;
import com.yqbsoft.laser.service.pos.model.WhOpstore;
import com.yqbsoft.laser.service.pos.model.WhOpstoreGoods;
import com.yqbsoft.laser.service.pos.model.WhOpstoreSku;
import com.yqbsoft.laser.service.pos.model.WhStoreSku;
import com.yqbsoft.laser.service.pos.service.JbsPosWarehouseService;
import com.yqbsoft.laser.service.pos.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.ObjectUtils;

public class JbsPosWarehouseServiceImpl
extends BaseServiceImpl
implements JbsPosWarehouseService {
    public static final String SYS_CODE = "jbsPos.JbsPosWarehouseServiceImpl";

    @Override
    public String receiveRequireGoodsBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.receiveRequireGoodsBill\u63a5\u6536\u6570\u636e", (Object)dataStr);
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.receiveRequireGoodsBill.toList", (Object)"\u8f6c\u6362\u540e\u6570\u636e\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("\u8f6c\u6362\u540e\u6570\u636e\u4e3a\u7a7a", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u603b\u6570\u91cf\u6216\u5546\u54c1\u603b\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"D32,D1".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u672a\u77e5\uff1a" + whOpstoreDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsType("2");
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("2019071800001392");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomains = this.copyGoods2SkuList(whOpstoreDomain.getWarehouseCode(), whOpstoreGoodsDomain);
                whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomains);
            }
            try {
                if (!checkDetail.booleanValue()) continue;
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj);
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.receiveRequireGoodsBill.saveData ", (Object)JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u8981\u8d27\u5355\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u8981\u8d27\u5355\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u8981\u8d27\u5355\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u8981\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String receiveReturnGoodsBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplreceiveReturnGoodsBill.param ", (Object)dataStr);
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveReturnGoodsBill.toList", (Object)"\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            String storeGoodsBtype = "D3";
            String storeGoodsType = "3";
            String storeType = "0";
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u603b\u6570\u91cf\u6216\u5546\u54c1\u603b\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
            whOpstoreDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreDomain.setStoreType(storeType);
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be6\u60c5\u5217\u8868\u4e2d\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setStoreGoodsBtype(storeGoodsBtype);
                whOpstoreGoodsDomain.setStoreGoodsType(storeGoodsType);
                whOpstoreGoodsDomain.setStoreType(storeType);
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomains = this.copyGoods2SkuList(whOpstoreDomain.getWarehouseCode(), whOpstoreGoodsDomain);
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomains) {
                    whOpstoreSkuDomain.setOpstoreDir("0");
                }
                whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomains);
            }
            try {
                if (!checkDetail.booleanValue()) continue;
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj);
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.POS\u63a5\u6536\u9000\u8d27\u5355\u63a5\u53e3.saveData ", (Object)JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u9000\u8d27\u5355\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u9000\u8d27\u5355\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u9000\u8d27\u5355\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u9000\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String inWhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplinWhNoticeBill.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            httpFormfacade.setOutsideApiUrl("/api/erp/saveDeliverGoodsOrder");
            JbsPosInWhNoticeResponse execute = null;
            JbsPosInWhNoticeRequest jbsPosInWhNoticeRequest = new JbsPosInWhNoticeRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosInWhNoticeRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsPosInWhNoticeRequest);
            if (!execute.getSuccess().booleanValue()) {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplsend inWhNoticeBill \u6570\u636e\u5904\u7406\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("POS\u5165\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("POS\u5165\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38", null);
        }
    }

    @Override
    public String receiveInWhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplreceiveInWhConfirmBill.param ", (Object)dataStr);
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error(SYS_CODE, (Object)"dataStr \u8f6c\u6362\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("dataStr \u8f6c\u6362\u4e3a\u7a7a", "", "");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreNcode())) {
                errorCodes.add("\u4e2d\u53f0\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"D8,D15,D17,D18".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u672a\u77e5\uff1a" + whOpstoreDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsType("1");
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setOpstoreDir("1");
                whOpstoreGoodsDomain.setStoreType(whOpstoreDomain.getStoreType());
                whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u6216\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumber()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u6216\u91cd\u91cf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getDiffNumberunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getDiffWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u6216\u91cd\u91cf\u5355\u4f4d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if ((BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffNumber()) != 0 || BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffWeight()) != 0) && EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffRemark())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u539f\u56e0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreWhlocal())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5e93\u4f4d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    this.setBatchData(whOpstoreDomain.getWarehouseCode(), whOpstoreSkuDomain);
                    whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                    whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                    whOpstoreSkuDomain.setStoreGoodsType(whOpstoreGoodsDomain.getStoreGoodsType());
                    whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
                    whOpstoreSkuDomain.setOpstoreDir("1");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            if (this.checkBatch(whOpstoreDomain).booleanValue()) {
                return JbsUtils.getPosErrorMap("\u6279\u6b21\u6570\u636e\u4e0d\u5339\u914d", "", "\u6279\u6b21\u7ea7\u6570\u636e\u9519\u8bef \u6570\u91cf/\u91cd\u91cf/\u6279\u6b21\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
                if (new BigDecimal("-1").compareTo(whOpstoreGoodsDomain.getGoodsNum()) != 0) continue;
                BigDecimal goodsNum = BigDecimal.ZERO;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                    goodsNum = goodsNum.add(whOpstoreSkuDomain.getGoodsNum());
                }
                whOpstoreGoodsDomain.setGoodsNum(goodsNum);
            }
            try {
                if (!checkDetail.booleanValue()) continue;
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                if ("D8,D15,D17".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                    this.checkSapOrderInfo(currentObj);
                    if ("D8".equals(whOpstoreDomain.getStoreGoodsBtype())) {
                        this.queryOldOpstoreSku(currentObj);
                    }
                }
                this.checkGoodsClass(currentObj);
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.POS\u63a5\u6536\u5165\u5e93\u786e\u8ba4\u63a5\u53e3.saveData ", (Object)JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String exWhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", null);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplexWhNoticeBill.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            httpFormfacade.setOutsideApiUrl("/api/erp/saveReDistributionDelivery");
            JbsPosInWhNoticeResponse execute = null;
            JbsPosExWhNoticeRequest jbsPosExWhNoticeRequest = new JbsPosExWhNoticeRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosExWhNoticeRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsPosExWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplPOS\u51fa\u5e93\u901a\u77e5\u6570\u636e\u5904\u7406\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
                return JbsUtils.getErrorMap("\u6570\u636e\u5904\u7406\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("POS\u51fa\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("POS\u51fa\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38", null);
        }
    }

    @Override
    public String receiveExWhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", "");
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplreceiveExWhConfirmBill.param", (Object)dataStr);
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.receiveExWhConfirmBill", (Object)"dataStr \u8f6c\u6362\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("dataStr \u8f6c\u6362\u4e3a\u7a7a", "", "");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreNcode())) {
                errorCodes.add("\u4e2d\u53f0\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"D7,D19".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u672a\u77e5\uff1a" + whOpstoreDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsType("1");
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            Integer itemLine = 10;
            Integer itemNo = 900001;
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight()).booleanValue() || this.checkNegative(whOpstoreGoodsDomain.getGoodsNum()).booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u91cd\u91cf\u503c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a\u8d1f\u6570");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setStoreType(whOpstoreDomain.getStoreType());
                whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setOpstoreDir("0");
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u6216\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumber()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u6216\u91cd\u91cf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getDiffNumberunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getDiffWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u6216\u91cd\u91cf\u5355\u4f4d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if ((BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffNumber()) != 0 || BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffWeight()) != 0) && EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffRemark())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u539f\u56e0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreWhlocal())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5e93\u4f4d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (this.checkNegative(whOpstoreSkuDomain.getGoodsWeight()).booleanValue() || this.checkNegative(whOpstoreSkuDomain.getGoodsNum()).booleanValue()) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u91cd\u91cf\u503c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a\u8d1f\u6570");
                        checkDetail = false;
                        break;
                    }
                    if (whOpstoreSkuDomainList.size() == 1) {
                        whOpstoreSkuDomain.setOpstoreSkuOldcode(String.valueOf(itemLine));
                    } else {
                        Integer n = itemNo;
                        Integer n2 = itemNo = Integer.valueOf(itemNo + 1);
                        whOpstoreSkuDomain.setOpstoreSkuOldcode(String.valueOf(n));
                    }
                    this.setBatchData(whOpstoreDomain.getWarehouseCode(), whOpstoreSkuDomain);
                    whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                    whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                    whOpstoreSkuDomain.setStoreGoodsType(whOpstoreGoodsDomain.getStoreGoodsType());
                    whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
                    whOpstoreSkuDomain.setOpstoreDir("0");
                    whOpstoreSkuDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                itemLine = itemLine + 10;
                if (checkDetail.booleanValue()) continue;
                break;
            }
            if (this.checkBatch(whOpstoreDomain).booleanValue()) {
                return JbsUtils.getPosErrorMap("\u6279\u6b21\u6570\u636e\u4e0d\u5339\u914d", "", "\u6279\u6b21\u7ea7\u6570\u636e\u9519\u8bef \u6570\u91cf/\u91cd\u91cf/\u6279\u6b21\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
                if (new BigDecimal("-1").compareTo(whOpstoreGoodsDomain.getGoodsNum()) != 0) continue;
                BigDecimal goodsNum = BigDecimal.ZERO;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                    goodsNum = goodsNum.add(whOpstoreSkuDomain.getGoodsNum());
                }
                whOpstoreGoodsDomain.setGoodsNum(goodsNum);
            }
            try {
                if (!checkDetail.booleanValue()) continue;
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                if ("D7".equals(whOpstoreDomain.getStoreGoodsBtype())) {
                    this.checkSapOrderInfo(whOpstoreDomain);
                }
                this.checkGoodsClass(currentObj);
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.POS\u63a5\u6536\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3.saveData ", (Object)JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String receiveDeliveryDiffBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.receiveDeliveryDiffBill", (Object)"param is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.receiveDeliveryDiffBill.param", (Object)dataStr);
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.receiveDeliveryDiffBill", (Object)"dataStr \u8f6c\u6362\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("dataStr \u8f6c\u6362\u4e3a\u7a7a", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreDomain.setStoreGoodsBtype("T1");
            whOpstoreDomain.setStoreGoodsType("2");
            whOpstoreDomain.setGoodsNum(whOpstoreDomain.getGoodsNum().abs());
            whOpstoreDomain.setGoodsWeight(whOpstoreDomain.getGoodsWeight().abs());
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u548c\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum().abs());
                whOpstoreGoodsDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight().abs());
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u6216\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    this.setBatchData(whOpstoreDomain.getWarehouseCode(), whOpstoreSkuDomain);
                    whOpstoreSkuDomain.setSkuEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setGoodsEocode(whOpstoreSkuDomain.getSkuNo());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setMemberCcode("20021000276227");
                    whOpstoreSkuDomain.setMemberCname("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            try {
                if (!checkDetail.booleanValue()) continue;
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj);
                this.handleDiffWarehouse(currentObj);
                this.queryOldOpstoreSku(currentObj);
                this.logger.info("jbsPos.JbsPosWarehouseServiceImplreceiveDeliveryDiffBill.saveObj", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                paramsMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", paramsMap);
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u5dee\u5f02\u6570\u636e\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u63a5\u6536\u5dee\u5f02\u6570\u636e\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("POS\u63a5\u6536\u5dee\u5f02\u6570\u636e\u63a5\u53e3\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25:" + errorCodes));
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String diffInventory(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplstoresInventory.param ", (Object)dataStr);
        List whOpstoreDomainList = JSONObject.parseArray((String)dataStr, WhOpstoreDomain.class);
        if (ObjectUtils.isEmpty((Object)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplstoresInventory.toList", (Object)"\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a", "", dataStr);
        }
        whOpstoreDomainList.stream().forEach(this::inventory);
        String result = JSONObject.toJSONString((Object)whOpstoreDomainList);
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplstoresInventory.result", (Object)result);
        return JbsUtils.getPosSuccessMap(result);
    }

    @Override
    public String syncReturnOrderState(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (null == whOpstoreDomain) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.syncReturnOrderState.param", (Object)"param is null");
            throw new ApiException("param is null");
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.syncReturnOrderState.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode() + "==" + whOpstoreDomain.getOpstoreNcode());
            httpFormfacade.setOutsideApiUrl("/api/erp/upReDeliveryApproveState");
            JbsPosInWhNoticeResponse execute = null;
            JbsPosSyncOrderStateRequest jbsPosSyncOrderStateRequest = new JbsPosSyncOrderStateRequest();
            BeanUtils.copyAllPropertys((Object)jbsPosSyncOrderStateRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsPosSyncOrderStateRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplPOS\u540c\u6b65\u53cd\u914d\u7533\u8bf7\u5355\u72b6\u6001\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson((Object)execute));
                return JbsUtils.getErrorMap("POS\u540c\u6b65\u53cd\u914d\u7533\u8bf7\u5355\u72b6\u6001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(String.valueOf(execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("POS\u540c\u6b65\u53cd\u914d\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("POS\u540c\u6b65\u53cd\u914d\u7533\u8bf7\u5355\u72b6\u6001\u5f02\u5e38", null);
        }
    }

    private void inventory(WhOpstoreDomain whOpstoreDomain) {
        Integer checkType = whOpstoreDomain.getCheckType();
        if (0 == checkType) {
            this.inventoryWhole(whOpstoreDomain);
            this.logger.info("jbsPos.JbsPosWarehouseServiceImplinventoryWhole", (Object)"\u5168\u573a\u76d8\u70b9");
            return;
        }
        if (1 == checkType) {
            this.inventorySingle(whOpstoreDomain);
            this.logger.info("jbsPos.JbsPosWarehouseServiceImplinventorySingle", (Object)"\u5355\u54c1\u76d8\u70b9");
            return;
        }
        throw new ApiException("\u9519\u8bef\u7684\u76d8\u70b9\u7c7b\u578b");
    }

    private void inventoryWhole(WhOpstoreDomain whOpstoreDomain) {
        ArrayList skuDomainList = new ArrayList();
        Optional.ofNullable(whOpstoreDomain).map(WhOpstoreDomain::getWhOpstoreGoodsDomainList).ifPresent(goodsList -> goodsList.forEach(goods -> skuDomainList.addAll(goods.getWhOpstoreSkuDomainList())));
        if (ObjectUtils.isEmpty(skuDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.sku", (Object)" sku \u4fe1\u606f\u4e3a\u7a7a");
            throw new ApiException("sku \u4fe1\u606f\u4e3a\u7a7a");
        }
        final String warehouseCode = whOpstoreDomain.getWarehouseCode();
        final HashMap param = new HashMap(){
            {
                this.put("fuzzy", false);
                this.put("warehouseCode", warehouseCode);
            }
        };
        QueryResult queryStoreResult = this.sendReSupObject("wh.whStoreGoods.queryStoreSkuPage", new HashMap(){
            {
                this.put("map", JSONObject.toJSONString((Object)param));
            }
        }, WhStoreSku.class);
        if (queryStoreResult == null) {
            this.logger.error(SYS_CODE, (Object)"wh.whStoreGoods.queryStoreSkuPage \u67e5\u8be2\u7ed3\u679c\u5f02\u5e38");
            throw new ApiException("wh.whStoreGoods.queryStoreSkuPage \u67e5\u8be2\u7ed3\u679c\u5f02\u5e38");
        }
        if (ObjectUtils.isEmpty((Object)queryStoreResult.getList())) {
            this.logger.error(SYS_CODE, (Object)"wh.whStoreGoods.queryStoreSkuPage \u67e5\u8be2sku\u4e0d\u5b58\u5728");
            throw new ApiException("wh.whStoreGoods.queryStoreSkuPage \u67e5\u8be2sku\u4e0d\u5b58\u5728");
        }
        List list = queryStoreResult.getList();
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplqueryStoreResult", (Object)("\u6570\u91cf: " + list.size()));
        HashMap map = new HashMap();
        list.forEach(e -> map.put(e.getSkuNo() + e.getSkuBarcode() + e.getStoreWhlocal(), e));
        for (WhOpstoreSkuDomain skuDomain : skuDomainList) {
            BigDecimal zero = new BigDecimal(0);
            BigDecimal goodsNum = skuDomain.getGoodsNum();
            BigDecimal goodsWeight = skuDomain.getGoodsWeight();
            if (goodsNum == null || goodsNum.compareTo(zero) < 0 || goodsWeight == null || goodsWeight.compareTo(zero) < 0) {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.numOrweight", (Object)" sku \u5e93\u5b58\u4e0d\u5408\u6cd5");
                throw new ApiException("\u4f20\u53c2\u6709\u8bef");
            }
            WhStoreSku whStoreSku = (WhStoreSku)map.get(skuDomain.getSkuNo() + skuDomain.getBatchNumber() + skuDomain.getStoreWhlocal());
            if (whStoreSku == null) {
                skuDomain.setOpstoreDir("1");
                skuDomain.setGoodsNum(goodsNum);
                skuDomain.setGoodsWeight(goodsWeight);
                this.logger.info("jbsPos.JbsPosWarehouseServiceImplinventory.whStoreSku", (Object)("POS \u5e93\u5b58\u4fe1\u606f\u5728\u4e2d\u53f0\u4e0d\u5b58\u5728: " + MessageFormat.format("warehouseCode: {0}, skuNo: {1}, skuBarCode: {2}, storeWhlocal: {3}", skuDomain.getWarehouseCode(), skuDomain.getSkuNo(), skuDomain.getBatchNumber(), skuDomain.getStoreWhlocal())));
                continue;
            }
            BigDecimal localGoodsNum = whStoreSku.getGoodsNum();
            BigDecimal localGoodsWeight = whStoreSku.getGoodsWeight();
            this.logger.info("inventory.localGoodsNum: " + localGoodsNum);
            this.logger.info("inventory.localGoodsWeight: " + localGoodsWeight);
            if (goodsNum.compareTo(localGoodsNum) >= 0 && goodsWeight.compareTo(localGoodsWeight) >= 0) {
                this.logger.info("\u76d8\u76c8\u5904\u7406");
                skuDomain.setOpstoreDir("1");
                skuDomain.setGoodsNum(goodsNum.subtract(localGoodsNum));
                skuDomain.setGoodsWeight(goodsWeight.subtract(localGoodsWeight));
            } else if (goodsNum.compareTo(localGoodsNum) <= 0 && goodsWeight.compareTo(localGoodsWeight) <= 0) {
                this.logger.info("\u76d8\u4e8f\u5904\u7406");
                skuDomain.setOpstoreDir("0");
                skuDomain.setGoodsNum(localGoodsNum.subtract(goodsNum));
                skuDomain.setGoodsWeight(localGoodsWeight.subtract(goodsWeight));
            } else {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.param", (Object)"\u76d8\u70b9\u6570\u636e\u6709\u8bef");
                throw new ApiException("\u76d8\u70b9\u6570\u636e\u6709\u8bef:[\u8d27\u53f7:" + skuDomain.getSkuNo() + "\uff0c\u6279\u6b21\uff1a" + skuDomain.getBatchNumber() + "\uff0c\u5e93\u4f4d\uff1a" + skuDomain.getStoreWhlocal() + "]");
            }
            map.remove(skuDomain.getSkuNo() + skuDomain.getBatchNumber() + skuDomain.getStoreWhlocal());
        }
        for (WhStoreSku sku : map.values()) {
            this.logger.info("jbsPos.JbsPosWarehouseServiceImplinventory.whStoreSku", (Object)("\u4e2d\u53f0\u5e93\u5b58\u4fe1\u606f\u5728 POS \u4e0d\u5b58\u5728: " + MessageFormat.format("warehouseCode: {0}, skuNo: {1}, skuBarCode: {2}, storeWhlocal: {3}", sku.getWarehouseCode(), sku.getSkuNo(), sku.getSkuBarcode(), sku.getStoreWhlocal())));
            WhOpstoreSkuDomain skuDomain = new WhOpstoreSkuDomain();
            skuDomain.setSkuNo(sku.getSkuNo());
            skuDomain.setSkuName(sku.getSkuName());
            skuDomain.setWarehouseCode(sku.getWarehouseCode());
            skuDomain.setStoreWhlocal(sku.getStoreWhlocal());
            skuDomain.setOpstoreDir("0");
            skuDomain.setGoodsNum(sku.getGoodsNum());
            skuDomain.setGoodsWeight(sku.getGoodsWeight());
            skuDomain.setBatchNumber(sku.getSkuBarcode());
            skuDomain.setPartsnameNumunit(sku.getPartsnameNumunit());
            skuDomain.setPartsnameWeightunit(sku.getPartsnameWeightunit());
            Optional.ofNullable(whOpstoreDomain).map(WhOpstoreDomain::getWhOpstoreGoodsDomainList).map(tList -> (WhOpstoreGoodsDomain)tList.get(0)).map(WhOpstoreGoodsDomain::getWhOpstoreSkuDomainList).ifPresent(e -> e.add(skuDomain));
        }
    }

    private void inventorySingle(WhOpstoreDomain whOpstoreDomain) {
        ArrayList skuDomainList = new ArrayList();
        Optional.ofNullable(whOpstoreDomain).map(WhOpstoreDomain::getWhOpstoreGoodsDomainList).ifPresent(goodsList -> goodsList.forEach(goods -> skuDomainList.addAll(goods.getWhOpstoreSkuDomainList())));
        if (ObjectUtils.isEmpty(skuDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.sku", (Object)" sku \u4fe1\u606f\u4e3a\u7a7a");
            throw new ApiException("sku \u4fe1\u606f\u4e3a\u7a7a");
        }
        for (WhOpstoreSkuDomain skuDomain : skuDomainList) {
            final String skuNo = skuDomain.getSkuNo();
            final String skuBarcode = skuDomain.getBatchNumber();
            final String storeWhlocal = skuDomain.getStoreWhlocal();
            final String warehouseCode = skuDomain.getWarehouseCode();
            if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)skuBarcode) || StringUtils.isBlank((String)storeWhlocal) || StringUtils.isBlank((String)warehouseCode)) {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.param", (Object)"\u4f20\u53c2\u4e3a\u7a7a");
                throw new ApiException("\u4f20\u53c2\u4e3a\u7a7a");
            }
            try {
                final HashMap param = new HashMap(){
                    {
                        this.put("fuzzy", false);
                        this.put("skuNo", skuNo);
                        this.put("skuBarcode", skuBarcode);
                        this.put("storeWhlocal", storeWhlocal);
                        this.put("warehouseCode", warehouseCode);
                    }
                };
                QueryResult queryStoreResult = this.sendReSupObject("wh.whStoreGoods.queryStoreSkuPage", new HashMap(){
                    {
                        this.put("map", JSONObject.toJSONString((Object)param));
                    }
                }, WhStoreSku.class);
                if (null == queryStoreResult) {
                    this.logger.error(SYS_CODE, (Object)"wh.whStoreGoods.queryStoreSkuPage \u67e5\u8be2\u7ed3\u679c\u5f02\u5e38");
                    throw new ApiException("wh.whStoreGoods.queryStoreSkuPage \u67e5\u8be2\u7ed3\u679c\u5f02\u5e38");
                }
                BigDecimal zero = BigDecimal.ZERO;
                BigDecimal goodsNum = skuDomain.getGoodsNum();
                BigDecimal goodsWeight = skuDomain.getGoodsWeight();
                if (goodsNum == null || goodsNum.compareTo(zero) < 0 || goodsWeight == null || goodsWeight.compareTo(zero) < 0) {
                    this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.numOrweight", (Object)" sku \u5e93\u5b58\u4e0d\u5408\u6cd5");
                    throw new ApiException("\u4f20\u53c2\u6709\u8bef");
                }
                if (ListUtil.isEmpty((Collection)queryStoreResult.getList())) {
                    skuDomain.setOpstoreDir("1");
                    skuDomain.setGoodsNum(goodsNum);
                    skuDomain.setGoodsWeight(goodsWeight);
                    continue;
                }
                WhStoreSku whStoreSku = (WhStoreSku)queryStoreResult.getList().get(0);
                BigDecimal localGoodsNum = whStoreSku.getGoodsNum();
                BigDecimal localGoodsWeight = whStoreSku.getGoodsWeight();
                this.logger.info("inventory.localGoodsNum: " + localGoodsNum);
                this.logger.info("inventory.localGoodsWeight: " + localGoodsWeight);
                if (goodsNum.compareTo(localGoodsNum) >= 0 && goodsWeight.compareTo(localGoodsWeight) >= 0) {
                    skuDomain.setOpstoreDir("1");
                    skuDomain.setGoodsNum(goodsNum.subtract(localGoodsNum));
                    skuDomain.setGoodsWeight(goodsWeight.subtract(localGoodsWeight));
                    continue;
                }
                if (goodsNum.compareTo(localGoodsNum) <= 0 && goodsWeight.compareTo(localGoodsWeight) <= 0) {
                    skuDomain.setOpstoreDir("0");
                    skuDomain.setGoodsNum(localGoodsNum.subtract(goodsNum));
                    skuDomain.setGoodsWeight(localGoodsWeight.subtract(goodsWeight));
                    continue;
                }
                this.logger.error("jbsPos.JbsPosWarehouseServiceImplinventory.param", (Object)("\u76d8\u70b9\u6570\u636e\u6709\u8bef\uff1a" + localGoodsNum + "-" + goodsNum + "/" + localGoodsWeight + "-" + goodsWeight));
                throw new ApiException("\u76d8\u70b9\u6570\u636e\u6709\u8bef");
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)"inventory \u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
                throw new ApiException("inventory \u5904\u7406\u6570\u636e\u5f02\u5e38");
            }
        }
    }

    @Override
    public String receiveAdjustInventory(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getPosErrorMap("param is null", "", dataStr);
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImplreceiveAdjustInventory.param ", (Object)dataStr);
        List whOpstoreDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreDomain.class);
        if (ListUtil.isEmpty((Collection)whOpstoreDomainList)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplreceiveAdjustInventory.toList", (Object)"\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a");
            return JbsUtils.getPosErrorMap("\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a", "", dataStr);
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "storeGoodsType\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"T8,T4,P2,T2,T5,T9".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            if ("T5".equals(whOpstoreDomain.getStoreGoodsBtype())) {
                whOpstoreDomain.setStoreGoodsType("3");
                whOpstoreDomain.setStoreType("1");
            } else if ("T9".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                whOpstoreDomain.setStoreGoodsType("4");
                whOpstoreDomain.setStoreType("1");
            }
            whOpstoreDomain.setMemberCode("20021000276227");
            whOpstoreDomain.setMemberName("Swift");
            whOpstoreDomain.setMemberCcode("20021000276227");
            whOpstoreDomain.setMemberCname("Swift");
            whOpstoreDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getOpstoreDir())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5e93\u5b58\u65b9\u5411opstoreDir\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setGoodsNo(whOpstoreGoodsDomain.getGoodsEocode());
                whOpstoreGoodsDomain.setMemberCode("20021000276227");
                whOpstoreGoodsDomain.setMemberName("Swift");
                whOpstoreGoodsDomain.setMemberCcode("20021000276227");
                whOpstoreGoodsDomain.setMemberCname("Swift");
                whOpstoreGoodsDomain.setBrandCode("2021082900000001");
                whOpstoreGoodsDomain.setBrandName("Swift");
                whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u6216\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5e93\u5b58\u65b9\u5411opstoreDir\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreWhlocal())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5e93\u4f4d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    this.setBatchData(whOpstoreDomain.getWarehouseCode(), whOpstoreSkuDomain);
                    whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
                    whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                    whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                    whOpstoreSkuDomain.setStoreGoodsType(whOpstoreGoodsDomain.getStoreGoodsType());
                    whOpstoreSkuDomain.setMemberCode("20021000276227");
                    whOpstoreSkuDomain.setMemberName("Swift");
                    whOpstoreSkuDomain.setMemberCcode("20021000276227");
                    whOpstoreSkuDomain.setMemberCname("Swift");
                    whOpstoreSkuDomain.setBrandCode("2021082900000001");
                    whOpstoreSkuDomain.setBrandName("Swift");
                    whOpstoreSkuDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            try {
                if (!checkDetail.booleanValue()) continue;
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj);
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.POS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u63a5\u53e3.saveData ", (Object)JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("POS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("POS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "POS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getPosErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "", errorCodes);
        }
        return JbsUtils.getPosSuccessMap("");
    }

    @Override
    public String queryPosStoreInventory(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplparam is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.queryPosStoreInventory.paramsMap ", (Object)JsonUtil.buildNormalBinder().toJson(paramsMap));
        List skuNoList = (List)paramsMap.get("skuNoList");
        List warhouseCodeList = (List)paramsMap.get("warhouseCode");
        String skus = "";
        if (ListUtil.isNotEmpty((Collection)skuNoList)) {
            for (Object str : skuNoList) {
                skus = skus + (String)str + ",";
            }
        }
        String whs = "";
        if (ListUtil.isNotEmpty((Collection)warhouseCodeList)) {
            for (String str : warhouseCodeList) {
                whs = whs + str + ",";
            }
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setOutsideApiUrl("/api/erp/getSkuStockList");
            JbsPosQueryStoreWhResponse execute = null;
            JbsPosQueryStoreWhRequest jbsPosQueryStoreWhRequest = new JbsPosQueryStoreWhRequest();
            if (StringUtils.isNotBlank((String)skus)) {
                jbsPosQueryStoreWhRequest.setSkuCodeStr(skus.substring(0, skus.length() - 1));
            }
            if (StringUtils.isNotBlank((String)whs)) {
                jbsPosQueryStoreWhRequest.setStoreCodeStr(whs.substring(0, whs.length() - 1));
            }
            if (null == (execute = httpFormfacade.execute(jbsPosQueryStoreWhRequest)) || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u63a8\u9001\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("POS\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("POS\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", "");
        }
    }

    @Override
    public String queryWmsDCInventory(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.queryWmsDCInventory", (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.queryWmsDCInventory.paramsMap", (Object)JsonUtil.buildNormalBinder().toJson(paramsMap));
        try {
            String returnJson = (String)this.getInternalRouter().inInvoke("jbsWms.warehouse.sendQueryWhInfo", paramsMap);
            if (StringUtils.isBlank((String)returnJson)) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
            }
            return JbsUtils.getSuccessMap(returnJson);
        }
        catch (Exception e) {
            this.logger.error("jbsPos.JbsPosWarehouseServiceImplPOS\u5e93\u5b58\u67e5\u8be2\u5f02\u5e38", (Object)e.toString(), (Throwable)e);
            return JbsUtils.getErrorMap("POS\u5e93\u5b58\u67e5\u8be2\u5f02\u5e38", "");
        }
    }

    private Boolean checkType(String storeGoodsBtype, String types) {
        Boolean flag = true;
        if (StringUtils.isBlank((String)storeGoodsBtype) || StringUtils.isBlank((String)types)) {
            return flag;
        }
        if (types.contains(storeGoodsBtype)) {
            flag = false;
        }
        return flag;
    }

    private List<String> checkWhOpStore(List<WhOpstoreDomain> whOpstoreDomainList, String typeStr) {
        ArrayList<String> errorCodes = new ArrayList<String>();
        if (ListUtil.isEmpty(whOpstoreDomainList)) {
            errorCodes.add("dataStr\u8f6cList \u4e3a\u7a7a");
            return errorCodes;
        }
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList;
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
                errorCodes.add("\u5916\u7cfb\u7edf\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreNcode())) {
                errorCodes.add("\u4e2d\u53f0\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u4ed3\u5e93\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getGoodsWeight())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e3a\u7a7a");
            }
            if (this.checkType(whOpstoreDomain.getStoreGoodsBtype(), typeStr).booleanValue()) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u51fa\u5165\u5e93\u7c7b\u578b\u672a\u77e5\uff1a" + whOpstoreDomain.getStoreGoodsBtype());
            }
            if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
            }
            if (ListUtil.isEmpty(whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u4e3a\u7a7a");
                continue;
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList;
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreGoodsDomain.getGoodsWeight())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u6216\u5546\u54c1\u91cd\u91cf\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameWeightunit())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u8be6\u60c5\u5217\u8868\u5546\u54c1code\u4e3a\u7a7a");
                }
                if (ListUtil.isEmpty(whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u4e3a\u7a7a");
                    continue;
                }
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getGoodsWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u53d8\u66f4\u6570\u91cf\u6216\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1\u6570\u91cf\u5355\u4f4d\u6216\u5546\u54c1\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getBatchNumber())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffNumber()) || EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffWeight())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u6216\u91cd\u91cf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuDomain.getDiffNumberunit()) || StringUtils.isBlank((String)whOpstoreSkuDomain.getDiffWeightunit())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u6570\u91cf\u6216\u91cd\u91cf\u5355\u4f4d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if ((BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffNumber()) != 0 || BigDecimal.ZERO.compareTo(whOpstoreSkuDomain.getDiffWeight()) != 0) && EmptyUtil.isEmpty((Object)whOpstoreSkuDomain.getDiffRemark())) {
                        errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5dee\u5f02\u539f\u56e0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreWhlocal())) continue;
                    errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u5355\u636e\u6279\u6b21\u5217\u8868\u5e93\u4f4d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (this.checkBatch(whOpstoreDomain).booleanValue()) {
                errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "\u6279\u6b21\u6570\u636e\u4e0d\u5339\u914d,\u6279\u6b21\u7ea7\u6570\u636e\u9519\u8bef \u6570\u91cf/\u91cd\u91cf/\u6279\u6b21\u9519\u8bef");
            }
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
                if (new BigDecimal("-1").compareTo(whOpstoreGoodsDomain.getGoodsNum()) != 0) continue;
                BigDecimal goodsNum = BigDecimal.ZERO;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                    goodsNum = goodsNum.add(whOpstoreSkuDomain.getGoodsNum());
                }
                whOpstoreGoodsDomain.setGoodsNum(goodsNum);
            }
        }
        return errorCodes;
    }

    public void checkGoodsClass(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap<String, String> whMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        whMap.put("warehouseCode", whOpstoreDomain.getWarehouseCode());
        whMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(whMap));
        QueryResult qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
        if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
            throw new ApiException("checkGoodsClass.warehouseCode", whMap.toString());
        }
        WhWarehouseReDomain whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        String goodsClass = "plat";
        String memberCode = whWarehouseReDomain.getMemberCode();
        whOpstoreDomain.setMemberCode(memberCode);
        whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        if ("0".equals(whWarehouseReDomain.getWarehouseCtype()) || "1".equals(whWarehouseReDomain.getWarehouseCtype())) {
            goodsClass = "store";
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            whOpstoreGoodsDomain.setGoodsEocode(whOpstoreGoodsDomain.getGoodsNo());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            HashMap<String, String> paramSendMap = new HashMap<String, String>();
            paramMap.put("goodsClass", goodsClass);
            paramMap.put("skuNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCode", memberCode);
            paramMap.put("tenantCode", "2019071800001392");
            paramSendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResutl = this.getQueryResutl("rs.sku.querySkuPage", paramSendMap, RsSkuDomain.class);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.assWhOpstoreDomain.querySkuPage", (Object)(JsonUtil.buildNormalBinder().toJson(paramSendMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)queryResutl)));
                throw new ApiException(whOpstoreGoodsDomain.getGoodsNo() + ":\u8be5\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            RsSkuDomain rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
            paramMap.clear();
            paramMap.put("goodsCode", rsSkuDomain.getGoodsCode());
            paramMap.put("tenantCode", "2019071800001392");
            RsResourceGoods rsResourceGoods = (RsResourceGoods)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, "object", new Object[]{RsResourceGoods.class});
            this.logger.error("jbsPos.JbsPosWarehouseServiceImpl.assWhOpstoreDomain.getResourceGoodsByCodeStr", (Object)(JsonUtil.buildNormalBinder().toJson(paramMap) + "\n" + JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods)));
            if (null == rsResourceGoods) continue;
            whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
            whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
            whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
            whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
            whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
            whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
            whOpstoreGoodsDomain.setGoodsProperty(rsResourceGoods.getGoodsProperty3());
            whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
            whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
            whOpstoreGoodsDomain.setMemberCode(rsResourceGoods.getMemberCode());
            whOpstoreGoodsDomain.setMemberName(rsResourceGoods.getMemberName());
            whOpstoreGoodsDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
            whOpstoreGoodsDomain.setMemberCname(rsResourceGoods.getMemberCname());
            whOpstoreGoodsDomain.setGoodsProperty3(rsResourceGoods.getGoodsProperty3());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
                whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
                whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
                whOpstoreSkuDomain.setGoodsName(rsSkuDomain.getGoodsName());
                whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
                whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
                whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
                whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
                whOpstoreSkuDomain.setSkuName(rsSkuDomain.getSkuName());
                whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreSkuDomain.setMemberCode(rsResourceGoods.getMemberCode());
                whOpstoreSkuDomain.setMemberName(rsResourceGoods.getMemberName());
                whOpstoreSkuDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
                whOpstoreSkuDomain.setMemberCname(rsResourceGoods.getMemberCname());
                whOpstoreSkuDomain.setStoreType(this.checkStoreType(whOpstoreSkuDomain));
                whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                this.checkNegative(whOpstoreSkuDomain.getGoodsNum());
                this.checkNegative(whOpstoreSkuDomain.getGoodsWeight());
            }
        }
    }

    private void queryOldOpstoreSku(WhOpstoreDomain currentObj) {
        if (null != currentObj) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("tenantCode", "2019071800001392");
            paramMap.put("opstoreCode", currentObj.getOpstoreNcode());
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResutl = this.getQueryResutl("wh.WhOpstore.queryOpstoreSkuPage", sendMap, WhOpstoreSkuDomain.class);
            if (null != queryResutl && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
                HashMap<String, String> skuDomainMap = new HashMap<String, String>();
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : queryResutl.getList()) {
                    String skuBarcode = whOpstoreSkuDomain.getSkuBarcode();
                    String skuNo = whOpstoreSkuDomain.getSkuNo();
                    String key = skuBarcode + "-" + skuNo;
                    skuDomainMap.put(key, whOpstoreSkuDomain.getOpstoreSkuOldcode());
                }
                List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = currentObj.getWhOpstoreGoodsDomainList();
                if (ListUtil.isNotEmpty(whOpstoreGoodsDomainList)) {
                    for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                        List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                        if (!ListUtil.isNotEmpty(whOpstoreSkuDomainList)) continue;
                        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                            String skuBarcode = whOpstoreSkuDomain.getSkuBarcode();
                            String skuNo = whOpstoreSkuDomain.getSkuNo();
                            String key = skuBarcode + "-" + skuNo;
                            if (!skuDomainMap.containsKey(key)) continue;
                            whOpstoreSkuDomain.setOpstoreSkuOldcode((String)skuDomainMap.get(key));
                        }
                    }
                }
            }
        }
    }

    private List<WhOpstoreSkuDomain> copyGoods2SkuList(String whPlant, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomains = new ArrayList<WhOpstoreSkuDomain>();
        if (null != whOpstoreGoodsDomain && ListUtil.isEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
            whOpstoreSkuDomain.setSkuNo(whOpstoreGoodsDomain.getGoodsEocode());
            whOpstoreSkuDomain.setGoodsEocode(whOpstoreGoodsDomain.getGoodsEocode());
            whOpstoreSkuDomain.setGoodsName(whOpstoreGoodsDomain.getGoodsName());
            whOpstoreSkuDomain.setPntreeCode(whPlant);
            whOpstoreSkuDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum());
            whOpstoreSkuDomain.setPartsnameNumunit(whOpstoreGoodsDomain.getPartsnameNumunit());
            whOpstoreSkuDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight());
            whOpstoreSkuDomain.setPartsnameWeightunit(whOpstoreGoodsDomain.getPartsnameWeightunit());
            whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreGoodsDomain.getStoreGoodsType());
            whOpstoreSkuDomain.setStoreType(whOpstoreGoodsDomain.getStoreType());
            whOpstoreSkuDomain.setMemberCode("20021000276227");
            whOpstoreSkuDomain.setMemberName("Swift");
            whOpstoreSkuDomain.setMemberCcode("20021000276227");
            whOpstoreSkuDomain.setMemberCname("Swift");
            whOpstoreSkuDomain.setBrandCode("2021082900000001");
            whOpstoreSkuDomain.setBrandName("Swift");
            whOpstoreSkuDomain.setTenantCode("2019071800001392");
            this.setBatchData(whPlant, whOpstoreSkuDomain);
            whOpstoreSkuDomains.add(whOpstoreSkuDomain);
        } else if (null != whOpstoreGoodsDomain && ListUtil.isNotEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
                whOpstoreSkuDomain.setStoreGoodsType(whOpstoreGoodsDomain.getStoreGoodsType());
                whOpstoreSkuDomain.setStoreType(whOpstoreGoodsDomain.getStoreType());
                whOpstoreSkuDomain.setMemberCode("20021000276227");
                whOpstoreSkuDomain.setMemberName("Swift");
                whOpstoreSkuDomain.setMemberCcode("20021000276227");
                whOpstoreSkuDomain.setMemberCname("Swift");
                whOpstoreSkuDomain.setBrandCode("2021082900000001");
                whOpstoreSkuDomain.setBrandName("Swift");
                whOpstoreSkuDomain.setTenantCode("2019071800001392");
                this.setBatchData(whPlant, whOpstoreSkuDomain);
                whOpstoreSkuDomains.add(whOpstoreSkuDomain);
            }
        }
        return whOpstoreSkuDomains;
    }

    private void setDiffData(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (null != whOpstoreSkuDomain) {
            whOpstoreSkuDomain.setPricesetPrefprice(whOpstoreSkuDomain.getDiffNumber());
            whOpstoreSkuDomain.setSkuName(whOpstoreSkuDomain.getDiffNumberunit());
            whOpstoreSkuDomain.setPricesetInsideprice(whOpstoreSkuDomain.getDiffWeight());
            whOpstoreSkuDomain.setTargetChannelCode(whOpstoreSkuDomain.getDiffWeightunit());
            whOpstoreSkuDomain.setPntreeName(whOpstoreSkuDomain.getDiffRemark());
        }
    }

    private Boolean checkBatch(WhOpstoreDomain whOpstoreDomain) {
        Boolean checkDetail = true;
        HashMap<String, String> map = new HashMap<String, String>();
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList()) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getWhOpstoreGoodsDomainList().get(0)) || EmptyUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList().get(0).getWhOpstoreSkuDomainList())) {
            checkDetail = false;
        }
        HashMap<String, WhOpstoreSkuDomain> checkMap = new HashMap<String, WhOpstoreSkuDomain>();
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                checkMap.put(whOpstoreDomain.getOpstoreOcode() + "-" + whOpstoreSkuDomain.getGoodsEocode() + "-" + whOpstoreSkuDomain.getSkuBarcode(), whOpstoreSkuDomain);
            }
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
        queryMap.put("tenantCode", "2019071800001392");
        queryMap.put("order", "true");
        map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
        QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstore.class);
        if (queryStoreResult != null && ListUtil.isEmpty((Collection)queryStoreResult.getList())) {
            checkDetail = false;
        }
        for (WhOpstore whOpstore : queryStoreResult.getList()) {
            queryMap.clear();
            queryMap.put("opstoreCode", whOpstore.getOpstoreCode());
            queryMap.put("tenantCode", "2019071800001392");
            queryMap.put("order", "true");
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult querySkuResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreSkuPage", map, WhOpstoreSku.class);
            if (querySkuResult != null && ListUtil.isEmpty((Collection)querySkuResult.getList())) {
                checkDetail = false;
                continue;
            }
            for (WhOpstoreSku whOpstoreSku : querySkuResult.getList()) {
                String key = whOpstore.getOpstoreOcode() + "-" + whOpstoreSku.getGoodsEocode() + "-" + whOpstoreSku.getSkuBarcode();
                if (!checkMap.containsKey(key)) {
                    checkDetail = false;
                    continue;
                }
                if (new BigDecimal("-1").compareTo(((WhOpstoreSkuDomain)checkMap.get(key)).getGoodsNum()) == 0) {
                    ((WhOpstoreSkuDomain)checkMap.get(key)).setGoodsNum(whOpstoreSku.getGoodsNum());
                    ((WhOpstoreSkuDomain)checkMap.get(key)).setPartsnameNumunit(whOpstoreSku.getPartsnameNumunit());
                }
                if (((WhOpstoreSkuDomain)checkMap.get(key)).getGoodsNum().add(((WhOpstoreSkuDomain)checkMap.get(key)).getDiffNumber()).compareTo(whOpstoreSku.getGoodsNum()) != 0) {
                    checkDetail = false;
                }
                if (((WhOpstoreSkuDomain)checkMap.get(key)).getGoodsWeight().add(((WhOpstoreSkuDomain)checkMap.get(key)).getDiffWeight()).compareTo(whOpstoreSku.getGoodsWeight()) != 0) {
                    checkDetail = false;
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            if (checkDetail.booleanValue()) continue;
            break;
        }
        return checkDetail;
    }

    private void setBatchData(String whPlant, WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreSkuDomain)) {
            whOpstoreSkuDomain.setGoodsEocode(whOpstoreSkuDomain.getSkuNo());
            whOpstoreSkuDomain.setGoodsName(whOpstoreSkuDomain.getSkuName());
            whOpstoreSkuDomain.setSkuBarcode(whOpstoreSkuDomain.getBatchNumber());
            whOpstoreSkuDomain.setPntreeCode(whPlant);
            this.setDiffData(whOpstoreSkuDomain);
        }
    }

    public Map checkExist(WhOpstoreDomain whOpstoreDomain) throws Exception {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            throw new ApiException("checkExist.\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult != null && ListUtil.isNotEmpty((Collection)queryStoreResult.getList()) && !EmptyUtil.isEmpty(queryStoreResult.getList().get(0))) {
                queryMap.put("checkFlag", "true");
            } else {
                queryMap.put("checkFlag", "false");
            }
            queryMap.put("currentObj", whOpstoreDomain);
            return queryMap;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new ApiException("checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38");
        }
    }

    private Boolean checkNegative(BigDecimal data) {
        if (!EmptyUtil.isEmpty((Object)data) && BigDecimal.ZERO.compareTo(data) > 0) {
            return true;
        }
        return false;
    }

    private String checkStoreType(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreSkuDomain) && StringUtils.isNotBlank((String)whOpstoreSkuDomain.getStoreWhlocal()) && whOpstoreSkuDomain.getStoreWhlocal().indexOf("10") == 0) {
            return "0";
        }
        return "1";
    }

    private void checkSapOrderInfo(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreNcode())) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("opstoreCode", whOpstoreDomain.getOpstoreNcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult == null || ListUtil.isEmpty((Collection)queryStoreResult.getList())) {
                throw new ApiException("\u627e\u4e0d\u5230\u539f\u5355\u636e\u4fe1\u606f");
            }
            WhOpstoreDomain dbWhOpstoreDomain = (WhOpstoreDomain)queryStoreResult.getList().get(0);
            whOpstoreDomain.setDataPic(dbWhOpstoreDomain.getDataPicpath());
            queryMap.clear();
            map.clear();
            queryMap.put("opstoreCode", dbWhOpstoreDomain.getOpstoreCode());
            queryMap.put("tenantCode", "2019071800001392");
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryGoodsResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreGoodsPage", map, WhOpstoreGoods.class);
            HashMap<String, WhOpstoreGoods> goodsDbMap = new HashMap<String, WhOpstoreGoods>();
            if (null == queryGoodsResult || ListUtil.isEmpty((Collection)queryGoodsResult.getList())) {
                throw new ApiException("\u627e\u4e0d\u5230\u539f\u5355\u636e\u7684Goods\u4fe1\u606f");
            }
            for (WhOpstoreGoods whOpstoreGoods : queryGoodsResult.getList()) {
                queryMap.clear();
                map.clear();
                queryMap.put("opstoreGoodsCode", whOpstoreGoods.getOpstoreGoodsCode());
                queryMap.put("tenantCode", "2019071800001392");
                map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
                QueryResult querySkuResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreSkuPage", map, WhOpstoreSku.class);
                if (null == querySkuResult || ListUtil.isEmpty((Collection)querySkuResult.getList())) {
                    throw new ApiException(whOpstoreGoods.getOpstoreGoodsCode() + ":\u627e\u4e0d\u5230\u539f\u5355\u636e\u7684Sku\u4fe1\u606f");
                }
                goodsDbMap.put(((WhOpstoreSku)querySkuResult.getList().get(0)).getSkuNo(), whOpstoreGoods);
            }
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                WhOpstoreGoods whOpstoreGoods = (WhOpstoreGoods)goodsDbMap.get(whOpstoreGoodsDomain.getGoodsNo());
                if (EmptyUtil.isEmpty((Object)whOpstoreGoods)) continue;
                whOpstoreGoodsDomain.setGoodsProperty5(whOpstoreGoods.getGoodsProperty5());
                whOpstoreGoodsDomain.setChannelName(whOpstoreGoods.getChannelName());
                whOpstoreGoodsDomain.setGoodsProperty2(whOpstoreGoods.getGoodsProperty2());
            }
        }
    }

    private void handleDiffWarehouse(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreNcode())) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("opstoreCode", whOpstoreDomain.getOpstoreNcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult == null || ListUtil.isEmpty((Collection)queryStoreResult.getList())) {
                throw new ApiException("\u627e\u4e0d\u5230\u539f\u5355\u636e\u4fe1\u606f");
            }
            WhOpstoreDomain dbWhOpstoreDomain = (WhOpstoreDomain)queryStoreResult.getList().get(0);
            whOpstoreDomain.setDataPic(dbWhOpstoreDomain.getWarehouseCode());
            whOpstoreDomain.setDataPicpath(dbWhOpstoreDomain.getWarehouseName());
            queryMap.clear();
            map.clear();
            queryMap.put("opstoreCode", dbWhOpstoreDomain.getOpstoreCode());
            queryMap.put("tenantCode", "2019071800001392");
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreGoodsResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreGoodsPage", map, WhOpstoreGoodsDomain.class);
            if (null == queryStoreGoodsResult || ListUtil.isEmpty((Collection)queryStoreGoodsResult.getList())) {
                throw new ApiException("\u627e\u4e0d\u5230\u539f\u5355\u636e\u5546\u54c1\u6570\u636e");
            }
            HashMap<String, WhOpstoreGoodsDomain> goodsMap = new HashMap<String, WhOpstoreGoodsDomain>();
            List goodsList = queryStoreGoodsResult.getList();
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : goodsList) {
                goodsMap.put(whOpstoreGoodsDomain.getGoodsNo(), whOpstoreGoodsDomain);
            }
            this.logger.info("jbsPos.JbsPosWarehouseServiceImpl.handleDiffWarehouse.goodsMap", (Object)JsonUtil.buildNormalBinder().toJson(goodsMap));
            List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
            if (ListUtil.isNotEmpty(whOpstoreGoodsDomainList)) {
                for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                    if (!goodsMap.containsKey(whOpstoreGoodsDomain.getGoodsNo())) {
                        throw new ApiException(whOpstoreGoodsDomain.getGoodsNo() + ":\u672a\u627e\u5230\u5546\u54c1\u4fe1\u606f");
                    }
                    WhOpstoreGoodsDomain whOpGoods = (WhOpstoreGoodsDomain)goodsMap.get(whOpstoreGoodsDomain.getGoodsNo());
                    whOpstoreGoodsDomain.setGoodsProperty2(whOpGoods.getGoodsProperty2());
                    whOpstoreGoodsDomain.setGoodsProperty5(whOpGoods.getGoodsProperty5());
                }
            }
        }
    }
}

