/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.yqbsoft.laser.service.da.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.domain.ExportOrderDomain;
import com.yqbsoft.laser.service.da.domain.OcContract;
import com.yqbsoft.laser.service.da.domain.OcContractGoods;
import com.yqbsoft.laser.service.da.domain.OcContractReDaDomain;
import com.yqbsoft.laser.service.da.domain.OcContractStatistics;
import com.yqbsoft.laser.service.da.service.OrderService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;

    @Override
    public SupQueryResult<OcContractReDaDomain> queryOrderPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        Integer startRow = (Integer)map.get("startRow");
        Integer rows = (Integer)map.get("rows");
        map.put("startRow", (startRow - 1) * rows);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<OcContractReDaDomain> orderReDomains = this.ocContractMapper.queryOrderPage(map);
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        Integer totalPage = this.ocContractMapper.getTotalPage(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        return list;
    }

    @Override
    public OcContractStatistics orderTotalStatistics(Map<String, Object> map) {
        this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String memberCcode = (String)map.get("memberCcode");
        String memberGcode = (String)map.get("memberGcode");
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)memberGcode)) {
            return null;
        }
        return this.ocContractMapper.orderTotalStatistics(map);
    }

    @Override
    public List<ExportOrderDomain> exportOrder(Map<String, Object> map) {
        String memberCcode = (String)map.get("memberCcode");
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        this.logger.info("----------------\u5bfc\u51fa\u4e0b\u8f7d---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<ExportOrderDomain> exportOrderDomains = this.ocContractMapper.exportOrder(map);
        List<ExportOrderDomain> exportRefundOrderDomains = this.ocContractMapper.exportRefundOrder(map);
        exportOrderDomains.addAll(exportRefundOrderDomains);
        return exportOrderDomains;
    }

    @Override
    public SupQueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        Integer totalPage = this.ocContractMapper.count(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        List<OcContract> orderReDomains = this.ocContractMapper.query(map);
        for (OcContract oc : orderReDomains) {
            map.clear();
            map.put("contractBillcode", oc.getContractBillcode());
            map.put("tenantCode", oc.getTenantCode());
            List<OcContractGoods> goodslist = this.ocContractGoodsMapper.query(map);
            oc.setGoodsList(goodslist);
        }
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        return list;
    }
}

