/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.da.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.domain.AftersaleList;
import com.yqbsoft.laser.service.da.domain.ExportOrderDomain;
import com.yqbsoft.laser.service.da.domain.OcContract;
import com.yqbsoft.laser.service.da.domain.OcContractGoods;
import com.yqbsoft.laser.service.da.domain.OcContractReDaDomain;
import com.yqbsoft.laser.service.da.domain.OcContractStatistics;
import com.yqbsoft.laser.service.da.domain.RefundListDomain;
import com.yqbsoft.laser.service.da.domain.SphContractDomain;
import com.yqbsoft.laser.service.da.domain.SphContractDto;
import com.yqbsoft.laser.service.da.domain.SphQueryOrderDomain;
import com.yqbsoft.laser.service.da.service.OrderService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.util.HttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private final String urlToken = "https://api.weixin.qq.com/cgi-bin/token";
    private final String urlQueryOrder = "https://api.weixin.qq.com/shop/order/get?access_token=";
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;

    @Override
    public SupQueryResult<OcContractReDaDomain> queryOrderPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        Integer startRow = (Integer)map.get("startRow");
        Integer rows = (Integer)map.get("rows");
        map.put("startRow", (startRow - 1) * rows);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<OcContractReDaDomain> orderReDomains = this.ocContractMapper.queryOrderPage(map);
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        Integer totalPage = this.ocContractMapper.getTotalPage(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        return list;
    }

    @Override
    public OcContractStatistics orderTotalStatistics(Map<String, Object> map) {
        this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String memberCcode = (String)map.get("memberCcode");
        String memberGcode = (String)map.get("memberGcode");
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)memberGcode)) {
            return null;
        }
        return this.ocContractMapper.orderTotalStatistics(map);
    }

    @Override
    public List<ExportOrderDomain> exportOrder(Map<String, Object> map) {
        String memberCcode = (String)map.get("memberCcode");
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        this.logger.info("----------------\u5bfc\u51fa\u4e0b\u8f7d---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<ExportOrderDomain> exportOrderDomains = this.ocContractMapper.exportOrder(map);
        List<ExportOrderDomain> exportRefundOrderDomains = this.ocContractMapper.exportRefundOrder(map);
        exportOrderDomains.addAll(exportRefundOrderDomains);
        return exportOrderDomains;
    }

    @Override
    public SupQueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        Integer totalPage = this.ocContractMapper.count(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        List<OcContract> orderReDomains = this.ocContractMapper.query(map);
        for (OcContract oc : orderReDomains) {
            map.clear();
            map.put("contractBillcode", oc.getContractBillcode());
            map.put("tenantCode", oc.getTenantCode());
            List<OcContractGoods> goodslist = this.ocContractGoodsMapper.query(map);
            oc.setGoodsList(goodslist);
        }
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        return list;
    }

    @Override
    public List<ExportOrderDomain> exportOrderOutline(Map<String, Object> map) {
        String memberCcode = (String)map.get("memberCcode");
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        this.logger.info("----------------\u5bfc\u51fa\u4e0b\u8f7d---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<ExportOrderDomain> exportOrderDomains = this.ocContractMapper.exportOrderOutline(map);
        return exportOrderDomains;
    }

    @Override
    public void saveOrderTime() {
        List<SphContractDomain> sphContractDomain = this.ocContractMapper.queryOrderOpenId();
        for (SphContractDomain contractDomain : sphContractDomain) {
            this.logger.info("\u67e5\u8be2\u7684\u6570\u636e\u5e93", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
            String contractBillCode = contractDomain.getContractBillCode();
            String openid = contractDomain.getOpenid();
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            SphContractDto sphContractDto = new SphContractDto();
            sphContractDto.setOut_order_id(contractBillCode);
            sphContractDto.setOpenid(openid);
            String sphContractJson = JsonUtil.buildNonDefaultBinder().toJson((Object)sphContractDto);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
            SphQueryOrderDomain sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            if (sphQueryOrderDomain.getErrcode() == 42001L || sphQueryOrderDomain.getErrcode() == 40001L) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
                sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            } else if (sphQueryOrderDomain.getErrcode() != 0L) {
                throw new ApiException(sphQueryOrderDomain.getErrmsg());
            }
            String pay_time = sphQueryOrderDomain.getOrder().getOrder_detail().getPay_info().getPay_time();
            if (StringUtils.isNotBlank((String)pay_time)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("contractBillCode", contractBillCode);
                hashMap.put("payTime", pay_time);
                this.ocContractMapper.updateOrderTime(hashMap);
            }
            if (sphQueryOrderDomain.getOrder() == null || sphQueryOrderDomain.getOrder().getRefund_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list())) continue;
            List<RefundListDomain> refund_list = sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list();
            if (sphQueryOrderDomain.getOrder().getRelated_aftersale_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list())) continue;
            List<AftersaleList> aftersale_list = sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list();
            if (CollectionUtils.isEmpty(refund_list)) continue;
            for (RefundListDomain refundListDomain : refund_list) {
                String finish_time = refundListDomain.getFinish_time();
                Long amount = refundListDomain.getAmount() / 100L;
                if (!StringUtils.isNotBlank((String)finish_time)) continue;
                Long refund_no = Long.valueOf(refundListDomain.getRefund_no().substring(6, refundListDomain.getRefund_no().length()));
                for (AftersaleList aftersaleList : aftersale_list) {
                    if (!aftersaleList.getAftersale_id().equals(refund_no) || aftersaleList.getVersion() != 3) continue;
                    HashMap<String, Object> orderTime = new HashMap<String, Object>();
                    orderTime.put("refundBillCode", aftersaleList.getAftersale_id());
                    orderTime.put("refundTime", finish_time);
                    orderTime.put("amount", amount);
                    this.ocContractMapper.updateRefundTime(orderTime);
                }
            }
        }
    }

    private String token(String channelCode) {
        String ridsToken = DisUtil.get((String)("token" + channelCode));
        if (StringUtils.isNotBlank((String)ridsToken)) {
            return ridsToken;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("B2Cchannel", "grant_type=client_credential&appid=wx7f02a34d666f4eb5&secret=5a7d1b49c76f79cbd1c640449f0fed66");
        if (hashMap.containsKey(channelCode)) {
            String accessToken = null;
            try {
                String param = (String)hashMap.get(channelCode);
                String token = HttpRequest.sendGet("https://api.weixin.qq.com/cgi-bin/token", param);
                Map map = (Map)JSONObject.parseObject((String)token, Map.class);
                accessToken = map.get("access_token").toString();
            }
            catch (Exception e) {
                throw new ApiException("\u7b2c\u4e00\u6b21token\u83b7\u53d6\u5931\u8d25");
            }
            DisUtil.set((String)("token" + channelCode), (String)accessToken, (int)7000);
            return accessToken;
        }
        return null;
    }

    private String twoToken(String channelCode) {
        String ridsToken = DisUtil.get((String)("token" + channelCode));
        if (StringUtils.isNotBlank((String)ridsToken)) {
            DisUtil.del((String)("token" + channelCode));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("B2Cchannel", "grant_type=client_credential&appid=wx7f02a34d666f4eb5&secret=5a7d1b49c76f79cbd1c640449f0fed66");
        if (hashMap.containsKey(channelCode)) {
            String accessToken = null;
            try {
                String param = (String)hashMap.get(channelCode);
                String token = HttpRequest.sendGet("https://api.weixin.qq.com/cgi-bin/token", param);
                Map map = (Map)JSONObject.parseObject((String)token, Map.class);
                accessToken = map.get("access_token").toString();
            }
            catch (Exception e) {
                throw new ApiException("token\u83b7\u53d6\u5931\u8d25");
            }
            DisUtil.set((String)("token" + channelCode), (String)accessToken, (int)7000);
            this.logger.info("\u83b7\u53d6token2____", (Object)accessToken);
            return accessToken;
        }
        return null;
    }
}

