/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.da.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.dao.OcContractTempMapper;
import com.yqbsoft.laser.service.da.domain.AfterDomain;
import com.yqbsoft.laser.service.da.domain.AfterMarketDomain;
import com.yqbsoft.laser.service.da.domain.AfterSaleIdDimaon;
import com.yqbsoft.laser.service.da.domain.AftersaleList;
import com.yqbsoft.laser.service.da.domain.ChargeBackDomian;
import com.yqbsoft.laser.service.da.domain.ExportOrderDomain;
import com.yqbsoft.laser.service.da.domain.MediaDomian;
import com.yqbsoft.laser.service.da.domain.OcContract;
import com.yqbsoft.laser.service.da.domain.OcContractDomain;
import com.yqbsoft.laser.service.da.domain.OcContractGoods;
import com.yqbsoft.laser.service.da.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.da.domain.OcContractPmGoodsReDomain;
import com.yqbsoft.laser.service.da.domain.OcContractReDaDomain;
import com.yqbsoft.laser.service.da.domain.OcContractReDomain;
import com.yqbsoft.laser.service.da.domain.OcContractStatistics;
import com.yqbsoft.laser.service.da.domain.OcContractTempDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundBean;
import com.yqbsoft.laser.service.da.domain.OcRefundDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundGoodsBean;
import com.yqbsoft.laser.service.da.domain.OcRefundGoodsBeanList;
import com.yqbsoft.laser.service.da.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundPmGoodsDomain;
import com.yqbsoft.laser.service.da.domain.RefundListDomain;
import com.yqbsoft.laser.service.da.domain.RefundType;
import com.yqbsoft.laser.service.da.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.da.domain.SaveRefundDomian;
import com.yqbsoft.laser.service.da.domain.SphContractDomain;
import com.yqbsoft.laser.service.da.domain.SphContractDto;
import com.yqbsoft.laser.service.da.domain.SphQueryOrderDomain;
import com.yqbsoft.laser.service.da.service.OrderService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.util.HttpRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static String CODE = "oc.refund.con";
    private final String urlToken = "https://api.weixin.qq.com/cgi-bin/token";
    private final String urlQueryOrder = "https://api.weixin.qq.com/shop/order/get?access_token=";
    private final String urlQueryChargeBackList = "https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=";
    private final String urlQueryChargeBack = "https://api.weixin.qq.com/shop/ecaftersale/get?access_token=";
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractTempMapper ocContractTempMapper;
    String saasTenantcode = "2022012800000001";

    @Override
    public SupQueryResult<OcContractReDaDomain> queryOrderPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        Integer startRow = (Integer)map.get("startRow");
        Integer rows = (Integer)map.get("rows");
        map.put("startRow", (startRow - 1) * rows);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<OcContractReDaDomain> orderReDomains = this.ocContractMapper.queryOrderPage(map);
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        Integer totalPage = this.ocContractMapper.getTotalPage(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        return list;
    }

    @Override
    public OcContractStatistics orderTotalStatistics(Map<String, Object> map) {
        this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String memberCcode = (String)map.get("memberCcode");
        String memberGcode = (String)map.get("memberGcode");
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)memberGcode)) {
            return null;
        }
        return this.ocContractMapper.orderTotalStatistics(map);
    }

    @Override
    public List<ExportOrderDomain> exportOrder(Map<String, Object> map) {
        String memberCcode = (String)map.get("memberCcode");
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        this.logger.info("----------------\u5bfc\u51fa\u4e0b\u8f7d---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<ExportOrderDomain> exportOrderDomains = this.ocContractMapper.exportOrder(map);
        List<ExportOrderDomain> exportRefundOrderDomains = this.ocContractMapper.exportRefundOrder(map);
        exportOrderDomains.addAll(exportRefundOrderDomains);
        this.logger.info("----------------\u6253\u5370\u53c2\u6570---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(exportOrderDomains));
        return exportOrderDomains;
    }

    @Override
    public SupQueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        Integer totalPage = this.ocContractMapper.count(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        List<OcContract> orderReDomains = this.ocContractMapper.query(map);
        for (OcContract oc : orderReDomains) {
            map.clear();
            map.put("contractBillcode", oc.getContractBillcode());
            map.put("tenantCode", oc.getTenantCode());
            List<OcContractGoods> goodslist = this.ocContractGoodsMapper.query(map);
            oc.setGoodsList(goodslist);
        }
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        return list;
    }

    @Override
    public void syOrderTemp(Map<String, Object> map) {
        this.logger.info("\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<OcContractTempDomain> ocContractTempDomains = this.ocContractTempMapper.querySyContractTemp(map);
        this.logger.info("\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocContractTempDomains));
        if (!CollectionUtils.isEmpty(ocContractTempDomains)) {
            this.ocContractTempMapper.insertBatch(ocContractTempDomains);
        }
    }

    @Override
    public void saveOrderTime() {
        List<SphContractDomain> sphContractDomain = this.ocContractMapper.queryOrderOpenId();
        for (SphContractDomain contractDomain : sphContractDomain) {
            this.logger.info("\u67e5\u8be2\u7684\u6570\u636e\u5e93", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
            String contractBillCode = contractDomain.getContractBillCode();
            String openid = contractDomain.getOpenid();
            if (StringUtils.isBlank((String)contractBillCode) || StringUtils.isBlank((String)openid)) continue;
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            SphContractDto sphContractDto = new SphContractDto();
            sphContractDto.setOut_order_id(contractBillCode);
            sphContractDto.setOpenid(openid);
            String sphContractJson = JsonUtil.buildNonDefaultBinder().toJson((Object)sphContractDto);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
            SphQueryOrderDomain sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            if (sphQueryOrderDomain.getErrcode() == 42001L || sphQueryOrderDomain.getErrcode() == 40001L) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
                sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            } else if (sphQueryOrderDomain.getErrcode() != 0L) continue;
            String pay_time = sphQueryOrderDomain.getOrder().getOrder_detail().getPay_info().getPay_time();
            if (StringUtils.isNotBlank((String)pay_time)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("contractBillCode", contractBillCode);
                hashMap.put("payTime", pay_time);
                this.ocContractMapper.updateOrderTime(hashMap);
            }
            if (sphQueryOrderDomain.getOrder() == null || sphQueryOrderDomain.getOrder().getRefund_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list())) continue;
            List<RefundListDomain> refund_list = sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list();
            if (sphQueryOrderDomain.getOrder().getRelated_aftersale_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list())) continue;
            List<AftersaleList> aftersale_list = sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list();
            if (CollectionUtils.isEmpty(refund_list)) continue;
            for (RefundListDomain refundListDomain : refund_list) {
                if (refundListDomain == null || StringUtils.isBlank((String)refundListDomain.getFinish_time())) continue;
                String finish_time = refundListDomain.getFinish_time();
                if (refundListDomain.getAmount() == null) continue;
                double amount = (double)refundListDomain.getAmount().longValue() / 100.0;
                if (!StringUtils.isNotBlank((String)finish_time)) continue;
                Long refund_no = Long.valueOf(refundListDomain.getRefund_no().substring(6, refundListDomain.getRefund_no().length()));
                for (AftersaleList aftersaleList : aftersale_list) {
                    if (!aftersaleList.getAftersale_id().equals(refund_no) || aftersaleList.getVersion() != 3) continue;
                    HashMap<String, Object> orderTime = new HashMap<String, Object>();
                    String aftersale_id = aftersaleList.getAftersale_id().toString();
                    orderTime.put("refundBillCode", aftersale_id);
                    orderTime.put("refundTime", finish_time);
                    orderTime.put("amount", amount);
                    this.ocContractMapper.updateRefundTime(orderTime);
                }
            }
        }
    }

    private String token(String channelCode) {
        String ridsToken = DisUtil.get((String)("token" + channelCode));
        if (StringUtils.isNotBlank((String)ridsToken)) {
            return ridsToken;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("B2Cchannel", "grant_type=client_credential&appid=wx7f02a34d666f4eb5&secret=5a7d1b49c76f79cbd1c640449f0fed66");
        if (hashMap.containsKey(channelCode)) {
            String accessToken = null;
            try {
                String param = (String)hashMap.get(channelCode);
                String token = HttpRequest.sendGet("https://api.weixin.qq.com/cgi-bin/token", param);
                Map map = (Map)JSONObject.parseObject((String)token, Map.class);
                accessToken = map.get("access_token").toString();
            }
            catch (Exception e) {
                throw new ApiException("\u7b2c\u4e00\u6b21token\u83b7\u53d6\u5931\u8d25");
            }
            DisUtil.set((String)("token" + channelCode), (String)accessToken, (int)7000);
            return accessToken;
        }
        return null;
    }

    private String twoToken(String channelCode) {
        String ridsToken = DisUtil.get((String)("token" + channelCode));
        if (StringUtils.isNotBlank((String)ridsToken)) {
            DisUtil.del((String)("token" + channelCode));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("B2Cchannel", "grant_type=client_credential&appid=wx7f02a34d666f4eb5&secret=5a7d1b49c76f79cbd1c640449f0fed66");
        if (hashMap.containsKey(channelCode)) {
            String accessToken = null;
            try {
                String param = (String)hashMap.get(channelCode);
                String token = HttpRequest.sendGet("https://api.weixin.qq.com/cgi-bin/token", param);
                Map map = (Map)JSONObject.parseObject((String)token, Map.class);
                accessToken = map.get("access_token").toString();
            }
            catch (Exception e) {
                throw new ApiException("token\u83b7\u53d6\u5931\u8d25");
            }
            DisUtil.set((String)("token" + channelCode), (String)accessToken, (int)7000);
            this.logger.info("\u83b7\u53d6token2____", (Object)accessToken);
            return accessToken;
        }
        return null;
    }

    @Override
    public void saveChargeBack() {
        AfterDomain afterDomain;
        Boolean has_more;
        String channelCode = "B2Cchannel";
        int i = 0;
        ArrayList<String> listAll = new ArrayList<String>();
        do {
            List<String> after_sales_orders;
            AfterMarketDomain afterMarketDomain = new AfterMarketDomain();
            afterMarketDomain.setOffset(i);
            this.logger.info("\u5faa\u73af\u6b21\u6570 ", (Object)i);
            ++i;
            afterMarketDomain.setLimit(50);
            afterMarketDomain.setStatus(2);
            String toJson = JsonUtil.buildNonDefaultBinder().toJson((Object)afterMarketDomain);
            String token = this.token(channelCode);
            String sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=" + token, toJson);
            afterDomain = (AfterDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, AfterDomain.class);
            if (afterDomain.getErrcode() == 42001 || afterDomain.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=" + token, toJson);
                afterDomain = (AfterDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, AfterDomain.class);
            }
            if (CollectionUtils.isEmpty(after_sales_orders = afterDomain.getAfter_sales_orders())) continue;
            listAll.addAll(after_sales_orders);
        } while (!(has_more = afterDomain.getHas_more()).equals(false));
        List<String> queryChargeBackList = this.ocContractMapper.queryChargeBack();
        this.logger.info("\u89c6\u6570\u636e\u5e93\u9000\u5355\u5217\u8868", (Object)JsonUtil.buildNormalBinder().toJson(queryChargeBackList));
        listAll.removeAll(queryChargeBackList);
        this.logger.info("\u603b\u9000\u5355\u5217\u8868", (Object)JsonUtil.buildNormalBinder().toJson(listAll));
        if (CollectionUtils.isEmpty(listAll)) {
            throw new ApiException("\u6ca1\u6709\u8981\u62c9\u7684\u9000\u5355");
        }
        for (String aftersaleId : listAll) {
            AfterSaleIdDimaon afterSaleIdDimaon = new AfterSaleIdDimaon();
            if (StringUtils.isBlank((String)aftersaleId)) continue;
            afterSaleIdDimaon.setAftersale_id(Long.valueOf(aftersaleId));
            String toJson = JsonUtil.buildNonDefaultBinder().toJson((Object)afterSaleIdDimaon);
            String token = this.token(channelCode);
            String sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get?access_token=" + token, toJson);
            ChargeBackDomian jsonChargeBack = (ChargeBackDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, ChargeBackDomian.class);
            if (jsonChargeBack.getErrcode() == 42001 || jsonChargeBack.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get?access_token=" + token, toJson);
                jsonChargeBack = (ChargeBackDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, ChargeBackDomian.class);
            }
            if (jsonChargeBack.getErrcode() != 0) continue;
            String out_order_id = jsonChargeBack.getAfter_sales_order().getOut_order_id();
            this.logger.info("\u8ba2\u5355\u53f7", (Object)out_order_id);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("out_order_id", out_order_id);
            String queryRefund = this.ocContractMapper.queryRefund(map);
            if (StringUtils.isBlank((String)queryRefund)) continue;
            String queryOrderPrice = this.ocContractMapper.queryOrderPrice(map);
            double aDouble = Double.valueOf(queryOrderPrice) * 100.0;
            this.logger.info("\u6570\u636e\u5e93\u7684\u8ba2\u5355\u91d1\u989d", (Object)queryOrderPrice);
            Integer orderamt = jsonChargeBack.getAfter_sales_order().getOrderamt();
            if (aDouble != (double)orderamt.intValue()) continue;
            this.logger.info("\u67e5\u8be2\u7684\u5546\u54c1\u7f16\u7801", (Object)queryRefund);
            ArrayList<OcRefundGoodsBeanList> list = new ArrayList<OcRefundGoodsBeanList>();
            SaveRefundDomian saveRefundDomian = new SaveRefundDomian();
            OcRefundGoodsBeanList ocRefundGoodsBeanList = new OcRefundGoodsBeanList();
            ocRefundGoodsBeanList.setContractGoodsCode(queryRefund);
            BigDecimal bigDecimal = new BigDecimal(jsonChargeBack.getAfter_sales_order().getProduct_info().getProduct_cnt());
            ocRefundGoodsBeanList.setGoodsCamount(bigDecimal);
            ocRefundGoodsBeanList.setRefundGoodsNum(bigDecimal);
            BigDecimal decimal = new BigDecimal((double)jsonChargeBack.getAfter_sales_order().getOrderamt().intValue() / 100.0).setScale(2, RoundingMode.HALF_UP);
            ocRefundGoodsBeanList.setRefundGoodsAmt(decimal);
            list.add(ocRefundGoodsBeanList);
            saveRefundDomian.setOcRefundGoodsBeanList(list);
            saveRefundDomian.setContractBillcode(out_order_id);
            saveRefundDomian.setRefundMoney(decimal);
            saveRefundDomian.setRefundEx(jsonChargeBack.getAfter_sales_order().getRefund_reason());
            saveRefundDomian.setRefundMeo("");
            List<MediaDomian> media_list = jsonChargeBack.getAfter_sales_order().getMedia_list();
            if (!CollectionUtils.isEmpty(media_list)) {
                ArrayList<String> objects = new ArrayList<String>();
                for (MediaDomian mediaDomian : media_list) {
                    String url = mediaDomian.getUrl();
                    objects.add(url);
                }
                saveRefundDomian.setOcRefundFileDomainList(objects);
            } else {
                saveRefundDomian.setOcRefundFileDomainList(null);
            }
            if (jsonChargeBack.getAfter_sales_order().getType() == 1) {
                saveRefundDomian.setRefundType("B01");
            } else {
                saveRefundDomian.setRefundType("B02");
            }
            String params = JsonUtil.buildNonDefaultBinder().toJson((Object)saveRefundDomian);
            this.logger.info("\u5f00\u59cb\u751f\u6210\u5c0f\u7a0b\u5e8f\u9000\u5355\u5355\u7684\u53c2\u6570", (Object)params);
            Long order_id = jsonChargeBack.getAfter_sales_order().getOrder_id();
            String saveRefund = this.saveRefund(params, RefundType.USER.getCode(), aftersaleId, order_id);
            this.logger.info("\u9000\u5355\u8fd4\u56de\u7684\u9000\u5355\u53f7", (Object)saveRefund);
        }
    }

    private String saveRefund(String params, String refundUsertype, String aftersaleId, Long order_id) {
        if (null == params) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            throw new ApiException("\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error(CODE + ".saveRefund", (Object)"param is null");
            throw new ApiException("\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error(CODE + ".saveRefund.refundMoney", (Object)"refundMoney is null");
            throw new ApiException("refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.saasTenantcode);
        OcContractReDomain ocContractReDomain = this.getContractByCode(map);
        if (ocRefundBean.getRefundMoney().compareTo(ocContractReDomain.getDataBmoney().setScale(2, 4)) == 1) {
            throw new ApiException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        if (ocRefundBean.getRefundMoney().compareTo(BigDecimal.ZERO) < 0) {
            throw new ApiException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".ocContractDomain.ex", (Throwable)e);
            throw new ApiException(CODE + ".ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            ocRefundDomain.setRefundOcode(order_id.toString());
            ocRefundDomain.setRefundZip(aftersaleId);
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveRefund.ex", (Throwable)e);
            throw new ApiException(CODE + ".saveRefund.ex", e.getMessage());
        }
        if ("2020091500000001".equals(ocContractReDomain.getTenantCode()) && 2 != ocContractReDomain.getDataState()) {
            ocRefundDomain.setRefundType("B02");
        }
        this.logger.info("\u6253\u5370\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
        return this.sendSaveRefund(ocRefundDomain);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsList(List<OcRefundGoodsBean> ocRefundGoodsList, OcContractDomain ocContractDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error(CODE + ".makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        Map<String, List<OcContractPmGoodsReDomain>> contractGoodsPmMap = null;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractDomain.getGoodsList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("contractBillcode", ocContractDomain.getContractBillcode());
        SupQueryResult ocContractPmGoodsReDomainSupQueryResult = this.queryContractPmGoodsPage(map);
        if (ListUtil.isNotEmpty((Collection)ocContractPmGoodsReDomainSupQueryResult.getList())) {
            contractGoodsPmMap = this.contractPmGoodsMap(ocContractPmGoodsReDomainSupQueryResult.getList());
        }
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList;
            String custrelCode = refundGoodsList.getCustrelCode();
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == ocContractGoods) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null != refundGoodsList.getSkuNo() && null != ocContractGoods.getSkuNo() && !refundGoodsList.getSkuNo().equals(ocContractGoods.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), ocContractDomain.getMemberCode(), ocContractDomain.getMemberCcode(), ocContractDomain.getChannelCode(), ocContractDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null != refundGoodsList.getGoodsCamount() && !OrderServiceImpl.isIntegerValue(refundGoodsList.getGoodsCamount())) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u5c0f\u6570");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            refundGoodsDomain.setGoodsProperty5(custrelCode);
            if (StringUtils.isNotBlank((String)refundGoodsList.getSkuNo())) {
                refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
                refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
                refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
                refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            }
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum(), 2, 0).setScale(2, 4);
            if (MapUtil.isNotEmpty(contractGoodsPmMap) && ListUtil.isNotEmpty(ocContractPmGoodsReDomainList = contractGoodsPmMap.get(refundGoodsList.getContractGoodsCode()))) {
                ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList1 = new ArrayList<OcContractPmGoodsReDomain>();
                for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
                    if (null == ocContractGoods.getContractGoodsRefnum()) {
                        ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    BigDecimal sumStr = refundGoodsDomain.getRefundGoodsNum().add(ocContractGoods.getContractGoodsRefnum());
                    BigDecimal sum = BigDecimal.ZERO;
                    if (sumStr.compareTo(ocContractGoods.getGoodsCamount()) == 0) {
                        BigDecimal sum2;
                        BigDecimal sum1 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(ocContractGoods.getContractGoodsRefnum()).setScale(2, 5);
                        sum = sum2 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().subtract(sum1);
                    } else {
                        sum = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(refundGoodsDomain.getRefundGoodsNum()).setScale(2, 5);
                    }
                    ocContractPmGoodsReDomain.setContractPmgoodsRepmoney(sum);
                    ocContractPmGoodsReDomain.setContractGoodsRefnum(refundGoodsDomain.getRefundGoodsNum());
                    ocContractPmGoodsReDomainList1.add(ocContractPmGoodsReDomain);
                }
                List<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = this.ocRefundPmGoods(ocContractPmGoodsReDomainList1);
                refundGoodsDomain.setOcRefundPmGoodsDomainList(ocRefundPmGoodsDomainList);
            }
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        this.logger.info("\u6253\u5370ocRefundGoodsDomainList\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocRefundGoodsDomainList));
        return ocRefundGoodsDomainList;
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error(CODE + ".contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    public List<OcRefundPmGoodsDomain> ocRefundPmGoods(List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList) {
        if (ListUtil.isEmpty(ocContractPmGoodsReDomainList)) {
            this.logger.error(CODE + ".ocRefundPmGoods", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = new ArrayList<OcRefundPmGoodsDomain>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
            OcRefundPmGoodsDomain ocRefundPmGoodsDomain = new OcRefundPmGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundPmGoodsDomain, (Object)ocContractPmGoodsReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                return null;
            }
            ocRefundPmGoodsDomain.setRefundPmgoodsRepmoney(ocContractPmGoodsReDomain.getContractPmgoodsRepmoney());
            ocRefundPmGoodsDomainList.add(ocRefundPmGoodsDomain);
        }
        return ocRefundPmGoodsDomainList;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    public Map<String, List<OcContractPmGoodsReDomain>> contractPmGoodsMap(List<OcContractPmGoodsReDomain> goodsPmList) {
        if (ListUtil.isEmpty(goodsPmList)) {
            this.logger.error(CODE + ".contractPmGoodsMap", (Object)"param is null");
            return null;
        }
        HashMap<String, List<OcContractPmGoodsReDomain>> map = new HashMap<String, List<OcContractPmGoodsReDomain>>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : goodsPmList) {
            if (!StringUtils.isNotBlank((String)ocContractPmGoodsReDomain.getContractGoodsCode())) continue;
            ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList = (ArrayList<OcContractPmGoodsReDomain>)map.get(ocContractPmGoodsReDomain.getContractGoodsCode());
            if (null == ocContractPmGoodsReDomainList) {
                ocContractPmGoodsReDomainList = new ArrayList<OcContractPmGoodsReDomain>();
                map.put(ocContractPmGoodsReDomain.getContractGoodsCode(), ocContractPmGoodsReDomainList);
            }
            ocContractPmGoodsReDomainList.add(ocContractPmGoodsReDomain);
        }
        return map;
    }

    public OcContractReDomain getContractByCode(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.contract.getContractByCode", pmap);
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)result, OcContractReDomain.class);
        return ocContractReDomain;
    }

    public String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        Object result = this.getInternalRouter().inInvoke("oc.refundEngine.sendSaveRefund", pmap);
        return result.toString();
    }

    public SupQueryResult queryContractPmGoodsPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.ContractPmGoods.queryContractPmGoodsPage", pmap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject((String)result, SupQueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractPmGoodsReDomain.class);
        supQueryResult.setList(list);
        return supQueryResult;
    }

    public RsSkuReDomain getChannelSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("skuNo", skuNo);
        pmap.put("memberCode", memberCode);
        pmap.put("memberCcode", memberCcode);
        pmap.put("channelCode", channelCode);
        pmap.put("tenantCode", tenantCode);
        Object result = this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", pmap);
        RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)result, RsSkuReDomain.class);
        return rsSkuReDomain;
    }

    @Override
    public void saveRefund() {
        List<SphContractDomain> sphContractDomain = this.ocContractMapper.queryOrder();
        for (SphContractDomain contractDomain : sphContractDomain) {
            this.logger.info("\u67e5\u8be2\u7684\u6570\u636e\u5e93", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
            String contractBillCode = contractDomain.getContractBillCode();
            String openid = contractDomain.getOpenid();
            if (StringUtils.isBlank((String)contractBillCode) || StringUtils.isBlank((String)openid)) continue;
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            SphContractDto sphContractDto = new SphContractDto();
            sphContractDto.setOut_order_id(contractBillCode);
            sphContractDto.setOpenid(openid);
            String sphContractJson = JsonUtil.buildNonDefaultBinder().toJson((Object)sphContractDto);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
            SphQueryOrderDomain sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            if (sphQueryOrderDomain.getErrcode() == 42001L || sphQueryOrderDomain.getErrcode() == 40001L) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
                sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            } else if (sphQueryOrderDomain.getErrcode() != 0L) {
                throw new ApiException(sphQueryOrderDomain.getErrmsg());
            }
            String pay_time = sphQueryOrderDomain.getOrder().getOrder_detail().getPay_info().getPay_time();
            if (StringUtils.isNotBlank((String)pay_time)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("contractBillCode", contractBillCode);
                hashMap.put("payTime", pay_time);
                this.ocContractMapper.updateOrderTime(hashMap);
            }
            this.logger.info("\u9000\u5355\u53c2\u6570", (Object)JsonUtil.buildNormalBinder().toJson((Object)sphQueryOrderDomain));
            if (sphQueryOrderDomain.getOrder() == null || sphQueryOrderDomain.getOrder().getRefund_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list())) continue;
            List<RefundListDomain> refund_list = sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list();
            if (sphQueryOrderDomain.getOrder().getRelated_aftersale_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list())) continue;
            List<AftersaleList> aftersale_list = sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list();
            if (CollectionUtils.isEmpty(refund_list)) continue;
            for (RefundListDomain refundListDomain : refund_list) {
                if (refundListDomain == null || StringUtils.isBlank((String)refundListDomain.getFinish_time())) continue;
                String finish_time = refundListDomain.getFinish_time();
                if (refundListDomain.getAmount() == null) continue;
                double amount = (double)refundListDomain.getAmount().longValue() / 100.0;
                if (!StringUtils.isNotBlank((String)finish_time)) continue;
                Long refund_no = Long.valueOf(refundListDomain.getRefund_no().substring(6, refundListDomain.getRefund_no().length()));
                for (AftersaleList aftersaleList : aftersale_list) {
                    if (!aftersaleList.getAftersale_id().equals(refund_no) || aftersaleList.getVersion() != 3) continue;
                    HashMap<String, Object> orderTime = new HashMap<String, Object>();
                    String aftersale_id = aftersaleList.getAftersale_id().toString();
                    orderTime.put("refundBillCode", aftersale_id);
                    orderTime.put("refundTime", finish_time);
                    orderTime.put("amount", amount);
                    this.logger.info("map\u7684\u503c", (Object)JsonUtil.buildNormalBinder().toJson(orderTime));
                    this.ocContractMapper.updateRefundTime(orderTime);
                }
            }
        }
    }
}

