/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.yqbsoft.laser.service.da.dao.ReSourceGoodsMapper;
import com.yqbsoft.laser.service.da.dao.RsResourceGoodsMapper;
import com.yqbsoft.laser.service.da.dao.RsSkuMapper;
import com.yqbsoft.laser.service.da.domain.ReSourceGoodsDomian;
import com.yqbsoft.laser.service.da.domain.rs.RsResourceGoods;
import com.yqbsoft.laser.service.da.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.da.domain.rs.RsSku;
import com.yqbsoft.laser.service.da.service.ReSourceGoodsService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ReSourceGoodsServiceImpl
extends BaseServiceImpl
implements ReSourceGoodsService {
    @Autowired
    private ReSourceGoodsMapper reSourceGoodsMapper;
    @Autowired
    private RsResourceGoodsMapper rsResourceGoodsMapper;
    @Autowired
    private RsSkuMapper rsSkuMapper;

    @Override
    public List<ReSourceGoodsDomian> exportGoods(Map<String, Object> map) {
        return this.reSourceGoodsMapper.exportGoods(map);
    }

    @Override
    public QueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(Map<String, Object> map) {
        List<RsResourceGoods> rsResourceGoodsList = this.queryResourceGoodsModelPage(map);
        List<RsResourceGoodsReDomain> rsResourceGoodsReDomainList = this.querySkuByGoodsCode(rsResourceGoodsList, map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countResourceGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsResourceGoodsReDomainList);
        return queryResult;
    }

    private int countResourceGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsResourceGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(".countResourceGoods", (Object)map.toString(), (Throwable)e);
        }
        return i;
    }

    private List<RsResourceGoods> queryResourceGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsResourceGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(".queryResourceGoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<RsResourceGoodsReDomain> querySkuByGoodsCode(List<RsResourceGoods> rsResourceGoodsList, Map<String, Object> map) {
        ArrayList<RsResourceGoodsReDomain> rsResourceGoodsReDomainList = new ArrayList<RsResourceGoodsReDomain>();
        if (rsResourceGoodsList == null || rsResourceGoodsList.isEmpty()) {
            return rsResourceGoodsReDomainList;
        }
        for (RsResourceGoods rsResourceGoods : rsResourceGoodsList) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.makeReDomian(rsResourceGoods);
            rsResourceGoodsReDomainList.add(rsResourceGoodsReDomain);
            if (map.get("children") == null) continue;
            List<RsSku> skuList = this.querySkuByGoodsCode(rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
            rsResourceGoodsReDomain.setSkuList(skuList);
        }
        return rsResourceGoodsReDomainList;
    }

    public List<RsSku> querySkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        return this.querySkuModelPage(map);
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(".querySkuModel", (Throwable)e);
            return null;
        }
    }

    private RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsResourceGoodsReDomain;
    }
}

