/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.da.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.dao.OcContractTempMapper;
import com.yqbsoft.laser.service.da.domain.AfterDomain;
import com.yqbsoft.laser.service.da.domain.AfterMarketDomain;
import com.yqbsoft.laser.service.da.domain.AfterSaleIdDimaon;
import com.yqbsoft.laser.service.da.domain.AftersaleList;
import com.yqbsoft.laser.service.da.domain.ChargeBackDomian;
import com.yqbsoft.laser.service.da.domain.ExportOrderDomain;
import com.yqbsoft.laser.service.da.domain.Funds;
import com.yqbsoft.laser.service.da.domain.FundsFlow;
import com.yqbsoft.laser.service.da.domain.LogisticsDomian;
import com.yqbsoft.laser.service.da.domain.OcContract;
import com.yqbsoft.laser.service.da.domain.OcContractDomain;
import com.yqbsoft.laser.service.da.domain.OcContractGoods;
import com.yqbsoft.laser.service.da.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.da.domain.OcContractPmGoodsReDomain;
import com.yqbsoft.laser.service.da.domain.OcContractReDaDomain;
import com.yqbsoft.laser.service.da.domain.OcContractReDomain;
import com.yqbsoft.laser.service.da.domain.OcContractStatistics;
import com.yqbsoft.laser.service.da.domain.OcContractTempDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundBean;
import com.yqbsoft.laser.service.da.domain.OcRefundDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundGoodsBean;
import com.yqbsoft.laser.service.da.domain.OcRefundGoodsBeanList;
import com.yqbsoft.laser.service.da.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundPmGoodsDomain;
import com.yqbsoft.laser.service.da.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.da.domain.RefundListDomain;
import com.yqbsoft.laser.service.da.domain.RefundType;
import com.yqbsoft.laser.service.da.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.da.domain.Running;
import com.yqbsoft.laser.service.da.domain.RunningDomian;
import com.yqbsoft.laser.service.da.domain.SaveRefundDomian;
import com.yqbsoft.laser.service.da.domain.SphContractDomain;
import com.yqbsoft.laser.service.da.domain.SphContractDto;
import com.yqbsoft.laser.service.da.domain.SphLogisticsDomian;
import com.yqbsoft.laser.service.da.domain.SphOrderDomian;
import com.yqbsoft.laser.service.da.domain.SphQueryOrderDomain;
import com.yqbsoft.laser.service.da.service.OrderService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.util.HttpRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static String CODE = "oc.refund.con";
    private final String urlToken = "https://api.weixin.qq.com/cgi-bin/token";
    private final String urlQueryOrder = "https://api.weixin.qq.com/shop/order/get?access_token=";
    private final String urlQueryChargeBackList = "https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=";
    private final String urlQueryChargeBack = "https://api.weixin.qq.com/shop/ecaftersale/get?access_token=";
    private final String urlRefund = "https://api.weixin.qq.com/shop/ecaftersale/get?access_token=";
    private final String urlRunning = "https://api.weixin.qq.com/shop/funds/getorderflow?access_token=";
    private final String urlRunningList = "https://api.weixin.qq.com/shop/funds/scanorderflow?access_token=";
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractTempMapper ocContractTempMapper;
    String saasTenantcode = "2022012800000001";

    @Override
    public SupQueryResult<OcContractReDaDomain> queryOrderPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        Integer startRow = (Integer)map.get("startRow");
        Integer rows = (Integer)map.get("rows");
        map.put("startRow", (startRow - 1) * rows);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<OcContractReDaDomain> orderReDomains = this.ocContractMapper.queryOrderPage(map);
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        Integer totalPage = this.ocContractMapper.getTotalPage(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        return list;
    }

    @Override
    public OcContractStatistics orderTotalStatistics(Map<String, Object> map) {
        this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String memberCcode = (String)map.get("memberCcode");
        String memberGcode = (String)map.get("memberGcode");
        if (StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)memberGcode)) {
            return null;
        }
        return this.ocContractMapper.orderTotalStatistics(map);
    }

    @Override
    public List<ExportOrderDomain> exportOrder(Map<String, Object> map) {
        String memberCcode = (String)map.get("memberCcode");
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        this.logger.info("----------------\u5bfc\u51fa\u4e0b\u8f7d---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<ExportOrderDomain> exportOrderDomains = this.ocContractMapper.exportOrder(map);
        List<ExportOrderDomain> exportRefundOrderDomains = this.ocContractMapper.exportRefundOrder(map);
        if (!CollectionUtils.isEmpty(exportRefundOrderDomains)) {
            exportOrderDomains.addAll(exportRefundOrderDomains);
        }
        this.logger.info("----------------\u6253\u5370\u53c2\u6570---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(exportOrderDomains));
        return exportOrderDomains;
    }

    @Override
    public List<ExportOrderDomain> exportOutlineOrder(Map<String, Object> map) {
        String memberCcode = (String)map.get("memberCcode");
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        this.logger.info("----------------\u6982\u8981\u8ba2\u5355\u5bfc\u51fa\u8bf7\u6c42\u53c2\u6570---------------:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        List<ExportOrderDomain> exportOrderDomains = this.ocContractMapper.exportOutlineOrder(map);
        List<ExportOrderDomain> exportRefundOrderDomains = this.ocContractMapper.exportRefundOrder(map);
        if (!CollectionUtils.isEmpty(exportRefundOrderDomains)) {
            exportOrderDomains.addAll(exportRefundOrderDomains);
        }
        return exportOrderDomains;
    }

    @Override
    public SupQueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        SupQueryResult list = new SupQueryResult();
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u6570\u636e:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        Integer totalPage = this.ocContractMapper.count(map);
        this.logger.info("\u603b\u6761\u6570\uff1a{}", (Object)totalPage);
        list.setTotal((long)totalPage.intValue());
        List<OcContract> orderReDomains = this.ocContractMapper.query(map);
        for (OcContract oc : orderReDomains) {
            map.clear();
            map.put("contractBillcode", oc.getContractBillcode());
            map.put("tenantCode", oc.getTenantCode());
            List<OcContractGoods> goodslist = this.ocContractGoodsMapper.query(map);
            oc.setGoodsList(goodslist);
        }
        this.logger.info("\u67e5\u8be2\u7684\u8ba2\u5355\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderReDomains.size()));
        list.setRows(orderReDomains);
        list.setList(orderReDomains);
        return list;
    }

    @Override
    public void syOrderTemp(Map<String, Object> map) {
        if (map == null) {
            this.logger.info("---------------------");
            map = new HashMap<String, Object>();
        }
        Long contractCount = this.ocContractTempMapper.querySyContractCount(map);
        this.logger.info("\u83b7\u53d6\u7684\u8ba2\u5355\u6570\u91cfcontractCount:{}", (Object)contractCount);
        int page = 0;
        int rows = 10;
        if (contractCount != null && contractCount != 0L) {
            while ((long)(page * rows) < contractCount) {
                map.put("page", page * rows);
                map.put("rows", rows);
                this.logger.info("\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
                List<OcContractTempDomain> ocContractTempDomains = this.ocContractTempMapper.querySyContractTemp(map);
                this.logger.info("\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocContractTempDomains));
                if (!CollectionUtils.isEmpty(ocContractTempDomains)) {
                    this.ocContractTempMapper.insertBatch(ocContractTempDomains);
                }
                ++page;
            }
        }
    }

    @Override
    public void nodeUpdateOrSyncContract(String contractBillcode) {
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u7684\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)contractBillcode));
        if (contractBillcode == null) {
            this.logger.info("\u72b6\u6001\u4e3a\u7a7a");
            return;
        }
        Integer dataState = this.ocContractMapper.getOcContractStateByContractBbillcode(contractBillcode);
        if (dataState != null && dataState == 5) {
            this.ocContractTempMapper.updateComplete("5", "\u4ea4\u6613\u6210\u529f", new Date(), contractBillcode);
            return;
        }
        this.ocContractTempMapper.deleteByContractBbillcode(contractBillcode);
        List<OcContractTempDomain> ocContractTempDomains = this.ocContractTempMapper.getSyContractTemp(contractBillcode);
        if (!CollectionUtils.isEmpty(ocContractTempDomains)) {
            int n = this.ocContractTempMapper.insertBatch(ocContractTempDomains);
        }
    }

    @Override
    public void nodeSyncRefundContract(String refundCode) {
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u7684\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)refundCode));
        if (refundCode == null) {
            this.logger.info("\u72b6\u6001\u4e3a\u7a7a");
            return;
        }
        this.ocContractTempMapper.deleteByRefundcode(refundCode);
        List<OcContractTempDomain> ocContractTempDomains = this.ocContractTempMapper.getSyRefundTemp(refundCode);
        if (!CollectionUtils.isEmpty(ocContractTempDomains)) {
            int n = this.ocContractTempMapper.insertBatch(ocContractTempDomains);
        }
    }

    @Override
    public void saveOrderTime() {
        List<SphContractDomain> sphContractDomain = this.ocContractMapper.queryOrderOpenId();
        for (SphContractDomain contractDomain : sphContractDomain) {
            HashMap<String, Object> hashMap;
            this.logger.info("\u67e5\u8be2\u7684\u6570\u636e\u5e93", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
            String contractBillCode = contractDomain.getContractBillCode();
            String openid = contractDomain.getOpenid();
            if (StringUtils.isBlank((String)contractBillCode) || StringUtils.isBlank((String)openid)) continue;
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            SphContractDto sphContractDto = new SphContractDto();
            sphContractDto.setOut_order_id(contractBillCode);
            sphContractDto.setOpenid(openid);
            String sphContractJson = JsonUtil.buildNonDefaultBinder().toJson((Object)sphContractDto);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
            SphQueryOrderDomain sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            if (sphQueryOrderDomain.getErrcode() == 42001L || sphQueryOrderDomain.getErrcode() == 40001L) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
                sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            } else if (sphQueryOrderDomain.getErrcode() != 0L) {
                this.logger.info(contractBillCode + "\u932f\u8aa4\u4fe1\u606f", (Object)sphQueryOrderDomain.getErrmsg());
                continue;
            }
            String pay_time = sphQueryOrderDomain.getOrder().getOrder_detail().getPay_info().getPay_time();
            if (StringUtils.isNotBlank((String)pay_time)) {
                hashMap = new HashMap<String, Object>();
                hashMap.put("contractBillCode", contractBillCode);
                hashMap.put("payTime", pay_time);
                this.ocContractMapper.updateOrderTime(hashMap);
            } else {
                hashMap = new HashMap();
                hashMap.put("contractBillCode", contractBillCode);
                this.ocContractMapper.updateTime(hashMap);
            }
            if (sphQueryOrderDomain.getOrder() == null || sphQueryOrderDomain.getOrder().getRefund_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list())) continue;
            List<RefundListDomain> refund_list = sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list();
            if (sphQueryOrderDomain.getOrder().getRelated_aftersale_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list())) continue;
            List<AftersaleList> aftersale_list = sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list();
            if (CollectionUtils.isEmpty(refund_list)) continue;
            for (RefundListDomain refundListDomain : refund_list) {
                if (refundListDomain == null || StringUtils.isBlank((String)refundListDomain.getFinish_time())) continue;
                String finish_time = refundListDomain.getFinish_time();
                if (refundListDomain.getAmount() == null) continue;
                double amount = (double)refundListDomain.getAmount().longValue() / 100.0;
                if (!StringUtils.isNotBlank((String)finish_time)) continue;
                Long refund_no = Long.valueOf(refundListDomain.getRefund_no().substring(6, refundListDomain.getRefund_no().length()));
                for (AftersaleList aftersaleList : aftersale_list) {
                    if (!aftersaleList.getAftersale_id().equals(refund_no) || aftersaleList.getVersion() != 3) continue;
                    HashMap<String, Object> orderTime = new HashMap<String, Object>();
                    String aftersale_id = aftersaleList.getAftersale_id().toString();
                    orderTime.put("refundBillCode", aftersale_id);
                    orderTime.put("refundTime", finish_time);
                    orderTime.put("amount", amount);
                    this.ocContractMapper.updateRefundTime(orderTime);
                }
            }
        }
    }

    private String token(String channelCode) {
        String queryAppId = this.secret(channelCode, "appid");
        String querySecret = this.secret(channelCode, "appid_secret");
        String ridsToken = DisUtil.get((String)(queryAppId + "-" + querySecret));
        if (StringUtils.isNotBlank((String)ridsToken)) {
            return ridsToken;
        }
        String accessToken = null;
        try {
            String token = HttpRequest.sendGet("https://api.weixin.qq.com/cgi-bin/token", "grant_type=client_credential&appid=" + queryAppId + "&secret=" + querySecret);
            Map map = (Map)JSONObject.parseObject((String)token, Map.class);
            accessToken = map.get("access_token").toString();
        }
        catch (Exception e) {
            throw new ApiException("\u7b2c\u4e00\u6b21token\u83b7\u53d6\u5931\u8d25");
        }
        DisUtil.set((String)(queryAppId + "-" + querySecret), (String)accessToken, (int)7000);
        return accessToken;
    }

    private String twoToken(String channelCode) {
        String queryAppId = this.secret(channelCode, "appid");
        String querySecret = this.secret(channelCode, "appid_secret");
        String ridsToken = DisUtil.get((String)(queryAppId + "-" + querySecret));
        if (StringUtils.isNotBlank((String)ridsToken)) {
            DisUtil.del((String)(queryAppId + "-" + querySecret));
        }
        String accessToken = null;
        try {
            String token = HttpRequest.sendGet("https://api.weixin.qq.com/cgi-bin/token", "grant_type=client_credential&appid=" + queryAppId + "&secret=" + querySecret);
            Map map = (Map)JSONObject.parseObject((String)token, Map.class);
            accessToken = map.get("access_token").toString();
        }
        catch (Exception e) {
            throw new ApiException("token\u83b7\u53d6\u5931\u8d25");
        }
        DisUtil.set((String)(queryAppId + "-" + querySecret), (String)accessToken, (int)7000);
        this.logger.info("\u83b7\u53d6token2____", (Object)accessToken);
        return accessToken;
    }

    public String querySecret(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("zyCdp.guide.querySecret", pmap);
        return result.toString();
    }

    private String secret(String channelCode, String appidSecret) {
        String querySecret = null;
        HashMap<String, Object> secret = new HashMap<String, Object>();
        if (channelCode.equals("B2Cchannel")) {
            secret.put("proappCode", "021");
            secret.put("types", appidSecret);
            querySecret = this.querySecret(secret);
            if (StringUtils.isBlank((String)querySecret)) {
                throw new ApiException("appid\u6216\u8005secret\u7a7a");
            }
        }
        return querySecret;
    }

    @Override
    public void saveChargeBack() {
        this.save(2);
    }

    private void save(Integer num) {
        AfterDomain afterDomain;
        Boolean has_more;
        String channelCode = "B2Cchannel";
        int i = 0;
        ArrayList<String> listAll = new ArrayList<String>();
        do {
            List<String> after_sales_orders;
            AfterMarketDomain afterMarketDomain = new AfterMarketDomain();
            afterMarketDomain.setOffset(i);
            this.logger.info("\u5faa\u73af\u6b21\u6570 ", (Object)i);
            ++i;
            afterMarketDomain.setLimit(50);
            afterMarketDomain.setStatus(num);
            String toJson = JsonUtil.buildNonDefaultBinder().toJson((Object)afterMarketDomain);
            String token = this.token(channelCode);
            String sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=" + token, toJson);
            afterDomain = (AfterDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, AfterDomain.class);
            if (afterDomain.getErrcode() == 42001 || afterDomain.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=" + token, toJson);
                afterDomain = (AfterDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, AfterDomain.class);
            }
            if (CollectionUtils.isEmpty(after_sales_orders = afterDomain.getAfter_sales_orders())) continue;
            listAll.addAll(after_sales_orders);
        } while (!(has_more = afterDomain.getHas_more()).equals(false));
        List<String> queryChargeBackList = this.ocContractMapper.queryChargeBack();
        this.logger.info("\u89c6\u6570\u636e\u5e93\u9000\u5355\u5217\u8868", (Object)JsonUtil.buildNormalBinder().toJson(queryChargeBackList));
        listAll.removeAll(queryChargeBackList);
        this.logger.info("\u603b\u9000\u5355\u5217\u8868", (Object)JsonUtil.buildNormalBinder().toJson(listAll));
        if (CollectionUtils.isEmpty(listAll)) {
            throw new ApiException("\u6ca1\u6709\u8981\u62c9\u7684\u9000\u5355");
        }
        for (String aftersaleId : listAll) {
            AfterSaleIdDimaon afterSaleIdDimaon = new AfterSaleIdDimaon();
            if (StringUtils.isBlank((String)aftersaleId)) continue;
            afterSaleIdDimaon.setAftersale_id(Long.valueOf(aftersaleId));
            String toJson = JsonUtil.buildNonDefaultBinder().toJson((Object)afterSaleIdDimaon);
            String token = this.token(channelCode);
            String sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get?access_token=" + token, toJson);
            ChargeBackDomian jsonChargeBack = (ChargeBackDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, ChargeBackDomian.class);
            if (jsonChargeBack.getErrcode() == 42001 || jsonChargeBack.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get?access_token=" + token, toJson);
                jsonChargeBack = (ChargeBackDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, ChargeBackDomian.class);
            }
            if (jsonChargeBack.getErrcode() != 0) continue;
            String out_order_id = jsonChargeBack.getAfter_sales_order().getOut_order_id();
            String out_product_id = jsonChargeBack.getAfter_sales_order().getProduct_info().getOut_product_id();
            String out_sku_id = jsonChargeBack.getAfter_sales_order().getProduct_info().getOut_sku_id();
            this.logger.info("\u8ba2\u5355\u53f7", (Object)out_order_id);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("out_order_id", out_order_id);
            map.put("out_product_id", out_product_id);
            map.put("out_sku_id", out_sku_id);
            String queryRefund = this.ocContractMapper.queryRefund(map);
            if (StringUtils.isBlank((String)queryRefund)) continue;
            this.logger.info("map111", (Object)JsonUtil.buildNormalBinder().toJson(map));
            String queryOrderPrice = this.ocContractMapper.queryOrderPrice(map);
            double aDouble = Double.valueOf(queryOrderPrice) * 100.0;
            this.logger.info("\u6570\u636e\u5e93\u7684\u8ba2\u5355\u91d1\u989d", (Object)queryOrderPrice);
            Integer orderamt = jsonChargeBack.getAfter_sales_order().getOrderamt();
            if (aDouble != (double)orderamt.intValue()) continue;
            this.logger.info("\u67e5\u8be2\u7684\u5546\u54c1\u7f16\u7801", (Object)queryRefund);
            ArrayList<OcRefundGoodsBeanList> list = new ArrayList<OcRefundGoodsBeanList>();
            SaveRefundDomian saveRefundDomian = new SaveRefundDomian();
            OcRefundGoodsBeanList ocRefundGoodsBeanList = new OcRefundGoodsBeanList();
            ocRefundGoodsBeanList.setContractGoodsCode(queryRefund);
            BigDecimal bigDecimal = new BigDecimal(jsonChargeBack.getAfter_sales_order().getProduct_info().getProduct_cnt());
            ocRefundGoodsBeanList.setGoodsCamount(bigDecimal);
            ocRefundGoodsBeanList.setRefundGoodsNum(bigDecimal);
            BigDecimal decimal = new BigDecimal((double)jsonChargeBack.getAfter_sales_order().getOrderamt().intValue() / 100.0).setScale(2, RoundingMode.HALF_UP);
            ocRefundGoodsBeanList.setRefundGoodsAmt(decimal);
            list.add(ocRefundGoodsBeanList);
            saveRefundDomian.setOcRefundGoodsBeanList(list);
            saveRefundDomian.setContractBillcode(out_order_id);
            saveRefundDomian.setRefundMoney(decimal);
            saveRefundDomian.setRefundEx(jsonChargeBack.getAfter_sales_order().getRefund_reason());
            saveRefundDomian.setRefundMeo("");
            saveRefundDomian.setOcRefundFileDomainList(null);
            if (jsonChargeBack.getAfter_sales_order().getType() == 1) {
                saveRefundDomian.setRefundType("B01");
            } else {
                saveRefundDomian.setRefundType("B02");
            }
            String params = JsonUtil.buildNonDefaultBinder().toJson((Object)saveRefundDomian);
            this.logger.info("\u5f00\u59cb\u751f\u6210\u5c0f\u7a0b\u5e8f\u9000\u5355\u5355\u7684\u53c2\u6570", (Object)params);
            Long order_id = jsonChargeBack.getAfter_sales_order().getOrder_id();
            String saveRefund = this.saveRefund(params, RefundType.USER.getCode(), aftersaleId, order_id);
            this.logger.info("\u9000\u5355\u8fd4\u56de\u7684\u9000\u5355\u53f7", (Object)saveRefund);
        }
    }

    private String saveRefund(String params, String refundUsertype, String aftersaleId, Long order_id) {
        if (null == params) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            throw new ApiException("\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error(CODE + ".saveRefund", (Object)"param is null");
            throw new ApiException("\u53c2\u6570\u4e3a\u7a7a");
        }
        if (null == ocRefundBean.getRefundMoney()) {
            this.logger.error(CODE + ".saveRefund.refundMoney", (Object)"refundMoney is null");
            throw new ApiException("refundMoney");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.saasTenantcode);
        OcContractReDomain ocContractReDomain = this.getContractByCode(map);
        if (ocRefundBean.getRefundMoney().compareTo(ocContractReDomain.getDataBmoney().setScale(2, 4)) == 1) {
            throw new ApiException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
        if (ocRefundBean.getRefundMoney().compareTo(BigDecimal.ZERO) < 0) {
            throw new ApiException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".ocContractDomain.ex", (Throwable)e);
            throw new ApiException(CODE + ".ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundUsertype(refundUsertype);
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
            ocRefundDomain.setDataStatestr("61");
            ocRefundDomain.setRefundOcode(order_id.toString());
            ocRefundDomain.setRefundZip(aftersaleId);
            if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveRefund.ex", (Throwable)e);
            throw new ApiException(CODE + ".saveRefund.ex", e.getMessage());
        }
        if ("2020091500000001".equals(ocContractReDomain.getTenantCode()) && 2 != ocContractReDomain.getDataState()) {
            ocRefundDomain.setRefundType("B02");
        }
        this.logger.info("\u6253\u5370\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
        return this.sendSaveRefund(ocRefundDomain);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsList(List<OcRefundGoodsBean> ocRefundGoodsList, OcContractDomain ocContractDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error(CODE + ".makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        Map<String, List<OcContractPmGoodsReDomain>> contractGoodsPmMap = null;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractDomain.getGoodsList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("contractBillcode", ocContractDomain.getContractBillcode());
        SupQueryResult ocContractPmGoodsReDomainSupQueryResult = this.queryContractPmGoodsPage(map);
        if (ListUtil.isNotEmpty((Collection)ocContractPmGoodsReDomainSupQueryResult.getList())) {
            contractGoodsPmMap = this.contractPmGoodsMap(ocContractPmGoodsReDomainSupQueryResult.getList());
        }
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList;
            String custrelCode = refundGoodsList.getCustrelCode();
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == ocContractGoods) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (null != refundGoodsList.getSkuNo() && null != ocContractGoods.getSkuNo() && !refundGoodsList.getSkuNo().equals(ocContractGoods.getSkuNo())) {
                RsSkuReDomain rsSkuReDomain = this.getChannelSkuBySkuNo(refundGoodsList.getSkuNo(), ocContractDomain.getMemberCode(), ocContractDomain.getMemberCcode(), ocContractDomain.getChannelCode(), ocContractDomain.getTenantCode());
                if (null == rsSkuReDomain) {
                    throw new Exception("\u6e20\u9053\u5546\u54c1\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                    return null;
                }
            }
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == refundGoodsList.getGoodsCamount()) {
                refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null != refundGoodsList.getGoodsCamount() && !OrderServiceImpl.isIntegerValue(refundGoodsList.getGoodsCamount())) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u5c0f\u6570");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setContractGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            refundGoodsDomain.setRefundGoodsAmt(refundGoodsList.getRefundGoodsAmt());
            refundGoodsDomain.setGoodsProperty5(custrelCode);
            if (StringUtils.isNotBlank((String)refundGoodsList.getSkuNo())) {
                refundGoodsDomain.setSkuNo(refundGoodsList.getSkuNo());
                refundGoodsDomain.setSkuShowno(refundGoodsList.getSkuShowno());
                refundGoodsDomain.setGoodsNo(refundGoodsList.getGoodsNo());
                refundGoodsDomain.setGoodsShowno(refundGoodsList.getGoodsShowno());
            }
            refundGoodsDomain.setRefundGoodsWeight(refundGoodsList.getRefundGoodsWeight());
            refundGoodsDomain.setRefundGoodsNum(refundGoodsList.getRefundGoodsNum());
            refundGoodsDomain.setRefundGoodsType(refundGoodsList.getRefundGoodsType());
            refundGoodsDomain.setRefundGoodsOldcode(refundGoodsList.getRefundGoodsOldcode());
            BigDecimal refundGoodsPrice = refundGoodsList.getRefundGoodsAmt().divide(refundGoodsList.getRefundGoodsNum(), 2, 0).setScale(2, 4);
            if (MapUtil.isNotEmpty(contractGoodsPmMap) && ListUtil.isNotEmpty(ocContractPmGoodsReDomainList = contractGoodsPmMap.get(refundGoodsList.getContractGoodsCode()))) {
                ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList1 = new ArrayList<OcContractPmGoodsReDomain>();
                for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
                    if (null == ocContractGoods.getContractGoodsRefnum()) {
                        ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
                    }
                    BigDecimal sumStr = refundGoodsDomain.getRefundGoodsNum().add(ocContractGoods.getContractGoodsRefnum());
                    BigDecimal sum = BigDecimal.ZERO;
                    if (sumStr.compareTo(ocContractGoods.getGoodsCamount()) == 0) {
                        BigDecimal sum2;
                        BigDecimal sum1 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(ocContractGoods.getContractGoodsRefnum()).setScale(2, 5);
                        sum = sum2 = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().subtract(sum1);
                    } else {
                        sum = ocContractPmGoodsReDomain.getContractPmgoodsPmoney().divide(ocContractPmGoodsReDomain.getGoodsCamount(), 2, 4).multiply(refundGoodsDomain.getRefundGoodsNum()).setScale(2, 5);
                    }
                    ocContractPmGoodsReDomain.setContractPmgoodsRepmoney(sum);
                    ocContractPmGoodsReDomain.setContractGoodsRefnum(refundGoodsDomain.getRefundGoodsNum());
                    ocContractPmGoodsReDomainList1.add(ocContractPmGoodsReDomain);
                }
                List<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = this.ocRefundPmGoods(ocContractPmGoodsReDomainList1);
                refundGoodsDomain.setOcRefundPmGoodsDomainList(ocRefundPmGoodsDomainList);
            }
            refundGoodsDomain.setRefundGoodsPrice(refundGoodsPrice);
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        this.logger.info("\u6253\u5370ocRefundGoodsDomainList\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocRefundGoodsDomainList));
        return ocRefundGoodsDomainList;
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error(CODE + ".contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    public List<OcRefundPmGoodsDomain> ocRefundPmGoods(List<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList) {
        if (ListUtil.isEmpty(ocContractPmGoodsReDomainList)) {
            this.logger.error(CODE + ".ocRefundPmGoods", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = new ArrayList<OcRefundPmGoodsDomain>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : ocContractPmGoodsReDomainList) {
            OcRefundPmGoodsDomain ocRefundPmGoodsDomain = new OcRefundPmGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundPmGoodsDomain, (Object)ocContractPmGoodsReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                return null;
            }
            ocRefundPmGoodsDomain.setRefundPmgoodsRepmoney(ocContractPmGoodsReDomain.getContractPmgoodsRepmoney());
            ocRefundPmGoodsDomainList.add(ocRefundPmGoodsDomain);
        }
        return ocRefundPmGoodsDomainList;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    public Map<String, List<OcContractPmGoodsReDomain>> contractPmGoodsMap(List<OcContractPmGoodsReDomain> goodsPmList) {
        if (ListUtil.isEmpty(goodsPmList)) {
            this.logger.error(CODE + ".contractPmGoodsMap", (Object)"param is null");
            return null;
        }
        HashMap<String, List<OcContractPmGoodsReDomain>> map = new HashMap<String, List<OcContractPmGoodsReDomain>>();
        for (OcContractPmGoodsReDomain ocContractPmGoodsReDomain : goodsPmList) {
            if (!StringUtils.isNotBlank((String)ocContractPmGoodsReDomain.getContractGoodsCode())) continue;
            ArrayList<OcContractPmGoodsReDomain> ocContractPmGoodsReDomainList = (ArrayList<OcContractPmGoodsReDomain>)map.get(ocContractPmGoodsReDomain.getContractGoodsCode());
            if (null == ocContractPmGoodsReDomainList) {
                ocContractPmGoodsReDomainList = new ArrayList<OcContractPmGoodsReDomain>();
                map.put(ocContractPmGoodsReDomain.getContractGoodsCode(), ocContractPmGoodsReDomainList);
            }
            ocContractPmGoodsReDomainList.add(ocContractPmGoodsReDomain);
        }
        return map;
    }

    public OcContractReDomain getContractByCode(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.contract.getContractByCode", pmap);
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)result, OcContractReDomain.class);
        return ocContractReDomain;
    }

    public String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        Object result = this.getInternalRouter().inInvoke("oc.refundEngine.sendSaveRefund", pmap);
        return result.toString();
    }

    public SupQueryResult queryContractPmGoodsPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.ContractPmGoods.queryContractPmGoodsPage", pmap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject((String)result, SupQueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractPmGoodsReDomain.class);
        supQueryResult.setList(list);
        return supQueryResult;
    }

    public RsSkuReDomain getChannelSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("skuNo", skuNo);
        pmap.put("memberCode", memberCode);
        pmap.put("memberCcode", memberCcode);
        pmap.put("channelCode", channelCode);
        pmap.put("tenantCode", tenantCode);
        Object result = this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", pmap);
        RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)result, RsSkuReDomain.class);
        return rsSkuReDomain;
    }

    @Override
    public void saveRefund() {
        List<SphContractDomain> sphContractDomain = this.ocContractMapper.queryOrder();
        for (SphContractDomain contractDomain : sphContractDomain) {
            HashMap<String, Object> hashMap;
            this.logger.info("\u67e5\u8be2\u7684\u6570\u636e\u5e93", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
            String contractBillCode = contractDomain.getContractBillCode();
            String openid = contractDomain.getOpenid();
            if (StringUtils.isBlank((String)contractBillCode) || StringUtils.isBlank((String)openid)) continue;
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            SphContractDto sphContractDto = new SphContractDto();
            sphContractDto.setOut_order_id(contractBillCode);
            sphContractDto.setOpenid(openid);
            String sphContractJson = JsonUtil.buildNonDefaultBinder().toJson((Object)sphContractDto);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
            SphQueryOrderDomain sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            if (sphQueryOrderDomain.getErrcode() == 42001L || sphQueryOrderDomain.getErrcode() == 40001L) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
                sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            } else if (sphQueryOrderDomain.getErrcode() != 0L) {
                this.logger.info(contractBillCode + "\u932f\u8aa4\u4fe1\u606f", (Object)sphQueryOrderDomain.getErrmsg());
                continue;
            }
            String pay_time = sphQueryOrderDomain.getOrder().getOrder_detail().getPay_info().getPay_time();
            if (StringUtils.isNotBlank((String)pay_time)) {
                hashMap = new HashMap<String, Object>();
                hashMap.put("contractBillCode", contractBillCode);
                hashMap.put("payTime", pay_time);
                this.ocContractMapper.updateOrderTime(hashMap);
            } else {
                hashMap = new HashMap();
                hashMap.put("contractBillCode", contractBillCode);
                this.logger.info("\u8ba2\u5355", (Object)contractBillCode);
                this.ocContractMapper.updateTime(hashMap);
            }
            this.logger.info("\u9000\u5355\u53c2\u6570", (Object)JsonUtil.buildNormalBinder().toJson((Object)sphQueryOrderDomain));
            if (sphQueryOrderDomain.getOrder() == null || sphQueryOrderDomain.getOrder().getRefund_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list())) continue;
            List<RefundListDomain> refund_list = sphQueryOrderDomain.getOrder().getRefund_info().getRefund_list();
            if (sphQueryOrderDomain.getOrder().getRelated_aftersale_info() == null || CollectionUtils.isEmpty(sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list())) continue;
            List<AftersaleList> aftersale_list = sphQueryOrderDomain.getOrder().getRelated_aftersale_info().getAftersale_list();
            if (CollectionUtils.isEmpty(refund_list)) continue;
            for (RefundListDomain refundListDomain : refund_list) {
                if (refundListDomain == null || StringUtils.isBlank((String)refundListDomain.getFinish_time())) continue;
                String finish_time = refundListDomain.getFinish_time();
                if (refundListDomain.getAmount() == null) continue;
                double amount = (double)refundListDomain.getAmount().longValue() / 100.0;
                if (!StringUtils.isNotBlank((String)finish_time)) continue;
                Long refund_no = Long.valueOf(refundListDomain.getRefund_no().substring(6, refundListDomain.getRefund_no().length()));
                for (AftersaleList aftersaleList : aftersale_list) {
                    if (!aftersaleList.getAftersale_id().equals(refund_no) || aftersaleList.getVersion() != 3) continue;
                    HashMap<String, Object> orderTime = new HashMap<String, Object>();
                    String aftersale_id = aftersaleList.getAftersale_id().toString();
                    orderTime.put("refundBillCode", aftersale_id);
                    orderTime.put("refundTime", finish_time);
                    orderTime.put("amount", amount);
                    this.logger.info("map\u7684\u503c", (Object)JsonUtil.buildNormalBinder().toJson(orderTime));
                    this.ocContractMapper.updateRefundTime(orderTime);
                }
            }
        }
    }

    @Override
    public void refund() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u62c9\u53d6\u89c6\u9891\u53f7\u7aef\u9000\u8d27\u9000\u6b3e\u5355");
        this.save(23);
    }

    @Override
    public void receive() {
        this.logger.info("\u89c6\u9891\u53f7\u7aef\u786e\u8ba4\u6536\u8d27\u4fe1\u606f\u540c\u6b65\u5fae\u5546\u57ce");
        List<SphOrderDomian> orderList = this.ocContractMapper.queryTwoOrder();
        if (CollectionUtils.isEmpty(orderList)) {
            throw new ApiException("\u6ca1\u6709\u8981\u540c\u6b65\u7684\u8ba2\u5355");
        }
        for (SphOrderDomian sphOrderDomian : orderList) {
            String openid = sphOrderDomian.getOpenid();
            String out_order_id = sphOrderDomian.getOut_order_id();
            if (StringUtils.isBlank((String)openid) || StringUtils.isBlank((String)out_order_id)) continue;
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            SphContractDto sphContractDto = new SphContractDto();
            sphContractDto.setOut_order_id(out_order_id);
            sphContractDto.setOpenid(openid);
            String sphContractJson = JsonUtil.buildNonDefaultBinder().toJson((Object)sphContractDto);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
            SphQueryOrderDomain sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            if (sphQueryOrderDomain.getErrcode() == 42001L || sphQueryOrderDomain.getErrcode() == 40001L) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/order/get?access_token=" + token, sphContractJson);
                sphQueryOrderDomain = (SphQueryOrderDomain)JSON.parseObject((String)queryOrder).toJavaObject(SphQueryOrderDomain.class);
            } else if (sphQueryOrderDomain.getErrcode() != 0L) {
                this.logger.info(out_order_id + "\u9519\u8bef\u4fe1\u606f", (Object)sphQueryOrderDomain.getErrmsg());
                continue;
            }
            this.logger.info("\u72b6\u6001", (Object)sphQueryOrderDomain.getOrder().getStatus());
            if (sphQueryOrderDomain.getOrder().getStatus() != 100) continue;
            this.confirmReceive(out_order_id);
        }
    }

    @Override
    public void logistics() {
        this.logger.info("\u89c6\u9891\u53f7\u7aef\u7269\u6d41\u4fe1\u606f\u540c\u6b65\u5fae\u5546\u57ce");
        List<SphLogisticsDomian> orderList = this.ocContractMapper.queryOrderList();
        this.logger.info("\u6570\u636e\u7684\u8ba2\u5355", (Object)JsonUtil.buildNormalBinder().toJson(orderList));
        if (CollectionUtils.isEmpty(orderList)) {
            throw new ApiException("\u6ca1\u6709\u8981\u540c\u6b65\u7684\u8ba2\u5355");
        }
        for (SphLogisticsDomian sphLogisticsDomian : orderList) {
            if (StringUtils.isBlank((String)sphLogisticsDomian.getAftersale_id()) || StringUtils.isBlank((String)sphLogisticsDomian.getOut_aftersale_id())) continue;
            this.logger.info("\u5f00\u59cb\u7684\u89c6\u9891\u53f7\u8ba2\u5355", (Object)sphLogisticsDomian.getOut_aftersale_id());
            SphLogisticsDomian sphLogistics = new SphLogisticsDomian();
            sphLogistics.setAftersale_id(sphLogisticsDomian.getAftersale_id());
            String json = JsonUtil.buildNonDefaultBinder().toJson((Object)sphLogistics);
            String channelCode = "B2Cchannel";
            String token = this.token(channelCode);
            String queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get?access_token=" + token, json);
            LogisticsDomian logisticsDomian = (LogisticsDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(queryOrder, LogisticsDomian.class);
            if (logisticsDomian.getErrcode() == 42001 || logisticsDomian.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                queryOrder = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get?access_token=" + token, json);
                logisticsDomian = (LogisticsDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(queryOrder, LogisticsDomian.class);
            } else if (logisticsDomian.getErrcode() != 0) {
                this.logger.info(sphLogisticsDomian.getOut_aftersale_id() + "\u9519\u8bef\u4fe1\u606f", (Object)logisticsDomian.getErrmsg());
                continue;
            }
            if (logisticsDomian.getErrcode() != 0 || logisticsDomian.getAfter_sales_order() == null || logisticsDomian.getAfter_sales_order().getReturn_info() == null) continue;
            String delivery_name = logisticsDomian.getAfter_sales_order().getReturn_info().getDelivery_name();
            String waybill_id = logisticsDomian.getAfter_sales_order().getReturn_info().getWaybill_id();
            String out_aftersale_id = sphLogisticsDomian.getOut_aftersale_id();
            this.sendGoods(out_aftersale_id, delivery_name, waybill_id);
        }
    }

    @Override
    public void cancel() {
        AfterDomain afterDomain;
        Boolean has_more;
        this.logger.info("\u89c6\u9891\u53f7\u7aef\u53d6\u6d88\u552e\u540e\u540c\u6b65\u5fae\u5546\u57ce");
        String channelCode = "B2Cchannel";
        int i = 0;
        ArrayList<String> listAll = new ArrayList<String>();
        do {
            List<String> after_sales_orders;
            AfterMarketDomain afterMarketDomain = new AfterMarketDomain();
            afterMarketDomain.setOffset(i);
            this.logger.info("\u5faa\u73af\u6b21\u6570 ", (Object)i);
            ++i;
            afterMarketDomain.setLimit(50);
            afterMarketDomain.setStatus(1);
            String toJson = JsonUtil.buildNonDefaultBinder().toJson((Object)afterMarketDomain);
            String token = this.token(channelCode);
            String sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=" + token, toJson);
            afterDomain = (AfterDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, AfterDomain.class);
            if (afterDomain.getErrcode() == 42001 || afterDomain.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/ecaftersale/get_list?access_token=" + token, toJson);
                afterDomain = (AfterDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, AfterDomain.class);
            }
            if (CollectionUtils.isEmpty(after_sales_orders = afterDomain.getAfter_sales_orders())) continue;
            listAll.addAll(after_sales_orders);
        } while (!(has_more = afterDomain.getHas_more()).equals(false));
        List<String> queryTwoChargeBack = this.ocContractMapper.queryTwoChargeBack();
        this.logger.info("\u89c6\u6570\u636e\u5e93\u9000\u5355\u5217\u8868", (Object)JsonUtil.buildNormalBinder().toJson(queryTwoChargeBack));
        listAll.removeAll(queryTwoChargeBack);
        this.logger.info("\u603b\u9000\u5355\u5217\u8868", (Object)JsonUtil.buildNormalBinder().toJson(listAll));
        if (CollectionUtils.isEmpty(listAll)) {
            throw new ApiException("\u6ca1\u6709\u8981\u62c9\u7684\u9000\u5355");
        }
        for (String order : listAll) {
            try {
                if (StringUtils.isBlank((String)order)) continue;
                String queryIndent = this.ocContractMapper.queryIndent(order);
                this.logger.info("\u9000\u5355", (Object)queryIndent);
                if (StringUtils.isBlank((String)queryIndent)) continue;
                this.res(queryIndent);
            }
            catch (Exception e) {
                this.logger.info("\u8ba2\u5355\u9519\u8bef\u4fe1\u606f", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void running() {
        String sendPost;
        String json;
        Funds funds;
        int i = 1;
        String channelCode = "B2Cchannel";
        String token = this.token(channelCode);
        ArrayList<String> listAll = new ArrayList<String>();
        do {
            Running running = new Running();
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -23);
            date = calendar.getTime();
            String[] split = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd").split("-");
            running.setDate(split[0] + split[1] + split[2]);
            running.setPage_num(i++);
            running.setPage_size(100);
            json = JsonUtil.buildNonDefaultBinder().toJson((Object)running);
            sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/funds/scanorderflow?access_token=" + token, json);
            funds = (Funds)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, Funds.class);
            if (funds.getErrcode() == 42001 || funds.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/funds/scanorderflow?access_token=" + token, json);
                funds = (Funds)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, Funds.class);
            }
            if (funds.getErrcode() != 0) {
                throw new ApiException(funds.getErrmsg());
            }
            listAll.addAll(funds.getFunds_flow_ids());
        } while (funds.getTotal_num() > (i - 1) * 100);
        if (CollectionUtils.isEmpty(listAll)) {
            throw new ApiException("\u65f6\u95f4" + DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd") + "\u6ca1\u6709\u8981\u83b7\u53d6\u7684\u6d41\u6c34");
        }
        this.logger.info("\u62c9\u53d6\u7684\u6d41\u6c34\u6709", (Object)JsonUtil.buildNormalBinder().toJson(listAll));
        for (String funds2 : listAll) {
            String shpOrder;
            String sphRunning;
            if (StringUtils.isBlank((String)funds2) || StringUtils.isNotBlank((String)(sphRunning = this.ocContractMapper.querySphRunning(funds2)))) continue;
            FundsFlow fundsFlow = new FundsFlow();
            fundsFlow.setFunds_flow_id(funds2);
            json = JsonUtil.buildNonDefaultBinder().toJson((Object)fundsFlow);
            sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/funds/getorderflow?access_token=" + token, json);
            RunningDomian runningDomian = (RunningDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, RunningDomian.class);
            if (runningDomian.getErrcode() == 42001 || runningDomian.getErrcode() == 40001) {
                token = this.twoToken(channelCode);
                sendPost = HttpRequest.sendPost("https://api.weixin.qq.com/shop/funds/getorderflow?access_token=" + token, json);
                runningDomian = (RunningDomian)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendPost, RunningDomian.class);
            }
            if (runningDomian.getErrcode() != 0) {
                throw new ApiException(runningDomian.getErrmsg());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("water", runningDomian.getFunds_flow().getFunds_flow_id());
            map.put("time", runningDomian.getFunds_flow().getBookkeeping_time());
            double amount = Double.parseDouble(runningDomian.getFunds_flow().getAmount());
            map.put("amount", amount);
            if (runningDomian.getFunds_flow().getBusi_type().equals("\u552e\u540e")) {
                map.put("chargeback", runningDomian.getFunds_flow().getRequest_no());
                shpOrder = this.ocContractMapper.querySphOrder(map);
                if (StringUtils.isBlank((String)shpOrder)) continue;
                map.put("order", shpOrder);
                map.put("type", "INO");
                map.put("state", 2);
                map.put("Tenantcode", "2022012800000001");
                String contract = this.ocContractMapper.queryContract(map);
                map.put("contract", contract);
                map.put("running", runningDomian.getFunds_flow().getRequest_no());
            } else {
                if (!runningDomian.getFunds_flow().getBusi_type().equals("\u8ba2\u5355")) continue;
                map.put("chargeback", runningDomian.getFunds_flow().getRequest_no());
                shpOrder = this.ocContractMapper.querySphChargeback(map);
                map.put("order", shpOrder);
                map.put("contract", shpOrder);
                map.put("type", "IN");
                map.put("state", 2);
                map.put("Tenantcode", "2022012800000001");
            }
            this.ocContractMapper.insert(map);
        }
    }

    @Override
    @Transactional
    public void updateContractAddress(String contractBillcode, String goodsReceiptMem, String goodsReceiptArrdess, String goodsReceiptPhone) {
        this.logger.info("\u6253\u5370\u6570\u636e\uff1a{}" + contractBillcode + "--" + goodsReceiptMem + "--" + goodsReceiptArrdess + "--" + goodsReceiptPhone);
        this.ocContractMapper.updateContractAddress(contractBillcode, goodsReceiptMem, goodsReceiptArrdess, goodsReceiptPhone);
        this.ocContractMapper.updateSgContractAddress(contractBillcode, goodsReceiptMem, goodsReceiptArrdess, goodsReceiptPhone);
        this.ocContractMapper.updateSgContractGoodsAddress(contractBillcode, goodsReceiptMem, goodsReceiptArrdess, goodsReceiptPhone);
    }

    @Override
    public Map<String, Object> isDz(Map<String, Object> map) {
        String userinfoCode = (String)map.get("userinfoCode");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map dz = this.ocContractGoodsMapper.isDz(userinfoCode);
        if (null == dz) {
            return result;
        }
        String mdCode = (String)dz.get("mdCode");
        String isDz = (String)dz.get("isDz");
        if ("\u5e97\u957f".equals(isDz)) {
            result.put("mdCode", mdCode);
            result.put("role", 1);
        } else {
            result.put("mdCode", null);
            result.put("role", 0);
        }
        return result;
    }

    @Override
    public Map<String, Object> mdtj(Map<String, Object> map) {
        String mdCode = (String)map.get("mdCode");
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        Set<String> strings = this.ocContractGoodsMapper.allmInMd(mdCode);
        if (null == strings) {
            return null;
        }
        int i = this.ocContractGoodsMapper.hyslInMd(mdCode);
        int i1 = this.ocContractGoodsMapper.hyslInMdToday(mdCode);
        result.put("ljkh", i);
        result.put("xzkhToday", i1);
        Map map1 = this.ocContractGoodsMapper.ddsAndDdje(strings);
        if (null != map1) {
            result.put("dds", map1.get("dds"));
            result.put("ddje", map1.get("ddje"));
        } else {
            result.put("dds", 0);
            result.put("ddje", bigDecimal);
        }
        Map map2 = this.ocContractGoodsMapper.tdsAndTdje(strings);
        if (null != map2) {
            result.put("tds", map1.get("tds"));
            result.put("tdje", map1.get("tdje"));
        } else {
            result.put("tds", 0);
            result.put("tdje", bigDecimal);
        }
        Map map3 = this.ocContractGoodsMapper.ddsAndDdjeToday(strings);
        if (null != map3) {
            result.put("ddsToday", map3.get("dds"));
            result.put("ddjeToday", map3.get("ddje"));
        } else {
            result.put("ddsToday", 0);
            result.put("ddjeToday", bigDecimal);
        }
        Map map4 = this.ocContractGoodsMapper.tdsAndTdjeToday(strings);
        if (null != map4) {
            result.put("tdsToday", map4.get("tds"));
            result.put("tdjeToday", map4.get("tdje"));
        } else {
            result.put("tdsToday", 0);
            result.put("tdjeToday", bigDecimal);
        }
        BigDecimal ddjeToday = (BigDecimal)result.get("ddjeToday");
        BigDecimal tdjeToday = (BigDecimal)result.get("tdjeToday");
        BigDecimal yjjeToday = ddjeToday.subtract(tdjeToday);
        if (yjjeToday.compareTo(bigDecimal) < 0) {
            yjjeToday = bigDecimal;
        }
        result.put("yjjeToday", yjjeToday);
        BigDecimal ddje = (BigDecimal)result.get("ddje");
        BigDecimal tdje = (BigDecimal)result.get("tdje");
        BigDecimal yjje = ddje.subtract(tdje);
        if (yjje.compareTo(bigDecimal) < 0) {
            yjje = bigDecimal;
        }
        result.put("yjje", yjje);
        return result;
    }

    @Override
    public Map<String, Object> mdtj1(Map<String, Object> map) {
        String mdCode = (String)map.get("mdCode");
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        Set<String> strings = this.ocContractGoodsMapper.allmInMd(mdCode);
        if (null == strings) {
            return null;
        }
        Set<String> strings1 = this.ocContractGoodsMapper.codeHasDg(strings);
        if (null == strings1) {
            return null;
        }
        int i = this.ocContractGoodsMapper.slHasDg(strings1);
        int i1 = this.ocContractGoodsMapper.slHasDgToday(strings1);
        result.put("ljkh", i);
        result.put("xzkhToday", i1);
        Map map1 = this.ocContractGoodsMapper.ddsAndDdje(strings1);
        if (null != map1) {
            result.put("dds", map1.get("dds"));
            result.put("ddje", map1.get("ddje"));
        } else {
            result.put("dds", 0);
            result.put("ddje", bigDecimal);
        }
        Map map2 = this.ocContractGoodsMapper.tdsAndTdje(strings1);
        if (null != map2) {
            result.put("tds", map1.get("tds"));
            result.put("tdje", map1.get("tdje"));
        } else {
            result.put("tds", 0);
            result.put("tdje", bigDecimal);
        }
        Map map3 = this.ocContractGoodsMapper.ddsAndDdjeToday(strings1);
        if (null != map3) {
            result.put("ddsToday", map3.get("dds"));
            result.put("ddjeToday", map3.get("ddje"));
        } else {
            result.put("ddsToday", 0);
            result.put("ddjeToday", bigDecimal);
        }
        Map map4 = this.ocContractGoodsMapper.tdsAndTdjeToday(strings1);
        if (null != map4) {
            result.put("tdsToday", map4.get("tds"));
            result.put("tdjeToday", map4.get("tdje"));
        } else {
            result.put("tdsToday", 0);
            result.put("tdjeToday", bigDecimal);
        }
        BigDecimal ddjeToday = (BigDecimal)result.get("ddjeToday");
        BigDecimal tdjeToday = (BigDecimal)result.get("tdjeToday");
        BigDecimal yjjeToday = ddjeToday.subtract(tdjeToday);
        if (yjjeToday.compareTo(bigDecimal) < 0) {
            yjjeToday = bigDecimal;
        }
        result.put("yjjeToday", yjjeToday);
        BigDecimal ddje = (BigDecimal)result.get("ddje");
        BigDecimal tdje = (BigDecimal)result.get("tdje");
        BigDecimal yjje = ddje.subtract(tdje);
        if (yjje.compareTo(bigDecimal) < 0) {
            yjje = bigDecimal;
        }
        result.put("yjje", yjje);
        return result;
    }

    @Override
    public Map<String, Object> mdtj2(Map<String, Object> map) {
        String mdCode = (String)map.get("mdCode");
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        Set<String> strings = this.ocContractGoodsMapper.allmInMd(mdCode);
        if (null == strings) {
            return null;
        }
        Set<String> strings1 = this.ocContractGoodsMapper.codeHasNoDg(strings);
        if (null == strings1) {
            return null;
        }
        int i = this.ocContractGoodsMapper.slHasNoDg(strings1);
        int i1 = this.ocContractGoodsMapper.slHasNoDgToday(strings1);
        result.put("ljkh", i);
        result.put("xzkhToday", i1);
        Map map1 = this.ocContractGoodsMapper.ddsAndDdje(strings1);
        if (null != map1) {
            result.put("dds", map1.get("dds"));
            result.put("ddje", map1.get("ddje"));
        } else {
            result.put("dds", 0);
            result.put("ddje", bigDecimal);
        }
        Map map2 = this.ocContractGoodsMapper.tdsAndTdje(strings1);
        if (null != map2) {
            result.put("tds", map1.get("tds"));
            result.put("tdje", map1.get("tdje"));
        } else {
            result.put("tds", 0);
            result.put("tdje", bigDecimal);
        }
        Map map3 = this.ocContractGoodsMapper.ddsAndDdjeToday(strings1);
        if (null != map3) {
            result.put("ddsToday", map3.get("dds"));
            result.put("ddjeToday", map3.get("ddje"));
        } else {
            result.put("ddsToday", 0);
            result.put("ddjeToday", bigDecimal);
        }
        Map map4 = this.ocContractGoodsMapper.tdsAndTdjeToday(strings1);
        if (null != map4) {
            result.put("tdsToday", map4.get("tds"));
            result.put("tdjeToday", map4.get("tdje"));
        } else {
            result.put("tdsToday", 0);
            result.put("tdjeToday", bigDecimal);
        }
        BigDecimal ddjeToday = (BigDecimal)result.get("ddjeToday");
        BigDecimal tdjeToday = (BigDecimal)result.get("tdjeToday");
        BigDecimal yjjeToday = ddjeToday.subtract(tdjeToday);
        if (yjjeToday.compareTo(bigDecimal) < 0) {
            yjjeToday = bigDecimal;
        }
        result.put("yjjeToday", yjjeToday);
        BigDecimal ddje = (BigDecimal)result.get("ddje");
        BigDecimal tdje = (BigDecimal)result.get("tdje");
        BigDecimal yjje = ddje.subtract(tdje);
        if (yjje.compareTo(bigDecimal) < 0) {
            yjje = bigDecimal;
        }
        result.put("yjje", yjje);
        return result;
    }

    @Override
    public Set<Map> mdtj3(Map<String, Object> map) {
        String mdCode = (String)map.get("mdCode");
        Set<Map> map1 = this.ocContractGoodsMapper.userinfoCodeByYggh(mdCode);
        return map1;
    }

    @Override
    public Map<String, Object> mdtjdetails(Map<String, Object> map) throws ParseException {
        String mdCode = (String)map.get("mdCode");
        String startTime = (String)map.get("startTime");
        String endTime = (String)map.get("endTime");
        String hykh = (String)map.get("hykh");
        String hyCode = null;
        if (null != hykh && null == (hyCode = this.ocContractGoodsMapper.hyCodeByHykh(hykh))) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728", "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        String userinfoCode1 = null;
        String userinfoCode = (String)map.get("userinfoCode");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = df.parse(endTime);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parse);
        ((Calendar)calendar).add(5, 1);
        endTime = df.format(calendar.getTime());
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        Set<String> strings = this.ocContractGoodsMapper.allmInMd(mdCode);
        if (null == strings) {
            return null;
        }
        if (null != userinfoCode && null == (strings = this.ocContractGoodsMapper.HyByUserinfoCode(userinfoCode1 = userinfoCode))) {
            return result;
        }
        Map map1 = this.ocContractGoodsMapper.ddsAndDdjeDate(strings, startTime, endTime, hyCode);
        if (null != map1) {
            result.put("dds", map1.get("dds"));
            result.put("ddje", map1.get("ddje"));
        } else {
            result.put("dds", 0);
            result.put("ddje", bigDecimal);
        }
        Map map2 = this.ocContractGoodsMapper.tdsAndTdjeDate(strings, startTime, endTime, hyCode);
        if (null != map2) {
            result.put("tds", map1.get("tds"));
            result.put("tdje", map1.get("tdje"));
        } else {
            result.put("tds", 0);
            result.put("tdje", bigDecimal);
        }
        BigDecimal ddje = (BigDecimal)result.get("ddje");
        BigDecimal tdje = (BigDecimal)result.get("tdje");
        BigDecimal yjje = ddje.subtract(tdje);
        if (yjje.compareTo(bigDecimal) < 0) {
            yjje = bigDecimal;
        }
        result.put("yjje", yjje);
        ArrayList cjdd = new ArrayList();
        List<Map> maps = this.ocContractGoodsMapper.ddbyDd(strings, startTime, endTime, hyCode);
        for (Map d : maps) {
            String hyCode1 = this.ocContractGoodsMapper.ddbySh((String)d.get("hyCode"));
            Map map3 = this.ocContractGoodsMapper.ddbyUserinfo(hyCode1);
            Map map4 = this.ocContractGoodsMapper.ddbyUserinfo((String)d.get("hyCode"));
            Map map5 = this.ocContractGoodsMapper.ddbyClear((String)d.get("ddh"));
            if (null == map5) continue;
            List<Map> mapss = this.ocContractGoodsMapper.ddByGoods((String)d.get("ddh"));
            for (Map d1 : mapss) {
                HashMap sp = new HashMap();
                sp.put("ygname", map3.get("name"));
                sp.put("ygkh", map3.get("hykh"));
                sp.put("hyname", map4.get("name"));
                sp.put("hykh", map4.get("hykh"));
                sp.put("hyphone", map4.get("phone"));
                sp.put("time", map5.get("times"));
                sp.put("jybm", map5.get("jybm"));
                sp.put("ddh", d.get("ddh"));
                sp.put("picture", d1.get("picture"));
                sp.put("name", d1.get("name"));
                sp.put("num", d1.get("num"));
                sp.put("types", d1.get("types"));
                sp.put("dj", d1.get("dj"));
                sp.put("zj", d1.get("zj"));
                cjdd.add(sp);
            }
        }
        result.put("cjdd", cjdd);
        return result;
    }

    @Override
    public Map<String, Object> mdtjdetails1(Map<String, Object> map) throws ParseException {
        String mdCode = (String)map.get("mdCode");
        String startTime = (String)map.get("startTime");
        String endTime = (String)map.get("endTime");
        String hykh = (String)map.get("hykh");
        String hyCode = null;
        if (null != hykh && null == (hyCode = this.ocContractGoodsMapper.hyCodeByHykh(hykh))) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728", "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        String userinfoCode1 = null;
        String userinfoCode = (String)map.get("userinfoCode");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = df.parse(endTime);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parse);
        ((Calendar)calendar).add(5, 1);
        endTime = df.format(calendar.getTime());
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        Set<String> strings = this.ocContractGoodsMapper.allmInMd(mdCode);
        if (null == strings) {
            return null;
        }
        Set<String> strings1 = this.ocContractGoodsMapper.codeHasDg(strings);
        if (null == strings1) {
            return null;
        }
        if (null != userinfoCode && null == (strings1 = this.ocContractGoodsMapper.HyByUserinfoCode(userinfoCode1 = userinfoCode))) {
            return result;
        }
        Map map1 = this.ocContractGoodsMapper.ddsAndDdjeDate(strings1, startTime, endTime, hyCode);
        if (null != map1) {
            result.put("dds", map1.get("dds"));
            result.put("ddje", map1.get("ddje"));
        } else {
            result.put("dds", 0);
            result.put("ddje", bigDecimal);
        }
        Map map2 = this.ocContractGoodsMapper.tdsAndTdjeDate(strings1, startTime, endTime, hyCode);
        if (null != map2) {
            result.put("tds", map1.get("tds"));
            result.put("tdje", map1.get("tdje"));
        } else {
            result.put("tds", 0);
            result.put("tdje", bigDecimal);
        }
        BigDecimal ddje = (BigDecimal)result.get("ddje");
        BigDecimal tdje = (BigDecimal)result.get("tdje");
        BigDecimal yjje = ddje.subtract(tdje);
        if (yjje.compareTo(bigDecimal) < 0) {
            yjje = bigDecimal;
        }
        result.put("yjje", yjje);
        ArrayList cjdd = new ArrayList();
        List<Map> maps = this.ocContractGoodsMapper.ddbyDd(strings1, startTime, endTime, hyCode);
        for (Map d : maps) {
            String hyCode1 = this.ocContractGoodsMapper.ddbySh((String)d.get("hyCode"));
            Map map3 = this.ocContractGoodsMapper.ddbyUserinfo(hyCode1);
            Map map4 = this.ocContractGoodsMapper.ddbyUserinfo((String)d.get("hyCode"));
            Map map5 = this.ocContractGoodsMapper.ddbyClear((String)d.get("ddh"));
            if (null == map5) continue;
            List<Map> mapss = this.ocContractGoodsMapper.ddByGoods((String)d.get("ddh"));
            for (Map d1 : mapss) {
                HashMap sp = new HashMap();
                sp.put("ygname", map3.get("name"));
                sp.put("ygkh", map3.get("hykh"));
                sp.put("hyname", map4.get("name"));
                sp.put("hykh", map4.get("hykh"));
                sp.put("hyphone", map4.get("phone"));
                sp.put("time", map5.get("times"));
                sp.put("jybm", map5.get("jybm"));
                sp.put("ddh", d.get("ddh"));
                sp.put("picture", d1.get("picture"));
                sp.put("name", d1.get("name"));
                sp.put("num", d1.get("num"));
                sp.put("types", d1.get("types"));
                sp.put("dj", d1.get("dj"));
                sp.put("zj", d1.get("zj"));
                cjdd.add(sp);
            }
        }
        result.put("cjdd", cjdd);
        return result;
    }

    @Override
    public Map<String, Object> mdtjdetails2(Map<String, Object> map) throws ParseException {
        String mdCode = (String)map.get("mdCode");
        String startTime = (String)map.get("startTime");
        String endTime = (String)map.get("endTime");
        String hykh = (String)map.get("hykh");
        String hyCode = null;
        if (null != hykh && null == (hyCode = this.ocContractGoodsMapper.hyCodeByHykh(hykh))) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728", "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        String userinfoCode1 = null;
        String userinfoCode = (String)map.get("userinfoCode");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = df.parse(endTime);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parse);
        ((Calendar)calendar).add(5, 1);
        endTime = df.format(calendar.getTime());
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        Set<String> strings = this.ocContractGoodsMapper.allmInMd(mdCode);
        if (null == strings) {
            return null;
        }
        Set<String> strings1 = this.ocContractGoodsMapper.codeHasNoDg(strings);
        if (null == strings1) {
            return null;
        }
        if (null != userinfoCode && null == (strings1 = this.ocContractGoodsMapper.HyByUserinfoCode(userinfoCode1 = userinfoCode))) {
            return result;
        }
        Map map1 = this.ocContractGoodsMapper.ddsAndDdjeDate(strings1, startTime, endTime, hyCode);
        if (null != map1) {
            result.put("dds", map1.get("dds"));
            result.put("ddje", map1.get("ddje"));
        } else {
            result.put("dds", 0);
            result.put("ddje", bigDecimal);
        }
        Map map2 = this.ocContractGoodsMapper.tdsAndTdjeDate(strings1, startTime, endTime, hyCode);
        if (null != map2) {
            result.put("tds", map1.get("tds"));
            result.put("tdje", map1.get("tdje"));
        } else {
            result.put("tds", 0);
            result.put("tdje", bigDecimal);
        }
        BigDecimal ddje = (BigDecimal)result.get("ddje");
        BigDecimal tdje = (BigDecimal)result.get("tdje");
        BigDecimal yjje = ddje.subtract(tdje);
        if (yjje.compareTo(bigDecimal) < 0) {
            yjje = bigDecimal;
        }
        result.put("yjje", yjje);
        ArrayList cjdd = new ArrayList();
        List<Map> maps = this.ocContractGoodsMapper.ddbyDd(strings1, startTime, endTime, hyCode);
        for (Map d : maps) {
            String hyCode1 = this.ocContractGoodsMapper.ddbySh((String)d.get("hyCode"));
            Map map3 = this.ocContractGoodsMapper.ddbyUserinfo(hyCode1);
            Map map4 = this.ocContractGoodsMapper.ddbyUserinfo((String)d.get("hyCode"));
            Map map5 = this.ocContractGoodsMapper.ddbyClear((String)d.get("ddh"));
            if (null == map5) continue;
            List<Map> mapss = this.ocContractGoodsMapper.ddByGoods((String)d.get("ddh"));
            for (Map d1 : mapss) {
                HashMap sp = new HashMap();
                sp.put("ygname", map3.get("name"));
                sp.put("ygkh", map3.get("hykh"));
                sp.put("hyname", map4.get("name"));
                sp.put("hykh", map4.get("hykh"));
                sp.put("hyphone", map4.get("phone"));
                sp.put("time", map5.get("times"));
                sp.put("jybm", map5.get("jybm"));
                sp.put("ddh", d.get("ddh"));
                sp.put("picture", d1.get("picture"));
                sp.put("name", d1.get("name"));
                sp.put("num", d1.get("num"));
                sp.put("types", d1.get("types"));
                sp.put("dj", d1.get("dj"));
                sp.put("zj", d1.get("zj"));
                cjdd.add(sp);
            }
        }
        result.put("cjdd", cjdd);
        return result;
    }

    private void confirmReceive(String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        this.sendContractNextCom(contractBillcode, 3, true);
    }

    public void sendContractNextCom(String contractBillcode, Integer dateState, boolean buy) {
        String tenantCode;
        Map getContractMap;
        OcContractReDomain contract;
        if (StringUtils.isBlank((String)contractBillcode) || null == dateState) {
            this.logger.info(CODE + ".sendContractNextCom", (Object)"param is null");
        }
        if ((contract = this.getContractOneByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode = this.saasTenantcode}))) == null) {
            this.logger.info("\u8ba2\u5355\u4e0d\u5b58\u5728");
            return;
        }
        if (dateState != contract.getDataState()) {
            this.logger.info("\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        this.sendContractNext(contractBillcode);
    }

    public OcContractReDomain getContractOneByCode(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.contract.getContractOneByCode", pmap);
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)result, OcContractReDomain.class);
        return ocContractReDomain;
    }

    protected void sendContractNext(String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return;
        }
        String tenantCode = this.saasTenantcode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.sendContractNext(contractBillcode, tenantCode, map);
    }

    public Object sendContractNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("contractBillcode", contractBillcode);
        pmap.put("tenantCode", tenantCode);
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.contractEngine.sendContractNext", pmap);
        return result;
    }

    private void sendGoods(String refundCode, String packageName, String packageBillno) {
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".sendGoods", (Object)"param is null");
            return;
        }
        HashMap<String, Object> paramStr = new HashMap<String, Object>();
        paramStr.put("refundCode", refundCode);
        SupQueryResult ocRefundReDomainSupQueryResult = this.queryRefundPage(paramStr);
        if (ListUtil.isEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".sendGoods", (Object)"ocRefundReDomainSupQueryResult is null");
            return;
        }
        String tenantCode = this.saasTenantcode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("packageName", packageName);
        map.put("packageBillno", packageBillno);
        this.sendRefundRes(refundCode, tenantCode, map);
    }

    public SupQueryResult queryRefundPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.refund.queryRefundPage", pmap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject((String)result, SupQueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcRefundReDomain.class);
        supQueryResult.setList(list);
        return supQueryResult;
    }

    public Object sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        pmap.put("refundCode", refundCode);
        pmap.put("tenantCode", tenantCode);
        Object result = this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundNext", pmap);
        return result;
    }

    private void res(String refundCode) {
        String goodsCode = this.ocContractMapper.queryGoodsCode(refundCode);
        if (StringUtils.isBlank((String)goodsCode)) {
            return;
        }
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".res", (Object)"param is null");
        }
        String tenantCode = this.saasTenantcode;
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.getRefundByCode(codeMap);
        if (null == refundReDomain) {
            this.logger.error(CODE + ".res", (Object)"refundReDomain is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundUcode", "MINI");
        map.put("refundUname", "MINI");
        map.put("refundAudate", new Date());
        map.put("goodsCode", goodsCode);
        this.updateRefundExamine(map, tenantCode, refundCode);
        if (refundReDomain.getDataState() == 0) {
            this.updateRefundRes(refundCode, tenantCode, map);
        }
    }

    public OcRefundReDomain getRefundByCode(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        Object result = this.getInternalRouter().inInvoke("oc.refund.getRefundByCode", pmap);
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)result, OcRefundReDomain.class);
        return ocRefundReDomain;
    }

    public Object updateRefundExamine(Map<String, Object> map, String tenantCode, String refundCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        pmap.put("refundCode", refundCode);
        pmap.put("tenantCode", tenantCode);
        Object result = this.getInternalRouter().inInvoke("oc.refund.updateRefundExamine", pmap);
        return result;
    }

    public Object updateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        pmap.put("refundCode", refundCode);
        pmap.put("tenantCode", tenantCode);
        Object result = this.getInternalRouter().inInvoke("oc.contractEngine.updateRefundRes", pmap);
        return result;
    }
}

