/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.dao.OcRefundMapper;
import com.yqbsoft.laser.service.da.domain.StatisticsContractDomain;
import com.yqbsoft.laser.service.da.domain.StatisticsGraphicalDomain;
import com.yqbsoft.laser.service.da.service.StatisticsService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class StatisticsServiceImpl
extends BaseServiceImpl
implements StatisticsService {
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;

    @Override
    public StatisticsContractDomain statisticsQueryTotal(Map<String, Object> map) {
        StatisticsContractDomain domain = this.ocContractMapper.statisticsContactData(map);
        StatisticsContractDomain refundData = this.ocRefundMapper.statisticsRefundData(map);
        domain.setRefundMoney(refundData.getRefundMoney());
        domain.setOnlyRefundNum(refundData.getOnlyRefundNum());
        domain.setExchangeRefundNum(refundData.getExchangeRefundNum());
        domain.setReturnRefundNum(refundData.getReturnRefundNum());
        return domain;
    }

    @Override
    public StatisticsGraphicalDomain statisticsQueryGraphical(Map<String, Object> map) {
        return null;
    }

    public static List<String> getXaxis(Map<String, Object> map) throws ParseException {
        String startTime = (String)map.get("startTime");
        String endTime = (String)map.get("endTime");
        Long diffDay = DateUtil.getDiffDay((String)DateUtils.getDateString((Date)DateUtils.parseDate((String)startTime, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"), (String)DateUtils.getDateString((Date)DateUtils.parseDate((String)endTime, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
        List<Object> xAxis = new ArrayList();
        Integer diffday = 0;
        if (diffDay == 0L) {
            xAxis = StatisticsServiceImpl.getHour(startTime);
        } else if (30L >= diffDay && diffDay > 0L) {
            diffday = 1;
            xAxis = StatisticsServiceImpl.getDay(startTime, diffDay);
        } else if (diffDay > 30L) {
            diffday = 1;
            xAxis = StatisticsServiceImpl.getMonth(startTime, diffDay);
        }
        return xAxis;
    }

    private static List<String> getDay(String startTime, Long diffDay) {
        ArrayList<String> list = new ArrayList<String>();
        long count = diffDay;
        String temp = startTime;
        int i = 0;
        while ((long)i <= count) {
            int year = DateUtils.getDay((String)temp);
            list.add(year + "");
            try {
                temp = DateUtils.parseDate((Date)DateUtils.addDays((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd"), (int)1));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    private static List<String> getMonth(String startTime, Long diffDay) {
        ArrayList<String> list = new ArrayList<String>();
        long count = diffDay / 30L;
        String temp = startTime;
        int i = 0;
        while ((long)i <= count) {
            int year = DateUtils.getMonth((String)temp);
            list.add(year + "");
            try {
                temp = DateUtils.parseDate((Date)DateUtils.addMonths((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd"), (int)1));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    private static List<String> getYear(String startTime, Long diffDay) {
        ArrayList<String> list = new ArrayList<String>();
        long count = diffDay / 365L;
        String temp = startTime;
        int i = 0;
        while ((long)i < count) {
            int year = DateUtils.getYear((String)temp);
            list.add(year + "");
            try {
                temp = DateUtils.parseDate((Date)DateUtils.addYears((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd"), (int)1));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    private static List<String> getHour(String startTime) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 24; ++i) {
            try {
                list.add(DateUtils.parseDateToString((Date)DateUtils.addHours((Date)DateUtils.parseDate((String)(startTime + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"), (int)i), (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        return list;
    }

    public static String lastDate(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtils.getDateString((Date)lastDate, (String)"yyyy-MM-dd");
    }

    public static String firstDate(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        return DateUtils.getDateString((Date)firstDate, (String)"yyyy-MM-dd");
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("startTime", "2022-12-21");
            map.put("endTime", "2022-12-21");
            System.out.println(StatisticsServiceImpl.getXaxis(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

