/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.yqbsoft.laser.service.da.dao.WlExporgApiMapper;
import com.yqbsoft.laser.service.da.dao.WlExporgConfigMapper;
import com.yqbsoft.laser.service.da.domain.wl.WlExporgApiDomain;
import com.yqbsoft.laser.service.da.domain.wl.WlExporgConfigDomain;
import com.yqbsoft.laser.service.da.service.ShunFengService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.util.shunfeng.ShunfengResponse;
import com.yqbsoft.laser.service.util.shunfeng.ShunfengUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ShunFengServiceImpl
extends BaseServiceImpl
implements ShunFengService {
    @Autowired
    private WlExporgApiMapper wlExporgApiMapper;
    @Autowired
    private WlExporgConfigMapper wlExporgConfigMapper;

    @Override
    public void expCreateOrder(Map<String, Object> map) {
        ShunfengResponse response;
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        WlExporgApiDomain wlExporgApiDomain = new WlExporgApiDomain();
        wlExporgApiDomain.setExporgApiCode("005");
        wlExporgApiDomain.setExporgCode("shunfeng");
        WlExporgConfigDomain wlExporgConfigDomain = new WlExporgConfigDomain();
        wlExporgConfigDomain.setExporgConfigRemake("005");
        wlExporgConfigDomain.setExporgCode("shunfeng");
        WlExporgApiDomain apiDomain = this.wlExporgApiMapper.getWlExporgApi(wlExporgApiDomain);
        if (Objects.isNull(apiDomain)) {
            this.logger.error("api\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
            new ApiException("api\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List<WlExporgConfigDomain> configDomain = this.getWlExporgConfig(wlExporgConfigDomain);
        String accessToken = this.findTokenParam();
        String result = ShunfengUtil.instance().expCreateOrder(apiDomain, configDomain, accessToken, (String)map.get("msgData"));
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)result));
        if (StringUtils.isBlank((String)result)) {
            this.logger.error("\u914d\u7f6e\u95ee\u9898");
            new ApiException("\u914d\u7f6e\u95ee\u9898");
        }
        if ((response = (ShunfengResponse)JsonUtil.buildNonDefaultBinder().getJsonToObject(result, ShunfengResponse.class)).getApiResultCode().equals("A1000")) {
            return;
        }
        this.logger.info(JsonUtil.buildNonDefaultBinder().toJson((Object)response));
        new ApiException(response.getApiResultData());
    }

    @Override
    public void cancelOrder(Map<String, Object> map) {
        ShunfengResponse response;
        WlExporgApiDomain wlExporgApiDomain = new WlExporgApiDomain();
        wlExporgApiDomain.setExporgApiCode("006");
        wlExporgApiDomain.setExporgCode("shunfeng");
        WlExporgConfigDomain wlExporgConfigDomain = new WlExporgConfigDomain();
        wlExporgConfigDomain.setExporgConfigRemake("006");
        wlExporgConfigDomain.setExporgCode("shunfeng");
        WlExporgApiDomain apiDomain = this.wlExporgApiMapper.getWlExporgApi(wlExporgApiDomain);
        if (Objects.isNull(apiDomain)) {
            this.logger.error("api\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
            new ApiException("api\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List<WlExporgConfigDomain> configDomain = this.getWlExporgConfig(wlExporgConfigDomain);
        String accessToken = this.findTokenParam();
        String result = ShunfengUtil.instance().cancelOrder(wlExporgApiDomain, configDomain, accessToken, JsonUtil.buildNonDefaultBinder().toJson(map));
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)result));
        if (StringUtils.isBlank((String)result)) {
            this.logger.error("\u914d\u7f6e\u95ee\u9898");
            new ApiException("\u914d\u7f6e\u95ee\u9898");
        }
        if ((response = (ShunfengResponse)JsonUtil.buildNonDefaultBinder().getJsonToObject(result, ShunfengResponse.class)).getApiResultCode().equals("A1000")) {
            return;
        }
        this.logger.info(JsonUtil.buildNonDefaultBinder().toJson((Object)response));
        new ApiException(response.getApiResultData());
    }

    private String findTokenParam() {
        WlExporgApiDomain wlExporgApiDomain = new WlExporgApiDomain();
        wlExporgApiDomain.setExporgApiCode("004");
        wlExporgApiDomain.setExporgCode("shunfeng");
        String accessToken = SupDisUtil.getRemot((String)String.format(wlExporgApiDomain.getExporgApiCode(), wlExporgApiDomain.getExporgCode()));
        if (StringUtils.isBlank((String)accessToken)) {
            WlExporgConfigDomain wlExporgConfigDomain = new WlExporgConfigDomain();
            wlExporgConfigDomain.setExporgConfigRemake("004");
            wlExporgConfigDomain.setExporgCode("shunfeng");
            WlExporgApiDomain apiDomain = this.wlExporgApiMapper.getWlExporgApi(wlExporgApiDomain);
            if (Objects.isNull(apiDomain)) {
                this.logger.error("api\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
                new ApiException("api\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
            }
            List<WlExporgConfigDomain> configDomain = this.getWlExporgConfig(wlExporgConfigDomain);
            accessToken = this.getToken(apiDomain, configDomain);
        }
        return accessToken;
    }

    private String getToken(WlExporgApiDomain apiDomain, List<WlExporgConfigDomain> configDomain) {
        ShunfengResponse response = ShunfengUtil.instance().getAccessToken(apiDomain, configDomain);
        SupDisUtil.set((String)String.format(apiDomain.getExporgApiCode(), apiDomain.getExporgCode()), (String)response.getAccessToken(), (int)(response.getExpiresIn() - 1000));
        return response.getAccessToken();
    }

    private List<WlExporgConfigDomain> getWlExporgConfig(WlExporgConfigDomain domain) {
        return this.wlExporgConfigMapper.query(domain);
    }
}

