/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.util.shunfeng;

import com.yqbsoft.laser.service.da.domain.wl.WlExporgApiDomain;
import com.yqbsoft.laser.service.da.domain.wl.WlExporgConfigDomain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.util.HttpRequest;
import com.yqbsoft.laser.service.util.shunfeng.ShunfengResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ShunfengUtil {
    private static final Logger logger = LoggerFactory.getLogger(ShunfengUtil.class);
    private static ShunfengUtil shunfengUtil = null;

    public static ShunfengUtil instance() {
        if (shunfengUtil == null) {
            shunfengUtil = new ShunfengUtil();
            return shunfengUtil;
        }
        return shunfengUtil;
    }

    public ShunfengResponse getAccessToken(WlExporgApiDomain apiDomain, List<WlExporgConfigDomain> configDomain) {
        String param = this.getParam(configDomain);
        String str = HttpRequest.sendPost(apiDomain.getExporgApiApicode() + "?" + param, null);
        return (ShunfengResponse)JsonUtil.buildNonDefaultBinder().getJsonToObject(str, ShunfengResponse.class);
    }

    private String getParam(List<WlExporgConfigDomain> configDomain) {
        String param = "";
        for (int i = 0; i < configDomain.size(); ++i) {
            param = i == configDomain.size() ? param + configDomain.get(i).getExporgConfigKey() + "=" + configDomain.get(i).getExporgConfigVaule() : param + configDomain.get(i).getExporgConfigKey() + "=" + configDomain.get(i).getExporgConfigVaule() + "&";
        }
        return param;
    }

    public String expCreateOrder(WlExporgApiDomain wlExporgApiDomain, List<WlExporgConfigDomain> configDomain, String accessToken, String msgData) {
        List list = configDomain.stream().filter(c -> c.getExporgConfigKey().equals("partnerID")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        WlExporgConfigDomain wlExporgConfigDomain = (WlExporgConfigDomain)list.get(0);
        String param = wlExporgConfigDomain.getExporgConfigKey() + "=" + wlExporgConfigDomain.getExporgConfigVaule() + "&accessToken=" + accessToken + "&requestID=" + UUID.randomUUID().toString().replace("-", "") + "&serviceCode=" + wlExporgApiDomain.getExporgApiApiver() + "&timestamp=" + System.currentTimeMillis() + "&msgData=" + msgData;
        logger.info("\u6253\u5370\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u7684\u65e5\u5fd7\uff1a{}", (Object)param);
        return HttpRequest.sendPost(wlExporgApiDomain.getExporgApiApicode() + "?" + param, null);
    }

    public String cancelOrder(WlExporgApiDomain wlExporgApiDomain, List<WlExporgConfigDomain> configDomain, String accessToken, String msgData) {
        List list = configDomain.stream().filter(c -> c.getExporgConfigKey().equals("partnerID")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        WlExporgConfigDomain wlExporgConfigDomain = (WlExporgConfigDomain)list.get(0);
        String param = wlExporgConfigDomain.getExporgConfigKey() + "=" + wlExporgConfigDomain.getExporgConfigVaule() + "&accessToken=" + accessToken + "&requestID=" + UUID.randomUUID().toString().replace("-", "") + "&serviceCode=" + wlExporgApiDomain.getExporgApiApiver() + "&timestamp=" + System.currentTimeMillis() + "&msgData=" + msgData;
        logger.info("\u6253\u5370\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u7684\u65e5\u5fd7\uff1a{}", (Object)param);
        return HttpRequest.sendPost(wlExporgApiDomain.getExporgApiApicode() + "?" + param, null);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String param = "partnerID=LZfNDzRLo&accessToken=1DAC443BEE9146D5A150535F258C2065&requestID=" + UUID.randomUUID().toString().replace("-", "") + "&serviceCode=EXP_RECE_CREATE_ORDER&timestamp=" + System.currentTimeMillis() + "&msgData={\"cargoDetails\":[{\"count\":2.365,\"unit\":\"\u4e2a\",\"weight\":6.1,\"amount\":100.5111,\"currency\":\"HKD\",\"name\":\"\u62a4\u80a4\u54c11\",\"sourceArea\":\"CHN\"}],\"contactInfoList\":[{\"address\":\"\u5e7f\u4e1c\u7701\u6df1\u5733\u5e02\u5357\u5c71\u533a\u8f6f\u4ef6\u4ea7\u4e1a\u57fa\u573011\u680b\",\"contact\":\"\u5c0f\u66fe\",\"contactType\":1,\"country\":\"CN\",\"postCode\":\"580058\",\"tel\":\"4006789888\"},{\"address\":\"\u5e7f\u4e1c\u7701\u5e7f\u5dde\u5e02\u767d\u4e91\u533a\u6e56\u5317\u5927\u53a6\",\"company\":\"\u987a\u4e30\u901f\u8fd0\",\"contact\":\"\u5c0f\u90b1\",\"contactType\":2,\"country\":\"CN\",\"postCode\":\"580058\",\"tel\":\"18688806057\"}],\"language\":\"zh_CN\",\"orderId\":\"OrderNum20200612223\"}";
        logger.info("\u6253\u5370\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u7684\u65e5\u5fd7\uff1a{}", (Object)param);
        String s = HttpRequest.sendPost("https://sfapi-sbox.sf-express.com/std/service?" + param, null);
        System.out.println(s);
    }
}

