/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.dao.OcRefundMapper;
import com.yqbsoft.laser.service.da.domain.store.GuideDomain;
import com.yqbsoft.laser.service.da.domain.store.StoreStatisticsDetailDomain;
import com.yqbsoft.laser.service.da.domain.store.StoreStatisticsDomain;
import com.yqbsoft.laser.service.da.domain.store.StoreStatisticsUserDomain;
import com.yqbsoft.laser.service.da.service.StoreStatisticsService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class StoreStatisticsServiceImpl
extends BaseServiceImpl
implements StoreStatisticsService {
    public static final String DATETIMESHOWFORMAT3 = "yyyy-MM-dd 23:59:59";
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;

    @Override
    public StoreStatisticsDomain storeStatisticsQuery(Map<String, Object> map) {
        this.logger.info("\u6253\u5370storeStatisticsQuery\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        StoreStatisticsDomain contractStatistics = this.ocContractMapper.getStoreContractStatistics(map);
        this.logger.info("\u6253\u5370contractStatistics\u7ed3\u679c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)contractStatistics));
        StoreStatisticsDomain refundStatistics = this.ocRefundMapper.getStoreRefundStatistics(map);
        this.logger.info("\u6253\u5370refundStatistics\u7ed3\u679c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)refundStatistics));
        Integer userTotal = this.ocContractMapper.getStoreUserStatistics(map);
        this.logger.info("\u6253\u5370userTotal\u7ed3\u679c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)userTotal));
        if (!map.containsKey("startTime")) {
            Date startTime = DateUtils.dateToDate((Date)new Date(), (String)"yyyy-MM-dd 00:00:00");
            Date endTime = DateUtils.dateToDate((Date)new Date(), (String)DATETIMESHOWFORMAT3);
            map.put("startTime", startTime);
            map.put("endTime", endTime);
        }
        StoreStatisticsDomain contractNowStatistics = this.ocContractMapper.getStoreContractStatistics(map);
        StoreStatisticsDomain refundNowStatistics = this.ocRefundMapper.getStoreRefundStatistics(map);
        Integer userNowTotal = this.ocContractMapper.getStoreUserStatistics(map);
        StoreStatisticsDomain storeStatisticsDomain = new StoreStatisticsDomain();
        storeStatisticsDomain.setContractTotalMoney(contractStatistics.getContractTotalMoney());
        storeStatisticsDomain.setContractTotalNum(contractStatistics.getContractTotalNum());
        storeStatisticsDomain.setRefundTotalMoney(refundStatistics.getContractTotalMoney());
        storeStatisticsDomain.setRefundTotalNum(refundStatistics.getContractTotalNum());
        storeStatisticsDomain.setContractNowTotalMoney(contractNowStatistics.getContractTotalMoney());
        storeStatisticsDomain.setContractNowTotalNum(contractNowStatistics.getContractTotalNum());
        storeStatisticsDomain.setRefundNowTotalMoney(refundNowStatistics.getContractTotalMoney());
        storeStatisticsDomain.setRefundNowTotalNum(refundNowStatistics.getContractTotalNum());
        storeStatisticsDomain.setUserTotal(userTotal);
        storeStatisticsDomain.setUserNowTotal(userNowTotal);
        return storeStatisticsDomain;
    }

    @Override
    public SupQueryResult<StoreStatisticsDetailDomain> storeStatisticsDetail(Map<String, Object> map) {
        this.logger.info("\u6253\u5370storeStatisticsDetail\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        Integer num = this.ocContractMapper.getStoreStatisticsDetailNum(map);
        List<StoreStatisticsDetailDomain> list = null;
        if (num > 0) {
            list = this.ocContractMapper.getStoreStatisticsDetail(map);
        }
        SupQueryResult result = new SupQueryResult();
        result.setTotal((long)num.intValue());
        result.setList(list);
        return result;
    }

    @Override
    public SupQueryResult<StoreStatisticsUserDomain> storeStatisticsUser(Map<String, Object> map) {
        this.logger.info("\u6253\u5370storeStatisticsUser\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        Integer num = this.ocContractMapper.getStoreStatisticsUserNum(map);
        List<StoreStatisticsUserDomain> list = null;
        if (num > 0) {
            list = this.ocContractMapper.getStoreStatisticsUser(map);
        }
        SupQueryResult result = new SupQueryResult();
        result.setTotal((long)num.intValue());
        result.setList(list);
        return result;
    }

    @Override
    public List<GuideDomain> queryGuide(Map<String, Object> map) {
        this.logger.info("\u6253\u5370queryGuide\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return this.ocContractMapper.queryGuide(map);
    }
}

