/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.util.http;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.util.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.springframework.web.multipart.MultipartFile;

public class HttpConnect {
    private static HttpConnect httpConnect = new HttpConnect();
    private static final String envVersion = "release";
    MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();

    public static HttpConnect getInstance() {
        return httpConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doGetStr(String url) {
        String CONTENT_CHARSET = "GBK";
        long time1 = System.currentTimeMillis();
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(55000);
        client.getParams().setParameter("http.protocol.content-charset", (Object)CONTENT_CHARSET);
        GetMethod method = new GetMethod(url);
        HttpResponse response = new HttpResponse();
        try {
            client.executeMethod((HttpMethod)method);
            System.out.println("\u8c03\u63a5\u53e3\u8fd4\u56de\u7684\u65f6\u95f4:" + (System.currentTimeMillis() - time1));
            response.setStringResult(method.getResponseBodyAsString());
        }
        catch (HttpException e) {
            method.releaseConnection();
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        catch (IOException e) {
            method.releaseConnection();
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doPostStr(String url, String param) throws UnsupportedEncodingException {
        String CONTENT_CHARSET = "UTF-8";
        long time1 = System.currentTimeMillis();
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(55000);
        client.getParams().setParameter("http.protocol.content-charset", (Object)CONTENT_CHARSET);
        PostMethod method = new PostMethod(url);
        StringRequestEntity stringRequestEntity = new StringRequestEntity(param, "application/x-www-form-urlencoded", "UTF-8");
        method.setRequestEntity((RequestEntity)new StringRequestEntity(param, "application/x-www-form-urlencoded", "UTF-8"));
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)method.getRequestEntity()));
        HttpResponse response = new HttpResponse();
        try {
            client.executeMethod((HttpMethod)method);
            System.out.println("\u8c03\u63a5\u53e3\u8fd4\u56de\u7684\u65f6\u95f4:" + (System.currentTimeMillis() - time1));
            response.setStringResult(method.getResponseBodyAsString());
        }
        catch (HttpException e) {
            method.releaseConnection();
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        catch (IOException e) {
            method.releaseConnection();
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doPostFile(String url, MultipartFile file) throws IOException {
        String CONTENT_CHARSET = "GBK";
        long time1 = System.currentTimeMillis();
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(55000);
        client.getParams().setParameter("http.protocol.content-charset", (Object)CONTENT_CHARSET);
        PostMethod method = new PostMethod(url);
        InputStream is = file.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        byte[] b = new byte[1024];
        while ((len = is.read(b, 0, b.length)) != -1) {
            baos.write(b, 0, len);
        }
        byte[] buffer = baos.toByteArray();
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(new Part[]{new FilePart("media", (PartSource)new ByteArrayPartSource(file.getOriginalFilename(), buffer))}, method.getParams()));
        HttpResponse response = new HttpResponse();
        try {
            client.executeMethod((HttpMethod)method);
            System.out.println("\u8c03\u63a5\u53e3\u8fd4\u56de\u7684\u65f6\u95f4:" + (System.currentTimeMillis() - time1));
            response.setStringResult(method.getResponseBodyAsString());
        }
        catch (HttpException e) {
            method.releaseConnection();
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        catch (IOException e) {
            method.releaseConnection();
            HttpResponse httpResponse = null;
            return httpResponse;
        }
        finally {
            baos.close();
            is.close();
            method.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostImg(String url, String param) throws UnsupportedEncodingException {
        String CONTENT_CHARSET = "UTF-8";
        long time1 = System.currentTimeMillis();
        HttpClient client = new HttpClient((HttpConnectionManager)this.connectionManager);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(55000);
        client.getParams().setParameter("http.protocol.content-charset", (Object)CONTENT_CHARSET);
        PostMethod method = new PostMethod(url);
        StringRequestEntity stringRequestEntity = new StringRequestEntity(param, "application/json", "UTF-8");
        method.setRequestEntity((RequestEntity)new StringRequestEntity(param, "application/json", "UTF-8"));
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)method.getRequestEntity()));
        String result = "";
        try {
            client.executeMethod((HttpMethod)method);
            System.out.println("\u8c03\u63a5\u53e3\u8fd4\u56de\u7684\u65f6\u95f4:" + (System.currentTimeMillis() - time1));
            InputStream responseBodyAsStream = method.getResponseBodyAsStream();
            byte[] bytes = this.InputStreamToByte(responseBodyAsStream);
            result = Base64.encodeBase64String((byte[])bytes);
        }
        catch (HttpException e) {
            method.releaseConnection();
            String string = null;
            return string;
        }
        catch (IOException e) {
            method.releaseConnection();
            String string = null;
            return string;
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private byte[] InputStreamToByte(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((ch = in.read(buffer)) != -1) {
            bytestream.write(buffer, 0, ch);
        }
        byte[] data = bytestream.toByteArray();
        bytestream.close();
        return data;
    }
}

