/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.da.service.impl;

import com.yqbsoft.laser.service.da.dao.OcContractMapper;
import com.yqbsoft.laser.service.da.dao.OcRefundMapper;
import com.yqbsoft.laser.service.da.domain.StatisticsContractDomain;
import com.yqbsoft.laser.service.da.domain.StatisticsGraphicalDomain;
import com.yqbsoft.laser.service.da.service.StatisticsService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class StatisticsServiceImpl
extends BaseServiceImpl
implements StatisticsService {
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;

    @Override
    public StatisticsContractDomain statisticsQueryTotal(Map<String, Object> map) {
        StatisticsContractDomain domain = this.ocContractMapper.statisticsContactData(map);
        Integer memberNum = this.ocContractMapper.statisticsUser(map);
        domain.setMemberTotal(memberNum);
        Integer memberQdNum = this.ocContractMapper.statisticsQdUser(map);
        domain.setMemberQdTotal(memberQdNum);
        StatisticsContractDomain refundData = this.ocRefundMapper.statisticsRefundData(map);
        domain.setRefundMoney(refundData.getRefundMoney());
        domain.setOnlyRefundNum(refundData.getOnlyRefundNum());
        domain.setExchangeRefundNum(refundData.getExchangeRefundNum());
        domain.setReturnRefundNum(refundData.getReturnRefundNum());
        domain.setPayPrice(new BigDecimal(StringUtils.isNotBlank((String)domain.getContactPrice()) ? domain.getContactPrice() : "0").subtract(new BigDecimal(StringUtils.isNotBlank((String)refundData.getRefundMoney()) ? refundData.getRefundMoney() : "0")).toString());
        return domain;
    }

    @Override
    public StatisticsGraphicalDomain statisticsQueryGraphical(Map<String, Object> map) {
        StatisticsGraphicalDomain statisticsGraphicalDomain = new StatisticsGraphicalDomain();
        try {
            String startTime = (String)map.get("startTime");
            String endTime = (String)map.get("endTime");
            String memberCode = (String)map.get("memberCode");
            if (StringUtils.isBlank((String)startTime) || StringUtils.isBlank((String)endTime) || StringUtils.isBlank((String)memberCode)) {
                this.logger.info("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
                return null;
            }
            return this.getXaxis(map, statisticsGraphicalDomain);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return statisticsGraphicalDomain;
        }
    }

    private void monthData(Map<String, Object> map, int i, List<String> xaxis, List<StatisticsContractDomain> series, String oldEndTime) throws ParseException {
        if (i != xaxis.size()) {
            String startTime = xaxis.get(i);
            map.put("startTime", startTime);
            String endTime = StatisticsServiceImpl.lastDate(DateUtils.parseDate((String)startTime, (String)"yyyy-MM-dd"));
            map.put("endTime", endTime);
            series.add(this.statisticsQueryTotal(map));
        } else {
            String startTime = xaxis.get(i);
            map.put("startTime", startTime);
            map.put("endTime", oldEndTime);
            series.add(this.statisticsQueryTotal(map));
        }
    }

    private void dayData(Map<String, Object> map, int i, List<String> xaxis, List<StatisticsContractDomain> series) throws ParseException {
        String DATETIMESHOWFORMAT2 = "yyyy-MM-dd 23:59:59";
        String startTime = xaxis.get(i);
        map.put("startTime", startTime);
        String endTime = DateUtils.parseDateToString((Date)DateUtils.parseDate((String)xaxis.get(i), (String)"yyyy-MM-dd"), (String)DATETIMESHOWFORMAT2);
        map.put("endTime", endTime);
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\u65e5\u5fd7:", (Object)JsonUtil.buildNonDefaultBinder().toJson(series));
        series.add(this.statisticsQueryTotal(map));
    }

    private void hourData(Map<String, Object> map, int i, List<String> xaxis, List<StatisticsContractDomain> series) throws ParseException {
        String DATETIMESHOWFORMAT2 = "yyyy-MM-dd HH:59:59";
        String startTime = xaxis.get(i);
        map.put("startTime", startTime);
        String endTime = DateUtils.parseDateToString((Date)DateUtils.parseDate((String)xaxis.get(i), (String)"yyyy-MM-dd"), (String)DATETIMESHOWFORMAT2);
        map.put("endTime", endTime);
        series.add(this.statisticsQueryTotal(map));
    }

    public StatisticsGraphicalDomain getXaxis(Map<String, Object> map, StatisticsGraphicalDomain statisticsGraphicalDomain) throws ParseException {
        String startTime = (String)map.get("startTime");
        String endTime = (String)map.get("endTime");
        Long diffDay = DateUtil.getDiffDay((String)DateUtils.getDateString((Date)DateUtils.parseDate((String)startTime, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"), (String)DateUtils.getDateString((Date)DateUtils.parseDate((String)endTime, (String)"yyyy-MM-dd"), (String)"yyyyMMdd"));
        Integer isflag = 0;
        List<Object> xaxis = new ArrayList();
        if (diffDay == 0L) {
            xaxis = StatisticsServiceImpl.getHour(startTime);
        } else if (30L >= diffDay && diffDay > 0L) {
            isflag = 1;
            xaxis = StatisticsServiceImpl.getDay(startTime, diffDay);
        } else if (diffDay > 30L) {
            isflag = 2;
            xaxis = StatisticsServiceImpl.getMonth(startTime, diffDay);
        }
        statisticsGraphicalDomain.setxAxis(xaxis);
        if (!CollectionUtils.isEmpty(xaxis)) {
            this.logger.info("isflag:" + isflag);
            ArrayList<StatisticsContractDomain> series = new ArrayList<StatisticsContractDomain>();
            for (int i = 0; i < xaxis.size(); ++i) {
                if (isflag == 0) {
                    this.hourData(map, i, xaxis, series);
                    continue;
                }
                if (isflag == 1) {
                    this.dayData(map, i, xaxis, series);
                    continue;
                }
                if (isflag != 2) continue;
                this.monthData(map, i, xaxis, series, endTime);
            }
            statisticsGraphicalDomain.setSeries(series);
        }
        return statisticsGraphicalDomain;
    }

    private static List<String> getDay(String startTime, Long diffDay) {
        ArrayList<String> list = new ArrayList<String>();
        long count = diffDay;
        String temp = startTime;
        int i = 0;
        while ((long)i <= count) {
            try {
                list.add(DateUtils.parseDate((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd")));
                temp = DateUtils.parseDate((Date)DateUtils.addDays((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd"), (int)1));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    private static List<String> getMonth(String startTime, Long diffDay) {
        ArrayList<String> list = new ArrayList<String>();
        long count = diffDay / 30L;
        String temp = startTime;
        int i = 0;
        while ((long)i <= count) {
            try {
                if (i == 0) {
                    list.add(temp);
                } else {
                    temp = StatisticsServiceImpl.firstDate(DateUtils.addMonths((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd"), (int)1));
                    list.add(temp);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    private static List<String> getYear(String startTime, Long diffDay) {
        ArrayList<String> list = new ArrayList<String>();
        long count = diffDay / 365L;
        String temp = startTime;
        int i = 0;
        while ((long)i < count) {
            int year = DateUtils.getYear((String)temp);
            list.add(year + "");
            try {
                temp = DateUtils.parseDate((Date)DateUtils.addYears((Date)DateUtils.parseDate((String)temp, (String)"yyyy-MM-dd"), (int)1));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    private static List<String> getHour(String startTime) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 24; ++i) {
            try {
                list.add(DateUtils.parseDateToString((Date)DateUtils.addHours((Date)DateUtils.parseDate((String)(startTime + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"), (int)i), (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        return list;
    }

    public static String lastDate(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtils.getDateString((Date)lastDate, (String)"yyyy-MM-dd");
    }

    public static String firstDate(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        return DateUtils.getDateString((Date)firstDate, (String)"yyyy-MM-dd");
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("startTime", "2022-01-11");
            map.put("endTime", "2022-12-31");
            map.put("memberCode", "2233");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

