/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.at.service.impl;

import com.yqbsoft.laser.service.at.constants.TimerConstants;
import com.yqbsoft.laser.service.at.dao.TtAuctionTimerMapper;
import com.yqbsoft.laser.service.at.domain.TtAuctionTimerDomain;
import com.yqbsoft.laser.service.at.domain.TtAuctionTimerReDomain;
import com.yqbsoft.laser.service.at.listener.AuctionCleaningListener;
import com.yqbsoft.laser.service.at.listener.AuctionStartListener;
import com.yqbsoft.laser.service.at.model.AtAuction;
import com.yqbsoft.laser.service.at.model.AtAuctionWin;
import com.yqbsoft.laser.service.at.model.TtAuctionTimer;
import com.yqbsoft.laser.service.at.queue.AtAuctionQueue;
import com.yqbsoft.laser.service.at.service.AtAuctionCleaningService;
import com.yqbsoft.laser.service.at.service.AtAuctionService;
import com.yqbsoft.laser.service.at.service.AtAuctionWinService;
import com.yqbsoft.laser.service.at.service.TtAuctionTimerService;
import com.yqbsoft.laser.service.at.timer.AuctionTimerExeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;

public class TtAuctionTimerServiceImpl
extends BaseServiceImpl
implements TtAuctionTimerService,
AuctionStartListener,
AuctionCleaningListener {
    private static final String SYS_CODE = SYS_CODE + ".TtAuctionTimerImpl";
    private static final ExecutorService executor = Executors.newFixedThreadPool(5);
    private static final String AUCTION_ID = "AUCTION_ID_";
    @Autowired
    private TtAuctionTimerMapper ttAuctionTimerMapper;
    private AtAuctionQueue atAuctionQueue;
    @Autowired
    private AtAuctionWinService atAuctionWinService;
    @Autowired
    private AtAuctionService atAuctionService;
    @Autowired
    private AtAuctionCleaningService atAuctionCleaningService;
    private final Map<String, String> cleanMap = new HashMap<String, String>();
    private int checkNumError = 0;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    private Date getSysDate() {
        try {
            return this.ttAuctionTimerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkatAuctionTimer(TtAuctionTimerDomain ttAuctionTimerDomain) {
        if (null == ttAuctionTimerDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ttAuctionTimerDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setatAuctionTimerDefault(TtAuctionTimer ttAuctionTimer) {
        if (null == ttAuctionTimer) {
            return;
        }
        if (null == ttAuctionTimer.getTimerState()) {
            ttAuctionTimer.setTimerState(0);
        }
        Date date = this.getSysDate();
        if (null == ttAuctionTimer.getGmtCreate()) {
            ttAuctionTimer.setGmtCreate(date);
        }
        ttAuctionTimer.setGmtModified(date);
        if (StringUtils.isBlank((String)ttAuctionTimer.getTimerCode())) {
            ttAuctionTimer.setTimerCode(this.getNo(null, "TtAuctionTimer", "ttAuctionTimer", ttAuctionTimer.getTenantCode()));
        }
    }

    private int getatAuctionTimerMaxCode() {
        int code = 0;
        try {
            return this.ttAuctionTimerMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionTimerMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setatAuctionTimerUpdataDefault(TtAuctionTimer ttAuctionTimer) {
        if (null == ttAuctionTimer) {
            return;
        }
        ttAuctionTimer.setGmtModified(this.getSysDate());
    }

    private void saveatAuctionTimerModel(TtAuctionTimer ttAuctionTimer) throws ApiException {
        if (null == ttAuctionTimer) {
            return;
        }
        try {
            this.ttAuctionTimerMapper.insert(ttAuctionTimer);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveatAuctionTimerModel.ex", (Throwable)e);
        }
    }

    private void saveatAuctionTimerBatchModel(List<TtAuctionTimer> ttAuctionTimerList) throws ApiException {
        if (null == ttAuctionTimerList || ttAuctionTimerList.isEmpty()) {
            return;
        }
        try {
            this.ttAuctionTimerMapper.insertBatch(ttAuctionTimerList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveatAuctionTimerBatchModel.ex", (Throwable)e);
        }
    }

    private TtAuctionTimer getatAuctionTimerModelById(Integer timerId) {
        if (null == timerId) {
            return null;
        }
        try {
            return this.ttAuctionTimerMapper.selectByPrimaryKey(timerId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionTimerModelById", (Throwable)e);
            return null;
        }
    }

    private TtAuctionTimer getatAuctionTimerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ttAuctionTimerMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionTimerModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delatAuctionTimerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ttAuctionTimerMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delatAuctionTimerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delatAuctionTimerModelByCode.num");
        }
    }

    private void deleteatAuctionTimerModel(Integer timerId) throws ApiException {
        if (null == timerId) {
            return;
        }
        int i = 0;
        try {
            i = this.ttAuctionTimerMapper.deleteByPrimaryKey(timerId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteatAuctionTimerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteatAuctionTimerModel.num");
        }
    }

    private void updateatAuctionTimerModel(TtAuctionTimer ttAuctionTimer) throws ApiException {
        if (null == ttAuctionTimer) {
            return;
        }
        int i = 0;
        try {
            i = this.ttAuctionTimerMapper.updateByPrimaryKey(ttAuctionTimer);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateatAuctionTimerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateatAuctionTimerModel.num");
        }
    }

    private void updateStateatAuctionTimerModel(Integer timerId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == timerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timerId", timerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ttAuctionTimerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionTimerModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionTimerModel.null");
        }
    }

    private void updateStateatAuctionTimerModelByCode(String tenantCode, String timerCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)timerCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("timerCode", timerCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ttAuctionTimerMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionTimerModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionTimerModelByCode.null");
        }
    }

    private TtAuctionTimer makeatAuctionTimer(TtAuctionTimerDomain ttAuctionTimerDomain, TtAuctionTimer ttAuctionTimer) {
        if (null == ttAuctionTimerDomain) {
            return null;
        }
        if (null == ttAuctionTimer) {
            ttAuctionTimer = new TtAuctionTimer();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ttAuctionTimer, (Object)ttAuctionTimerDomain);
            return ttAuctionTimer;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeatAuctionTimer", (Throwable)e);
            return null;
        }
    }

    private TtAuctionTimerReDomain makeTtAuctionTimerReDomain(TtAuctionTimer ttAuctionTimer) {
        if (null == ttAuctionTimer) {
            return null;
        }
        TtAuctionTimerReDomain ttAuctionTimerReDomain = new TtAuctionTimerReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ttAuctionTimerReDomain, (Object)ttAuctionTimer);
            return ttAuctionTimerReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeTtAuctionTimerReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TtAuctionTimer> queryatAuctionTimerModelPage(Map<String, Object> parammap) {
        try {
            return this.ttAuctionTimerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryatAuctionTimerModel", (Throwable)e);
            return null;
        }
    }

    private int countatAuctionTimer(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ttAuctionTimerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countatAuctionTimer", (Throwable)e);
        }
        return i;
    }

    private TtAuctionTimer findAuctionTimerByGoodsInfoId(String goodsInfoId) {
        if (StringUtils.isBlank((String)goodsInfoId)) {
            return null;
        }
        try {
            return this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".findAuctionTimerByGoodsInfoId", (Throwable)e);
            return null;
        }
    }

    private TtAuctionTimer createTtAuctionTimer(TtAuctionTimerDomain ttAuctionTimerDomain) {
        String msg = this.checkatAuctionTimer(ttAuctionTimerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveatAuctionTimer.checkatAuctionTimer", msg);
        }
        TtAuctionTimer ttAuctionTimer = this.makeatAuctionTimer(ttAuctionTimerDomain, null);
        this.setatAuctionTimerDefault(ttAuctionTimer);
        return ttAuctionTimer;
    }

    @Override
    public String saveatAuctionTimer(TtAuctionTimerDomain ttAuctionTimerDomain) throws ApiException {
        TtAuctionTimer ttAuctionTimer = this.createTtAuctionTimer(ttAuctionTimerDomain);
        this.saveatAuctionTimerModel(ttAuctionTimer);
        return ttAuctionTimer.getTimerCode();
    }

    @Override
    public String saveatAuctionTimerBatch(List<TtAuctionTimerDomain> ttAuctionTimerDomainList) throws ApiException {
        if (null == ttAuctionTimerDomainList || ttAuctionTimerDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TtAuctionTimer> ttAuctionTimerList = new ArrayList<TtAuctionTimer>();
        String code = "";
        for (TtAuctionTimerDomain ttAuctionTimerDomain : ttAuctionTimerDomainList) {
            TtAuctionTimer ttAuctionTimer = this.createTtAuctionTimer(ttAuctionTimerDomain);
            code = ttAuctionTimer.getTimerCode();
            ttAuctionTimerList.add(ttAuctionTimer);
        }
        this.saveatAuctionTimerBatchModel(ttAuctionTimerList);
        return code;
    }

    @Override
    public void updateatAuctionTimerState(Integer timerId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == timerId) {
            return;
        }
        this.updateStateatAuctionTimerModel(timerId, dataState, oldDataState, map);
    }

    @Override
    public void updateatAuctionTimerStateByCode(String tenantCode, String timerCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)timerCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateatAuctionTimerModelByCode(tenantCode, timerCode, dataState, oldDataState, map);
    }

    @Override
    public void updateatAuctionTimer(TtAuctionTimerDomain ttAuctionTimerDomain) throws ApiException {
        String msg = this.checkatAuctionTimer(ttAuctionTimerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateatAuctionTimer.checkatAuctionTimer", msg);
        }
        TtAuctionTimer oldTtAuctionTimer = this.getatAuctionTimerModelById(ttAuctionTimerDomain.getTimerId());
        if (null == oldTtAuctionTimer) {
            throw new ApiException(SYS_CODE + ".updateatAuctionTimer.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TtAuctionTimer ttAuctionTimer = this.makeatAuctionTimer(ttAuctionTimerDomain, oldTtAuctionTimer);
        this.setatAuctionTimerUpdataDefault(ttAuctionTimer);
        this.updateatAuctionTimerModel(ttAuctionTimer);
    }

    @Override
    public TtAuctionTimer getatAuctionTimer(Integer timerId) {
        if (null == timerId) {
            return null;
        }
        return this.getatAuctionTimerModelById(timerId);
    }

    @Override
    public void deleteatAuctionTimer(Integer timerId) throws ApiException {
        if (null == timerId) {
            return;
        }
        this.deleteatAuctionTimerModel(timerId);
    }

    @Override
    public QueryResult<TtAuctionTimer> queryatAuctionTimerPage(Map<String, Object> map) {
        List<TtAuctionTimer> ttAuctionTimerList = this.queryatAuctionTimerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countatAuctionTimer(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ttAuctionTimerList);
        return queryResult;
    }

    @Override
    public TtAuctionTimer getatAuctionTimerByCode(String tenantCode, String timerCode) throws ApiException {
        if (StringUtils.isBlank((String)timerCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("timerCode", timerCode);
        return this.getatAuctionTimerModelByCode(map);
    }

    @Override
    public void deleteatAuctionTimerByCode(String tenantCode, String timerCode) throws ApiException {
        if (StringUtils.isBlank((String)timerCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("timerCode", timerCode);
        this.delatAuctionTimerModelByCode(map);
    }

    private TtAuctionTimer findAuctionTimerByAuctionId(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return null;
        }
        try {
            return this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(auctionId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".findAuctionTimerByAuctionId", (Throwable)e);
            return null;
        }
    }

    private int findAuctionTimerUnfinished(String auctionId) {
        if (auctionId == null) {
            this.logger.error(SYS_CODE + "findAuctionTimerUnfinished===========\u67e5\u8be2\u573a\u6b21\u662f\u5426\u6709\u672a\u7ed3\u675f\u7684\u5546\u54c1=============\u53c2\u6570\u9519\u8bef");
            throw new ApiException(SYS_CODE + ".findAuctionTimerUnfinished", "param is null");
        }
        try {
            return this.ttAuctionTimerMapper.findAuctionTimerUnfinished(auctionId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + "findAuctionTimerUnfinished", (Throwable)e);
            return 0;
        }
    }

    private void updateAuctionGoodsInfoTimerFinish(String goodsInfoId) {
        if (goodsInfoId == null) {
            this.logger.error(SYS_CODE + "updateAuctionGoodsInfoTimerFinish===========\u66f4\u65b0\u5546\u54c1\u7ade\u4ef7\u72b6\u6001\u4e3a\u7ed3\u675f=============\u53c2\u6570\u9519\u8bef");
            throw new ApiException(SYS_CODE + ".updateAuctionGoodsInfoTimerFinish", "param is null");
        }
        try {
            this.ttAuctionTimerMapper.updateAuctionGoodsInfoTimerFinish(goodsInfoId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + "updateAuctionGoodsInfoTimerFinish", (Throwable)e);
        }
    }

    private void updateAuctionTimerFinish(String auctionId) {
        if (auctionId == null) {
            this.logger.error(SYS_CODE + "updateAuctionTimerFinish===========\u66f4\u65b0\u573a\u6b21\u72b6\u6001\u4e3a\u7ed3\u675f=============\u53c2\u6570\u9519\u8bef");
            throw new ApiException(SYS_CODE + ".updateAuctionTimerFinish", "param is null");
        }
        try {
            this.ttAuctionTimerMapper.updateAuctionTimerFinish(auctionId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + "updateAuctionTimerFinish", (Throwable)e);
        }
    }

    private List<TtAuctionTimer> selectUnfinishedAuctionTimer() {
        try {
            return this.ttAuctionTimerMapper.selectUnfinishedAuctionTimer();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".selectUnfinishedAuctionTimer", (Throwable)e);
            return null;
        }
    }

    private List<TtAuctionTimer> selectUnfinishedGoodsTimer() {
        try {
            return this.ttAuctionTimerMapper.selectUnfinishedGoodsTimer();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".selectUnfinishedAuctionTimer", (Throwable)e);
            return null;
        }
    }

    @Override
    public String addAuctionTimer(String atAuctionStr) throws ApiException {
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        TtAuctionTimer tt = this.findAuctionTimerByAuctionId(atAuction.getAuctionCode());
        Date date = new Date();
        if (null == tt) {
            TtAuctionTimerDomain ttAuctionTimerDomain = new TtAuctionTimerDomain();
            ttAuctionTimerDomain.setTimerCode(UUID.randomUUID().toString());
            ttAuctionTimerDomain.setTimerAuctionId(atAuction.getAuctionCode());
            ttAuctionTimerDomain.setTimerGoodsInfoId("0");
            ttAuctionTimerDomain.setTimerStartDatetime(atAuction.getAuctionSdate());
            ttAuctionTimerDomain.setTimerEndDatetime(atAuction.getAuctionEdate());
            if (atAuction.getAuctionType().equals("00")) {
                ttAuctionTimerDomain.setTimerStartDatetime(atAuction.getGmtCreate());
                ttAuctionTimerDomain.setTimerEndDatetime(atAuction.getAuctionAgdate());
            }
            ttAuctionTimerDomain.setTimerState(0);
            ttAuctionTimerDomain.setGmtCreate(date);
            ttAuctionTimerDomain.setGmtModified(date);
            ttAuctionTimerDomain.setTenantCode(atAuction.getTenantCode());
            String result = this.saveatAuctionTimer(ttAuctionTimerDomain);
            this.logger.error("==================addAuctionTimer=", (Object)("\u4fdd\u5b58\u7ed3\u679c\uff1a" + result));
            try {
                tt = new TtAuctionTimer();
                BeanUtils.copyAllPropertys((Object)tt, (Object)ttAuctionTimerDomain);
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE + ".addAuctionTimer.copyAllPropertys", (Throwable)e);
            }
        } else {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            if (atAuction.getAuctionType().equals("00")) {
                tt.setTimerStartDatetime(atAuction.getGmtCreate());
                tt.setTimerEndDatetime(atAuction.getAuctionAgdate());
            }
            this.updateatAuctionTimerModel(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
        }
        assert (tt != null);
        if (tt.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
            final TtAuctionTimer finalTt = tt;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    TtAuctionTimerServiceImpl.this.noticeAuctionStart(finalTt);
                }
            });
        } else {
            AuctionTimerExeService.getInstance().auctionStartTimer(AUCTION_ID + tt.getTimerAuctionId(), tt.getTimerStartDatetime(), tt, this);
            this.logger.error("addAuctionTimer =====\u65b0\u589e\u7ade\u62cd.\u52a0\u5165\u5b9a\u65f6=====", (Object)("\u573a\u6b21code:" + atAuction.getAuctionCode() + ",taskId:" + AUCTION_ID + tt.getTimerAuctionId()));
        }
        return "SUCCESS";
    }

    @Override
    public void initReuseAuctionTimer() throws ApiException {
        this.logger.error("initRepeatListedAuction", (Object)("====================\u521d\u59cb\u5316\u91cd\u590d\u5355\u54c1\u5f00\u59cb==================\u6267\u884c\u65f6\u95f4\uff1a" + new Date()));
        long start = System.currentTimeMillis();
        List<AtAuction> list = this.getAuctions();
        this.logger.error("list============" + JsonUtil.buildNormalBinder().toJson(list));
        Date date = new Date();
        if (null != list && !list.isEmpty()) {
            block0: for (AtAuction la : list) {
                HashMap<String, String> queryMap1 = new HashMap<String, String>();
                queryMap1.put("tenantCode", la.getTenantCode());
                queryMap1.put("auctionCode", la.getAuctionCode());
                queryMap1.put("auctionType", "09");
                HashMap<String, Object> auctionWinMap = new HashMap<String, Object>();
                auctionWinMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMap1));
                QueryResult<AtAuctionWin> quresultConf = this.atAuctionWinService.queryatAuctionWinPage(auctionWinMap);
                this.logger.error("quresultConf================" + JsonUtil.buildNormalBinder().toJson((Object)quresultConf.getList()));
                if (quresultConf.getList().isEmpty()) continue;
                this.logger.error("\u6d41\u6807======================");
                String wStr = la.getAuctionOcode();
                List weeks = JsonUtil.buildNormalBinder().getJsonToList(wStr, String.class);
                if (ListUtil.isEmpty((Collection)weeks)) continue;
                for (String w : weeks) {
                    String t = TtAuctionTimerServiceImpl.dayOfWeek(date);
                    if (!w.equals(t)) continue;
                    String nowDate = DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd");
                    String startTime = DateUtil.getDateString((Date)la.getAuctionSdate(), (String)"HH:mm:ss");
                    StringBuilder startSb = new StringBuilder();
                    startSb.append(nowDate);
                    startSb.append(" ");
                    startSb.append(startTime);
                    la.setAuctionSdate(DateUtil.isDate((String)startSb.toString()));
                    if (TimerConstants.AUCTION_STATE_2.equals(la.getDataState())) {
                        la.setDataState(TimerConstants.AUCTION_STATE_0);
                    }
                    String endTime = DateUtil.parsTime((Date)la.getAuctionEdate());
                    StringBuilder endSb = new StringBuilder();
                    endSb.append(nowDate);
                    endSb.append(" ");
                    endSb.append(endTime);
                    la.setAuctionEdate(DateUtil.isDate((String)endSb.toString()));
                    this.logger.error("-------------------");
                    String apiCode = "at.atAuction.updateAuction";
                    HashMap<String, String> queryMap = new HashMap<String, String>();
                    queryMap.put("atAuction", JsonUtil.buildNonDefaultBinder().toJson((Object)la));
                    String s = this.internalInvoke(apiCode, queryMap);
                    this.logger.error("s-------------------" + s);
                    this.addAuctionTimer(JsonUtil.buildNonDefaultBinder().toJson((Object)la));
                    continue block0;
                }
            }
        }
        this.logger.error(".initRepeatListedAuction", (Object)("====================\u521d\u59cb\u5316\u91cd\u590d\u5355\u54c1\u7ed3\u675f==================time:" + (System.currentTimeMillis() - start)));
    }

    private String noticeAuctionStart(TtAuctionTimer timer) throws ApiException {
        String respStr = this.atAuctionService.auctionStartWithTimer(timer.getTimerAuctionId());
        if (respStr != null) {
            String goodsInfoIdListStr;
            timer.setTimerState(1);
            this.logger.error("=======noticeAuctionStart====\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + "\u63d0\u4ea4\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u8fd4\u56de============" + respStr);
            this.updateatAuctionTimerModel(timer);
            if (respStr.equals("SUCCESS")) {
                return "SUCCESS";
            }
            Map resp = (Map)JsonUtil.getAllJsonUtil().getJsonToObject(respStr, Map.class);
            if (null == resp) {
                return "ERROR";
            }
            this.logger.error("=======resp\uff1a", (Object)resp);
            String atAuctionStr = resp.get("atAuctionStr") == null ? null : resp.get("atAuctionStr").toString();
            String string = goodsInfoIdListStr = resp.get("goodsInfoIdListStr") == null ? null : resp.get("goodsInfoIdListStr").toString();
            if (null == atAuctionStr || null == goodsInfoIdListStr) {
                throw new ApiException("\u8fd4\u56de\u503c atAuctionStr \u4e3a\u7a7a \u6216\u8005 goodsInfoIdListStr\u4e3a\u7a7a");
            }
            this.addGoodsInfoTimers(atAuctionStr, goodsInfoIdListStr);
            this.logger.error("=======noticeAuctionStart====\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + "\u63d0\u4ea4\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u8fd4\u56de============" + respStr);
        }
        return "SUCCESS";
    }

    @Override
    public String updateAuctionTimer(AtAuction atAuction) throws ApiException {
        TtAuctionTimer tt = this.findAuctionTimerByAuctionId(atAuction.getAuctionCode());
        if (tt == null) {
            throw new ApiException(SYS_CODE + ".updateatAuctionTimer.TtAuctionTimer", "null");
        }
        if (tt.getTimerStartDatetime().getTime() - atAuction.getAuctionSdate().getTime() != 0L || tt.getTimerEndDatetime().getTime() - atAuction.getAuctionEdate().getTime() != 0L) {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            this.updateatAuctionTimerModel(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
        }
        return "SUCCESS";
    }

    @Override
    public String addGoodsInfoTimers(String atAuctionStr, String goodsInfoIdListStr) throws ApiException {
        this.logger.error("===========atAuctionStr\uff1a" + atAuctionStr + " goodsInfoIdListStr============" + goodsInfoIdListStr);
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        this.logger.error("===========atAuction\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)atAuction));
        List goodsInfoIds = JsonUtil.buildNormalBinder().getJsonToList(goodsInfoIdListStr, String.class);
        this.logger.error(" goodsInfoIdListStr============" + JsonUtil.buildNormalBinder().toJson((Object)goodsInfoIds));
        Date date = new Date();
        for (String id : goodsInfoIds) {
            TtAuctionTimer tt1;
            TtAuctionTimer tt = this.findAuctionTimerByGoodsInfoId(id);
            if (null == tt) {
                TtAuctionTimerDomain ttAuctionTimer = new TtAuctionTimerDomain();
                ttAuctionTimer.setTimerCode(UUID.randomUUID().toString());
                ttAuctionTimer.setTimerAuctionId(atAuction.getAuctionCode());
                ttAuctionTimer.setTimerGoodsInfoId(id);
                ttAuctionTimer.setTimerState(1);
                ttAuctionTimer.setTimerStartDatetime(atAuction.getAuctionSdate());
                ttAuctionTimer.setTimerEndDatetime(atAuction.getAuctionEdate());
                ttAuctionTimer.setGmtCreate(date);
                ttAuctionTimer.setGmtModified(date);
                ttAuctionTimer.setTenantCode(atAuction.getTenantCode());
                this.saveatAuctionTimer(ttAuctionTimer);
            } else {
                tt.setTimerStartDatetime(atAuction.getAuctionSdate());
                tt.setTimerEndDatetime(atAuction.getAuctionEdate());
                this.updateatAuctionTimerModel(tt);
            }
            if (null == (tt1 = this.findAuctionTimerByGoodsInfoId(id)) || tt1.getTimerEndDatetime().getTime() - date.getTime() > 0L) continue;
            this.auctionGoodsInfoCleaning(tt1, new HashMap<String, String>());
        }
        return "SUCCESS";
    }

    @Override
    public String updateGoodsInfoTimer(String goodsInfoId, String endDatetimeStr) throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u5ef6\u65f6===========", (Object)(" ==========\u5ef6\u65f6\u5546\u54c1ID=" + goodsInfoId + " \u5ef6\u65f6\u65f6\u95f4\uff1a" + endDatetimeStr));
        TtAuctionTimer tt = this.findAuctionTimerByGoodsInfoId(goodsInfoId);
        if (null != tt) {
            Date date = DateUtil.isDate((String)endDatetimeStr);
            tt.setTimerEndDatetime(date);
            this.updateatAuctionTimerModel(tt);
            this.logger.error("======================\u66f4\u65b0\u5ef6\u65f6===========", (Object)" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=");
            TtAuctionTimer auctionTimer = this.findAuctionTimerByAuctionId(tt.getTimerAuctionId());
            if (auctionTimer != null && auctionTimer.getTimerEndDatetime().getTime() < tt.getTimerEndDatetime().getTime()) {
                auctionTimer.setTimerEndDatetime(tt.getTimerEndDatetime());
                this.updateatAuctionTimerModel(auctionTimer);
                this.logger.error("======================\u66f4\u65b0\u66f4\u65b0\u573a\u6b21\u7ed3\u675f\u65f6\u95f4===========", (Object)" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=");
            }
        }
        return "SUCCESS";
    }

    @Override
    public String initAuctionTimer() throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u5f00\u59cb===========");
        this.atAuctionQueue = new AtAuctionQueue(this);
        try {
            this.atAuctionQueue.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AuctionTimerExeService.getInstance().start();
        List<TtAuctionTimer> list = this.selectUnfinishedAuctionTimer();
        Date date = new Date();
        for (TtAuctionTimer auctionTimer : list) {
            if (auctionTimer.getTimerStartDatetime() == null) continue;
            this.logger.error("initAuctionTimer =====\u7ade\u4ef7\u521d\u59cb\u5316.\u5f00\u59cb\u65f6\u95f4=====", (Object)("\u7ade\u62cdcode:" + auctionTimer.getTimerAuctionId() + ",time:" + (auctionTimer.getTimerStartDatetime().getTime() - date.getTime())));
            HashMap<String, String> auctionMap = new HashMap<String, String>();
            auctionMap.put("auctionCode", auctionTimer.getTimerAuctionId());
            AtAuction auction = this.atAuctionService.getatAuctionMoByCode(auctionTimer.getTenantCode(), auctionTimer.getTimerAuctionId());
            if (auction.getAuctionType().equals("00") && auctionTimer.getTimerEndDatetime().getTime() - date.getTime() <= 0L) {
                this.atAuctionService.updateatAuctionState(auction.getAuctionId(), 2, auction.getDataState(), null);
                this.updateatAuctionTimerState(auctionTimer.getTimerId(), 2, auctionTimer.getTimerState(), null);
                continue;
            }
            if (auctionTimer.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
                this.atAuctionQueue.addAuction(auctionTimer);
                this.logger.error("initAuctionTimer =====\u7ade\u4ef7\u521d\u59cb\u5316.\u52a0\u5165\u961f\u5217=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)auctionTimer));
                continue;
            }
            this.logger.error("initAuctionTimer =====\u7ade\u4ef7\u521d\u59cb\u5316.\u52a0\u5165\u5b9a\u65f6=====", (Object)("taskId:AUCTION_ID_" + auctionTimer.getTimerAuctionId()));
            AuctionTimerExeService.getInstance().auctionStartTimer(AUCTION_ID + auctionTimer.getTimerAuctionId(), auctionTimer.getTimerStartDatetime(), auctionTimer, this);
        }
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u7ed3\u675f===========");
        return "SUCCESS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revealAllTimer() {
        if (StringUtils.isBlank((String)SupDisUtil.get((String)"revealAllTimerFlag"))) {
            try {
                if (!this.checkTaskHandelFull()) {
                    return;
                }
                SupDisUtil.set((String)"revealAllTimerFlag", (String)"true", (int)5);
                this.logger.error("======================\u62fc\u76d8\u5b9a\u65f6\u4efb\u52a1start===========" + SupDisUtil.get((String)"revealAllTimerFlag"));
                Date date = new Date();
                List<TtAuctionTimer> list = this.selectUnfinishedGoodsTimer();
                for (TtAuctionTimer tt : list) {
                    this.logger.error("======================\u62fc\u76d8\u5b9a\u65f6\u4efb\u52a1tt===========" + tt.getTimerCode());
                    if (tt.getTimerEndDatetime() == null || date.getTime() - tt.getTimerEndDatetime().getTime() <= 500L) continue;
                    this.cleanMap.put(tt.getTimerCode(), tt.getTimerCode());
                    this.auctionGoodsInfoCleaning(tt, this.cleanMap);
                }
            }
            catch (Exception e) {
                this.logger.error("======================\u62fc\u76d8\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38===========", (Object)e.getMessage());
            }
            finally {
                if (StringUtils.isNotBlank((String)SupDisUtil.get((String)"revealAllTimerFlag"))) {
                    SupDisUtil.del((String)"revealAllTimerFlag");
                }
            }
        }
    }

    private boolean checkTaskHandelFull() {
        if (!this.cleanMap.isEmpty()) {
            ++this.checkNumError;
            this.logger.error("=====\u5b9a\u65f6\u4efb\u52a1\u7ed3\u7b97.\u672a\u5168\u90e8\u5904\u7406=====\u5269\u4f59\u6570\u91cf\uff1a" + this.cleanMap.size() + ",\u5f02\u5e38\u6b21\u6570\uff1a" + this.checkNumError);
            if (this.checkNumError > 3) {
                this.checkNumError = 0;
                this.cleanMap.clear();
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
    }

    @Override
    public void auctionStart(TtAuctionTimer auction) {
        this.noticeAuctionStart(auction);
    }

    @Override
    public void noticeStart(TtAuctionTimer auction) {
        this.noticeAuctionStart(auction);
    }

    @Override
    public void auctionGoodsInfoCleaning(final TtAuctionTimer timer, final Map<String, String> cleanMapT) {
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u5f00\u59cb\u7ed3\u7b97===============");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                String result = TtAuctionTimerServiceImpl.this.atAuctionCleaningService.auctionGoodsInfoCleaning(timer.getTimerAuctionId(), timer.getTimerGoodsInfoId());
                TtAuctionTimerServiceImpl.this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + " \u7ade\u4ef7\u5546\u54c1\uff1a" + timer.getTimerGoodsInfoId() + " \u8bc4\u6807\u7ed3\u7b97\uff1a" + result);
                TtAuctionTimerServiceImpl.this.updateAuctionGoodsInfoTimerFinish(timer.getTimerGoodsInfoId());
                int count = TtAuctionTimerServiceImpl.this.findAuctionTimerUnfinished(timer.getTimerAuctionId());
                TtAuctionTimerServiceImpl.this.logger.error("==========\u8fd8\u5269 \u3010" + count + "\u3011\u4e2a\u5546\u54c1\u672a\u7ed3\u7b97");
                if (count <= 0) {
                    String temp = DateUtil.parseDateTime((Date)timer.getTimerEndDatetime());
                    String noticeResult = TtAuctionTimerServiceImpl.this.atAuctionService.auctionEndWithTimer(timer.getTimerAuctionId(), temp);
                    TtAuctionTimerServiceImpl.this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + " \u901a\u77e5\u7ed3\u679c\uff1a" + noticeResult);
                    TtAuctionTimerServiceImpl.this.updateAuctionTimerFinish(timer.getTimerAuctionId());
                }
                try {
                    if (cleanMapT != null) {
                        cleanMapT.remove(timer.getTimerCode());
                    }
                }
                catch (Exception e) {
                    TtAuctionTimerServiceImpl.this.logger.error("===========\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\u6e05\u9664\u5f02\u5e38=====");
                }
                TtAuctionTimerServiceImpl.this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u7ed3\u7b97\u5b8c\u6210===============");
            }
        });
    }

    @Override
    public void testOutTimer() {
        this.logger.error("===========\u5b9a\u65f6\u4efb\u52a1\u8f93\u51fa\u6d4b\u8bd5===========");
    }

    private List<AtAuction> getAuctions() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("auctionEocode", "1");
        param.put("auctionType", "09");
        HashMap<String, Object> auctionMap = new HashMap<String, Object>();
        auctionMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(param));
        QueryResult<AtAuction> quresultConf = this.atAuctionService.queryatAuctionPage(auctionMap);
        return quresultConf.getList();
    }

    private List<AtAuction> queryAuctionModel(Map<String, Object> parammap) {
        try {
            return this.ttAuctionTimerMapper.queryAuction(parammap);
        }
        catch (Exception e) {
            this.logger.error(".queryListedAuctionModel", (Throwable)e);
            return null;
        }
    }

    public static String dayOfWeek(Date date) {
        int day = DateUtil.getWeek((Date)date);
        switch (day) {
            case 1: {
                return "\u5468\u65e5";
            }
            case 2: {
                return "\u5468\u4e00";
            }
            case 3: {
                return "\u5468\u4e8c";
            }
            case 4: {
                return "\u5468\u4e09";
            }
            case 5: {
                return "\u5468\u56db";
            }
            case 6: {
                return "\u5468\u4e94";
            }
            case 7: {
                return "\u5468\u516d";
            }
        }
        return null;
    }
}

