/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.at.service.impl;

import com.yqbsoft.laser.service.at.dao.AtAuctionUserginfoMapper;
import com.yqbsoft.laser.service.at.dao.AtAuctiondtMapper;
import com.yqbsoft.laser.service.at.domain.AtAuctionEnrollReDomain;
import com.yqbsoft.laser.service.at.domain.AtAuctiondtDomain;
import com.yqbsoft.laser.service.at.domain.AtAuctiondtReDomain;
import com.yqbsoft.laser.service.at.domain.TaTransferaDomain;
import com.yqbsoft.laser.service.at.domain.TaTransferaListDomain;
import com.yqbsoft.laser.service.at.domain.UmUserinfo;
import com.yqbsoft.laser.service.at.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.at.domain.VdFaccountOuterDtDomain;
import com.yqbsoft.laser.service.at.model.AtAuctionUserginfo;
import com.yqbsoft.laser.service.at.model.AtAuctionWin;
import com.yqbsoft.laser.service.at.model.AtAuctiondt;
import com.yqbsoft.laser.service.at.service.AtAuctionEnrollService;
import com.yqbsoft.laser.service.at.service.AtAuctionWinService;
import com.yqbsoft.laser.service.at.service.AtAuctiondtService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AtAuctiondtServiceImpl
extends BaseServiceImpl
implements AtAuctiondtService {
    private static final String SYS_CODE = SYS_CODE + ".AtAuctiondtServiceImpl";
    private AtAuctiondtMapper atAuctiondtMapper;
    private AtAuctionUserginfoMapper atAuctionUserginfoMapper;
    private AtAuctionWinService atAuctionWinService;
    private AtAuctionEnrollService atAuctionEnrollService;

    public void setAtAuctionWinService(AtAuctionWinService atAuctionWinService) {
        this.atAuctionWinService = atAuctionWinService;
    }

    public void setAtAuctionUserginfoMapper(AtAuctionUserginfoMapper atAuctionUserginfoMapper) {
        this.atAuctionUserginfoMapper = atAuctionUserginfoMapper;
    }

    public AtAuctionEnrollService getAtAuctionEnrollService() {
        if (null == this.atAuctionEnrollService) {
            this.atAuctionEnrollService = (AtAuctionEnrollService)ApplicationContextUtil.getService((String)"atAuctionEnrollService");
        }
        return this.atAuctionEnrollService;
    }

    public void setAtAuctiondtMapper(AtAuctiondtMapper atAuctiondtMapper) {
        this.atAuctiondtMapper = atAuctiondtMapper;
    }

    private Date getSysDate() {
        try {
            return this.atAuctiondtMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctiondt(AtAuctiondtDomain atAuctiondtDomain) {
        if (null == atAuctiondtDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)atAuctiondtDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctiondtDefault(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return;
        }
        if (null == atAuctiondt.getDataState()) {
            atAuctiondt.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == atAuctiondt.getGmtCreate()) {
            atAuctiondt.setGmtCreate(date);
        }
        atAuctiondt.setGmtModified(date);
        if (StringUtils.isBlank((String)atAuctiondt.getAuctionDtCode())) {
            atAuctiondt.setAuctionDtCode(this.getNo(null, "AtAuctiondt", "atAuctiondt", atAuctiondt.getTenantCode()));
        }
    }

    private int getAuctiondtMaxCode() {
        int code = 0;
        try {
            return this.atAuctiondtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getAuctiondtMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctiondtUpdataDefault(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return;
        }
        atAuctiondt.setGmtModified(this.getSysDate());
    }

    private void saveAuctiondtModel(AtAuctiondt atAuctiondt) throws ApiException {
        if (null == atAuctiondt) {
            return;
        }
        try {
            this.atAuctiondtMapper.insert(atAuctiondt);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveAuctiondtModel.ex", (Throwable)e);
        }
    }

    private void updateAtAuctionWinState(Integer atAuctionWinId) throws ApiException {
        if (null == atAuctionWinId) {
            return;
        }
        try {
            this.atAuctionWinService.updateatAuctionWinState(atAuctionWinId, 1, 0, null);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateAtAuctionWinState.ex", (Throwable)e);
        }
    }

    private void saveAuctiondtBatchModel(List<AtAuctiondt> atAuctiondtList) throws ApiException {
        if (null == atAuctiondtList || atAuctiondtList.isEmpty()) {
            return;
        }
        try {
            this.atAuctiondtMapper.insertBatch(atAuctiondtList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveAuctiondtBatchModel.ex", (Throwable)e);
        }
    }

    private AtAuctiondt getAuctiondtModelById(Integer auctionDtId) {
        if (null == auctionDtId) {
            return null;
        }
        try {
            return this.atAuctiondtMapper.selectByPrimaryKey(auctionDtId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getAuctiondtModelById", (Throwable)e);
            return null;
        }
    }

    private AtAuctiondt getAuctiondtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.atAuctiondtMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getAuctiondtModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctiondtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delAuctiondtModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delAuctiondtModelByCode.num");
        }
    }

    private void deleteAuctiondtModel(Integer auctionDtId) throws ApiException {
        if (null == auctionDtId) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.deleteByPrimaryKey(auctionDtId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteAuctiondtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteAuctiondtModel.num");
        }
    }

    private void updateAuctiondtModel(AtAuctiondt atAuctiondt) throws ApiException {
        if (null == atAuctiondt) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateByPrimaryKey(atAuctiondt);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtModel.num");
        }
    }

    private void updateAuctiondtSelective(AtAuctiondt atAuctiondt) throws ApiException {
        if (null == atAuctiondt) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateByPrimaryKeySelective(atAuctiondt);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtSelective.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtSelective.num");
        }
    }

    private void updateStateAuctiondtModel(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionDtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionDtId", auctionDtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        expmap.put("auctionAudit", this.getSysDate());
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModel.ex", (Throwable)e);
        }
        if (i < 1) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModel.ex", "\u4fee\u6539\u5931\u8d25");
        }
    }

    private void updateStateAuctiondtModelForCheck(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionDtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionDtId", auctionDtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateStateByPrimaryKeyForCheck(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModelForCheck.ex", (Throwable)e);
        }
        if (i < 1) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModelForCheck.ex", "\u4fee\u6539\u5931\u8d25" + map);
        }
    }

    private void updateStateAuctiondtModelByCode(String tenantCode, String auctionDtCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionDtCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionDtCode", auctionDtCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModelByCode.ex", (Throwable)e);
        }
    }

    private void updateStateAuctiondtModelByCodeForCheck(String tenantCode, String auctionDtCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionDtCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionDtCode", auctionDtCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateStateByCodeForCheck(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModelByCodeForCheck.ex", (Throwable)e);
        }
    }

    private AtAuctiondt makeAuctiondt(AtAuctiondtDomain atAuctiondtDomain, AtAuctiondt atAuctiondt) {
        if (null == atAuctiondtDomain) {
            return null;
        }
        if (null == atAuctiondt) {
            atAuctiondt = new AtAuctiondt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)atAuctiondt, (Object)atAuctiondtDomain);
            return atAuctiondt;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeAuctiondt", (Throwable)e);
            return null;
        }
    }

    private AtAuctiondtReDomain makeAtAuctiondtReDomain(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return null;
        }
        AtAuctiondtReDomain atAuctiondtReDomain = new AtAuctiondtReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)atAuctiondtReDomain, (Object)atAuctiondt);
            return atAuctiondtReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeAtAuctiondtReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AtAuctiondt> queryAuctiondtModelPage(Map<String, Object> parammap) {
        List<AtAuctiondt> atAuctiondtList = null;
        try {
            atAuctiondtList = this.atAuctiondtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryAuctiondtModel", (Object)parammap.toString(), (Throwable)e);
        }
        return atAuctiondtList;
    }

    private int countAuctiondt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.atAuctiondtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countAuctiondt", (Throwable)e);
        }
        return i;
    }

    private AtAuctiondt createAtAuctiondt(AtAuctiondtDomain atAuctiondtDomain) {
        String msg = this.checkAuctiondt(atAuctiondtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveAuctiondt.checkAuctiondt", msg);
        }
        AtAuctiondt atAuctiondt = this.makeAuctiondt(atAuctiondtDomain, null);
        this.setAuctiondtDefault(atAuctiondt);
        return atAuctiondt;
    }

    @Override
    public String saveAuctiondt(AtAuctiondtDomain atAuctiondtDomain) throws ApiException {
        AtAuctiondt atAuctiondt = this.createAtAuctiondt(atAuctiondtDomain);
        if ("2".equals(atAuctiondt.getAuctionDtType())) {
            this.updateAtAuctionWinState(atAuctiondtDomain.getAuctionWinId());
            this.updateDepositDt(atAuctiondt);
        } else if ("3".equals(atAuctiondt.getAuctionDtType())) {
            this.updatecommiss(atAuctiondt, false);
        } else if ("4".equals(atAuctiondt.getAuctionDtType())) {
            this.updatePunishDt(atAuctiondt);
        } else {
            String tenantCode = atAuctiondt.getTenantCode();
            List<AtAuctionUserginfo> atAuctionUserginfos = this.queryatAuctionUserginfoModelPage(this.getQueryMapParam("auctionCode,tenantCode,memberBcode,auctionEnrollCode", new Object[]{atAuctiondt.getAuctionCode(), atAuctiondt.getTenantCode(), atAuctiondt.getMemberBcode(), atAuctiondt.getAuctionEnrollCode()}));
            for (AtAuctionUserginfo atAuctionUserginfo : atAuctionUserginfos) {
                this.updateStateatAuctionUserginfoModel(atAuctionUserginfo.getAuctionUserginfoId(), 1, atAuctionUserginfo.getDataState(), null);
            }
            this.getAtAuctionEnrollService().updatOnlyAuctionEnrollDstate(atAuctiondt.getAuctionEnrollCode(), 0, tenantCode, null);
        }
        this.saveAuctiondtModel(atAuctiondt);
        return atAuctiondt.getAuctionDtCode();
    }

    private void updatecommiss(AtAuctiondt atAuctiondt, boolean flag) {
        if (null == atAuctiondt) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("auctionDtType", "1");
        paramMap.put("fuzzy", true);
        List<AtAuctiondt> list = this.queryAuctiondtModelPage(paramMap);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        BigDecimal temp = new BigDecimal("0.00");
        boolean stop = false;
        for (AtAuctiondt auctiondt : list) {
            if (stop) break;
            if (null == auctiondt.getAuctionDtDpnum()) {
                auctiondt.setAuctionDtDpnum(BigDecimal.ZERO);
            }
            if (flag) {
                if (temp.compareTo(new BigDecimal("0.00")) < 0) {
                    BigDecimal tempAmount = auctiondt.getAuctionDtDpnum().add(temp);
                    if (tempAmount.compareTo(new BigDecimal("0")) < 0) {
                        tempAmount = new BigDecimal("0.00");
                    }
                    auctiondt.setAuctionDtDpnum(tempAmount);
                } else {
                    BigDecimal subAuctionDtDpnum = auctiondt.getAuctionDtDpnum().subtract(atAuctiondt.getAuctionDtDpnum());
                    if (subAuctionDtDpnum.compareTo(new BigDecimal("0")) < 0) {
                        temp = subAuctionDtDpnum;
                        subAuctionDtDpnum = new BigDecimal("0.00");
                    }
                    auctiondt.setAuctionDtDpnum(subAuctionDtDpnum);
                    if (subAuctionDtDpnum.compareTo(BigDecimal.ZERO) >= 0) {
                        stop = true;
                    }
                }
            }
            this.updateAuctiondtModel(auctiondt);
        }
    }

    private void updateDepositDt(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("auctionDtType", "1");
        paramMap.put("fuzzy", true);
        List<AtAuctiondt> auctions = this.queryAuctiondtModelPage(paramMap);
        if (ListUtil.isEmpty(auctions)) {
            return;
        }
        BigDecimal commissionAmount = atAuctiondt.getAuctionDtSdpnum();
        boolean stop = false;
        for (AtAuctiondt auction : auctions) {
            if (stop || commissionAmount.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal sub = auction.getAuctionDtDpnum().subtract(commissionAmount);
            auction.setAuctionDtDpnum(sub);
            if (sub.compareTo(BigDecimal.ZERO) < 0) {
                commissionAmount = commissionAmount.subtract(new BigDecimal(auction.getAuctionruleDpnum()));
                auction.setAuctionDtDpnum(BigDecimal.ZERO);
            } else {
                stop = true;
            }
            this.updateAuctiondtModel(auction);
        }
    }

    private void updatePunishDt(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("auctionDtType", "1");
        paramMap.put("fuzzy", true);
        List<AtAuctiondt> auctions = this.queryAuctiondtModelPage(paramMap);
        if (ListUtil.isEmpty(auctions)) {
            return;
        }
        BigDecimal punishAmount = atAuctiondt.getAuctionDtDpnum();
        boolean stop = false;
        for (AtAuctiondt auction : auctions) {
            if (auction.getAuctionDtDpnum().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (stop || punishAmount.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal sub = auction.getAuctionDtDpnum().subtract(punishAmount);
            if (sub.compareTo(BigDecimal.ZERO) < 0) {
                punishAmount = punishAmount.subtract(auction.getAuctionDtDpnum());
                auction.setAuctionDtDpnum(BigDecimal.ZERO);
            } else {
                auction.setAuctionDtDpnum(sub);
                stop = true;
            }
            this.updateAuctiondtModel(auction);
        }
    }

    private void updateCollectCommiss(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("auctionDtType", "2");
        paramMap.put("fuzzy", true);
        List<AtAuctiondt> list = this.queryAuctiondtModelPage(paramMap);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        AtAuctiondt collectCommissionDt = list.get(0);
        BigDecimal auctionDtDpnum = atAuctiondt.getAuctionDtDpnum();
        collectCommissionDt.setAuctionDtSdpnum(collectCommissionDt.getAuctionDtSdpnum().subtract(auctionDtDpnum));
        this.updateAuctiondtModel(collectCommissionDt);
    }

    private List<AtAuctionUserginfo> queryatAuctionUserginfoModelPage(Map<String, Object> parammap) {
        try {
            return this.atAuctionUserginfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryatAuctionUserginfoModel", (Throwable)e);
            return null;
        }
    }

    private void updateStateatAuctionUserginfoModel(Integer auctionUserginfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionUserginfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionUserginfoId", auctionUserginfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctionUserginfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionUserginfoModel.ex", (Throwable)e);
        }
    }

    @Override
    public String saveAuctiondtBatch(List<AtAuctiondtDomain> atAuctiondtDomainList) throws ApiException {
        if (null == atAuctiondtDomainList || atAuctiondtDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AtAuctiondt> atAuctiondtList = new ArrayList<AtAuctiondt>();
        String code = "";
        for (AtAuctiondtDomain atAuctiondtDomain : atAuctiondtDomainList) {
            AtAuctiondt atAuctiondt = this.createAtAuctiondt(atAuctiondtDomain);
            code = atAuctiondt.getAuctionDtCode();
            atAuctiondtList.add(atAuctiondt);
            this.getAtAuctionEnrollService().updatOnlyAuctionEnrollDstate(atAuctiondtDomain.getAuctionEnrollCode(), 0, atAuctiondtDomain.getTenantCode(), null);
        }
        if (ListUtil.isNotEmpty(atAuctiondtList)) {
            AtAuctiondt atAuctiondt1 = (AtAuctiondt)atAuctiondtList.get(0);
            this.saveAuctiondtBatchModel(atAuctiondtList);
            List<AtAuctionUserginfo> atAuctionUserginfos = this.queryatAuctionUserginfoModelPage(this.getQueryMapParam("auctionCode,tenantCode,memberBcode", new Object[]{atAuctiondt1.getAuctionCode(), atAuctiondt1.getTenantCode(), atAuctiondt1.getMemberBcode()}));
            for (AtAuctionUserginfo atAuctionUserginfo : atAuctionUserginfos) {
                this.updateStateatAuctionUserginfoModel(atAuctionUserginfo.getAuctionUserginfoId(), 1, atAuctionUserginfo.getDataState(), null);
            }
        }
        return code;
    }

    @Override
    public void updateAuctiondtState(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAuctiondtModel(auctionDtId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctiondtStateByCode(String tenantCode, String auctionDtCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAuctiondtModelByCode(tenantCode, auctionDtCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctiondt(AtAuctiondtDomain atAuctiondtDomain) throws ApiException {
        String msg = this.checkAuctiondt(atAuctiondtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondt.checkAuctiondt", msg);
        }
        AtAuctiondt oldAtAuctiondt = this.getAuctiondtModelById(atAuctiondtDomain.getAuctionDtId());
        if (null == oldAtAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AtAuctiondt atAuctiondt = this.makeAuctiondt(atAuctiondtDomain, oldAtAuctiondt);
        if (StringUtils.isBlank((String)atAuctiondtDomain.getUserName())) {
            atAuctiondt.setUserName(null);
        }
        if (StringUtils.isBlank((String)atAuctiondtDomain.getUserCode())) {
            atAuctiondt.setUserCode(null);
        }
        this.setAuctiondtUpdataDefault(atAuctiondt);
        this.updateAuctiondtModel(atAuctiondt);
    }

    @Override
    public AtAuctiondt getAuctiondt(Integer auctionDtId) {
        return this.getAuctiondtModelById(auctionDtId);
    }

    @Override
    public void deleteAuctiondt(Integer auctionDtId) throws ApiException {
        this.deleteAuctiondtModel(auctionDtId);
    }

    @Override
    public QueryResult<AtAuctiondt> queryAuctiondtPage(Map<String, Object> map) {
        List<AtAuctiondt> atAuctiondtList = this.queryAuctiondtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctiondt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(atAuctiondtList);
        return queryResult;
    }

    @Override
    public int countAuctiondtNum(Map<String, Object> map) {
        return this.countAuctiondt(map);
    }

    @Override
    public AtAuctiondt getAuctiondtByCode(String tenantCode, String auctionDtCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionDtCode", auctionDtCode);
        return this.getAuctiondtModelByCode(map);
    }

    @Override
    public void deleteAuctiondtByCode(String tenantCode, String auctionDtCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionDtCode", auctionDtCode);
        this.delAuctiondtModelByCode(map);
    }

    @Override
    public void updateAuctiondtStateForCheck(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctiondtStateByCodeForCheck(String tenantCode, String auctionDtCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAuctiondtModelByCodeForCheck(tenantCode, auctionDtCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctiondtCommissState(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        TaTransferaDomain taTransferaDomain;
        AtAuctiondt atAuctiondt = this.getAuctiondt(auctionDtId);
        if (null == atAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.atAuctiondt", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("tenantCode", atAuctiondt.getTenantCode());
        paramMap.put("auctionDtType", "1");
        List<AtAuctiondt> atAuctiondts = this.getAuctiondtByParamMap(paramMap);
        if (ListUtil.isEmpty(atAuctiondts)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.taTransferaDomain", "\u8f6c\u8d26\u5931\u8d25\uff0c\u67e5\u8be2\u4fdd\u8bc1\u91d1\u4fe1\u606f\u5f02\u5e38");
        }
        BigDecimal depositAmount = new BigDecimal("0.00");
        for (AtAuctiondt auctiondt : atAuctiondts) {
            depositAmount = depositAmount.add(new BigDecimal(auctiondt.getAuctionruleDpnum()));
        }
        BigDecimal commissionAmount = atAuctiondt.getAuctionDtDpnum();
        if (commissionAmount.compareTo(depositAmount) > 0) {
            atAuctiondt.setAuctionDtDpnum(depositAmount);
        }
        if (null == (taTransferaDomain = this.creatCommissionTransferaDomain(true, atAuctiondt, map))) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.taTransferaDomain", "\u8f6c\u8d26\u5931\u8d25\uff0c\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("taTransferaDomain", JsonUtil.buildNormalBinder().toJson((Object)taTransferaDomain));
        String transferaCode = this.internalInvoke("ta.taTransfera.saveTransferaOne", queryMap);
        if (StringUtils.isEmpty((String)transferaCode)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.atAuctiondt", "\u8f6c\u8d26\u5931\u8d25");
        }
        if (depositAmount.compareTo(atAuctiondt.getAuctionDtDpnum()) == 0) {
            for (AtAuctiondt auctiondtB : atAuctiondts) {
                this.updateStateAuctiondtModelForCheck(auctiondtB.getAuctionDtId(), 1, auctiondtB.getDataState(), map);
            }
        }
        HashMap<String, Object> auctionWinMap = new HashMap<String, Object>();
        auctionWinMap.put("auctionCode", atAuctiondt.getAuctionCode());
        auctionWinMap.put("memberBcode", atAuctiondt.getMemberBcode());
        auctionWinMap.put("tenantCode", atAuctiondt.getTenantCode());
        QueryResult<AtAuctionWin> atAuctionWins = this.atAuctionWinService.queryatAuctionWinPage(auctionWinMap);
        if (atAuctionWins != null && ListUtil.isNotEmpty((Collection)atAuctionWins.getList())) {
            AtAuctionWin atAuctionWin = (AtAuctionWin)atAuctionWins.getList().get(0);
            atAuctionWin.setDataState(2);
            this.atAuctionWinService.updateatAuctionWinState(atAuctionWin.getAuctionWinId(), 2, 1, null);
        }
    }

    @Override
    public void updateAuctiondtCommissStateForEPay(Integer auctionDtId, Integer dataState, Integer oldDataState, String ePaysToken, Map<String, Object> map) throws ApiException {
        String tranchePay;
        UmUserinfo inUserInfo;
        AtAuctiondt atAuctiondt = this.getAuctiondt(auctionDtId);
        if (null == atAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissStateForEPay", "atAuctiondt\u4e3a\u7a7a");
        }
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("tenantCode", atAuctiondt.getTenantCode());
        paramMap.put("auctionDtType", "1");
        List<AtAuctiondt> atAuctiondts = this.getAuctiondtByParamMap(paramMap);
        if (ListUtil.isEmpty(atAuctiondts)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissStateForEPay", "\u67e5\u8be2\u4fdd\u8bc1\u91d1\u4fe1\u606f\u5f02\u5e38");
        }
        BigDecimal depositAmount = new BigDecimal("0.00");
        for (AtAuctiondt auctiondt : atAuctiondts) {
            depositAmount = depositAmount.add(new BigDecimal(auctiondt.getAuctionruleDpnum()));
        }
        BigDecimal commissionAmount = atAuctiondt.getAuctionDtDpnum();
        if (commissionAmount.compareTo(depositAmount) > 0) {
            atAuctiondt.setAuctionDtDpnum(depositAmount);
            commissionAmount = depositAmount;
        }
        String outSubAcctNo = "";
        String inSubAcctNo = "";
        UmUserinfo outUserInfo = this.getUmUserInfo(atAuctiondt.getMemberBcode(), atAuctiondt.getTenantCode());
        if (null != outUserInfo) {
            if (null == outUserInfo.getUserinfoOcode()) {
                throw new ApiException(SYS_CODE + ".ePayMembershipTranchePay.\u8f6c\u51fa\u8d26\u6237\u4e3a\u7a7a");
            }
            outSubAcctNo = outUserInfo.getUserinfoOcode();
        }
        if (null != (inUserInfo = this.getUmUserInfo(atAuctiondt.getMemberCode(), atAuctiondt.getTenantCode()))) {
            if (null == inUserInfo.getUserinfoOcode()) {
                throw new ApiException(SYS_CODE + ".ePayMembershipTranchePay.\u8f6c\u5165\u8d26\u6237\u4e3a\u7a7a");
            }
            inSubAcctNo = inUserInfo.getUserinfoOcode();
        }
        if (null == (tranchePay = this.ePayMembershipTranchePay(ePaysToken, commissionAmount, outSubAcctNo, inSubAcctNo, atAuctiondt, "\u4f63\u91d1\u6536\u53d6"))) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissStateForEPay", "ePay\u8f6c\u8d26\u5931\u8d25");
        }
        this.saveFaccountOuterDtDomain(atAuctiondt, outSubAcctNo, tranchePay, "T7-02");
        this.saveFaccountOuterDtDomain(atAuctiondt, inSubAcctNo, tranchePay, "T7-01");
    }

    private void saveFaccountOuterDtDomain(AtAuctiondt atAuctiondt, String subAcctNo, String tranchePay, String remark) {
        VdFaccountOuterDtDomain vdFaccountOuterDtDomain = new VdFaccountOuterDtDomain();
        vdFaccountOuterDtDomain.setFaccountOuterDtSqeno(tranchePay);
        vdFaccountOuterDtDomain.setFaccountOuterNo(subAcctNo);
        vdFaccountOuterDtDomain.setFaccountingDate(DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd"));
        vdFaccountOuterDtDomain.setFaccountOuterName("EPay\u5b50\u8d26\u6237");
        vdFaccountOuterDtDomain.setCurrencyCode("01");
        vdFaccountOuterDtDomain.setOrderAmount(atAuctiondt.getAuctionDtDpnum());
        vdFaccountOuterDtDomain.setOrderPrice(BigDecimal.ONE);
        vdFaccountOuterDtDomain.setDicPaypdCode("PD05");
        vdFaccountOuterDtDomain.setPtradpdeCode("TRANSFER");
        vdFaccountOuterDtDomain.setBusinessOrderno(tranchePay);
        vdFaccountOuterDtDomain.setClearOrderSuitno("1");
        vdFaccountOuterDtDomain.setTenantCode(atAuctiondt.getTenantCode());
        if (null != remark) {
            String[] remarks = remark.split("-");
            switch (remarks[0]) {
                case "T7": {
                    vdFaccountOuterDtDomain.setPaymentOrderMemo("\u3010\u624b\u7eed\u8d39\u6536\u53d6\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + atAuctiondt.getAuctionName());
                    break;
                }
                case "T8": {
                    vdFaccountOuterDtDomain.setPaymentOrderMemo("\u3010\u624b\u7eed\u8d39\u8fd4\u8fd8\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + atAuctiondt.getAuctionName());
                    break;
                }
                case "T9": {
                    vdFaccountOuterDtDomain.setPaymentOrderMemo("\u3010\u4fdd\u8bc1\u91d1\u7f5a\u6ca1\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + atAuctiondt.getAuctionName());
                    break;
                }
                default: {
                    vdFaccountOuterDtDomain.setPaymentOrderMemo("\u3010\u4f63\u91d1\u64cd\u4f5c\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + atAuctiondt.getAuctionName());
                }
            }
            vdFaccountOuterDtDomain.setBusinessType(remarks[0]);
            vdFaccountOuterDtDomain.setFundType(remarks[1]);
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("vdFaccountOuterDtDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterDtDomain));
        this.internalInvoke("vd.faccountOuter.saveFaccountOuterDt", queryMap);
    }

    private String ePayMembershipTranchePay(String ePaysToken, BigDecimal commissionAmount, String outSubAcctNo, String inSubAcctNo, AtAuctiondt atAuctiondt, String remark) {
        String tranchePayUrl = "http://150.223.27.24:8092/apix/epay/membershipTranchePay";
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("outSubAcctNo", outSubAcctNo);
        HashMap<String, Object> parMap = new HashMap<String, Object>();
        parMap.put("auctionCode", atAuctiondt.getAuctionCode());
        parMap.put("memberBcode", atAuctiondt.getMemberBcode());
        parMap.put("tenantCode", atAuctiondt.getTenantCode());
        parMap.put("dataStateNot", "2");
        List list = this.atAuctionEnrollService.queryatAuctionEnrollPage(parMap).getList();
        if (ListUtil.isNotEmpty((Collection)list)) {
            AtAuctionEnrollReDomain enrollReDomain = (AtAuctionEnrollReDomain)list.get(0);
            requestMap.put("orderNo", enrollReDomain.getAuctionEnrollCode() + "-" + enrollReDomain.getTenantCode());
        }
        requestMap.put("tranSeqNo", atAuctiondt.getAuctionDtCode());
        requestMap.put("inSubAcctNo", inSubAcctNo);
        requestMap.put("tranAmt", commissionAmount.toString());
        requestMap.put("businessContent", remark);
        requestMap.put("businessFrom", "6");
        requestMap.put("clearingType", "\u5faa\u73af\u7269\u8d44");
        requestMap.put("goodsName", atAuctiondt.getAuctionName());
        requestMap.put("businessType", "6");
        requestMap.put("createrUserId", atAuctiondt.getMemberBcode());
        requestMap.put("relationId", atAuctiondt.getMemberCode());
        Map<String, String> responseMap = this.doPostToEPay(tranchePayUrl, requestMap, ePaysToken);
        if (null == responseMap) {
            this.logger.error(SYS_CODE + ".ePayMembershipTranchePay", (Object)"\u8bf7\u6c42EPay\u652f\u4ed8\u5f02\u5e38");
        } else if (responseMap.containsKey("TxnReturnMsg")) {
            String txnReturnMsg = responseMap.get("TxnReturnMsg");
            if ("\u4ea4\u6613\u6210\u529f".equals(txnReturnMsg)) {
                this.logger.error(SYS_CODE + ".ePayMembershipTranchePay", (Object)("EPay" + remark + "\u6210\u529f"));
                return responseMap.get("FrontSeqNo");
            }
            this.logger.error(SYS_CODE + ".ePayMembershipTranchePay", (Object)("EPay" + remark + "\u5931\u8d25"));
        }
        return null;
    }

    private UmUserinfo getUmUserInfo(String userInfoCode, String tenantCode) {
        HashMap<String, String> userInfomap = new HashMap<String, String>();
        userInfomap.put("userinfoCode", userInfoCode);
        userInfomap.put("tenantCode", tenantCode);
        String umUserInfoStr = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", userInfomap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNonNullBinder().getJsonToObject(umUserInfoStr, UmUserinfo.class);
        if (null == umUserinfo) {
            this.logger.error(SYS_CODE + ".getUmUserinfo", (Object)"\u7528\u6237\u4e0d\u5b58\u5728");
            return null;
        }
        return umUserinfo;
    }

    private List<AtAuctiondt> getAuctiondtByParamMap(Map<String, Object> param) {
        if (null == param) {
            return null;
        }
        try {
            return this.atAuctiondtMapper.query(param);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateAuctiondtReturnCommissState(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        AtAuctiondt atAuctiondt = this.getAuctiondt(auctionDtId);
        if (null == atAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.atAuctiondt", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
        this.updateCollectCommiss(atAuctiondt);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        TaTransferaDomain taTransferaDomain = this.creatCommissionTransferaDomain(false, atAuctiondt, map);
        if (null == taTransferaDomain) {
            this.logger.error(SYS_CODE + ".updateAuctiondtReturnCommissState", (Object)atAuctiondt);
        }
        queryMap.put("taTransferaDomain", JsonUtil.buildNormalBinder().toJson((Object)taTransferaDomain));
        String transferaCode = this.internalInvoke("ta.taTransfera.saveTransferaOne", queryMap);
        if (StringUtils.isEmpty((String)transferaCode)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.atAuctiondt", "\u8f6c\u8d26\u5931\u8d25");
        }
    }

    @Override
    public void updateAuctiondtReturnCommissStateForEPay(Integer auctionDtId, Integer dataState, Integer oldDataState, String ePaysToken, Map<String, Object> map) throws ApiException {
        AtAuctiondt atAuctiondt = this.getAuctiondt(auctionDtId);
        if (null == atAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissStateForEPay", "atAuctiondt\u4e3a\u7a7a");
        }
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
        this.updateCollectCommiss(atAuctiondt);
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("merchantCode", memberCode);
        queryMap.put("faccountType", faccountType);
        queryMap.put("tenantCode", tenantCode);
        String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", queryMap);
        List vdList = JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountInfo.class);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    private TaTransferaDomain creatCommissionTransferaDomain(boolean basicTofrozen, AtAuctiondt auctiondt, Map<String, Object> map) {
        VdFaccountInfo vdFaccountInfoout;
        VdFaccountInfo vdFaccountInfoin;
        if (null == auctiondt) {
            this.logger.error(SYS_CODE + ".creatCommissionTransferaDomain.auctiondt", (Object)auctiondt);
            return null;
        }
        String memberCode = auctiondt.getMemberCode();
        String tenantCode = auctiondt.getTenantCode();
        if (StringUtils.isEmpty((String)memberCode)) {
            return null;
        }
        String userName = "";
        String userCode = "";
        if (null != map) {
            userName = (String)map.get("userName");
            userCode = (String)map.get("userCode");
        }
        String typein = "";
        String type = "";
        String outno = "";
        String inno = "";
        TaTransferaDomain taTransferaDomain = new TaTransferaDomain();
        ArrayList<TaTransferaListDomain> taTransferaListDomains = new ArrayList<TaTransferaListDomain>();
        TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
        if (null == auctiondt.getAuctionDtDpnum()) {
            auctiondt.setAuctionDtDpnum(new BigDecimal("0"));
        }
        if (basicTofrozen) {
            typein = memberCode.substring(0, 1);
            type = auctiondt.getMemberBcode().substring(0, 1);
            outno = "104";
            inno = "101";
            if ("2".equals(typein)) {
                inno = "201";
            }
            if ("2".equals(type)) {
                outno = "204";
            }
            Map<String, VdFaccountInfo> vd = this.getVd(memberCode, tenantCode, inno);
            vdFaccountInfoin = vd.get(inno);
            vd = this.getVd(auctiondt.getMemberBcode(), tenantCode, outno);
            vdFaccountInfoout = vd.get(outno);
            taTransferaDomain.setTransferaName("\u3010\u624b\u7eed\u8d39\u6536\u53d6\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + auctiondt.getAuctionName());
            taTransferaListDomain.setTransferaListRemark("\u3010\u624b\u7eed\u8d39\u6536\u53d6\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + auctiondt.getAuctionName());
            taTransferaDomain.setTransferaType("T7");
            taTransferaDomain.setUserinfoCode(auctiondt.getMemberBcode());
            taTransferaDomain.setUserinfoName(auctiondt.getMemberBname());
            taTransferaDomain.setTransferaUcode(auctiondt.getMemberCode());
            taTransferaDomain.setTransferaUname(auctiondt.getMemberName());
            taTransferaListDomain.setUserinfoCode(auctiondt.getMemberBcode());
            taTransferaListDomain.setUserinfoName(auctiondt.getMemberBname());
        } else {
            type = memberCode.substring(0, 1);
            typein = auctiondt.getMemberBcode().substring(0, 1);
            outno = "101";
            inno = "101";
            if ("2".equals(typein)) {
                inno = "201";
            }
            if ("2".equals(type)) {
                outno = "201";
            }
            Map<String, VdFaccountInfo> vd = this.getVd(auctiondt.getMemberBcode(), tenantCode, inno);
            vdFaccountInfoin = vd.get(inno);
            vd = this.getVd(memberCode, tenantCode, outno);
            vdFaccountInfoout = vd.get(outno);
            taTransferaDomain.setTransferaName("\u3010\u624b\u7eed\u8d39\u9000\u56de\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + auctiondt.getAuctionName());
            taTransferaListDomain.setTransferaListRemark("\u3010\u624b\u7eed\u8d39\u9000\u56de\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + auctiondt.getAuctionName());
            taTransferaDomain.setTransferaType("T8");
            taTransferaDomain.setUserinfoCode(auctiondt.getMemberCode());
            taTransferaDomain.setUserinfoName(auctiondt.getMemberName());
            taTransferaDomain.setTransferaUcode(auctiondt.getMemberBcode());
            taTransferaDomain.setTransferaUname(auctiondt.getMemberBname());
            taTransferaListDomain.setUserinfoCode(auctiondt.getMemberCode());
            taTransferaListDomain.setUserinfoName(auctiondt.getMemberName());
        }
        if (null == vdFaccountInfoin || null == vdFaccountInfoout) {
            this.logger.error(SYS_CODE + ".creatCommissionTransferaDomain.vdFaccountInfoin", (Object)vdFaccountInfoin);
            this.logger.error(SYS_CODE + ".creatCommissionTransferaDomain.vdFaccountInfoout", (Object)vdFaccountInfoout);
            return null;
        }
        taTransferaDomain.setFaccountId(vdFaccountInfoout.getFaccountOuterNo());
        taTransferaDomain.setTransferaOpcode(auctiondt.getAuctionDtCode());
        taTransferaDomain.setFchannelPmodeCode("web");
        taTransferaDomain.setTransferaMoney(auctiondt.getAuctionDtDpnum());
        taTransferaDomain.setTenantCode(tenantCode);
        taTransferaDomain.setFundType(vdFaccountInfoout.getFundType());
        taTransferaDomain.setTransferaCategory(type);
        taTransferaDomain.setUserName(userName);
        taTransferaDomain.setUserCode(userCode);
        taTransferaDomain.setTransferaMode("1");
        taTransferaListDomain.setTransferaListUno(vdFaccountInfoin.getFaccountOuterNo());
        taTransferaListDomain.setTransferaListFtype(vdFaccountInfoin.getFundType());
        taTransferaListDomain.setTransferaListMoney(auctiondt.getAuctionDtDpnum());
        taTransferaListDomain.setTransferaListCategory(typein);
        taTransferaListDomain.setUserCode(userCode);
        taTransferaListDomain.setUserName(userName);
        taTransferaListDomain.setFaccountId(vdFaccountInfoout.getFaccountOuterNo());
        taTransferaListDomain.setFundType(vdFaccountInfoout.getFundType());
        taTransferaListDomain.setTransferaListUcode(vdFaccountInfoin.getMerchantCode());
        taTransferaListDomain.setTransferaListUname(vdFaccountInfoin.getFaccountOuterName());
        taTransferaListDomains.add(taTransferaListDomain);
        taTransferaDomain.setTaTransferaListDomainList(taTransferaListDomains);
        return taTransferaDomain;
    }

    private TaTransferaDomain creatConfiscateTransferDomain(AtAuctiondt auctiondt, Map<String, Object> map) {
        if (null == auctiondt) {
            this.logger.error(SYS_CODE + ".creatConfiscateTransferDomain.auctiondt", (Object)auctiondt);
            return null;
        }
        String memberCode = auctiondt.getMemberCode();
        String tenantCode = auctiondt.getTenantCode();
        if (StringUtils.isEmpty((String)memberCode)) {
            this.logger.error(SYS_CODE + ".creatConfiscateTransferDomain.memberCode", (Object)"memberCode\u4e3anull");
            return null;
        }
        String typein = memberCode.substring(0, 1);
        String type = auctiondt.getMemberBcode().substring(0, 1);
        String outno = "102";
        String inno = "101";
        if ("2".equals(typein)) {
            inno = "201";
        }
        if ("2".equals(type)) {
            outno = "202";
        }
        Map<String, VdFaccountInfo> vd = this.getVd(memberCode, tenantCode, inno);
        VdFaccountInfo vdFaccountInfoin = vd.get(inno);
        vd = this.getVd(auctiondt.getMemberBcode(), tenantCode, outno);
        VdFaccountInfo vdFaccountInfoout = vd.get(outno);
        String userName = "";
        String userCode = "";
        if (null != map) {
            userName = (String)map.get("userName");
            userCode = (String)map.get("userCode");
        }
        TaTransferaDomain taTransferaDomain = new TaTransferaDomain();
        ArrayList<TaTransferaListDomain> taTransferaListDomains = new ArrayList<TaTransferaListDomain>();
        TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
        if (null == auctiondt.getAuctionDtDpnum()) {
            auctiondt.setAuctionDtDpnum(new BigDecimal("0"));
        }
        taTransferaDomain.setTransferaName("\u3010\u4fdd\u8bc1\u91d1\u7f5a\u6ca1\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + auctiondt.getAuctionName());
        taTransferaListDomain.setTransferaListRemark("\u3010\u4fdd\u8bc1\u91d1\u7f5a\u6ca1\u3011\u7ade\u4ef7\u573a\u6b21\u540d\u79f0\uff1a" + auctiondt.getAuctionName());
        taTransferaDomain.setTransferaType("T9");
        taTransferaDomain.setUserinfoCode(auctiondt.getMemberBcode());
        taTransferaDomain.setUserinfoName(auctiondt.getMemberBname());
        taTransferaDomain.setTransferaUcode(auctiondt.getMemberCode());
        taTransferaDomain.setTransferaUname(auctiondt.getMemberName());
        taTransferaListDomain.setUserinfoCode(auctiondt.getMemberBcode());
        taTransferaListDomain.setUserinfoName(auctiondt.getMemberBname());
        if (null == vdFaccountInfoin || null == vdFaccountInfoout) {
            this.logger.error(SYS_CODE + ".creatConfiscateTransferDomain.vdFaccountInfoin", (Object)("in:" + vdFaccountInfoin));
            this.logger.error(SYS_CODE + ".creatConfiscateTransferDomain.vdFaccountInfoout", (Object)("out:" + vdFaccountInfoout));
            return null;
        }
        taTransferaDomain.setFaccountId(vdFaccountInfoout.getFaccountOuterNo());
        taTransferaDomain.setTransferaOpcode(auctiondt.getAuctionDtCode());
        taTransferaDomain.setFchannelPmodeCode("web");
        taTransferaDomain.setTransferaMoney(auctiondt.getAuctionDtDpnum());
        taTransferaDomain.setTenantCode(tenantCode);
        taTransferaDomain.setFundType(vdFaccountInfoout.getFundType());
        taTransferaDomain.setTransferaCategory(type);
        taTransferaDomain.setUserName(userName);
        taTransferaDomain.setUserCode(userCode);
        taTransferaDomain.setTransferaMode("1");
        taTransferaListDomain.setTransferaListUno(vdFaccountInfoin.getFaccountOuterNo());
        taTransferaListDomain.setTransferaListFtype(vdFaccountInfoin.getFundType());
        taTransferaListDomain.setTransferaListMoney(auctiondt.getAuctionDtDpnum());
        taTransferaListDomain.setTransferaListCategory(typein);
        taTransferaListDomain.setUserCode(userCode);
        taTransferaListDomain.setUserName(userName);
        taTransferaListDomain.setFaccountId(vdFaccountInfoout.getFaccountOuterNo());
        taTransferaListDomain.setFundType(vdFaccountInfoout.getFundType());
        taTransferaListDomain.setTransferaListUcode(vdFaccountInfoin.getMerchantCode());
        taTransferaListDomain.setTransferaListUname(vdFaccountInfoin.getFaccountOuterName());
        taTransferaListDomains.add(taTransferaListDomain);
        taTransferaDomain.setTaTransferaListDomainList(taTransferaListDomains);
        return taTransferaDomain;
    }

    @Override
    public String updateAuctiondtConfiscateDeposit(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        AtAuctiondt atAuctiondt = this.getAuctiondt(auctionDtId);
        if (null == atAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtConfiscateDeposit.atAuctiondt", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("tenantCode", atAuctiondt.getTenantCode());
        paramMap.put("auctionDtType", "1");
        List<AtAuctiondt> auctiondtByParamMap = this.getAuctiondtByParamMap(paramMap);
        if (ListUtil.isEmpty(auctiondtByParamMap)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.taTransferaDomain", "\u67e5\u8be2\u4fdd\u8bc1\u91d1\u4fe1\u606f\u5f02\u5e38");
        }
        BigDecimal commissionAmount = atAuctiondt.getAuctionDtDpnum();
        if (dataState == 2) {
            for (AtAuctiondt auctiondt : auctiondtByParamMap) {
                if (auctiondt.getDataState() == 2) continue;
                if (commissionAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal auctionruleDpnum = new BigDecimal(auctiondt.getAuctionruleDpnum());
                BigDecimal add = auctiondt.getAuctionDtDpnum().add(commissionAmount);
                AtAuctiondt atAuctiondtNew = new AtAuctiondt();
                atAuctiondtNew.setAuctionDtId(auctiondt.getAuctionDtId());
                if (add.compareTo(auctionruleDpnum) <= 0) {
                    atAuctiondtNew.setAuctionDtDpnum(add);
                    this.updateAuctiondtSelective(atAuctiondtNew);
                    break;
                }
                atAuctiondtNew.setAuctionDtDpnum(auctionruleDpnum);
                commissionAmount = add.subtract(auctionruleDpnum);
                this.updateAuctiondtSelective(atAuctiondtNew);
            }
        } else if (dataState == 1) {
            TaTransferaDomain taTransferaDomain;
            BigDecimal depositAmount = new BigDecimal("0.00");
            for (AtAuctiondt auctiondt : auctiondtByParamMap) {
                if (auctiondt.getDataState() == 2) continue;
                depositAmount = depositAmount.add(new BigDecimal(auctiondt.getAuctionruleDpnum()));
            }
            if (commissionAmount.compareTo(depositAmount) > 0) {
                atAuctiondt.setAuctionDtDpnum(depositAmount);
            }
            if (null == (taTransferaDomain = this.creatConfiscateTransferDomain(atAuctiondt, map))) {
                throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.taTransferaDomain", "\u8f6c\u8d26\u5931\u8d25\uff0c\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
            }
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("taTransferaDomain", JsonUtil.buildNormalBinder().toJson((Object)taTransferaDomain));
            String transferaCode = this.internalInvoke("ta.taTransfera.saveTransferaOne", queryMap);
            if (StringUtils.isEmpty((String)transferaCode)) {
                throw new ApiException(SYS_CODE + ".updateAuctiondtCommissState.atAuctiondt", "\u8f6c\u8d26\u5931\u8d25");
            }
            return transferaCode;
        }
        return "\u8f6c\u8d26\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38";
    }

    @Override
    public void updateAuctiondtConfiscateDepositForEPay(Integer auctionDtId, Integer dataState, Integer oldDataState, String ePaysToken, Map<String, Object> map) throws ApiException {
        AtAuctiondt atAuctiondt = this.getAuctiondt(auctionDtId);
        if (null == atAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtConfiscateDepositForEPay", "atAuctiondt\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("auctionCode", atAuctiondt.getAuctionCode());
        paramMap.put("memberBcode", atAuctiondt.getMemberBcode());
        paramMap.put("tenantCode", atAuctiondt.getTenantCode());
        paramMap.put("auctionDtType", "1");
        List<AtAuctiondt> auctiondtByParamMap = this.getAuctiondtByParamMap(paramMap);
        if (ListUtil.isEmpty(auctiondtByParamMap)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtConfiscateDepositForEPay", "\u67e5\u8be2\u4fdd\u8bc1\u91d1\u4fe1\u606f\u5f02\u5e38");
        }
        BigDecimal commissionAmount = atAuctiondt.getAuctionDtDpnum();
        if (dataState == 2) {
            for (AtAuctiondt auctiondt : auctiondtByParamMap) {
                if (auctiondt.getDataState() == 2) continue;
                if (commissionAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal auctionruleDpnum = new BigDecimal(auctiondt.getAuctionruleDpnum());
                BigDecimal add = auctiondt.getAuctionDtDpnum().add(commissionAmount);
                AtAuctiondt atAuctiondtNew = new AtAuctiondt();
                atAuctiondtNew.setAuctionDtId(auctiondt.getAuctionDtId());
                if (add.compareTo(auctionruleDpnum) <= 0) {
                    atAuctiondtNew.setAuctionDtDpnum(add);
                    this.updateAuctiondtSelective(atAuctiondtNew);
                    break;
                }
                atAuctiondtNew.setAuctionDtDpnum(auctionruleDpnum);
                commissionAmount = add.subtract(auctionruleDpnum);
                this.updateAuctiondtSelective(atAuctiondtNew);
            }
        } else if (dataState == 1) {
            String tranchePay;
            UmUserinfo inUserInfo;
            BigDecimal depositAmount = new BigDecimal("0.00");
            for (AtAuctiondt auctiondt : auctiondtByParamMap) {
                if (auctiondt.getDataState() == 2) continue;
                depositAmount = depositAmount.add(new BigDecimal(auctiondt.getAuctionruleDpnum()));
            }
            if (commissionAmount.compareTo(depositAmount) > 0) {
                commissionAmount = depositAmount;
                atAuctiondt.setAuctionDtDpnum(depositAmount);
            }
            String outSubAcctNo = "";
            String inSubAcctNo = "";
            UmUserinfo outUserInfo = this.getUmUserInfo(atAuctiondt.getMemberBcode(), atAuctiondt.getTenantCode());
            if (null != outUserInfo) {
                if (null == outUserInfo.getUserinfoOcode()) {
                    throw new ApiException(SYS_CODE + ".ePayMembershipTranchePay.\u8f6c\u51fa\u8d26\u6237\u4e3a\u7a7a");
                }
                outSubAcctNo = outUserInfo.getUserinfoOcode();
            }
            if (null != (inUserInfo = this.getUmUserInfo(atAuctiondt.getMemberCode(), atAuctiondt.getTenantCode()))) {
                if (null == inUserInfo.getUserinfoOcode()) {
                    throw new ApiException(SYS_CODE + ".ePayMembershipTranchePay.\u8f6c\u5165\u8d26\u6237\u4e3a\u7a7a");
                }
                inSubAcctNo = inUserInfo.getUserinfoOcode();
            }
            if (null == (tranchePay = this.ePayMembershipTranchePay(ePaysToken, commissionAmount, outSubAcctNo, inSubAcctNo, atAuctiondt, "\u4fdd\u8bc1\u91d1\u7f5a\u6ca1"))) {
                throw new ApiException(SYS_CODE + ".updateAuctiondtCommissStateForEPay", "ePay\u8f6c\u8d26\u5931\u8d25");
            }
            this.saveFaccountOuterDtDomain(atAuctiondt, outSubAcctNo, tranchePay, "T8-02");
            this.saveFaccountOuterDtDomain(atAuctiondt, inSubAcctNo, tranchePay, "T8-01");
        }
    }

    private Map<String, String> doPostToEPay(String url, Map<String, Object> json, String ePaysToken) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setHeader("token", ePaysToken);
        Map<String, String> dataMap = new HashMap<String, String>();
        try {
            StringEntity requestEntity = new StringEntity(JsonUtil.buildNonDefaultBinder().toJson(json), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                Map map = (Map)JsonUtil.buildNormalBinder().getJsonToObject(result, Map.class);
                if (null == map) {
                    return null;
                }
                String msg = (String)map.get("msg");
                Object data = map.get("data");
                if (null != data) {
                    String dataStr = JsonUtil.buildNormalBinder().toJson(data);
                    if (dataStr.startsWith("{")) {
                        dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToObject(dataStr, Map.class);
                    } else {
                        dataMap.put("data", data.toString());
                    }
                }
                dataMap.put("result", msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }
}

