/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractGoodsPlanMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsPlanDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsPlanReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractGoodsPlan;
import com.yqbsoft.laser.service.contract.service.OcContractGoodsPlanService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractGoodsPlanServiceImpl
extends BaseServiceImpl
implements OcContractGoodsPlanService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractGoodsPlanServiceImpl";
    private OcContractGoodsPlanMapper ocContractGoodsPlanMapper;

    public void setOcContractGoodsPlanMapper(OcContractGoodsPlanMapper ocContractGoodsPlanMapper) {
        this.ocContractGoodsPlanMapper = ocContractGoodsPlanMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractGoodsPlanMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractGoodsPlan(OcContractGoodsPlanDomain ocContractGoodsPlanDomain) {
        if (null == ocContractGoodsPlanDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsPlanDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractGoodsPlanDefault(OcContractGoodsPlan ocContractGoodsPlan) {
        if (null == ocContractGoodsPlan) {
            return;
        }
        if (null == ocContractGoodsPlan.getDataState()) {
            ocContractGoodsPlan.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractGoodsPlan.getGmtCreate()) {
            ocContractGoodsPlan.setGmtCreate(date);
        }
        ocContractGoodsPlan.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractGoodsPlan.getContractGoodsCode())) {
            ocContractGoodsPlan.setContractGoodsCode(this.getNo(null, "OcContractGoodsPlan", "ocContractGoodsPlan", ocContractGoodsPlan.getTenantCode()));
        }
    }

    private int getContractGoodsPlanMaxCode() {
        int code = 0;
        try {
            return this.ocContractGoodsPlanMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.getContractGoodsPlanMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractGoodsPlanUpdataDefault(OcContractGoodsPlan ocContractGoodsPlan) {
        if (null == ocContractGoodsPlan) {
            return;
        }
        ocContractGoodsPlan.setGmtModified(this.getSysDate());
    }

    private void saveContractGoodsPlanModel(OcContractGoodsPlan ocContractGoodsPlan) throws ApiException {
        if (null == ocContractGoodsPlan) {
            return;
        }
        try {
            this.ocContractGoodsPlanMapper.insert(ocContractGoodsPlan);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.saveContractGoodsPlanModel.ex", (Throwable)e);
        }
    }

    private void saveContractGoodsPlanBatchModel(List<OcContractGoodsPlan> ocContractGoodsPlanList) throws ApiException {
        if (null == ocContractGoodsPlanList || ocContractGoodsPlanList.isEmpty()) {
            return;
        }
        try {
            this.ocContractGoodsPlanMapper.insertBatch(ocContractGoodsPlanList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.saveContractGoodsPlanBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractGoodsPlan getContractGoodsPlanModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.ocContractGoodsPlanMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.getContractGoodsPlanModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractGoodsPlan getContractGoodsPlanModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractGoodsPlanMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.getContractGoodsPlanModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractGoodsPlanModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsPlanMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.delContractGoodsPlanModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.delContractGoodsPlanModelByCode.num");
        }
    }

    private void deleteContractGoodsPlanModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsPlanMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.deleteContractGoodsPlanModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.deleteContractGoodsPlanModel.num");
        }
    }

    private void updateContractGoodsPlanModel(OcContractGoodsPlan ocContractGoodsPlan) throws ApiException {
        if (null == ocContractGoodsPlan) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsPlanMapper.updateByPrimaryKey(ocContractGoodsPlan);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateContractGoodsPlanModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateContractGoodsPlanModel.num");
        }
    }

    private void updateStateContractGoodsPlanModel(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractGoodsPlanMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateStateContractGoodsPlanModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateStateContractGoodsPlanModel.null");
        }
    }

    private void updateStateContractGoodsPlanModelByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractGoodsPlanMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateStateContractGoodsPlanModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateStateContractGoodsPlanModelByCode.null");
        }
    }

    private OcContractGoodsPlan makeContractGoodsPlan(OcContractGoodsPlanDomain ocContractGoodsPlanDomain, OcContractGoodsPlan ocContractGoodsPlan) {
        if (null == ocContractGoodsPlanDomain) {
            return null;
        }
        if (null == ocContractGoodsPlan) {
            ocContractGoodsPlan = new OcContractGoodsPlan();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoodsPlan, (Object)ocContractGoodsPlanDomain);
            return ocContractGoodsPlan;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.makeContractGoodsPlan", (Throwable)e);
            return null;
        }
    }

    private OcContractGoodsPlanReDomain makeOcContractGoodsPlanReDomain(OcContractGoodsPlan ocContractGoodsPlan) {
        if (null == ocContractGoodsPlan) {
            return null;
        }
        OcContractGoodsPlanReDomain ocContractGoodsPlanReDomain = new OcContractGoodsPlanReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoodsPlanReDomain, (Object)ocContractGoodsPlan);
            return ocContractGoodsPlanReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.makeOcContractGoodsPlanReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoodsPlan> queryContractGoodsPlanModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsPlanMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.queryContractGoodsPlanModel", (Throwable)e);
            return null;
        }
    }

    private int countContractGoodsPlan(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractGoodsPlanMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractGoodsPlanServiceImpl.countContractGoodsPlan", (Throwable)e);
        }
        return i;
    }

    private OcContractGoodsPlan createOcContractGoodsPlan(OcContractGoodsPlanDomain ocContractGoodsPlanDomain) {
        String msg = this.checkContractGoodsPlan(ocContractGoodsPlanDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.saveContractGoodsPlan.checkContractGoodsPlan", msg);
        }
        OcContractGoodsPlan ocContractGoodsPlan = this.makeContractGoodsPlan(ocContractGoodsPlanDomain, null);
        this.setContractGoodsPlanDefault(ocContractGoodsPlan);
        return ocContractGoodsPlan;
    }

    @Override
    public String saveContractGoodsPlan(OcContractGoodsPlanDomain ocContractGoodsPlanDomain) throws ApiException {
        OcContractGoodsPlan ocContractGoodsPlan = this.createOcContractGoodsPlan(ocContractGoodsPlanDomain);
        this.saveContractGoodsPlanModel(ocContractGoodsPlan);
        return ocContractGoodsPlan.getContractGoodsCode();
    }

    @Override
    public String saveContractGoodsPlanBatch(List<OcContractGoodsPlanDomain> ocContractGoodsPlanDomainList) throws ApiException {
        if (null == ocContractGoodsPlanDomainList || ocContractGoodsPlanDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractGoodsPlan> ocContractGoodsPlanList = new ArrayList<OcContractGoodsPlan>();
        String code = "";
        for (OcContractGoodsPlanDomain ocContractGoodsPlanDomain : ocContractGoodsPlanDomainList) {
            OcContractGoodsPlan ocContractGoodsPlan = this.createOcContractGoodsPlan(ocContractGoodsPlanDomain);
            code = ocContractGoodsPlan.getContractGoodsCode();
            ocContractGoodsPlanList.add(ocContractGoodsPlan);
        }
        this.saveContractGoodsPlanBatchModel(ocContractGoodsPlanList);
        return code;
    }

    @Override
    public void updateContractGoodsPlanState(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        this.updateStateContractGoodsPlanModel(contractGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractGoodsPlanStateByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractGoodsPlanModelByCode(tenantCode, contractGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractGoodsPlan(OcContractGoodsPlanDomain ocContractGoodsPlanDomain) throws ApiException {
        String msg = this.checkContractGoodsPlan(ocContractGoodsPlanDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateContractGoodsPlan.checkContractGoodsPlan", msg);
        }
        OcContractGoodsPlan oldOcContractGoodsPlan = this.getContractGoodsPlanModelById(ocContractGoodsPlanDomain.getContractGoodsId());
        if (null == oldOcContractGoodsPlan) {
            throw new ApiException("oc.CONTRACT.OcContractGoodsPlanServiceImpl.updateContractGoodsPlan.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractGoodsPlan ocContractGoodsPlan = this.makeContractGoodsPlan(ocContractGoodsPlanDomain, oldOcContractGoodsPlan);
        this.setContractGoodsPlanUpdataDefault(ocContractGoodsPlan);
        this.updateContractGoodsPlanModel(ocContractGoodsPlan);
    }

    @Override
    public OcContractGoodsPlan getContractGoodsPlan(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        return this.getContractGoodsPlanModelById(contractGoodsId);
    }

    @Override
    public void deleteContractGoodsPlan(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        this.deleteContractGoodsPlanModel(contractGoodsId);
    }

    @Override
    public QueryResult<OcContractGoodsPlan> queryContractGoodsPlanPage(Map<String, Object> map) {
        List<OcContractGoodsPlan> ocContractGoodsPlanList = this.queryContractGoodsPlanModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoodsPlan(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsPlanList);
        return queryResult;
    }

    @Override
    public OcContractGoodsPlan getContractGoodsPlanByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        return this.getContractGoodsPlanModelByCode(map);
    }

    @Override
    public void deleteContractGoodsPlanByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        this.delContractGoodsPlanModelByCode(map);
    }
}

