/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.contract.domain.GoodsSendNumBean;
import com.yqbsoft.laser.service.contract.domain.OcCflowNodeReDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowPserviceReDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractEditDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.domain.OcReorderDomain;
import com.yqbsoft.laser.service.contract.domain.ProcessBean;
import com.yqbsoft.laser.service.contract.enumc.FlowStartCon;
import com.yqbsoft.laser.service.contract.enumc.PprocessStartCon;
import com.yqbsoft.laser.service.contract.es.ContractQueryCall;
import com.yqbsoft.laser.service.contract.model.OcCflowNode;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcContractCtrl;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcContractSub;
import com.yqbsoft.laser.service.contract.service.ContractCopier;
import com.yqbsoft.laser.service.contract.service.OcCflowPprocessService;
import com.yqbsoft.laser.service.contract.service.OcCflowService;
import com.yqbsoft.laser.service.contract.service.OcContractCtrlService;
import com.yqbsoft.laser.service.contract.service.OcContractEditService;
import com.yqbsoft.laser.service.contract.service.OcContractFlowEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractSubService;
import com.yqbsoft.laser.service.contract.service.impl.OcContractSupperServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractFlowEngineServiceImpl
extends OcContractSupperServiceImpl
implements OcContractFlowEngineService {
    public static final String SYS_CODE = "oc.CONTRACT.OcContractFlowEngineServiceImpl";
    private static final Integer EXECUTE_INDEX = 100;
    private OcContractCtrlService ocContractCtrlService;
    private OcContractService ocContractService;
    private OcContractEditService ocContractEditService;
    private OcContractSubService ocContractSubService;
    private OcCflowPprocessService ocCflowPprocessService;
    private OcCflowService ocCflowService;
    private ContractCopier contractCopier;
    private String conmap_key_startType = "startType";
    private String conmap_key_contract = "ocContractDomain";
    private String conmap_key_rmap = "rmap";
    private String conmap_key_goods = "contractGoodsList";
    private String conmap_key_paymoney = "contractPaygmoney";
    private static final String defDataStr = "dataStatestr";

    public void setOcContractEditService(OcContractEditService ocContractEditService) {
        this.ocContractEditService = ocContractEditService;
    }

    public void setOcCflowService(OcCflowService ocCflowService) {
        this.ocCflowService = ocCflowService;
    }

    public void setContractCopier(ContractCopier contractCopier) {
        this.contractCopier = contractCopier;
    }

    public void setOcContractSubService(OcContractSubService ocContractSubService) {
        this.ocContractSubService = ocContractSubService;
    }

    public OcContractService getOcContractService() {
        return this.ocContractService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public OcCflowPprocessService getOcCflowPprocessService() {
        return this.ocCflowPprocessService;
    }

    public void setOcCflowPprocessService(OcCflowPprocessService ocCflowPprocessService) {
        this.ocCflowPprocessService = ocCflowPprocessService;
    }

    public OcContractCtrlService getOcContractCtrlService() {
        return this.ocContractCtrlService;
    }

    public void setOcContractCtrlService(OcContractCtrlService ocContractCtrlService) {
        this.ocContractCtrlService = ocContractCtrlService;
    }

    @Override
    public List<OcCflowPprocessDomain> saveContractEngineStart(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain || null == ocContractDomain.getPackageList() || ocContractDomain.getPackageList().isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContractEngineStart.null", "null");
        }
        OcCflowReDomain ocCflowReDomain = this.getOcCflowReDomain(ocContractDomain.getContractType(), ocContractDomain.getAppmanageIcode(), ocContractDomain.getChannelCode(), ocContractDomain.getGoodsClass(), ocContractDomain.getTenantCode(), ocContractDomain.getNewCreateFlag());
        if (null == ocCflowReDomain || null == ocCflowReDomain.getNodeReList() || ocCflowReDomain.getNodeReList().isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContractEngineStart.ocCflowReDomain", "ocCflowReDomain is null");
        }
        this.logger.info("\u4e0b\u5355\u6d41\u7a0b\u7ec4 ocCflowReDomain cflowCode\uff1a" + ocCflowReDomain.getCflowCode());
        OcContractReDomain ocContractReDomain = new OcContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractReDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContractEngineStart.null", "null");
        }
        if (null == ocContractReDomain.getDataState()) {
            ocContractReDomain.setDataState(0);
        }
        return this.createCflowPprocessList(ocContractReDomain, ocCflowReDomain, FlowStartCon.AU.getCode());
    }

    private List<OcCflowNodeReDomain> getOcCflowNodeReDomainList(String cflowCode, String cflowNodeNextcode, String tenantCode) {
        List ocCflowNodeList = DisUtil.getMapListJson((String)"ocProtCflowNodeByParent", (String)(cflowCode + "-" + cflowNodeNextcode + "-" + tenantCode), OcCflowNodeReDomain.class);
        if (ListUtil.isEmpty((Collection)ocCflowNodeList) && ListUtil.isEmpty((Collection)(ocCflowNodeList = DisUtil.getMapListJson((String)"ocProtCflowNodeByParent", (String)(cflowCode + "-" + cflowNodeNextcode + "-" + "00000000"), OcCflowNodeReDomain.class))) && null == (ocCflowNodeList = (List)DisUtil.getDisCache().getRemotMapJson("ocProtCflowNodeByParent", cflowCode + "-" + cflowNodeNextcode + "-" + "00000000", OcCflowNodeReDomain.class))) {
            this.logger.info("===\u65b0\u83b7\u53d6\u4e0b\u4e00\u4e2a\u8ba2\u5355\u8282\u70b9DB:", (Object)(cflowCode + "-" + cflowNodeNextcode + "-" + tenantCode));
        }
        return ocCflowNodeList;
    }

    private OcCflowNodeReDomain getOcCflowNode(String cflowCode, String cflowNodeCode, String tenantCode) {
        OcCflowNodeReDomain ocCflowNodeReDomain = (OcCflowNodeReDomain)DisUtil.getMapJson((String)"ocProtCflowNode", (String)(cflowCode + "-" + cflowNodeCode + "-" + tenantCode), OcCflowNodeReDomain.class);
        if (null == ocCflowNodeReDomain && null == (ocCflowNodeReDomain = (OcCflowNodeReDomain)DisUtil.getMapJson((String)"ocProtCflowNode", (String)(cflowCode + "-" + cflowNodeCode + "-" + "00000000"), OcCflowNodeReDomain.class)) && null == (ocCflowNodeReDomain = (OcCflowNodeReDomain)DisUtil.getDisCache().getRemotMapJson("ocProtCflowNode", cflowCode + "-" + cflowNodeCode + "-" + "00000000", OcCflowNodeReDomain.class))) {
            this.logger.info("===\u65b0\u83b7\u53d6\u5f53\u524d\u8ba2\u5355\u8282\u70b9DB:", (Object)(cflowCode + "-" + cflowNodeCode + "-" + tenantCode));
            OcCflowNode ocCflowNode = this.ocCflowService.getCflowNodeByCode(cflowNodeCode, "00000000");
            if (ocCflowNode != null) {
                try {
                    BeanUtils.copyAllPropertys((Object)ocCflowNodeReDomain, (Object)ocCflowNode);
                }
                catch (Exception e) {
                    throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.getOcCflowNodeDomain.ocCflowNodeStr", cflowCode + "-" + cflowNodeCode + "-" + tenantCode);
                }
                HashMap<String, String> nodeparentmap = DisUtil.getMapAll((String)"ocProtCflowNode");
                if (nodeparentmap == null) {
                    nodeparentmap = new HashMap<String, String>();
                }
                nodeparentmap.put(cflowCode + "-" + cflowNodeCode + "-" + "00000000", JsonUtil.buildNormalBinder().toJson((Object)ocCflowNodeReDomain));
                DisUtil.setMap((String)"ocProtCflowNode", nodeparentmap);
            }
        }
        if (null == ocCflowNodeReDomain) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.getOcCflowNodeDomain.ocCflowNodeStr", cflowCode + "-" + cflowNodeCode + "-" + tenantCode);
        }
        return ocCflowNodeReDomain;
    }

    private void saveBatchCflowPprocess(List<OcCflowPprocessDomain> ocCflowPprocessDomainList, Map<String, Object> rmap) {
        if (null == ocCflowPprocessDomainList || ocCflowPprocessDomainList.isEmpty()) {
            return;
        }
        this.ocCflowPprocessService.saveBatchCflowPprocess(ocCflowPprocessDomainList);
        for (OcCflowPprocessDomain ocCflowPprocessDomain : ocCflowPprocessDomainList) {
            boolean callflag = this.callStart(ocCflowPprocessDomain, ocCflowPprocessDomain.getOcCflowNodeReDomain(), rmap);
            if (callflag) continue;
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveBatchCflowPprocess.callflag", ocCflowPprocessDomain.getCflowCode());
        }
    }

    private List<OcCflowPprocessDomain> createCflowPprocessList(OcContractReDomain ocContractDomain, OcCflowReDomain ocCflowReDomain, String cflowNodeStart) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null == ocCflowReDomain || null == ocCflowReDomain.getNodeReList() || ocCflowReDomain.getNodeReList().isEmpty()) {
            this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.createCflowPprocessList.null");
            return null;
        }
        List<OcCflowNodeReDomain> nodeReList = ocCflowReDomain.getNodeReList();
        if (ListUtil.isEmpty(nodeReList)) {
            // empty if block
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(defDataStr, ocContractDomain.getDataStatestr());
        return this.makeNodeToPprocess(ocContractDomain, cflowNodeStart, nodeReList, map);
    }

    private Map<String, Object> makeMap(OcContractDomain ocContractDomain, String cflowNodeStart, Map<String, Object> rmap) {
        List<OcPackageDomain> packageList;
        if (null == ocContractDomain) {
            return null;
        }
        HashMap<String, Object> conMap = new HashMap<String, Object>();
        conMap.put(this.conmap_key_startType, cflowNodeStart);
        conMap.put(this.conmap_key_contract, ocContractDomain);
        conMap.put(this.conmap_key_rmap, JsonUtil.buildNormalBinder().toJson(rmap));
        List<OcContractSettlDomain> settlist = ocContractDomain.getOcContractSettlList();
        if (null != settlist && !settlist.isEmpty()) {
            ArrayList<OcContractSettlDomain> nodeSettlist = null;
            String settlBlance = "";
            for (OcContractSettlDomain ocContractSettlDomain : settlist) {
                if (null == ocContractSettlDomain.getDataState()) {
                    ocContractSettlDomain.setDataState(0);
                }
                if (0 != ocContractSettlDomain.getDataState() || StringUtils.isBlank((String)ocContractSettlDomain.getContractSettlBlance())) continue;
                settlBlance = ocContractSettlDomain.getContractSettlBlance();
                if ("BCOP".equals(settlBlance)) {
                    settlBlance = "COP";
                }
                if ("BPM".equals(settlBlance)) {
                    settlBlance = "PM";
                }
                if (null == (nodeSettlist = (ArrayList<OcContractSettlDomain>)conMap.get(settlBlance))) {
                    nodeSettlist = new ArrayList<OcContractSettlDomain>();
                    conMap.put(settlBlance, nodeSettlist);
                }
                nodeSettlist.add(ocContractSettlDomain);
            }
        }
        if (null == (packageList = ocContractDomain.getPackageList()) || packageList.isEmpty()) {
            return conMap;
        }
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            contractGoodsList.addAll(ocPackageDomain.getContractGoodsList());
        }
        conMap.put(this.conmap_key_goods, contractGoodsList);
        return conMap;
    }

    private List<OcCflowPprocessDomain> makeNodeToPprocess(OcContractReDomain ocContractDomain, String cflowNodeStart, List<OcCflowNodeReDomain> nodeReList, Map<String, Object> rmap) {
        OcCflowPprocessDomain ocCflowPprocessDomain;
        if (null == nodeReList || nodeReList.isEmpty()) {
            this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.nodeReList", (Object)("end===" + ocContractDomain.getContractBillcode()));
            return null;
        }
        if (FlowStartCon.EE.getCode().equals(cflowNodeStart)) {
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.cflowNodeStart", (Object)cflowNodeStart);
            return null;
        }
        long s = System.currentTimeMillis();
        Map<String, Object> conMap = this.makeMap(ocContractDomain, cflowNodeStart, rmap);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.time0", (Object)(System.currentTimeMillis() - s));
        ArrayList<OcCflowPprocessDomain> pprocessList = new ArrayList<OcCflowPprocessDomain>();
        int index = 99;
        int nowIndex = 0;
        OcCflowNodeReDomain endOcCflowNodeReDomain = null;
        String mapStr = null;
        if (null != rmap) {
            mapStr = JsonUtil.buildNormalBinder().toJson(rmap);
        }
        if (null == rmap) {
            rmap = new HashMap<String, Object>();
            rmap.put(this.conmap_key_paymoney, ocContractDomain.getDataBmoney());
        }
        rmap.put(this.conmap_key_contract, ocContractDomain);
        for (OcCflowNodeReDomain ocCflowNodeReDomain : nodeReList) {
            if (ContractQueryCall.checkMNode(ocCflowNodeReDomain.getCflowCode()) && !StringUtils.isBlank((String)DisUtil.getRemot((String)("OC_FLOW_NODEMN-mnode-" + ocCflowNodeReDomain.getCflowCode()))) || ContractQueryCall.checkNowNodeEx(ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode(), ContractQueryCall.getMbNodeMnNode(ocCflowNodeReDomain)) || ContractQueryCall.checkNowNodeEx(ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode(), ContractQueryCall.getMnNodeMnNode(ocCflowNodeReDomain))) continue;
            if (ocCflowNodeReDomain.getCflowNodeNextcode().equals(ocCflowNodeReDomain.getCflowCode()) && StringUtils.isBlank((String)ocCflowNodeReDomain.getCflowPserviceCode())) {
                if (!StringUtils.isNotBlank((String)ocCflowNodeReDomain.getCflowNodeStart()) || !ocCflowNodeReDomain.getCflowNodeStart().equals(cflowNodeStart)) continue;
                endOcCflowNodeReDomain = ocCflowNodeReDomain;
                continue;
            }
            if (!this.excetuCon(conMap, ocCflowNodeReDomain)) {
                this.logger.info("\u8282\u70b9\u6761\u4ef6\u672a\u901a\u8fc7\uff1a", (Object)(ocCflowNodeReDomain.getCflowNodeCode() + "=" + ocCflowNodeReDomain.getCflowNodeCondition() + ";" + conMap.get("rmap") + "===" + ocContractDomain.getContractBillcode()));
                this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.excetuCon", (Object)(ocCflowNodeReDomain.getCflowNodeCode() + "=" + ocCflowNodeReDomain.getCflowNodeCondition() + ";" + conMap.get("rmap") + "===" + ocContractDomain.getContractBillcode()));
                continue;
            }
            if (StringUtils.isBlank((String)ocCflowNodeReDomain.getCflowNodeIndex())) {
                ocCflowNodeReDomain.setCflowNodeIndex("0");
            }
            if ((nowIndex = Integer.valueOf(ocCflowNodeReDomain.getCflowNodeIndex()).intValue()) > index && nowIndex != EXECUTE_INDEX) {
                this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.index", (Object)(ocCflowNodeReDomain.getCflowNodeCode() + "===" + ocContractDomain.getContractBillcode()));
                continue;
            }
            if (StringUtils.isNotBlank((String)ocCflowNodeReDomain.getCflowPserviceCode())) {
                OcCflowPserviceReDomain ocCflowPserviceReDomain = this.getPservice(ocCflowNodeReDomain.getCflowPserviceCode(), ocCflowNodeReDomain.getTenantCode());
                if (null == ocCflowPserviceReDomain && ocCflowNodeReDomain.getCflowCode().equals(ocCflowNodeReDomain.getCflowNodeNextcode())) {
                    throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.noservice", "null===" + ocContractDomain.getContractBillcode());
                }
                if (!this.excetuConJs(conMap, ocCflowPserviceReDomain.getCflowPserviceItemCn())) {
                    this.logger.info("\u670d\u52a1\u8282\u70b9\u6761\u4ef6\u672a\u901a\u8fc7\uff1a\u670d\u52a1\u8282\u70b9\uff1a" + JSON.toJSONString((Object)ocCflowPserviceReDomain) + "\u6570\u636e\uff1a" + conMap);
                    this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.excetuConJs", (Object)(ocCflowNodeReDomain.getCflowNodeCode() + ";" + ocCflowPserviceReDomain.getCflowPserviceItemCn() + "===" + ocContractDomain.getContractBillcode()));
                    continue;
                }
            }
            if (null != (ocCflowPprocessDomain = this.createProcess(ocCflowNodeReDomain, ocContractDomain, false, rmap))) {
                Map callmap;
                ocCflowPprocessDomain.setCflowPprocessCon(mapStr);
                if (StringUtils.isNotBlank((String)ocCflowNodeReDomain.getCflowNodeScallparam()) && MapUtil.isNotEmpty((Map)(callmap = JsonUtil.buildNormalBinder().getJsonToMap(ocCflowNodeReDomain.getCflowNodeScallparam(), String.class, Object.class))) && callmap.containsKey("callDataState")) {
                    ocContractDomain.setCallDataState((String)callmap.get("callDataState"));
                }
                pprocessList.add(ocCflowPprocessDomain);
            }
            if (nowIndex == EXECUTE_INDEX) continue;
            index = nowIndex;
        }
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.time1", (Object)(System.currentTimeMillis() - s));
        if (pprocessList.isEmpty() && null != endOcCflowNodeReDomain) {
            ocCflowPprocessDomain = this.createProcess(endOcCflowNodeReDomain, ocContractDomain, true, rmap);
            if (null != ocCflowPprocessDomain) {
                ocCflowPprocessDomain.setCflowPprocessCon(mapStr);
            }
            pprocessList.add(ocCflowPprocessDomain);
        }
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.time2", (Object)(System.currentTimeMillis() - s));
        this.saveBatchCflowPprocess(pprocessList, rmap);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.makeNodeToPprocess.time3", (Object)(System.currentTimeMillis() - s));
        return pprocessList;
    }

    private boolean callStart(OcCflowPprocessDomain ocCflowPprocessDomain, OcCflowNodeReDomain ocCflowNodeReDomain, Map<String, Object> rmap) {
        if (null == ocCflowPprocessDomain || null == ocCflowNodeReDomain) {
            return true;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocCflowNodeReDomain", ocCflowNodeReDomain);
        map.put("ocCflowPprocessDomain", ocCflowPprocessDomain);
        if (null != rmap && !rmap.isEmpty()) {
            map.putAll(rmap);
        }
        return this.savecall(ocCflowNodeReDomain.getCflowNodeScallcon(), ocCflowNodeReDomain.getCflowNodeScallparam(), map, ocCflowPprocessDomain);
    }

    private boolean callEnd(OcCflowPprocessDomain ocCflowPprocessDomain, OcCflowNodeReDomain ocCflowNodeReDomain, Integer dataState, Map<String, Object> rmap) {
        if (null == ocCflowPprocessDomain || null == ocCflowNodeReDomain) {
            return true;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", dataState);
        map.put("ocCflowNodeReDomain", ocCflowNodeReDomain);
        map.put("ocCflowPprocessDomain", ocCflowPprocessDomain);
        if (null != rmap && !rmap.isEmpty()) {
            map.putAll(rmap);
        }
        return this.savecall(ocCflowNodeReDomain.getCflowNodeCallcon(), ocCflowNodeReDomain.getCflowNodeCallparam(), map, ocCflowPprocessDomain);
    }

    private boolean savecall(String js, String callparam, Map<String, Object> map, OcCflowPprocessDomain ocCflowPprocessDomain) {
        if (StringUtils.isBlank((String)js)) {
            return true;
        }
        String res = (String)ScriptUtil.evel((String)js, map);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.savecall.ScriptUtil.evel", (Object)"===end===");
        if (!"ok".equals(res)) {
            return false;
        }
        Map m = JsonUtil.buildNonDefaultBinder().getJsonToMap(callparam, String.class, Object.class);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.savecall.JsonUtil.buildNonDefaultBinder", (Object)"===end===");
        Integer dataState = null;
        Integer oldDataState = null;
        BigDecimal contractPaygmoney = null;
        this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.savecall.JsonUtil.map", (Object)("map" + JsonUtil.buildNormalBinder().toJson(map) + ",m:" + JsonUtil.buildNormalBinder().toJson((Object)m)));
        OcContractCtrlCflowDomain ocContractCtrlCflowDomain = new OcContractCtrlCflowDomain();
        HashMap<String, Object> remap = new HashMap<String, Object>();
        if (null != m && !m.isEmpty()) {
            SimpleDateFormat dateFormat;
            Object obj;
            String contractPaygmoneyStr;
            if (null != m.get("dataState")) {
                dataState = Integer.valueOf(String.valueOf(m.get("dataState")));
            }
            if (null != m.get("oldDataState")) {
                oldDataState = Integer.valueOf(String.valueOf(m.get("oldDataState")));
            }
            if (null != m.get("contractPaygmoney") && null != map && StringUtils.isNotBlank((String)(contractPaygmoneyStr = String.valueOf(m.get("contractPaygmoney"))))) {
                contractPaygmoney = new BigDecimal(contractPaygmoneyStr);
            }
            if (null != m.get("memo") && null != map) {
                remap.put("memo", map.get("memo"));
            }
            if (null != m.get("contractDepositdate") && null != map) {
                obj = map.get("contractDepositdate");
                Date contractDepositdate = new Date();
                ocContractCtrlCflowDomain.setContractDepositdate(contractDepositdate);
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("contractDepositdate", contractDepositdate);
                } else {
                    remap.put("contractDepositdate", DateUtil.getDateString((Date)contractDepositdate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                ocContractCtrlCflowDomain.setContractDepositdate(contractDepositdate);
            }
            if (null != m.get("contractPaydate") && null != map) {
                obj = map.get("contractPaydate");
                Date contractPaydate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("contractPaydate", contractPaydate);
                } else {
                    remap.put("contractPaydate", DateUtil.getDateString((Date)contractPaydate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                ocContractCtrlCflowDomain.setContractPaydate(contractPaydate);
                if ("contractPaydate".equals(m.get("contractPaydate").toString()) && !EmptyUtil.isEmpty((Object)map.get("contractPaydate"))) {
                    remap.put("contractPaydate", map.get("contractPaydate"));
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        ocContractCtrlCflowDomain.setContractPaydate(dateFormat.parse(map.get("contractPaydate").toString()));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (null != m.get("contractEffectivedate") && null != map) {
                obj = map.get("contractEffectivedate");
                Date contractEffectivedate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("contractEffectivedate", contractEffectivedate);
                } else {
                    remap.put("contractEffectivedate", DateUtil.getDateString((Date)contractEffectivedate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                ocContractCtrlCflowDomain.setContractEffectivedate(contractEffectivedate);
                if ("contractEffectivedate".equals(m.get("contractEffectivedate").toString()) && !EmptyUtil.isEmpty((Object)map.get("contractEffectivedate"))) {
                    remap.put("contractEffectivedate", map.get("contractEffectivedate"));
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        ocContractCtrlCflowDomain.setContractEffectivedate(dateFormat.parse(map.get("contractEffectivedate").toString()));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (null != m.get("contractValidate") && null != map) {
                obj = map.get("contractValidate");
                Date contractValidate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("contractValidate", contractValidate);
                } else {
                    remap.put("contractValidate", DateUtil.getDateString((Date)contractValidate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                ocContractCtrlCflowDomain.setContractValidate(contractValidate);
                if ("contractValidate".equals(m.get("contractValidate").toString()) && !EmptyUtil.isEmpty((Object)map.get("contractValidate"))) {
                    remap.put("contractValidate", map.get("contractValidate"));
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        ocContractCtrlCflowDomain.setContractValidate(dateFormat.parse(map.get("contractValidate").toString()));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (null != m.get("contractInvoicedate") && null != map) {
                obj = map.get("contractInvoicedate");
                Date contractInvoicedate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("contractInvoicedate", contractInvoicedate);
                } else {
                    remap.put("contractInvoicedate", DateUtil.getDateString((Date)contractInvoicedate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                ocContractCtrlCflowDomain.setContractInvoicedate(contractInvoicedate);
            }
            if (null != m.get("sendgoodsSddate") && null != map) {
                obj = map.get("sendgoodsSddate");
                Date sendgoodsSddate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("sendgoodsSddate", sendgoodsSddate);
                } else {
                    remap.put("sendgoodsSddate", DateUtil.getDateString((Date)sendgoodsSddate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            if (null != m.get("sendgoodsGddate") && null != map) {
                obj = map.get("sendgoodsGddate");
                Date sendgoodsGddate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("sendgoodsGddate", sendgoodsGddate);
                } else {
                    remap.put("sendgoodsGddate", DateUtil.getDateString((Date)sendgoodsGddate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            if (null != m.get("sendgoodsVaildate") && null != map) {
                obj = map.get("sendgoodsVaildate");
                Date sendgoodsVaildate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("sendgoodsVaildate", sendgoodsVaildate);
                } else {
                    remap.put("sendgoodsVaildate", DateUtil.getDateString((Date)sendgoodsVaildate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            if (null != m.get("sendgoodsGetdate") && null != map) {
                obj = map.get("sendgoodsGetdate");
                Date sendgoodsGetdate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("sendgoodsGetdate", sendgoodsGetdate);
                } else {
                    remap.put("sendgoodsGetdate", DateUtil.getDateString((Date)sendgoodsGetdate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            if (null != m.get("sendgoodsOkdate") && null != map) {
                obj = map.get("sendgoodsOkdate");
                Date sendgoodsOkdate = new Date();
                if (null == obj || "".equals(obj.toString()) || obj.toString().equals("date")) {
                    remap.put("sendgoodsOkdate", sendgoodsOkdate);
                } else {
                    remap.put("sendgoodsOkdate", DateUtil.getDateString((Date)sendgoodsOkdate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
        }
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.savecall.remap.init", (Object)"===end===");
        ocContractCtrlCflowDomain.setPtradeSeqno((String)map.get("ptradeSeqno"));
        ocContractCtrlCflowDomain.setCflowCode(ocCflowPprocessDomain.getCflowCode());
        ocContractCtrlCflowDomain.setCflowNodeCode(ocCflowPprocessDomain.getCflowNodeCode());
        ocContractCtrlCflowDomain.setCflowPprocessCode(ocCflowPprocessDomain.getCflowPprocessCode());
        ocContractCtrlCflowDomain.setContractCtrlSeqno(ocCflowPprocessDomain.getContractCtrlSeqno());
        ocContractCtrlCflowDomain.setUserCode(ocCflowPprocessDomain.getUserCode());
        ocContractCtrlCflowDomain.setUserName(ocCflowPprocessDomain.getUserName());
        ocContractCtrlCflowDomain.setDataState(dataState);
        ocContractCtrlCflowDomain.setOldDataState(oldDataState);
        ocContractCtrlCflowDomain.setTenantCode(ocCflowPprocessDomain.getTenantCode());
        ocContractCtrlCflowDomain.setContractPaygmoney(contractPaygmoney);
        this.ocContractService.updateContractFlowState(ocContractCtrlCflowDomain, remap, ocCflowPprocessDomain);
        String contractSubCode = (String)map.get("contractSubCode");
        if (StringUtils.isNotBlank((String)contractSubCode)) {
            this.ocContractSubService.updateContracSubPay(contractSubCode, ocCflowPprocessDomain.getTenantCode(), null);
        }
        return true;
    }

    private OcCflowPserviceReDomain getPservice(String cflowPserviceCode, String tenantCode) {
        if (StringUtils.isBlank((String)cflowPserviceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (cflowPserviceCode.indexOf("mock") >= 0) {
            OcCflowPserviceReDomain ocCflowPserviceReDomain = new OcCflowPserviceReDomain();
            ocCflowPserviceReDomain.setCflowPserviceCode(cflowPserviceCode);
            ocCflowPserviceReDomain.setTenantCode(tenantCode);
            ocCflowPserviceReDomain.setDataState(1);
            ocCflowPserviceReDomain.setDataCalltype("API");
            ocCflowPserviceReDomain.setDataCallurl("mock");
            return ocCflowPserviceReDomain;
        }
        OcCflowPserviceReDomain ocCflowPserviceReDomain = (OcCflowPserviceReDomain)DisUtil.getMapJson((String)"OcCflowPservice", (String)(cflowPserviceCode + "-" + tenantCode), OcCflowPserviceReDomain.class);
        if (null == ocCflowPserviceReDomain && null == (ocCflowPserviceReDomain = (OcCflowPserviceReDomain)DisUtil.getMapJson((String)"OcCflowPservice", (String)(cflowPserviceCode + "-" + "00000000"), OcCflowPserviceReDomain.class))) {
            ocCflowPserviceReDomain = (OcCflowPserviceReDomain)DisUtil.getDisCache().getRemotMapJson("OcCflowPservice", cflowPserviceCode + "-" + "00000000", OcCflowPserviceReDomain.class);
        }
        if (null == ocCflowPserviceReDomain) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.getPservice.noservice", cflowPserviceCode + "-" + tenantCode);
        }
        return ocCflowPserviceReDomain;
    }

    private boolean excetuCon(Map<String, Object> conMap, OcCflowNodeReDomain ocCflowNodeReDomain) {
        if (null == ocCflowNodeReDomain || null == conMap || conMap.isEmpty()) {
            return false;
        }
        if (ocCflowNodeReDomain.getCflowNodeNextcode().equals(ocCflowNodeReDomain.getCflowCode()) && StringUtils.isBlank((String)ocCflowNodeReDomain.getCflowPserviceCode())) {
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.excetuCon.end", (Object)"end");
            return false;
        }
        if (!conMap.get(this.conmap_key_startType).equals(ocCflowNodeReDomain.getCflowNodeStart())) {
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.excetuCon.startType", (Object)("conmap_key_startType:" + conMap.get(this.conmap_key_startType) + "-" + ocCflowNodeReDomain.getCflowNodeStart() + "===" + ocCflowNodeReDomain.getCflowNodeCode()));
            return false;
        }
        if (StringUtils.isNotBlank((String)ocCflowNodeReDomain.getCflowNodeStart()) && !ocCflowNodeReDomain.getCflowNodeStart().equals(conMap.get(this.conmap_key_startType))) {
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.excetuCon.fchannelType", (Object)("fchannelType:" + conMap.get(this.conmap_key_startType) + "-" + ocCflowNodeReDomain.getCflowNodeStart() + "===" + ocCflowNodeReDomain.getCflowNodeCode()));
            return false;
        }
        return this.excetuConJs(conMap, ocCflowNodeReDomain.getCflowNodeCondition());
    }

    public static void main(String[] args) {
        String conStr = "if(CRP===undefined){return 'error';} else {return 'ok';}";
        conStr = "if(null==js_keymap.CRP&&null==js_keymap.VD&&null==js_keymap.CAS){return 'ok';} else {return 'error';}";
        HashMap<String, String> conMap = new HashMap<String, String>();
        HashMap<String, String> conMap1 = new HashMap<String, String>();
        conMap1.put("sendgoodsLogName", "\u5df2\u53d1\u8d27");
        conMap1.put("INT", "1");
        conMap.put("rmap", JsonUtil.buildNormalBinder().toJson(conMap1));
        conMap.put("CRP", "33");
        String res = (String)ScriptUtil.evel((String)conStr, conMap);
        if (!"ok".equals(res)) {
            System.out.println("===1");
        }
        System.out.println("===2" + res);
    }

    private boolean excetuConJs(Map<String, Object> conMap, String conStr) {
        this.logger.error("conMap=====", (Object)JsonUtil.buildNormalBinder().toJson(conMap));
        this.logger.error("conStr=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)conStr));
        if (StringUtils.isBlank((String)conStr)) {
            return true;
        }
        String res = (String)ScriptUtil.evel((String)conStr, conMap);
        this.logger.error("res=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)res));
        return "ok".equals(res);
    }

    private OcCflowPprocessDomain createProcess(OcCflowNodeReDomain ocCflowNodeReDomain, OcContractReDomain ocContractDomain, boolean endFlag, Map<String, Object> rmap) {
        OcCflowPprocessDomain ocCflowPprocessDomain = this.createPprocessDomain(ocCflowNodeReDomain, ocContractDomain, endFlag, rmap);
        if (null == ocCflowPprocessDomain) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.createProcess.pprocess", "null");
        }
        return ocCflowPprocessDomain;
    }

    private OcCflowPprocessDomain createPprocessDomain(OcCflowNodeReDomain ocCflowNodeReDomain, OcContractReDomain ocContractDomain, boolean endFlag, Map<String, Object> rmap) {
        if (null == ocCflowNodeReDomain || null == ocContractDomain) {
            return null;
        }
        OcCflowPprocessDomain ocCflowPprocessDomain = new OcCflowPprocessDomain();
        ocCflowPprocessDomain.setCflowPprocessCode(this.createUUIDString());
        ocCflowPprocessDomain.setCflowCode(ocCflowNodeReDomain.getCflowCode());
        ocCflowPprocessDomain.setCflowNodeCode(ocCflowNodeReDomain.getCflowNodeCode());
        ocCflowPprocessDomain.setCflowName(ocCflowNodeReDomain.getCflowNodeName());
        if (MapUtil.isNotEmpty(rmap)) {
            ocCflowPprocessDomain.setUserCode((String)rmap.get("userCode"));
            ocCflowPprocessDomain.setUserName((String)rmap.get("userName"));
        }
        ocCflowPprocessDomain.setCflowPprocessTime(new Date());
        ocCflowPprocessDomain.setCflowPserviceCode(ocCflowNodeReDomain.getCflowPserviceCode());
        ocCflowPprocessDomain.setContractBbillcode(ocContractDomain.getContractBbillcode());
        ocCflowPprocessDomain.setContractBillcode(ocContractDomain.getContractBillcode());
        if (StringUtils.isBlank((String)ocContractDomain.getContractCtrlSeqno())) {
            OcContractCtrl ocContractCtrl = this.ocContractCtrlService.getContractCtrlByBillCode(ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode());
            if (null == ocContractCtrl) {
                this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.createPprocessDomain.null", (Object)(ocContractDomain.getContractBillcode() + "=" + ocContractDomain.getTenantCode()));
                return null;
            }
            ocContractDomain.setContractCtrlSeqno(ocContractCtrl.getContractCtrlSeqno());
        }
        ocCflowPprocessDomain.setContractCtrlSeqno(ocContractDomain.getContractCtrlSeqno());
        ocCflowPprocessDomain.setTenantCode(ocContractDomain.getTenantCode());
        ocCflowPprocessDomain.setEndFlag(endFlag);
        ocCflowPprocessDomain.setOcContractDomain(ocContractDomain);
        ocCflowPprocessDomain.setOcCflowNodeReDomain(ocCflowNodeReDomain);
        return ocCflowPprocessDomain;
    }

    @Override
    public ProcessBean updateContractNext(OcContractDomain ocContractDomain, boolean nextflag) throws ApiException {
        this.ocContractService.updateContract(ocContractDomain);
        if (nextflag) {
            return this.saveContractNext(ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode(), null);
        }
        return null;
    }

    @Override
    public ProcessBean updateContract(OcContractDomain ocContractDomain) {
        return null;
    }

    @Override
    public ProcessBean saveContractNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        return this.saveContract(FlowStartCon.AN.getCode(), contractBillcode, tenantCode, map);
    }

    @Override
    public ProcessBean updateContractEdit(OcContractEditDomain ocContractEditDomain, Map<String, Object> map) throws ApiException {
        if (null == ocContractEditDomain) {
            return null;
        }
        this.ocContractService.updateContractEdit(ocContractEditDomain);
        return this.saveContract(FlowStartCon.AN.getCode(), ocContractEditDomain.getContractBillcode(), ocContractEditDomain.getTenantCode(), map);
    }

    @Override
    public ProcessBean saveContractEdit(List<OcContractEditDomain> ocContractEditDomainList, Map<String, Object> map) throws ApiException {
        if (ListUtil.isEmpty(ocContractEditDomainList)) {
            return null;
        }
        this.ocContractEditService.saveContractEditBatch(ocContractEditDomainList);
        return this.saveContract(FlowStartCon.AN.getCode(), ocContractEditDomainList.get(0).getContractBillcode(), ocContractEditDomainList.get(0).getTenantCode(), map);
    }

    @Override
    public ProcessBean saveContractOk(String contractBillcode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        Map parammap = this.getQueryMapParam("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode});
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(parammap);
        if (null == ocContractReDomain) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContractOk.ocContractReDomain", parammap.toString());
        }
        this.ocContractService.updateContractState(ocContractReDomain.getContractId(), ocContractReDomain.getDataState(), ocContractReDomain.getDataState());
        QueryResult<OcContractGoods> qlist = this.ocContractService.queryContractGoodsPage(parammap);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContractOk.ocContractGoods", parammap.toString());
        }
        boolean flag = false;
        for (OcContractGoods ocContractGoods : qlist.getList()) {
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsTopnum()) {
                ocContractGoods.setGoodsTopnum(BigDecimal.ZERO);
            }
            if (0 != ocContractGoods.getContractGoodsType()) continue;
            flag = true;
        }
        boolean update = true;
        for (OcContractGoods ocContractGoods : qlist.getList()) {
            if (flag && 0 == ocContractGoods.getContractGoodsType() && ocContractGoods.getGoodsCamount().compareTo(ocContractGoods.getGoodsTopnum()) == 1) {
                update = false;
                break;
            }
            if (flag || 0 == ocContractGoods.getContractGoodsType() || ocContractGoods.getGoodsCamount().compareTo(ocContractGoods.getGoodsTopnum()) != 1) continue;
            update = false;
            break;
        }
        if (update) {
            return this.saveContract(FlowStartCon.AN.getCode(), contractBillcode, tenantCode, map);
        }
        return null;
    }

    @Override
    public ProcessBean saveContractEdit(String contractBillcode, String tenantCode, Map<String, Object> map) {
        return this.saveContract(FlowStartCon.ED.getCode(), contractBillcode, tenantCode, map);
    }

    @Override
    public ProcessBean saveContractMsg(String contractBillcode, String tenantCode, Map<String, Object> map) {
        return this.saveContract(FlowStartCon.MSG.getCode(), contractBillcode, tenantCode, map);
    }

    @Override
    public ProcessBean saveContractBatchNext(String contractBbillcode, String tenantCode, Map<String, Object> map) {
        List<OcContract> ocContractList = this.queryContractByBbillCode(contractBbillcode, tenantCode);
        if (null == ocContractList || ocContractList.isEmpty()) {
            return null;
        }
        ArrayList<OcCflowPprocessDomain> relist = new ArrayList<OcCflowPprocessDomain>();
        ProcessBean processBean = new ProcessBean();
        ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
        for (OcContract ocContract : ocContractList) {
            ProcessBean oneProcessBean = this.saveContract(FlowStartCon.AN.getCode(), ocContract.getContractBillcode(), tenantCode, map);
            if (null != oneProcessBean && ListUtil.isNotEmpty(oneProcessBean.getOcCflowPprocessDomainList())) {
                relist.addAll(oneProcessBean.getOcCflowPprocessDomainList());
            }
            if (null == oneProcessBean || !ListUtil.isNotEmpty(oneProcessBean.getOcContractDomainList())) continue;
            ocContractDomainList.addAll(oneProcessBean.getOcContractDomainList());
        }
        processBean.setOcCflowPprocessDomainList(relist);
        processBean.setOcContractDomainList(ocContractDomainList);
        return processBean;
    }

    private ProcessBean saveContract(String cflowNodeStart, String contractBillcode, String tenantCode, Map<String, Object> rmap) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContract.null");
        }
        this.ocContractService.updateContractLockByCode(contractBillcode, tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractDomain = this.ocContractService.getContractByCode(map);
        if (null == ocContractDomain) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContract.ocContractDomain", ((Object)map).toString());
        }
        if (MapUtil.isNotEmpty(rmap) && StringUtils.isNotBlank((String)((String)rmap.get("send"))) && ListUtil.isNotEmpty(ocContractDomain.getPackageList()) && StringUtils.isNotBlank((String)ocContractDomain.getPackageList().get(0).getPackageBillno())) {
            return null;
        }
        OcContractCtrl ocContractCtrl = this.ocContractCtrlService.getContractCtrlByBillCode(contractBillcode, tenantCode);
        if (null == ocContractCtrl) {
            throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContract.ocContractCtrl", contractBillcode + "=" + tenantCode);
        }
        if (null == rmap) {
            rmap = new HashMap<String, Object>();
        }
        String blance = ocContractDomain.getContractBlance();
        boolean flag = false;
        String contractSubCode = (String)rmap.get("contractSubCode");
        if (("2".equals(blance) || "3".equals(blance)) && StringUtils.isNotBlank((String)contractSubCode)) {
            OcContractSub ocContractSub = this.ocContractSubService.getContractSubByCode(tenantCode, contractSubCode);
            if (null == ocContractSub) {
                throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContract.ocContractSub", rmap.toString());
            }
            rmap.put("contractPaygmoney", ocContractSub.getContractSubGmoney());
            if (null != ocContractDomain.getContractPayamoney() && BigDecimal.ZERO.compareTo(ocContractDomain.getContractPayamoney()) != 0 || 1 != ocContractDomain.getDataState()) {
                flag = true;
            }
        } else if (!rmap.containsKey("contractPaygmoney")) {
            rmap.put("contractPaygmoney", ocContractDomain.getDataBmoney());
        }
        ocContractDomain.setContractCtrlSeqno(ocContractCtrl.getContractCtrlSeqno());
        List<OcCflowPprocessDomain> ppList = null;
        if (!flag) {
            OcCflowNodeReDomain ocCflowNodeReDomain = this.getOcCflowNode(ocContractCtrl.getCflowCode(), ocContractCtrl.getCflowNodeCode(), tenantCode);
            if (null == ocCflowNodeReDomain) {
                throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveContract.ocCflowNodeReDomain", ocContractCtrl.getCflowNodeCode() + "=" + tenantCode);
            }
            List<OcCflowNodeReDomain> ocCflowNodeList = this.getOcCflowNodeReDomainList(ocContractCtrl.getCflowCode(), ocCflowNodeReDomain.getCflowNodeNextcode(), ocContractCtrl.getTenantCode());
            ppList = this.makeNodeToPprocess(ocContractDomain, cflowNodeStart, ocCflowNodeList, rmap);
        }
        if (("2".equals(blance) || "3".equals(blance)) && flag && StringUtils.isNotBlank((String)contractSubCode)) {
            this.ocContractSubService.updateContracSubPay(contractSubCode, tenantCode, contractBillcode);
        }
        ProcessBean processBean = new ProcessBean();
        processBean.setOcCflowPprocessDomainList(ppList);
        ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
        processBean.setOcContractDomainList(ocContractDomainList);
        ocContractDomainList.add(ocContractDomain);
        return processBean;
    }

    @Override
    public ProcessBean saveContractBack(String contractBillcode, String tenantCode, Map<String, Object> map) {
        return this.saveContract(FlowStartCon.AB.getCode(), contractBillcode, tenantCode, map);
    }

    @Override
    public ProcessBean saveFlowNode(OcCflowPprocessDomain ocCflowPprocessDomain) {
        Map callmap;
        if (null == ocCflowPprocessDomain) {
            return null;
        }
        Integer oldDataState = ocCflowPprocessDomain.getOldDataState();
        if (null == oldDataState) {
            oldDataState = PprocessStartCon.AN.getCode();
        }
        long s = System.currentTimeMillis();
        this.ocCflowPprocessService.updateCflowPprocessStateByCode(ocCflowPprocessDomain.getCflowPprocessCode(), ocCflowPprocessDomain.getTenantCode(), oldDataState, oldDataState);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time0", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
        String cflowNodeStart = FlowStartCon.CS.getCode();
        if (ContractQueryCall.checkMNode(ocCflowPprocessDomain.getCflowCode())) {
            if (!ocCflowPprocessDomain.getCflowPprocessCode().equals(DisUtil.getRemot((String)("OC_FLOW_NODEMN-mnode-" + ocCflowPprocessDomain.getCflowCode())))) {
                return null;
            }
            int ex = ContractQueryCall.checkMNodeEx(ocCflowPprocessDomain.getContractBillcode(), ocCflowPprocessDomain.getTenantCode(), ocCflowPprocessDomain.getCflowCode());
            cflowNodeStart = ex == 1 ? FlowStartCon.CE.getCode() : (ex == 2 ? FlowStartCon.CS.getCode() : FlowStartCon.BL.getCode());
        } else if (1 == ContractQueryCall.checkMex(ocCflowPprocessDomain.getContractBillcode(), ocCflowPprocessDomain.getTenantCode(), ocCflowPprocessDomain.getCflowCode())) {
            ocCflowPprocessDomain.setExflag(false);
            cflowNodeStart = FlowStartCon.CE.getCode();
        } else {
            ocCflowPprocessDomain.setExflag(true);
            if (StringUtils.isNotBlank((String)ocCflowPprocessDomain.getCflowPserviceCode())) {
                OcCflowPserviceReDomain ocCflowPserviceReDomain = this.getPservice(ocCflowPprocessDomain.getCflowPserviceCode(), ocCflowPprocessDomain.getTenantCode());
                if (null == ocCflowPserviceReDomain) {
                    throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.ocCflowPserviceReDomain", "null");
                }
                Map rmap = null;
                if (StringUtils.isNotBlank((String)ocCflowPprocessDomain.getCflowPprocessCon())) {
                    rmap = JsonUtil.buildNormalBinder().getJsonToMap(ocCflowPprocessDomain.getCflowPprocessCon(), String.class, Object.class);
                }
                Map<String, Object> map = this.makeMap(ocCflowPprocessDomain.getOcContractDomain(), null, rmap);
                long startTime = System.currentTimeMillis();
                cflowNodeStart = this.callService(ocCflowPserviceReDomain, map);
                this.logger.info("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "\u8ba2\u5355\u6d41\u7a0b\u5f02\u6b65\u5904\u7406:" + ocCflowPserviceReDomain.getDataCallurl() + ":" + (System.currentTimeMillis() - startTime) + ":" + 1 + ":" + (FlowStartCon.CS.getCode().equals(cflowNodeStart) ? "Y" : "N"));
                if (StringUtils.isBlank((String)cflowNodeStart)) {
                    throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.cflowNodeStart", "null");
                }
            }
        }
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time1", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
        Integer dataState = FlowStartCon.CE.getCode().equals(cflowNodeStart) ? PprocessStartCon.CE.getCode() : (FlowStartCon.EE.getCode().equals(cflowNodeStart) ? PprocessStartCon.EE.getCode() : (FlowStartCon.BL.getCode().equals(cflowNodeStart) ? PprocessStartCon.BL.getCode() : PprocessStartCon.CS.getCode()));
        ocCflowPprocessDomain.setExDataState(dataState);
        this.ocCflowPprocessService.updateCflowPprocessStateByCode(ocCflowPprocessDomain.getCflowPprocessCode(), ocCflowPprocessDomain.getTenantCode(), dataState, oldDataState);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time2", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
        if (FlowStartCon.EE.getCode().equals(cflowNodeStart) || FlowStartCon.BL.getCode().equals(cflowNodeStart)) {
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.cflowNodeStart", (Object)cflowNodeStart);
            return null;
        }
        HashMap<String, Object> ermap = new HashMap<String, Object>();
        ermap.put("dataState", dataState);
        ermap.put("ocContractDomain", ocCflowPprocessDomain.getOcContractDomain());
        ermap.put("contractPaygmoney", ocCflowPprocessDomain.getOcContractDomain().getDataBmoney());
        this.callEnd(ocCflowPprocessDomain, ocCflowPprocessDomain.getOcCflowNodeReDomain(), dataState, ermap);
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time3", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
        OcCflowNodeReDomain ocCflowNodeReDomain = ocCflowPprocessDomain.getOcCflowNodeReDomain();
        if (null == ocCflowNodeReDomain) {
            ocCflowNodeReDomain = this.getOcCflowNode(ocCflowPprocessDomain.getCflowCode(), ocCflowPprocessDomain.getCflowNodeCode(), ocCflowPprocessDomain.getTenantCode());
            if (null == ocCflowNodeReDomain) {
                throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.ocCflowNodeReDomain", "null");
            }
            ocCflowPprocessDomain.setOcCflowNodeReDomain(ocCflowNodeReDomain);
        }
        if (StringUtils.isNotBlank((String)ocCflowNodeReDomain.getCflowNodeCallparam()) && MapUtil.isNotEmpty((Map)(callmap = JsonUtil.buildNormalBinder().getJsonToMap(ocCflowPprocessDomain.getOcCflowNodeReDomain().getCflowNodeCallparam(), String.class, Object.class))) && callmap.containsKey("callDataState")) {
            ocCflowPprocessDomain.setCallDataState((String)callmap.get("callDataState"));
        }
        if (!ocCflowPprocessDomain.isEndFlag()) {
            if (ocCflowNodeReDomain.getCflowCode().equals(ocCflowNodeReDomain.getCflowNodeNextcode())) {
                this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.ocCflowNodeListStr", (Object)(ocCflowNodeReDomain.getCflowNodeNextcode() + "====" + ocCflowNodeReDomain.getCflowCode() + "=====" + ocCflowNodeReDomain.getCflowNodeCode() + "===" + ocCflowPprocessDomain.getContractBillcode()));
                return null;
            }
            List<OcCflowNodeReDomain> ocCflowNodeList = this.getOcCflowNodeReDomainList(ocCflowPprocessDomain.getCflowCode(), ocCflowNodeReDomain.getCflowNodeNextcode(), ocCflowPprocessDomain.getTenantCode());
            this.logger.info("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.ocCflowNodeList", (Object)JsonUtil.buildNormalBinder().toJson(ocCflowNodeList));
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time4", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time6", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
            String mapStr = ocCflowPprocessDomain.getCflowPprocessCon();
            Map rmap = null;
            if (StringUtils.isNotBlank((String)mapStr)) {
                rmap = JsonUtil.buildNormalBinder().getJsonToMap(mapStr, String.class, Object.class);
            }
            if (ListUtil.isEmpty(ocCflowNodeList)) {
                this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.ocCflowNodeList", (Object)(ocCflowNodeReDomain.getCflowNodeCode() + ":" + ocCflowPprocessDomain.getCflowCode() + ":" + ocCflowNodeReDomain.getCflowNodeNextcode() + "===" + ocCflowPprocessDomain.getContractBillcode()));
                return null;
            }
            ProcessBean processBean = new ProcessBean();
            List<OcCflowPprocessDomain> relist = this.makeNodeToPprocess(ocCflowPprocessDomain.getOcContractDomain(), cflowNodeStart, ocCflowNodeList, rmap);
            processBean.setOcCflowPprocessDomainList(relist);
            ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
            processBean.setOcContractDomainList(ocContractDomainList);
            ocContractDomainList.add(ocCflowPprocessDomain.getOcContractDomain());
            this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImplsaveFlowNode.time7", (Object)("contractBillcode:" + ocCflowPprocessDomain.getOcContractDomain().getContractBillcode() + "(" + (System.currentTimeMillis() - s) + ")"));
            return processBean;
        }
        this.logger.debug("oc.CONTRACT.OcContractFlowEngineServiceImpl.saveFlowNode.end", (Object)ocCflowPprocessDomain.getCflowNodeCode());
        return null;
    }

    private String callService(OcCflowPserviceReDomain ocCflowPserviceReDomain, Map<String, Object> map) {
        String paramStr;
        if (null == ocCflowPserviceReDomain) {
            return null;
        }
        if ("mock".equals(ocCflowPserviceReDomain.getDataCallurl())) {
            return FlowStartCon.CS.getCode();
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)map.get(this.conmap_key_contract);
        if (null != ocContractReDomain) {
            ocContractReDomain.setGoodsList((List)map.get(this.conmap_key_goods));
        }
        ocContractReDomain.setContractState(ocContractReDomain.getDataState());
        map.put(this.conmap_key_contract, ocContractReDomain);
        if (!"ocContractDomain".equals(ocCflowPserviceReDomain.getDataParam())) {
            paramStr = SoaUtil.makeParam((String)ocCflowPserviceReDomain.getDataParam(), (String)ocCflowPserviceReDomain.getDataCom(), map);
        } else {
            HashMap<String, OcContractReDomain> callmap = new HashMap<String, OcContractReDomain>();
            callmap.put("ocContractDomain", ocContractReDomain);
            paramStr = JsonUtil.buildNormalBinder().toJson(callmap);
        }
        Object obj = null;
        try {
            obj = UddiUtil.invokeUrl((String)ocCflowPserviceReDomain.getDataCalltype(), (String)ocCflowPserviceReDomain.getDataCallurl(), (String)paramStr, null);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.callService.error.e", (Object)("dataCalltype:" + ocCflowPserviceReDomain.getDataCalltype() + ";dataCallurl:" + ocCflowPserviceReDomain.getDataCallurl()), (Throwable)e);
            return FlowStartCon.EE.getCode();
        }
        OutMessage outMessage = null;
        String res = null;
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (outMessage.isError()) {
                this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.callService.error.obj", (Object)(outMessage.getReObj() + "======" + outMessage.isError() + "======" + ocCflowPserviceReDomain.getDataCallurl()));
                throw new ApiException("oc.CONTRACT.OcContractFlowEngineServiceImpl.callService.error", ocCflowPserviceReDomain.getDataCallurl());
            }
            res = null == outMessage.getReObj() ? null : outMessage.getReObj().toString();
        } else if (null != obj) {
            res = (String)obj;
        }
        String dataFlagStr = ocCflowPserviceReDomain.getDataFlag();
        String dataFlag = null;
        String eeFlag = "";
        if (StringUtils.isNotBlank((String)dataFlagStr)) {
            if (dataFlagStr.trim().indexOf("{") >= 0) {
                Map dataMap = JsonUtil.buildNormalBinder().getJsonToMap(dataFlagStr, String.class, Object.class);
                dataFlag = (String)dataMap.get("success");
                eeFlag = (String)dataMap.get("exception");
            } else {
                dataFlag = dataFlagStr;
            }
        }
        if (StringUtils.isBlank((String)res)) {
            res = "";
        }
        if (StringUtils.isBlank((String)res) && StringUtils.isBlank((String)dataFlag)) {
            return FlowStartCon.CS.getCode();
        }
        if ((StringUtils.isBlank((String)res) || StringUtils.isBlank((String)dataFlag)) && StringUtils.isBlank((String)eeFlag)) {
            this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.callService.res", (Object)paramStr);
            return FlowStartCon.CE.getCode();
        }
        if (StringUtils.isBlank((String)dataFlag)) {
            dataFlag = "";
        }
        if (res.equals(dataFlag)) {
            return FlowStartCon.CS.getCode();
        }
        if (res.equals(eeFlag) && StringUtils.isNotBlank((String)eeFlag)) {
            return FlowStartCon.EE.getCode();
        }
        if (res.indexOf("{") >= 0) {
            OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(res, OcReorderDomain.class);
            if (ocReorderDomain.isError()) {
                this.logger.error("oc.CONTRACT.OcContractFlowEngineServiceImpl.callService.error", (Object)(res + "=" + paramStr));
                return FlowStartCon.CE.getCode();
            }
            if (ocReorderDomain.isSuccess()) {
                return FlowStartCon.CS.getCode();
            }
            if (ocReorderDomain.isCe()) {
                return FlowStartCon.EE.getCode();
            }
        }
        return FlowStartCon.CE.getCode();
    }

    private List<OcContract> queryContractByBbillCode(String contractBbillcode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        QueryResult<OcContract> qlist = this.ocContractService.queryContractPage(map);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @Override
    public ProcessBean saveOffPayOk(OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            return null;
        }
        this.ocContractService.saveContractSettl(ocContractSettlDomain);
        return this.saveContract(FlowStartCon.AN.getCode(), ocContractSettlDomain.getContractBillcode(), ocContractSettlDomain.getTenantCode(), null);
    }

    @Override
    public ProcessBean saveOffPayOkBatch(List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return null;
        }
        ArrayList<OcCflowPprocessDomain> relist = new ArrayList<OcCflowPprocessDomain>();
        ProcessBean processBean = new ProcessBean();
        ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            this.ocContractService.saveContractSettl(ocContractSettlDomain);
            ProcessBean oneProcessBean = this.saveContract(FlowStartCon.AN.getCode(), ocContractSettlDomain.getContractBillcode(), ocContractSettlDomain.getTenantCode(), null);
            if (null != oneProcessBean && ListUtil.isNotEmpty(oneProcessBean.getOcCflowPprocessDomainList())) {
                relist.addAll(oneProcessBean.getOcCflowPprocessDomainList());
            }
            if (null == oneProcessBean || !ListUtil.isNotEmpty(oneProcessBean.getOcContractDomainList())) continue;
            ocContractDomainList.addAll(oneProcessBean.getOcContractDomainList());
        }
        processBean.setOcCflowPprocessDomainList(relist);
        processBean.setOcContractDomainList(ocContractDomainList);
        return processBean;
    }

    @Override
    public ProcessBean updateTopNum(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return null;
        }
        Map<String, String> mainMap = this.ocContractService.updateTopNum(goodsSendNumBeanList);
        String tenantCode = goodsSendNumBeanList.get(0).getTenantCode();
        if (MapUtil.isEmpty(mainMap)) {
            return null;
        }
        ArrayList<OcCflowPprocessDomain> relist = new ArrayList<OcCflowPprocessDomain>();
        ProcessBean processBean = new ProcessBean();
        ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
        for (String contractBillcode : mainMap.keySet()) {
            ProcessBean oneProcessBean = this.saveContractNext(mainMap.get(contractBillcode), tenantCode, null);
            if (null != oneProcessBean && ListUtil.isNotEmpty(oneProcessBean.getOcCflowPprocessDomainList())) {
                relist.addAll(oneProcessBean.getOcCflowPprocessDomainList());
            }
            if (null == oneProcessBean || !ListUtil.isNotEmpty(oneProcessBean.getOcContractDomainList())) continue;
            ocContractDomainList.addAll(oneProcessBean.getOcContractDomainList());
        }
        processBean.setOcCflowPprocessDomainList(relist);
        processBean.setOcContractDomainList(ocContractDomainList);
        return processBean;
    }

    @Override
    public ProcessBean updateTopNumNoRefund(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return null;
        }
        Map<String, String> mainMap = this.ocContractService.updateTopNumByRefund(goodsSendNumBeanList);
        String tenantCode = goodsSendNumBeanList.get(0).getTenantCode();
        if (MapUtil.isEmpty(mainMap)) {
            return null;
        }
        HashMap<String, Object> refmap = new HashMap<String, Object>();
        refmap.put("settl", "topRefund");
        ArrayList<OcCflowPprocessDomain> relist = new ArrayList<OcCflowPprocessDomain>();
        ProcessBean processBean = new ProcessBean();
        ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
        for (String contractBillcode : mainMap.keySet()) {
            ProcessBean oneProcessBean = this.saveContractNext(mainMap.get(contractBillcode), tenantCode, refmap);
            if (null != oneProcessBean && ListUtil.isNotEmpty(oneProcessBean.getOcCflowPprocessDomainList())) {
                relist.addAll(oneProcessBean.getOcCflowPprocessDomainList());
            }
            if (null == oneProcessBean || !ListUtil.isNotEmpty(oneProcessBean.getOcContractDomainList())) continue;
            ocContractDomainList.addAll(oneProcessBean.getOcContractDomainList());
        }
        processBean.setOcCflowPprocessDomainList(relist);
        processBean.setOcContractDomainList(ocContractDomainList);
        return processBean;
    }

    @Override
    public ProcessBean sendFina(List<OcContractGoodsDomain> ocContractGoodsDomainList) {
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            return null;
        }
        HashMap mainMap = new HashMap();
        ArrayList<OcCflowPprocessDomain> relist = new ArrayList<OcCflowPprocessDomain>();
        ProcessBean processBean = new ProcessBean();
        ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            if (StringUtils.isNotBlank((String)((String)mainMap.get(ocContractGoodsDomain.getContractBillcode())))) continue;
            ProcessBean oneProcessBean = this.saveContractNext(ocContractGoodsDomain.getContractBillcode(), ocContractGoodsDomain.getTenantCode(), null);
            if (null != oneProcessBean && ListUtil.isNotEmpty(oneProcessBean.getOcCflowPprocessDomainList())) {
                relist.addAll(oneProcessBean.getOcCflowPprocessDomainList());
            }
            if (null == oneProcessBean || !ListUtil.isNotEmpty(oneProcessBean.getOcContractDomainList())) continue;
            ocContractDomainList.addAll(oneProcessBean.getOcContractDomainList());
        }
        processBean.setOcCflowPprocessDomainList(relist);
        processBean.setOcContractDomainList(ocContractDomainList);
        return processBean;
    }
}

