/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.contract.dao.OcShoppingGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcShoppingMapper;
import com.yqbsoft.laser.service.contract.domain.GoodsNumDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingReDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingpackgeDomain;
import com.yqbsoft.laser.service.contract.domain.TypeBean;
import com.yqbsoft.laser.service.contract.engine.ContractPollThread;
import com.yqbsoft.laser.service.contract.engine.ContractService;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcShopping;
import com.yqbsoft.laser.service.contract.model.OcShoppingGoods;
import com.yqbsoft.laser.service.contract.model.OcShoppingpackge;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcShoppingService;
import com.yqbsoft.laser.service.contract.service.OcShoppingpackgeService;
import com.yqbsoft.laser.service.contract.service.impl.OcCacheBaseImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class OcShoppingServiceImpl
extends OcCacheBaseImpl
implements OcShoppingService {
    public static final String SYS_CODE = "oc.CONTRACT.OcShoppingServiceImpl";
    private static ContractService contractService;
    private static Object lock;
    private OcShoppingMapper ocShoppingMapper;
    private OcShoppingGoodsMapper ocShoppingGoodsMapper;
    private OcContractService ocContractService;
    private OcShoppingpackgeService ocShoppingpackgeService;
    private static final String SHOPPACKAGECACHEKEY = "shoppackage_group_mem_key";
    private static final String SHOPPACKAGECACHEKEYKEY = "shoppackage_group_mem_key_key";
    private static final String SHOPPINGCACHEKEY = "oc_shoppingmem_gruop_key";
    private static final String SHOPPINGCACHEKEYKEY = "oc_shoppingmem_gruop_key_key";
    private static final String shopLockKeyPre = "shopLockKeyPre";
    String CACHE_KEY_CFLOW = "ocProtCflow";

    public void setOcShoppingpackgeService(OcShoppingpackgeService ocShoppingpackgeService) {
        this.ocShoppingpackgeService = ocShoppingpackgeService;
    }

    public void setOcShoppingMapper(OcShoppingMapper ocShoppingMapper) {
        this.ocShoppingMapper = ocShoppingMapper;
    }

    public void setOcShoppingGoodsMapper(OcShoppingGoodsMapper ocShoppingGoodsMapper) {
        this.ocShoppingGoodsMapper = ocShoppingGoodsMapper;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    private Date getSysDate() {
        try {
            return this.ocShoppingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkShopping(OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setShoppingDefault(OcShopping ocShopping) {
        if (null == ocShopping) {
            return;
        }
        if (null == ocShopping.getDataState()) {
            ocShopping.setDataState(0);
        }
        if (null == ocShopping.getGmtCreate()) {
            ocShopping.setGmtCreate(this.getSysDate());
        }
        ocShopping.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocShopping.getShoppingCode())) {
            HashMap<String, String> opmap = new HashMap<String, String>();
            opmap.put("userinfoCode", ocShopping.getMemberBcode());
            ocShopping.setShoppingCode(this.getNoNew(null, OcShopping.class.getSimpleName(), "shoppingCode", ocShopping.getTenantCode(), opmap));
        }
    }

    public String getNoNew(String notype, String tableName, String columnName, String tenantCode, Map<String, String> opmap) {
        String key;
        String no;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", notype);
        map.put("tableName", tableName);
        map.put("columnName", columnName);
        map.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(opmap));
        if (StringUtils.isBlank((String)notype)) {
            notype = "0";
        }
        if (StringUtils.isNotBlank((String)(no = DisUtil.spop((String)(key = tenantCode + notype + tableName + columnName))))) {
            return no;
        }
        Object object = this.getInternalRouter().inInvoke("nm.no.createMaxBillNumberNew", "1.0", "0", map);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    private void setShoppingpackgeDefault(OcShoppingpackge ocShoppingpackge) {
        if (null == ocShoppingpackge) {
            return;
        }
        if (null == ocShoppingpackge.getDataState()) {
            ocShoppingpackge.setDataState(0);
        }
        if (null == ocShoppingpackge.getGmtCreate()) {
            ocShoppingpackge.setGmtCreate(this.getSysDate());
        }
        ocShoppingpackge.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocShoppingpackge.getShoppingpackgeCode())) {
            ocShoppingpackge.setShoppingpackgeCode(this.createUUIDString());
        }
    }

    private int getShoppingMaxCode() {
        int code = 0;
        try {
            return this.ocShoppingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setShoppingUpdataDefault(OcShopping ocShopping) {
        if (null == ocShopping) {
            return;
        }
        ocShopping.setGmtModified(this.getSysDate());
    }

    private void saveShoppingModel(OcShopping ocShopping) throws ApiException {
        if (null == ocShopping) {
            return;
        }
        try {
            this.ocShoppingMapper.insert(ocShopping);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingModel.ex", (Throwable)e);
        }
    }

    private void saveShoppingBatchModel(List<OcShopping> ocShoppingList) throws ApiException {
        if (ListUtil.isEmpty(ocShoppingList)) {
            return;
        }
        try {
            this.ocShoppingMapper.insertBatch(ocShoppingList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingBatchModel.ex", (Throwable)e);
        }
    }

    private OcShopping getShoppingModelById(Integer shoppingId) {
        if (null == shoppingId) {
            return null;
        }
        try {
            return this.ocShoppingMapper.selectByPrimaryKey(shoppingId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingModelById", (Throwable)e);
            return null;
        }
    }

    public OcShopping getShoppingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocShoppingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingModelByCode", (Throwable)e);
            return null;
        }
    }

    private void updateCmountShopping(String shoppingCode, String tenantCode, BigDecimal addcamount, BigDecimal addcweight, BigDecimal addrefrice, BigDecimal addmoney) throws ApiException {
        if (StringUtils.isBlank((String)shoppingCode) || StringUtils.isBlank((String)tenantCode) || null == addcamount) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingCode", shoppingCode);
        map.put("tenantCode", tenantCode);
        map.put("shoppingCamount", addcamount);
        map.put("shoppingCweight", addcweight);
        map.put("pricesetRefrice", addrefrice);
        map.put("goodsMoney", addmoney);
        int i = 0;
        try {
            i = this.ocShoppingMapper.updateCamountByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShopping.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShopping.null");
        }
    }

    public void delShoppingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingModelByCode.num");
        }
    }

    private void deleteShoppingModel(Integer shoppingId) throws ApiException {
        if (null == shoppingId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingMapper.deleteByPrimaryKey(shoppingId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingModel.num");
        }
    }

    private void updateShoppingModel(OcShopping ocShopping) throws ApiException {
        if (null == ocShopping) {
            return;
        }
        try {
            this.ocShoppingMapper.updateByPrimaryKeySelective(ocShopping);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingModel.ex", (Throwable)e);
        }
    }

    private void updateStateShoppingModel(Integer shoppingId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == shoppingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingId", shoppingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocShoppingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingModel.null");
        }
    }

    private OcShopping makeShopping(OcShoppingDomain ocShoppingDomain, OcShopping ocShopping) {
        if (null == ocShoppingDomain) {
            return null;
        }
        if (null == ocShopping) {
            ocShopping = new OcShopping();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocShopping, (Object)ocShoppingDomain);
            return ocShopping;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShopping", (Throwable)e);
            return null;
        }
    }

    private List<OcShopping> queryShoppingModelPage(Map<String, Object> parammap) {
        try {
            return this.ocShoppingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.queryShoppingModel", (Throwable)e);
            return null;
        }
    }

    private List<OcShopping> queryShoppingModelPageLock(Map<String, Object> parammap, String lockKey) {
        return this.queryShoppingModelPage(parammap, lockKey, 0);
    }

    private List<OcShopping> queryShoppingModelPage(Map<String, Object> parammap, String lockKey, int c) {
        return this.queryShoppingModelPage(parammap);
    }

    private int countShopping(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocShoppingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.countShopping", (Throwable)e);
        }
        return i;
    }

    private String checkShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberCode())) {
            msg = msg + "\u5356\u5bb6\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberBcode())) {
            msg = msg + "\u4e70\u5bb6\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (ocShoppingGoodsDomain.getPricesetNprice() == null) {
            msg = msg + "\u4ef7\u683c\u4e3a\u7a7a;";
        }
        if (ocShoppingGoodsDomain.getGoodsCamount() == null) {
            msg = msg + "\u6570\u91cf\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getGoodsCode())) {
            msg = msg + "\u539f\u59cb\u5355\u636e\u53f7\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setShoppingGoodsDefault(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return;
        }
        if (null == ocShoppingGoods.getDataState()) {
            ocShoppingGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocShoppingGoods.getGmtCreate()) {
            ocShoppingGoods.setGmtCreate(date);
        }
        ocShoppingGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocShoppingGoods.getShoppingGoodsCode())) {
            HashMap<String, String> opmap = new HashMap<String, String>();
            ocShoppingGoods.setShoppingGoodsCode(this.getNoNew(null, OcShoppingGoods.class.getSimpleName(), "shoppingGoodsCode", ocShoppingGoods.getTenantCode(), opmap));
        }
        if (StringUtils.isBlank((String)ocShoppingGoods.getShoppingCode())) {
            ocShoppingGoods.setShoppingCode(ocShoppingGoods.getShoppingGoodsCode());
        }
    }

    private int getShoppingGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocShoppingGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setShoppingGoodsUpdataDefault(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return;
        }
        ocShoppingGoods.setGmtModified(this.getSysDate());
    }

    public void saveShoppingGoodsModel(OcShoppingGoods ocShoppingGoods) throws ApiException {
        if (null == ocShoppingGoods) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.insert(ocShoppingGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveShoppingGoodsModelBatch(List<OcShoppingGoods> ocShoppingGoodsList) throws ApiException {
        if (ListUtil.isEmpty(ocShoppingGoodsList)) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.insertBatch(ocShoppingGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingGoodsModelBatch.ex", (Throwable)e);
        }
    }

    private OcShoppingGoods getShoppingGoodsModelById(Integer shoppingGoodsId) {
        if (null == shoppingGoodsId) {
            return null;
        }
        try {
            return this.ocShoppingGoodsMapper.selectByPrimaryKey(shoppingGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcShoppingGoods getShoppingGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocShoppingGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delShoppingGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingGoodsModelByCode.num");
        }
    }

    public void delShoppingGoodsModelByShoppingCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.deleteByShoppingCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingGoodsModelByShoppingCode.ex", (Throwable)e);
        }
    }

    private void deleteShoppingGoodsModel(Integer shoppingGoodsId) throws ApiException {
        if (null == shoppingGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.deleteByPrimaryKey(shoppingGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateShoppingGoodsModel(OcShoppingGoods ocShoppingGoods) throws ApiException {
        if (null == ocShoppingGoods) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.updateByPrimaryKeySelective(ocShoppingGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateCmountShoppingGoods(Integer shoppingGoodsId, BigDecimal addcamount, BigDecimal addcweight, String goodsDay) throws ApiException {
        if (null == shoppingGoodsId || null == addcamount) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("goodsCamount", addcamount);
        map.put("goodsCweight", addcweight);
        map.put("goodsDay", goodsDay);
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.updateCamountByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShoppingGoods.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShoppingGoods.null");
        }
    }

    private void updateShoppingGoodsSort(Integer shoppingGoodsId, String goodsSpec3, String goodsSpec2, String goodsProperty2, BigDecimal addcamount, BigDecimal addcweight, String goodsProperty3, String goodsContract) throws ApiException {
        if (null == shoppingGoodsId || StringUtils.isBlank((String)goodsSpec3) && StringUtils.isBlank((String)goodsSpec2) && StringUtils.isBlank((String)goodsProperty2) && StringUtils.isBlank((String)goodsProperty3) && EmptyUtil.isEmpty((Object)addcamount) && EmptyUtil.isEmpty((Object)addcweight)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("goodsSpec3", goodsSpec3);
        map.put("goodsSpec2", goodsSpec2);
        map.put("goodsProperty2", goodsProperty2);
        map.put("goodsProperty3", goodsProperty3);
        map.put("goodsCamount", addcamount);
        map.put("goodsCweight", addcweight);
        map.put("goodsContract", goodsContract);
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.updateSortByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsSort.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsSort.null");
        }
    }

    private void updateCmountShoppingGoodsByCode(String shoppingGoodsCode, BigDecimal addcamount, BigDecimal addcweight, String goodsDay) throws ApiException {
        if (StringUtils.isBlank((String)shoppingGoodsCode) || null == addcamount) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsCode", shoppingGoodsCode);
        map.put("goodsCamount", addcamount);
        map.put("goodsCweight", addcweight);
        map.put("goodsDay", goodsDay);
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.updateCamountByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShoppingGoodsByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShoppingGoodsByCode.null");
        }
    }

    private void updateStateShoppingGoodsModel(Integer shoppingGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == shoppingGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingGoodsModel.null");
        }
    }

    private OcShoppingGoods makeShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain, OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoodsDomain) {
            return null;
        }
        if (null == ocShoppingGoods) {
            ocShoppingGoods = new OcShoppingGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoods, (Object)ocShoppingGoodsDomain);
            return ocShoppingGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShoppingGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcShoppingGoods> queryShoppingGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocShoppingGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.queryShoppingGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countShoppingGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.countShoppingGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveShopping(OcShoppingDomain ocShoppingDomain) throws ApiException {
        String msg = this.checkShopping(ocShoppingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShopping.checkShopping", msg);
        }
        OcShopping ocShopping = this.makeShopping(ocShoppingDomain, null);
        this.setShoppingDefault(ocShopping);
        this.saveShoppingModel(ocShopping);
    }

    @Override
    public void updateShoppingState(Integer shoppingId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateShoppingModel(shoppingId, dataState, oldDataState);
    }

    @Override
    public void updateShopping(OcShoppingDomain ocShoppingDomain) throws ApiException {
        String msg = this.checkShopping(ocShoppingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopping.checkShopping", msg);
        }
        OcShopping oldOcShopping = this.getShoppingModelById(ocShoppingDomain.getShoppingId());
        if (null == oldOcShopping) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopping.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcShopping ocShopping = this.makeShopping(ocShoppingDomain, oldOcShopping);
        this.setShoppingUpdataDefault(ocShopping);
        this.updateShoppingModel(ocShopping);
    }

    @Override
    public OcShopping getShopping(Integer shoppingId) {
        return this.getShoppingModelById(shoppingId);
    }

    @Override
    public void deleteShopping(Integer shoppingId) throws ApiException {
        OcShopping ocShopping = this.getShoppingModelById(shoppingId);
        if (null == ocShopping) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShopping.ocShopping", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteShoppingModel(shoppingId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingCode", ocShopping.getShoppingCode());
        map.put("tenantCode", ocShopping.getTenantCode());
        this.ocShoppingpackgeService.deleteshoppingpackgeByShoppingCode(ocShopping.getTenantCode(), ocShopping.getShoppingCode());
        this.delShoppingGoodsModelByShoppingCode(map);
    }

    @Override
    public QueryResult<OcShoppingReDomain> queryShoppingPage(Map<String, Object> map) {
        List<OcShopping> ocShoppingList = this.queryShoppingModelPage(map);
        ArrayList<OcShoppingReDomain> ocShoppingReDomainList = null;
        if (ocShoppingList != null && !ocShoppingList.isEmpty()) {
            ocShoppingReDomainList = new ArrayList<OcShoppingReDomain>();
            for (OcShopping ocShopping : ocShoppingList) {
                ocShoppingReDomainList.add(this.makeReDomain(ocShopping));
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        if (!EmptyUtil.isEmpty((Object)map.get("startRow")) && !EmptyUtil.isEmpty((Object)map.get("rows"))) {
            pageTools.setRecordCount(this.countShopping(map));
        }
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocShoppingReDomainList);
        return queryResult;
    }

    private OcShoppingReDomain makeReDomain(OcShopping ocShopping) {
        if (null == ocShopping) {
            return null;
        }
        OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShopping);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ocShoppingReDomain.setShoppingpackageList(this.queryPackgeDomain(ocShopping));
        return ocShoppingReDomain;
    }

    private List<OcShoppingpackgeDomain> queryPackgeDomain(OcShopping ocShopping) {
        if (null == ocShopping) {
            return null;
        }
        String shoppingCode = ocShopping.getShoppingCode();
        String tenantCode = ocShopping.getTenantCode();
        HashMap<String, String> parammap = new HashMap<String, String>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("shoppingCode", shoppingCode);
        List<OcShoppingpackge> ocShoppingpackgeList = this.ocShoppingpackgeService.queryshoppingpackgeByShoppingCode(tenantCode, shoppingCode);
        if (ListUtil.isEmpty(ocShoppingpackgeList)) {
            return null;
        }
        ArrayList<OcShoppingpackgeDomain> ocShoppingpackgeDomainList = new ArrayList<OcShoppingpackgeDomain>();
        for (OcShoppingpackge ocShoppingpackge : ocShoppingpackgeList) {
            OcShoppingpackgeDomain ocShoppingpackgeDomain = this.makeShoppingpackgeDomain(ocShoppingpackge);
            ocShoppingpackgeDomainList.add(ocShoppingpackgeDomain);
            ocShoppingpackgeDomain.setShoppingGoodsList(this.queryGoodsDomain(shoppingCode, ocShoppingpackgeDomain, tenantCode));
        }
        return ocShoppingpackgeDomainList;
    }

    private List<OcShoppingGoodsDomain> queryGoodsDomain(String shoppingCode, OcShoppingpackgeDomain ocShoppingpackgeDomain, String tenantCode) {
        if (StringUtils.isBlank((String)shoppingCode) || StringUtils.isBlank((String)tenantCode) || null == ocShoppingpackgeDomain || StringUtils.isBlank((String)ocShoppingpackgeDomain.getShoppingpackgeCode())) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("shoppingCode", shoppingCode);
        parammap.put("shoppingpackgeCode", ocShoppingpackgeDomain.getShoppingpackgeCode());
        parammap.put("order", true);
        List<OcShoppingGoods> goodsList = this.queryShoppingGoodsModelPage(parammap);
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        ArrayList<OcShoppingGoodsDomain> ocShoppingGoodsDomainList = new ArrayList<OcShoppingGoodsDomain>();
        ocShoppingpackgeDomain.setSumMoney(BigDecimal.ZERO);
        ocShoppingpackgeDomain.setSumNum(BigDecimal.ZERO);
        ocShoppingpackgeDomain.setSumWeight(BigDecimal.ZERO);
        ocShoppingpackgeDomain.setSumRefMoney(BigDecimal.ZERO);
        for (OcShoppingGoods ocShoppingGoods : goodsList) {
            OcShoppingGoodsDomain ocShoppingGoodsDomain = this.makeShoppingGoodsDomain(ocShoppingGoods);
            ocShoppingGoodsDomainList.add(ocShoppingGoodsDomain);
            if (null != ocShoppingGoodsDomain.getShoppingGoodsCheck() && 0 != ocShoppingGoodsDomain.getShoppingGoodsCheck()) continue;
            ocShoppingpackgeDomain.setSumMoney(ocShoppingpackgeDomain.getSumMoney().add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            ocShoppingpackgeDomain.setSumNum(ocShoppingpackgeDomain.getSumNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            ocShoppingpackgeDomain.setSumWeight(ocShoppingpackgeDomain.getSumWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            ocShoppingpackgeDomain.setSumRefMoney(ocShoppingpackgeDomain.getSumRefMoney().add(ocShoppingGoodsDomain.getPricesetRefrice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
        }
        return ocShoppingGoodsDomainList;
    }

    @Override
    public OcShopping getShoppingByCode(Map<String, Object> map) {
        return this.getShoppingModelByCode(map);
    }

    @Override
    public void delShoppingByCode(Map<String, Object> map) throws ApiException {
        this.delShoppingModelByCode(map);
        this.ocShoppingpackgeService.deleteshoppingpackgeByShoppingCode((String)map.get("tenantCode"), (String)map.get("shoppingCode"));
        this.delShoppingGoodsModelByShoppingCode(map);
    }

    @Override
    public String saveShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) throws ApiException {
        return this.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    private OcShoppingGoods createShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        String msg = this.checkShoppingGoods(ocShoppingGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingGoods.checkShoppingGoods", msg);
        }
        OcShoppingGoods ocShoppingGoods = this.makeShoppingGoods(ocShoppingGoodsDomain, null);
        this.setShoppingGoodsDefault(ocShoppingGoods);
        return ocShoppingGoods;
    }

    @Override
    public String insertShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) throws ApiException {
        if (ocShoppingGoodsDomain == null) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.insertShoppingGoods.ocShoppingGoodsDomain.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ocShoppingGoodsDomain.getMemberBcode().equals(ocShoppingGoodsDomain.getMemberCode())) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.insertShoppingGoods.check.buyMember", "\u4e0d\u80fd\u8d2d\u4e70\u81ea\u5bb6\u5546\u54c1");
        }
        ArrayList<OcShoppingGoodsDomain> ocShoppingGoodsDomainList = new ArrayList<OcShoppingGoodsDomain>();
        ocShoppingGoodsDomainList.add(ocShoppingGoodsDomain);
        return this.insertBatchShoppingGoods(ocShoppingGoodsDomainList);
    }

    @Override
    public String insertBatchShoppingGoods(List<OcShoppingGoodsDomain> ocShoppingGoodsDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocShoppingGoodsDomainList)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.insertBatchShoppingGoods.ocShoppingGoodsDomainList", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<OcShoppingGoods> ocShoppingGoodsList = new ArrayList<OcShoppingGoods>();
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList) {
            this.createShoppingGoods(ocShoppingGoodsDomain, ocShoppingGoodsList);
        }
        if (ListUtil.isNotEmpty(ocShoppingGoodsList)) {
            this.saveShoppingGoodsModelBatch(ocShoppingGoodsList);
            for (OcShoppingGoods ocShoppingGoods : ocShoppingGoodsList) {
                String cacheKey = this.SHOPPINGGOODSCACHEKEY + ocShoppingGoods.getSkuCode() + "-" + ocShoppingGoods.getMemberBcode() + "-" + ocShoppingGoods.getTenantCode() + "-" + ocShoppingGoods.getContractGoodsGtype();
                cacheKey = cacheKey + "-" + ocShoppingGoods.getGoodsSpec4() + "-" + ocShoppingGoods.getChannelCode() + "-" + ocShoppingGoods.getUserCode();
                String jsons = this.getDdFlag(ocShoppingGoods.getTenantCode(), ocShoppingGoods.getChannelCode(), "HGUserCode");
                if (StringUtils.isNotBlank((String)jsons)) {
                    cacheKey = cacheKey + "-" + ocShoppingGoods.getUserCode();
                }
                SupDisUtil.set((String)cacheKey, (String)ocShoppingGoods.getShoppingGoodsCode());
            }
        }
        return ocShoppingGoodsDomainList.get(0).getShoppingGoodsCode();
    }

    public String insertBatchShoppingGoods(List<OcShoppingGoodsDomain> ocShoppingGoodsDomainList, int n) throws ApiException {
        ArrayList<OcShoppingGoods> ocShoppingGoodsList = new ArrayList<OcShoppingGoods>();
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList) {
            this.createShoppingGoods(ocShoppingGoodsDomain, ocShoppingGoodsList);
        }
        if (ListUtil.isNotEmpty(ocShoppingGoodsList)) {
            this.saveShoppingGoodsModelBatch(ocShoppingGoodsList);
            for (OcShoppingGoods ocShoppingGoods : ocShoppingGoodsList) {
                String cacheKey = ocShoppingGoods.getSkuCode() + "-" + ocShoppingGoods.getMemberBcode() + "-" + ocShoppingGoods.getTenantCode();
                SupDisUtil.set((String)cacheKey, (String)ocShoppingGoods.getShoppingGoodsCode());
            }
        }
        return ((OcShoppingGoods)ocShoppingGoodsList.get(0)).getShoppingGoodsCode();
    }

    private void createShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain, List<OcShoppingGoods> ocShoppingGoodsList) {
        String shoppingGoodsCode;
        if (ocShoppingGoodsDomain == null || null == ocShoppingGoodsList) {
            return;
        }
        OcShoppingGoods ocShoppingGoods = null;
        String cacheKey = this.SHOPPINGGOODSCACHEKEY + ocShoppingGoodsDomain.getSkuCode() + "-" + ocShoppingGoodsDomain.getMemberBcode() + "-" + ocShoppingGoodsDomain.getTenantCode() + "-" + ocShoppingGoodsDomain.getContractGoodsGtype();
        String json = null;
        cacheKey = cacheKey + "-" + ocShoppingGoodsDomain.getGoodsSpec4() + "-" + ocShoppingGoodsDomain.getChannelCode() + "-" + ocShoppingGoodsDomain.getUserCode();
        json = this.getDdFlag(ocShoppingGoodsDomain.getTenantCode(), ocShoppingGoodsDomain.getChannelCode(), "HGUserCode");
        if (StringUtils.isNotBlank((String)json)) {
            cacheKey = cacheKey + "-" + ocShoppingGoodsDomain.getUserCode();
        }
        if (StringUtils.isBlank((String)(shoppingGoodsCode = SupDisUtil.getRemot((String)cacheKey)))) {
            ocShoppingGoods = this.createShoppingGoods(ocShoppingGoodsDomain);
            ocShoppingGoodsList.add(ocShoppingGoods);
        } else {
            ocShoppingGoodsDomain.setShoppingGoodsCode(shoppingGoodsCode);
            try {
                this.updateCmountShoppingGoodsByCode(shoppingGoodsCode, ocShoppingGoodsDomain.getGoodsCamount(), ocShoppingGoodsDomain.getGoodsCweight(), null);
            }
            catch (ApiException e) {
                SupDisUtil.del((String)cacheKey);
                throw e;
            }
        }
    }

    private OcShoppingGoods getShoppingGoodsByGlide(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        OcShoppingGoods ocShoppingGoods = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        map.put("shoppingCode", ocShoppingGoodsDomain.getShoppingCode());
        map.put("skuCode", ocShoppingGoodsDomain.getSkuCode());
        List<OcShoppingGoods> list = this.queryShoppingGoodsModelPage(map);
        if (list != null && !list.isEmpty()) {
            ocShoppingGoods = list.get(0);
        }
        return ocShoppingGoods;
    }

    private OcShopping createShoppingByGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null) {
            return null;
        }
        OcShopping ocShopping = new OcShopping();
        try {
            BeanUtils.copyAllPropertys((Object)ocShopping, (Object)ocShoppingGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)ocShopping.getShoppingType())) {
            String shoppingType = StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingType()) ? ocShoppingGoodsDomain.getGoodsType() : ocShoppingGoodsDomain.getShoppingType();
            ocShopping.setShoppingType(shoppingType);
        }
        ocShopping.setShoppingCamount(ocShoppingGoodsDomain.getGoodsCamount());
        ocShopping.setShoppingCweight(ocShoppingGoodsDomain.getGoodsCweight());
        ocShopping.setShoppingDate(this.getSysDate());
        if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
            ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
        }
        ocShopping.setGoodsMoney(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
        if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
            ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
        }
        ocShopping.setPricesetRefrice(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
        this.setShoppingDefault(ocShopping);
        return ocShopping;
    }

    private OcShoppingpackge createShoppingpackgeByGoods(OcShopping ocShopping, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null || null == ocShopping) {
            return null;
        }
        OcShoppingpackge ocShoppingpackge = new OcShoppingpackge();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingpackge, (Object)ocShopping);
            BeanUtils.copyAllPropertys((Object)ocShoppingpackge, (Object)ocShoppingGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ocShoppingpackge.setGoodsNum(ocShoppingGoodsDomain.getGoodsCamount());
        ocShoppingpackge.setGoodsWeight(ocShoppingGoodsDomain.getGoodsCweight());
        if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
            ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
        }
        ocShoppingpackge.setGoodsMoney(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
        if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
            ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
        }
        ocShoppingpackge.setPricesetRefrice(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
        this.setShoppingpackgeDefault(ocShoppingpackge);
        return ocShoppingpackge;
    }

    private OcShopping getShoppingpackgeGroupby(String str, OcShopping ocShopping, OcShoppingGoodsDomain ocShoppingGoodsDomain, Map<String, OcShoppingpackge> shoppingpackgeMap, List<OcShoppingpackge> ocShoppingpackgeList) {
        if (null == ocShoppingGoodsDomain || null == shoppingpackgeMap || null == ocShoppingpackgeList || null == ocShopping) {
            return null;
        }
        String mapKey = "";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocShoppingGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
                if (StringUtils.isNotBlank((String)mapKey)) {
                    mapKey = mapKey + "-";
                }
                mapKey = mapKey + obj;
            }
        } else {
            parammap.put("memberCode", ocShoppingGoodsDomain.getMemberCode());
            if (StringUtils.isNotBlank((String)mapKey)) {
                mapKey = mapKey + "-";
            }
            mapKey = mapKey + ocShoppingGoodsDomain.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShopping.getShoppingCode();
        parammap.put("shoppingCode", ocShopping.getShoppingCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getMemberBcode();
        parammap.put("memberBcode", ocShoppingGoodsDomain.getMemberBcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getChannelCode();
        parammap.put("channelCode", ocShoppingGoodsDomain.getChannelCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getTenantCode();
        parammap.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        OcShoppingpackge ocShoppingpackge = null;
        ocShoppingpackge = shoppingpackgeMap.get(mapKey);
        if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
            ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
            ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        }
        if (null == ocShoppingpackge) {
            QueryResult<OcShoppingpackge> qlist;
            if (null == ocShoppingpackge && ListUtil.isNotEmpty((Collection)(qlist = this.ocShoppingpackgeService.queryshoppingpackgePage(parammap)).getList())) {
                ocShoppingpackge = (OcShoppingpackge)qlist.getList().get(0);
            }
            if (null != ocShoppingpackge) {
                shoppingpackgeMap.put(mapKey, ocShoppingpackge);
                ocShoppingpackge.setGoodsNum(ocShoppingGoodsDomain.getGoodsCamount());
                ocShoppingpackge.setGoodsWeight(ocShoppingGoodsDomain.getGoodsCweight());
                if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                    ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
                }
                ocShoppingpackge.setGoodsMoney(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
                if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                    ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
                }
                ocShoppingpackge.setPricesetRefrice(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
                this.ocShoppingpackgeService.updateCmount(ocShoppingpackge.getShoppingpackgeCode(), ocShoppingpackge.getTenantCode(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                ocShoppingpackge = this.createShoppingpackgeByGoods(ocShopping, ocShoppingGoodsDomain);
                ocShoppingpackgeList.add(ocShoppingpackge);
                shoppingpackgeMap.put(mapKey, ocShoppingpackge);
            }
        } else {
            if (null == ocShoppingpackge.getGoodsNum()) {
                ocShoppingpackge.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocShoppingpackge.getGoodsWeight()) {
                ocShoppingpackge.setGoodsWeight(BigDecimal.ZERO);
            }
            ocShoppingpackge.setGoodsNum(ocShoppingpackge.getGoodsNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            ocShoppingpackge.setGoodsWeight(ocShoppingpackge.getGoodsWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
            }
            ocShoppingpackge.setGoodsMoney(ocShoppingpackge.getGoodsMoney().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice())));
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            ocShoppingpackge.setPricesetRefrice(ocShoppingpackge.getPricesetRefrice().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice())));
        }
        ocShoppingpackge.setMapKey(mapKey);
        ocShoppingGoodsDomain.setShoppingpackgeCode(ocShoppingpackge.getShoppingpackgeCode());
        return ocShopping;
    }

    private OcShopping getShoppingGroupby(String str, OcShoppingGoodsDomain ocShoppingGoodsDomain, Map<String, OcShopping> shoppingMap, List<OcShopping> ocShoppingList) {
        if (null == ocShoppingGoodsDomain || null == shoppingMap || null == ocShoppingList) {
            return null;
        }
        String mapKey = "";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocShoppingGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
                if (StringUtils.isNotBlank((String)mapKey)) {
                    mapKey = mapKey + "-";
                }
                mapKey = mapKey + obj;
            }
        } else {
            parammap.put("memberCode", ocShoppingGoodsDomain.getMemberCode());
            if (StringUtils.isNotBlank((String)mapKey)) {
                mapKey = mapKey + "-";
            }
            mapKey = mapKey + ocShoppingGoodsDomain.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getMemberBcode();
        parammap.put("memberBcode", ocShoppingGoodsDomain.getMemberBcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getChannelCode();
        parammap.put("channelCode", ocShoppingGoodsDomain.getChannelCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getTenantCode();
        parammap.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        String shoppingType = StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingType()) ? ocShoppingGoodsDomain.getGoodsType() : ocShoppingGoodsDomain.getShoppingType();
        parammap.put("shoppingType", shoppingType);
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + parammap.get("shoppingType");
        OcShopping ocShopping = null;
        ocShopping = shoppingMap.get(mapKey);
        if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
            ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
            ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        }
        if (null == ocShopping) {
            List<OcShopping> list;
            if (null == ocShopping && ListUtil.isNotEmpty(list = this.queryShoppingModelPageLock(parammap, "shopLockKeyPre-" + mapKey))) {
                ocShopping = list.get(0);
            }
            if (null != ocShopping) {
                shoppingMap.put(mapKey, ocShopping);
                ocShopping.setShoppingCamount(ocShoppingGoodsDomain.getGoodsCamount());
                ocShopping.setShoppingCweight(ocShoppingGoodsDomain.getGoodsCweight());
                ocShopping.setShoppingDate(this.getSysDate());
                if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                    ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
                }
                ocShopping.setGoodsMoney(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
                if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                    ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
                }
                ocShopping.setPricesetRefrice(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
                this.updateCmountShopping(ocShopping.getShoppingCode(), ocShopping.getTenantCode(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                ocShopping = this.createShoppingByGoods(ocShoppingGoodsDomain);
                ocShopping.setShoppingType(shoppingType);
                ocShoppingList.add(ocShopping);
                shoppingMap.put(mapKey, ocShopping);
            }
        } else {
            if (null == ocShopping.getShoppingCamount()) {
                ocShopping.setShoppingCamount(BigDecimal.ZERO);
            }
            if (null == ocShopping.getShoppingCweight()) {
                ocShopping.setShoppingCweight(BigDecimal.ZERO);
            }
            ocShopping.setShoppingCamount(ocShopping.getShoppingCamount().add(ocShoppingGoodsDomain.getGoodsCamount()));
            ocShopping.setShoppingCweight(ocShopping.getShoppingCweight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
            }
            ocShopping.setGoodsMoney(ocShopping.getGoodsMoney().add(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice())));
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            ocShopping.setPricesetRefrice(ocShopping.getPricesetRefrice().add(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice())));
        }
        ocShoppingGoodsDomain.setShoppingCode(ocShopping.getShoppingCode());
        ocShopping.setMapkey(mapKey);
        return ocShopping;
    }

    @Override
    public void updateShoppingGoodsState(Integer shoppingGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateShoppingGoodsModel(shoppingGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) throws ApiException {
        String msg = this.checkShoppingGoods(ocShoppingGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.checkShoppingGoods", msg);
        }
        OcShoppingGoods oldOcShoppingGoods = this.getShoppingGoodsModelById(ocShoppingGoodsDomain.getShoppingGoodsId());
        if (null == oldOcShoppingGoods) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcShoppingGoods ocShoppingGoods = this.makeShoppingGoods(ocShoppingGoodsDomain, oldOcShoppingGoods);
        this.setShoppingGoodsUpdataDefault(ocShoppingGoods);
        this.updateShoppingGoodsModel(ocShoppingGoods);
    }

    @Override
    public OcShoppingGoods getShoppingGoods(Integer shoppingGoodsId) {
        return this.getShoppingGoodsModelById(shoppingGoodsId);
    }

    @Override
    public void deleteShoppingGoods(Integer shoppingGoodsId) throws ApiException {
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsModelById(shoppingGoodsId);
        if (null == ocShoppingGoods) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingGoods.ocShoppingGoods", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleGoodsByModel(ocShoppingGoods);
    }

    public void deleteShoppingGoods(Integer shoppingGoodsId, List<String> cacheList) throws ApiException {
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsModelById(shoppingGoodsId);
        if (null == ocShoppingGoods) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingGoods.ocShoppingGoods", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleGoodsByModelAndCache(ocShoppingGoods, cacheList);
    }

    public void deleteShoppingGoodsByCode(String shoppingGoodsCode, String tenantCode, List<String> cacheList) throws ApiException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("shoppingGoodsCode", shoppingGoodsCode);
        param.put("tenantCode", tenantCode);
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsByCode(param);
        if (null == ocShoppingGoods) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingGoods.ocShoppingGoods", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleGoodsByModelAndCacheByCode(ocShoppingGoods, cacheList);
    }

    @Override
    public void deleteShoppingGoodsByMemberBcode(String tenantCode, String memberBcode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberBcode)) {
            throw new ApiException("\u53c2\u6570\u9519\u8bef!");
        }
        String cacheKey = "";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberBcode", memberBcode);
        List<OcShoppingGoods> ocShoppingGoods = this.queryShoppingGoodsModelPage(param);
        if (ListUtil.isNotEmpty(ocShoppingGoods)) {
            this.deleteShoppingGoodsModelByMemberBcode(tenantCode, memberBcode);
            for (OcShoppingGoods ocShoppingGood : ocShoppingGoods) {
                cacheKey = this.SHOPPINGGOODSCACHEKEY + ocShoppingGood.getSkuCode() + "-" + ocShoppingGood.getMemberBcode() + "-" + ocShoppingGood.getTenantCode() + "-" + ocShoppingGood.getContractGoodsGtype();
                cacheKey = cacheKey + "-" + ocShoppingGood.getGoodsSpec4() + "-" + ocShoppingGood.getChannelCode() + "-" + ocShoppingGood.getUserCode();
                String jsons = this.getDdFlag(ocShoppingGood.getTenantCode(), ocShoppingGood.getChannelCode(), "HGUserCode");
                if (StringUtils.isNotBlank((String)jsons)) {
                    cacheKey = cacheKey + "-" + ocShoppingGood.getUserCode();
                }
                SupDisUtil.del((String)cacheKey);
            }
        }
    }

    private void deleteShoppingGoodsModelByMemberBcode(String tenantCode, String memberBcode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberBcode", memberBcode);
        try {
            this.ocShoppingGoodsMapper.delByMemberBcode(param);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingModelByCode.ex", (Throwable)e);
        }
    }

    private void deleGoodsByModel(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingCode", ocShoppingGoods.getShoppingCode());
        map.put("tenantCode", ocShoppingGoods.getTenantCode());
        List<OcShoppingGoods> gooldsList = this.queryShoppingGoodsModelPage(map);
        if (ListUtil.isEmpty(gooldsList)) {
            return;
        }
        if (gooldsList.size() == 1) {
            this.delShoppingByCode(map);
        } else {
            BigDecimal weight;
            BigDecimal amount = ocShoppingGoods.getGoodsCamount();
            if (null == amount) {
                amount = BigDecimal.ZERO;
            }
            if (null == (weight = ocShoppingGoods.getGoodsCweight())) {
                weight = BigDecimal.ZERO;
            }
            BigDecimal addmoney = amount.multiply(ocShoppingGoods.getPricesetNprice());
            BigDecimal addrefrice = amount.multiply(ocShoppingGoods.getPricesetRefrice());
            this.updateCmountShopping(ocShoppingGoods.getShoppingCode(), ocShoppingGoods.getTenantCode(), amount, weight, addrefrice, addmoney);
            this.deleteShoppingGoodsModel(ocShoppingGoods.getShoppingGoodsId());
            map.put("shoppingpackgeCode", ocShoppingGoods.getShoppingpackgeCode());
            gooldsList = this.queryShoppingGoodsModelPage(map);
            if (ListUtil.isEmpty(gooldsList)) {
                this.ocShoppingpackgeService.deleteshoppingpackgeByCode(ocShoppingGoods.getTenantCode(), ocShoppingGoods.getShoppingpackgeCode());
            } else {
                this.ocShoppingpackgeService.updateCmount(ocShoppingGoods.getShoppingpackgeCode(), ocShoppingGoods.getTenantCode(), amount, weight, addrefrice, addmoney);
            }
        }
    }

    private void deleGoodsByModelAndCache(OcShoppingGoods ocShoppingGoods, List<String> cacheKeyList) {
        if (null == ocShoppingGoods) {
            return;
        }
        this.deleteShoppingGoodsModel(ocShoppingGoods.getShoppingGoodsId());
        String cacheKey = this.SHOPPINGGOODSCACHEKEY + ocShoppingGoods.getSkuCode() + "-" + ocShoppingGoods.getMemberBcode() + "-" + ocShoppingGoods.getTenantCode() + "-" + ocShoppingGoods.getContractGoodsGtype();
        cacheKey = cacheKey + "-" + ocShoppingGoods.getGoodsSpec4() + "-" + ocShoppingGoods.getChannelCode() + "-" + ocShoppingGoods.getUserCode();
        String jsons = this.getDdFlag(ocShoppingGoods.getTenantCode(), ocShoppingGoods.getChannelCode(), "HGUserCode");
        if (StringUtils.isNotBlank((String)jsons)) {
            cacheKey = cacheKey + "-" + ocShoppingGoods.getUserCode();
        }
        cacheKeyList.add(cacheKey);
    }

    private void deleGoodsByModelAndCacheByCode(OcShoppingGoods ocShoppingGoods, List<String> cacheKeyList) {
        if (null == ocShoppingGoods) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", ocShoppingGoods.getTenantCode());
        param.put("shoppingGoodsCode", ocShoppingGoods.getShoppingGoodsCode());
        this.delShoppingGoodsModelByCode(param);
        String cacheKey = this.SHOPPINGGOODSCACHEKEY + ocShoppingGoods.getSkuCode() + "-" + ocShoppingGoods.getMemberBcode() + "-" + ocShoppingGoods.getTenantCode() + "-" + ocShoppingGoods.getContractGoodsGtype();
        cacheKey = cacheKey + "-" + ocShoppingGoods.getGoodsSpec4() + "-" + ocShoppingGoods.getChannelCode() + "-" + ocShoppingGoods.getUserCode();
        String jsons = this.getDdFlag(ocShoppingGoods.getTenantCode(), ocShoppingGoods.getChannelCode(), "HGUserCode");
        if (StringUtils.isNotBlank((String)jsons)) {
            cacheKey = cacheKey + "-" + ocShoppingGoods.getUserCode();
        }
        cacheKeyList.add(cacheKey);
    }

    @Override
    public QueryResult<OcShoppingGoods> queryShoppingGoodsPage(Map<String, Object> map) {
        List<OcShoppingGoods> ocShoppingGoodsList = this.queryShoppingGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        if (!EmptyUtil.isEmpty((Object)map.get("startRow")) && !EmptyUtil.isEmpty((Object)map.get("rows"))) {
            pageTools.setRecordCount(this.countShoppingGoods(map));
        }
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocShoppingGoodsList);
        return queryResult;
    }

    @Override
    public OcShoppingGoods getShoppingGoodsByCode(Map<String, Object> map) {
        return this.getShoppingGoodsModelByCode(map);
    }

    @Override
    public void delShoppingGoodsByCode(Map<String, Object> map) throws ApiException {
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsModelByCode(map);
        if (ocShoppingGoods == null) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingGoodsByCode.null", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.deleGoodsByModel(ocShoppingGoods);
    }

    @Override
    public void updateShoppingGoodsNum(Integer shoppingGoodsId, BigDecimal amount, BigDecimal weight, String goodsDay) throws ApiException {
        if (null == shoppingGoodsId || null == amount) {
            this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsNum.params", (Object)("shoppingGoodsId:" + shoppingGoodsId + ",amount:" + amount + ",weight:" + weight + ",goodsDay:" + goodsDay));
            return;
        }
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoods(shoppingGoodsId);
        if (ocShoppingGoods == null) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsNum.null", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (null == ocShoppingGoods.getGoodsCamount()) {
            ocShoppingGoods.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocShoppingGoods.getGoodsCweight()) {
            ocShoppingGoods.setGoodsCweight(BigDecimal.ZERO);
        }
        amount = amount.subtract(ocShoppingGoods.getGoodsCamount());
        weight = weight.subtract(ocShoppingGoods.getGoodsCweight());
        BigDecimal addmoney = amount.multiply(ocShoppingGoods.getPricesetNprice());
        BigDecimal addrefrice = amount.multiply(ocShoppingGoods.getPricesetRefrice());
        this.updateCmountShoppingGoods(shoppingGoodsId, amount, weight, goodsDay);
    }

    @Override
    public void updateShoppingGoodsNumByCode(String shoppingGoodsCode, BigDecimal amount, BigDecimal goodWeight, String goodsDay, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)shoppingGoodsCode) || null == amount) {
            this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsNumByCode.params", (Object)("shoppingGoodsCode:" + shoppingGoodsCode + ",amount:" + amount + ",goodWeight:" + goodWeight + ",goodsDay:" + goodsDay));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("shoppingGoodsCode", shoppingGoodsCode);
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsByCode(param);
        if (ocShoppingGoods == null) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsNum.null", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (null == ocShoppingGoods.getGoodsCamount()) {
            ocShoppingGoods.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocShoppingGoods.getGoodsCweight()) {
            ocShoppingGoods.setGoodsCweight(BigDecimal.ZERO);
        }
        amount = amount.subtract(ocShoppingGoods.getGoodsCamount());
        goodWeight = goodWeight.subtract(ocShoppingGoods.getGoodsCweight());
        BigDecimal addmoney = amount.multiply(ocShoppingGoods.getPricesetNprice());
        BigDecimal addrefrice = amount.multiply(ocShoppingGoods.getPricesetRefrice());
        this.updateCmountShoppingGoodsByCode(shoppingGoodsCode, amount, goodWeight, goodsDay);
    }

    @Override
    public void updateShoppingGoodsNumBatch(List<GoodsNumDomain> goodsList) throws ApiException {
        if (goodsList == null || goodsList.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.updateShoppingGoodsNumBatch", "\u53c2\u6570\u4e3a\u7a7a");
        }
        for (GoodsNumDomain goodsNumDomain : goodsList) {
            this.updateShoppingGoodsNum(goodsNumDomain.getId(), goodsNumDomain.getNum(), goodsNumDomain.getWeight(), null);
        }
    }

    @Override
    public void deleteShoppingGoodsBatch(List<Integer> idList) throws ApiException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        ArrayList<String> cacheKeyList = new ArrayList<String>();
        for (Integer shoppingGoodsId : idList) {
            this.deleteShoppingGoods(shoppingGoodsId, cacheKeyList);
        }
        if (ListUtil.isNotEmpty(cacheKeyList)) {
            for (String s : cacheKeyList) {
                SupDisUtil.del((String)s);
            }
        }
    }

    @Override
    public void deleteShoppingGoodsBatchByCode(List<String> codeList, String tenantCode) throws ApiException {
        if (codeList == null || codeList.isEmpty()) {
            return;
        }
        ArrayList<String> cacheKeyList = new ArrayList<String>();
        for (String code : codeList) {
            this.deleteShoppingGoodsByCode(code, tenantCode, cacheKeyList);
        }
        if (ListUtil.isNotEmpty(cacheKeyList)) {
            for (String s : cacheKeyList) {
                SupDisUtil.del((String)s);
            }
        }
    }

    public void deleteShoppingGoodsBatchAndCache(List<Integer> idList, List<String> cacheKeyList) throws ApiException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        for (Integer shoppingGoodsId : idList) {
            this.deleteShoppingGoods(shoppingGoodsId, cacheKeyList);
        }
    }

    public void deleteShoppingGoodsBatchAndCacheByCode(List<String> codeList, List<String> cacheKeyList, String tenantCode) throws ApiException {
        if (codeList == null || codeList.isEmpty()) {
            return;
        }
        for (String code : codeList) {
            this.deleteShoppingGoodsByCode(code, tenantCode, cacheKeyList);
        }
    }

    @Override
    public String saveShoppingCartOrder(OcShoppingDomain ocShoppingDomain) {
        OcContractDomain ocContractDomain = this.makeContract(ocShoppingDomain, "0");
        this.handleShoppingGoods(ocShoppingDomain);
        return ocContractDomain.getContractBillcode();
    }

    private void handleShoppingGoods(OcShoppingDomain ocShoppingDomain) {
        if (ocShoppingDomain == null) {
            return;
        }
        List<OcShoppingpackgeDomain> packageList = ocShoppingDomain.getShoppingpackageList();
        if (packageList == null || packageList.isEmpty()) {
            return;
        }
        for (OcShoppingpackgeDomain ocShoppingpackgeDomain : packageList) {
            List<OcShoppingGoodsDomain> goodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
            if (goodsList == null || goodsList.isEmpty()) continue;
            for (OcShoppingGoodsDomain ocShoppingGoodsDomain : goodsList) {
                this.deleteShoppingGoods(ocShoppingGoodsDomain.getShoppingGoodsId());
            }
        }
    }

    @Override
    public String saveContractByOcShopping(OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        OcContractDomain ocContractDomain = this.makeContract(ocShoppingDomain, contractTypepro);
        this.handleShoppingGoods(ocShoppingDomain);
        return this.ocContractService.saveContract(ocContractDomain).getContractBillcode();
    }

    @Override
    public String saveContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        return this.saveContract(ocContractDomain, shoppingGoodsIdList);
    }

    @Override
    public String sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        long startTime = System.currentTimeMillis();
        ArrayList<String> cacheKeyList = new ArrayList<String>();
        String code = this.saveContract(ocContractDomain, shoppingGoodsIdList, cacheKeyList);
        this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.sendContractByDel1===" + code, (Object)(System.currentTimeMillis() - startTime));
        this.logger.debug("\u3010\u901a\u8fc7\u8d2d\u7269\u8f66\u4e0b\u5355\u63a8\u9001\u5230mq\u7684\u8ba2\u5355\u6570\u636e\u3011- {}", JSON.toJSON((Object)ocContractDomain));
        this.getContractService().putQueue(ocContractDomain);
        if (ListUtil.isNotEmpty(cacheKeyList)) {
            for (String key : cacheKeyList) {
                SupDisUtil.del((String)key);
            }
        }
        this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.sendContractByDel2===" + code, (Object)(System.currentTimeMillis() - startTime));
        return code;
    }

    @Override
    public String sendContractByDelByCode(OcContractDomain ocContractDomain, List<String> shoppingGoodsCodeList) {
        long startTime = System.currentTimeMillis();
        if (ocContractDomain.getChannelCode().equals("BESTPAY-MALL")) {
            ocContractDomain.setShoppingGoodsFlag(1);
        }
        ArrayList<String> cacheKeyList = new ArrayList<String>();
        String code = this.saveContractByCode(ocContractDomain, shoppingGoodsCodeList, cacheKeyList);
        this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.sendContractByDel1===" + code, (Object)(System.currentTimeMillis() - startTime));
        this.logger.debug("\u3010\u901a\u8fc7\u8d2d\u7269\u8f66\u4e0b\u5355\u63a8\u9001\u5230mq\u7684\u8ba2\u5355\u6570\u636e\u3011- {}", JSON.toJSON((Object)ocContractDomain));
        this.getContractService().putQueue(ocContractDomain);
        if (ListUtil.isNotEmpty(cacheKeyList)) {
            for (String key : cacheKeyList) {
                SupDisUtil.del((String)key);
            }
        }
        this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.sendContractByDel2===" + code, (Object)(System.currentTimeMillis() - startTime));
        return code;
    }

    @Override
    public String sendBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        ArrayList<String> cacheList = new ArrayList<String>();
        String code = this.saveBatchContractByDelAndCache(ocContractDomainList, shoppingGoodsIdList, cacheList);
        if (null != ocContractDomainList && !ocContractDomainList.isEmpty()) {
            for (OcContractDomain ocContractDomain : ocContractDomainList) {
                if (ocContractDomain.getChannelCode().equals("BESTPAY-MALL")) {
                    ocContractDomain.setShoppingGoodsFlag(1);
                }
                this.getContractService().putQueue(ocContractDomain);
            }
        }
        if (ListUtil.isNotEmpty(cacheList)) {
            for (String cacheKey : cacheList) {
                SupDisUtil.del((String)cacheKey);
            }
        }
        return code;
    }

    @Override
    public String sendBatchContractByDelByCode(List<OcContractDomain> ocContractDomainList, List<String> shoppingGoodsCodeList) {
        ArrayList<String> cacheList = new ArrayList<String>();
        String code = this.saveBatchContractByDelAndCacheByCode(ocContractDomainList, shoppingGoodsCodeList, cacheList);
        if (null != ocContractDomainList && !ocContractDomainList.isEmpty()) {
            for (OcContractDomain ocContractDomain : ocContractDomainList) {
                if (ocContractDomain.getChannelCode().equals("BESTPAY-MALL")) {
                    ocContractDomain.setShoppingGoodsFlag(1);
                }
                this.getContractService().putQueue(ocContractDomain);
            }
        }
        if (ListUtil.isNotEmpty(cacheList)) {
            for (String cacheKey : cacheList) {
                SupDisUtil.del((String)cacheKey);
            }
        }
        return code;
    }

    @Override
    public String saveBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        String code = this.saveBatchContract(ocContractDomainList, shoppingGoodsIdList);
        return code;
    }

    public String saveBatchContractByDelAndCache(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList, List<String> cacheList) {
        return this.saveBatchContractAndCache(ocContractDomainList, shoppingGoodsIdList, cacheList);
    }

    public String saveBatchContractByDelAndCacheByCode(List<OcContractDomain> ocContractDomainList, List<String> shoppingGoodsCodeList, List<String> cacheList) {
        return this.saveBatchContractAndCacheByCode(ocContractDomainList, shoppingGoodsCodeList, cacheList);
    }

    @Override
    public List<OcContract> saveBatchContractByDelRe(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        List<OcContract> list;
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatch(shoppingGoodsIdList);
        }
        if (ListUtil.isEmpty(list = this.ocContractService.saveBatchContract(ocContractDomainList))) {
            return null;
        }
        return list;
    }

    @Override
    public List<OcContract> saveBatchContractByDelCodeRe(List<OcContractDomain> ocContractDomainList, List<String> shoppingGoodsCodeList) {
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<String> cacheList = new ArrayList<String>();
        if (null != shoppingGoodsCodeList && !shoppingGoodsCodeList.isEmpty()) {
            this.deleteShoppingGoodsBatchAndCacheByCode(shoppingGoodsCodeList, cacheList, ocContractDomainList.get(0).getTenantCode());
        }
        List<OcContract> list = this.ocContractService.saveBatchContract(ocContractDomainList);
        if (ListUtil.isNotEmpty(cacheList)) {
            for (String cacheKey : cacheList) {
                SupDisUtil.del((String)cacheKey);
            }
        }
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractService getContractService() {
        Object object = lock;
        synchronized (object) {
            if (null == contractService) {
                contractService = new ContractService((OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService"));
                for (int i = 0; i < 200; ++i) {
                    contractService.addPollPool(new ContractPollThread(contractService));
                }
            }
            return contractService;
        }
    }

    private String saveBatchContract(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        List<OcContract> list;
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatch(shoppingGoodsIdList);
        }
        if (ListUtil.isEmpty(list = this.ocContractService.saveBatchContract(ocContractDomainList))) {
            return null;
        }
        BigDecimal dataBmoney = BigDecimal.ZERO;
        String codeStr = "";
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        for (OcContract ocContract : list) {
            if (StringUtils.isNotBlank((String)codeStr)) {
                codeStr = codeStr + ",";
            }
            codeStr = codeStr + ocContract.getContractBillcode();
            cacheMap.put("contractBbillcode", ocContract.getContractBbillcode());
            dataBmoney = dataBmoney.add(ocContract.getDataBmoney());
        }
        cacheMap.put("contractBillcodeStr", codeStr);
        cacheMap.put("dataBmoney", dataBmoney);
        DisUtil.setJson((String)("OC_BBILLCODESTR-" + cacheMap.get("contractBbillcode")), cacheMap, (int)3600000);
        return list.get(0).getContractBbillcode();
    }

    private String saveBatchContractAndCache(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList, List<String> cacheList) {
        List<OcContract> list;
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatchAndCache(shoppingGoodsIdList, cacheList);
        }
        if (ListUtil.isEmpty(list = this.ocContractService.saveBatchContract(ocContractDomainList))) {
            return null;
        }
        BigDecimal dataBmoney = BigDecimal.ZERO;
        String codeStr = "";
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        for (OcContract ocContract : list) {
            if (StringUtils.isNotBlank((String)codeStr)) {
                codeStr = codeStr + ",";
            }
            codeStr = codeStr + ocContract.getContractBillcode();
            cacheMap.put("contractBbillcode", ocContract.getContractBbillcode());
            dataBmoney = dataBmoney.add(ocContract.getDataBmoney());
        }
        cacheMap.put("contractBillcodeStr", codeStr);
        cacheMap.put("dataBmoney", dataBmoney);
        DisUtil.setJson((String)("OC_BBILLCODESTR-" + cacheMap.get("contractBbillcode")), cacheMap, (int)3600000);
        return list.get(0).getContractBbillcode();
    }

    private String saveBatchContractAndCacheByCode(List<OcContractDomain> ocContractDomainList, List<String> shoppingGoodsCodeList, List<String> cacheList) {
        List<OcContract> list;
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            return null;
        }
        String tenantCode = ocContractDomainList.get(0).getTenantCode();
        if (null != shoppingGoodsCodeList && !shoppingGoodsCodeList.isEmpty()) {
            this.deleteShoppingGoodsBatchAndCacheByCode(shoppingGoodsCodeList, cacheList, tenantCode);
        }
        if (ListUtil.isEmpty(list = this.ocContractService.saveBatchContract(ocContractDomainList))) {
            return null;
        }
        BigDecimal dataBmoney = BigDecimal.ZERO;
        String codeStr = "";
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        for (OcContract ocContract : list) {
            if (StringUtils.isNotBlank((String)codeStr)) {
                codeStr = codeStr + ",";
            }
            codeStr = codeStr + ocContract.getContractBillcode();
            cacheMap.put("contractBbillcode", ocContract.getContractBbillcode());
            dataBmoney = dataBmoney.add(ocContract.getDataBmoney());
        }
        cacheMap.put("contractBillcodeStr", codeStr);
        cacheMap.put("dataBmoney", dataBmoney);
        DisUtil.setJson((String)("OC_BBILLCODESTR-" + cacheMap.get("contractBbillcode")), cacheMap, (int)3600000);
        return list.get(0).getContractBbillcode();
    }

    private String saveContract(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        long startTime = System.currentTimeMillis();
        if (null == ocContractDomain) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatch(shoppingGoodsIdList);
        }
        this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.saveContract1", (Object)(System.currentTimeMillis() - startTime));
        String contractBillcode = this.ocContractService.saveContract(ocContractDomain).getContractBillcode();
        this.logger.info("oc.CONTRACT.OcShoppingServiceImpl.saveContract2", (Object)(System.currentTimeMillis() - startTime));
        return contractBillcode;
    }

    private String saveContract(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList, List<String> cacheList) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatchAndCache(shoppingGoodsIdList, cacheList);
        }
        return this.ocContractService.saveContract(ocContractDomain).getContractBillcode();
    }

    private String saveContractByCode(OcContractDomain ocContractDomain, List<String> shoppingGoodsCodeList, List<String> cacheList) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null != shoppingGoodsCodeList && !shoppingGoodsCodeList.isEmpty()) {
            this.deleteShoppingGoodsBatchAndCacheByCode(shoppingGoodsCodeList, cacheList, ocContractDomain.getTenantCode());
        }
        return this.ocContractService.saveContract(ocContractDomain).getContractBillcode();
    }

    public OcContractDomain makeContract(OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (ocShoppingDomain == null) {
            return null;
        }
        String jsonStr = JsonUtil.buildNormalBinder().toJson((Object)ocShoppingDomain);
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(jsonStr, OcContractDomain.class);
        String value = DisUtil.getMap((String)"DdFalgSetting-key", (String)(ocShoppingDomain.getTenantCode() + "-paytime-orderDuration"));
        if (StringUtil.isBlank((String)value)) {
            value = "1440";
        }
        ocContractDomain.setContractPmode(ocShoppingDomain.getScontractPmode());
        ocContractDomain.setGoodsNum(ocShoppingDomain.getShoppingCamount());
        ocContractDomain.setContractTypepro(contractTypepro);
        if (null == ocContractDomain.getContractPaydate()) {
            ocContractDomain.setContractPaydate(DateUtils.addMinutes((Date)new Date(), (int)Integer.valueOf(value)));
        }
        ocContractDomain.setContractRemark(ocShoppingDomain.getShoppingRemark());
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            goodsList.addAll(ocPackageDomain.getContractGoodsList());
        }
        ocContractDomain.setContractMoney(ocShoppingDomain.getGoodsMoney());
        BigDecimal contractHmoney = ocShoppingDomain.getGoodsMoney();
        BigDecimal goodsPmoney = ocShoppingDomain.getGoodsPmoney();
        if (goodsPmoney != null) {
            contractHmoney = contractHmoney.add(goodsPmoney);
        }
        ocContractDomain.setDataBmoney(contractHmoney);
        return ocContractDomain;
    }

    private OcShoppingGoodsDomain getShoppingGoodsReDomain(Integer shoppingGoodsId) {
        if (null == shoppingGoodsId) {
            return null;
        }
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsModelById(shoppingGoodsId);
        if (null == ocShoppingGoods) {
            return null;
        }
        return this.makeShoppingGoodsDomain(ocShoppingGoods);
    }

    private OcShoppingReDomain getShoppingReDomain(String shoppingCode, String tenantCode) {
        if (StringUtils.isBlank((String)shoppingCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingCode", shoppingCode);
        map.put("tenantCode", tenantCode);
        OcShopping ocShopping = this.getShoppingByCode(map);
        if (null == ocShopping) {
            return null;
        }
        return this.makeShoppingReDomain(ocShopping);
    }

    private OcShoppingpackgeDomain getShoppingpackgeDomain(String shoppingpackgeCode, String tenantCode) {
        if (StringUtils.isBlank((String)shoppingpackgeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OcShoppingpackge ocShoppingpackge = this.ocShoppingpackgeService.getshoppingpackgeByCode(tenantCode, shoppingpackgeCode);
        if (null == ocShoppingpackge) {
            return null;
        }
        return this.makeShoppingpackgeDomain(ocShoppingpackge);
    }

    @Override
    public List<OcShoppingReDomain> queryShoppingToContract(List<Integer> shoppingGoodsIdList, String terminalType) {
        if (null == shoppingGoodsIdList || shoppingGoodsIdList.isEmpty()) {
            return null;
        }
        HashMap<String, OcShoppingReDomain> shoppingmap = new HashMap<String, OcShoppingReDomain>();
        HashMap<String, OcShoppingpackgeDomain> shoppingpackgemap = new HashMap<String, OcShoppingpackgeDomain>();
        String key = "";
        String packKey = "";
        ArrayList<OcShoppingReDomain> reList = new ArrayList<OcShoppingReDomain>();
        for (Integer shoppingGoodsId : shoppingGoodsIdList) {
            OcShoppingGoodsDomain ocShoppingGoodsDomain = this.getShoppingGoodsReDomain(shoppingGoodsId);
            if (null == ocShoppingGoodsDomain || StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingCode())) continue;
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
            }
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
                ocShoppingGoodsDomain.setGoodsCamount(new BigDecimal("0"));
            }
            if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
                ocShoppingGoodsDomain.setGoodsCweight(new BigDecimal("0"));
            }
            String tenantCode = ocShoppingGoodsDomain.getTenantCode();
            String shoppingpackgeCode = ocShoppingGoodsDomain.getShoppingpackgeCode();
            packKey = ocShoppingGoodsDomain.getMemberCode() + "-" + ocShoppingGoodsDomain.getChannelCode() + "-" + ocShoppingGoodsDomain.getMemberBcode() + "-" + ocShoppingGoodsDomain.getTenantCode();
            key = ocShoppingGoodsDomain.getMemberCode() + "-" + ocShoppingGoodsDomain.getChannelCode() + "-" + ocShoppingGoodsDomain.getMemberBcode() + "-" + ocShoppingGoodsDomain.getTenantCode();
            ocShoppingGoodsDomain.setShoppingCode(key);
            ocShoppingGoodsDomain.setShoppingpackgeCode(packKey);
            OcShoppingReDomain ocShoppingReDomain = (OcShoppingReDomain)shoppingmap.get(key);
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
            }
            ocShoppingGoodsDomain.setPricesetNprice(ocShoppingGoodsDomain.getPricesetNprice().setScale(4, 4));
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            ocShoppingGoodsDomain.setPricesetRefrice(ocShoppingGoodsDomain.getPricesetRefrice().setScale(4, 4));
            if (null == ocShoppingReDomain) {
                ocShoppingReDomain = new OcShoppingReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShoppingGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error("queryShoppingPage.copyAllPropertys ", (Throwable)e);
                }
                ocShoppingReDomain.setShoppingCode(key);
                reList.add(ocShoppingReDomain);
                ocShoppingReDomain.setShoppingCamount(ocShoppingGoodsDomain.getGoodsCamount());
                ocShoppingReDomain.setShoppingCweight(ocShoppingGoodsDomain.getGoodsCweight());
                ocShoppingReDomain.setGoodsMoney(ocShoppingReDomain.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
                ocShoppingReDomain.setPricesetRefrice(ocShoppingReDomain.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
                shoppingmap.put(key, ocShoppingReDomain);
            } else {
                ocShoppingReDomain.setShoppingCamount(ocShoppingReDomain.getShoppingCamount().add(ocShoppingGoodsDomain.getGoodsCamount()));
                ocShoppingReDomain.setShoppingCweight(ocShoppingReDomain.getShoppingCweight().add(ocShoppingGoodsDomain.getGoodsCweight()));
                ocShoppingReDomain.setGoodsMoney(ocShoppingReDomain.getGoodsMoney().add(ocShoppingReDomain.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice())));
                ocShoppingReDomain.setPricesetRefrice(ocShoppingReDomain.getPricesetRefrice().add(ocShoppingReDomain.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice())));
            }
            OcShoppingpackgeDomain ocShoppingpackgeDomain = (OcShoppingpackgeDomain)shoppingpackgemap.get(packKey);
            if (null == ocShoppingpackgeDomain) {
                ocShoppingpackgeDomain = new OcShoppingpackgeDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocShoppingpackgeDomain, (Object)ocShoppingGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error("queryShoppingPage.copyAllPropertys ", (Throwable)e);
                }
                ocShoppingpackgeDomain.setShoppingpackgeCode(packKey);
                ocShoppingpackgeDomain.setShoppingCode(key);
                List<OcShoppingpackgeDomain> shoppingpackageList = ocShoppingReDomain.getShoppingpackageList();
                if (null == shoppingpackageList) {
                    shoppingpackageList = new ArrayList<OcShoppingpackgeDomain>();
                    ocShoppingReDomain.setShoppingpackageList(shoppingpackageList);
                }
                shoppingpackageList.add(ocShoppingpackgeDomain);
                ocShoppingpackgeDomain.setGoodsNum(ocShoppingGoodsDomain.getGoodsCamount());
                ocShoppingpackgeDomain.setGoodsWeight(ocShoppingGoodsDomain.getGoodsCweight());
                ocShoppingpackgeDomain.setGoodsMoney(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
                ocShoppingpackgeDomain.setPricesetRefrice(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
                shoppingpackgemap.put(packKey, ocShoppingpackgeDomain);
            } else {
                ocShoppingpackgeDomain.setGoodsNum(ocShoppingpackgeDomain.getGoodsNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
                ocShoppingpackgeDomain.setGoodsWeight(ocShoppingpackgeDomain.getGoodsWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
                ocShoppingpackgeDomain.setGoodsMoney(ocShoppingpackgeDomain.getGoodsMoney().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice())));
                ocShoppingpackgeDomain.setPricesetRefrice(ocShoppingpackgeDomain.getPricesetRefrice().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice())));
            }
            List<OcShoppingGoodsDomain> shoppingGoodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
            if (null == shoppingGoodsList) {
                shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
                ocShoppingpackgeDomain.setShoppingGoodsList(shoppingGoodsList);
            }
            shoppingGoodsList.add(ocShoppingGoodsDomain);
        }
        return reList;
    }

    protected String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    private OcShoppingReDomain makeShoppingReDomain(OcShopping ocShopping) {
        if (null == ocShopping) {
            return null;
        }
        OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShopping);
            TypeBean typeBean = this.getOcSetting(ocShoppingReDomain.getShoppingType(), ocShoppingReDomain.getTenantCode());
            if (null != typeBean) {
                ocShoppingReDomain.setScontractBlance(typeBean.getBlance());
                ocShoppingReDomain.setScontractPmode(typeBean.getPmode());
                ocShoppingReDomain.setIntpay(typeBean.getIntpay());
                ocShoppingReDomain.setPmpay(typeBean.getPmpay());
                ocShoppingReDomain.setBlance(typeBean.getBlance());
                ocShoppingReDomain.setPmode(typeBean.getPmode());
                ocShoppingReDomain.setFreight(typeBean.getFreight());
                ocShoppingReDomain.setCoppay(typeBean.getCoppay());
                ocShoppingReDomain.setUrpay(typeBean.getUrpay());
                ocShoppingReDomain.setInvp(typeBean.getInvp());
                ocShoppingReDomain.setRef(typeBean.getRef());
                ocShoppingReDomain.setReg(typeBean.getReg());
            }
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShoppingReDomain.e", (Throwable)e);
        }
        return ocShoppingReDomain;
    }

    private OcShoppingGoodsDomain makeShoppingGoodsDomain(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return null;
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)ocShoppingGoods);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShoppingGoodsDomain.e", (Throwable)e);
        }
        return ocShoppingGoodsDomain;
    }

    private OcShoppingpackgeDomain makeShoppingpackgeDomain(OcShoppingpackge ocShoppingpackge) {
        if (null == ocShoppingpackge) {
            return null;
        }
        OcShoppingpackgeDomain ocShoppingpackgeDomain = new OcShoppingpackgeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingpackgeDomain, (Object)ocShoppingpackge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ocShoppingpackgeDomain;
    }

    @Override
    public void updateShoppingGoodsPmInfo(Integer shoppingGoodsId, String promotionCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("promotionCode", promotionCode);
        this.ocShoppingGoodsMapper.updateShoppingGoodsPmInfo(map);
    }

    @Override
    public void updateShoppingGoodsCheckState(String memberCode, String shoppingCode, Integer shoppingGoodsId, Integer checkState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberBCode", memberCode);
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("checkState", checkState);
        this.updateShoppingGoodsCheckStateModel(map);
    }

    private void updateShoppingGoodsCheckStateModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.updateShoppingGoodsCheckState(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateRefundModel.ex", e + "map" + map);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsCheckStateModel.exmap" + map);
        }
    }

    @Override
    public void updateShoppingGoodsListCheckState(String memberCode, String shoppingCode, String shoppingGoodsIdStr, Integer checkState) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberBCode", memberCode);
        map.put("shoppingGoodsIdStr", shoppingGoodsIdStr);
        map.put("checkState", checkState);
        int i = this.ocShoppingGoodsMapper.updateShoppingGoodsCheckState(map);
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsListCheckState.exmap" + map);
        }
    }

    @Override
    public void updateShopGoodsBySkuCode(Map<String, Object> map) {
        String msg = this.checkShopGoodsByMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopGoodsBySkuCode.checkShopGoodsByMap", msg);
        }
        Integer dataState = (Integer)map.get("dataState");
        if (null != dataState && dataState != 0) {
            map.put("shoppingGoodsCheck", 1);
        }
        HashMap<String, Object> paramap = new HashMap<String, Object>();
        paramap.put("skuCode", map.get("skuCode"));
        paramap.put("goodsCode", map.get("goodsCode"));
        paramap.put("tenantCode", map.get("tenantCode"));
        this.updateShopGoodsBySkuCodeModel(map);
    }

    private String checkShopGoodsByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)String.valueOf(map.get("skuCode")))) {
            msg = msg + "skuCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("goodsCode")))) {
            msg = msg + "goodsCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            msg = msg + "tenantCode is null";
        }
        return msg;
    }

    private void updateShopGoodsBySkuCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.updateShoppingGoodsBySkuCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopGoodsBySkuCodeModel.ex", (Throwable)e);
        }
    }

    public void updateShopBySkuCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        try {
            this.ocShoppingMapper.updateShoppingByShoCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopBySkuCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateShoppingGoodsStr(String opShopping) throws ApiException {
        if (StringUtils.isBlank((String)opShopping)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsStr.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcShoppingDomain ocShoppingDomain = (OcShoppingDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(opShopping, OcShoppingDomain.class);
        if (null == ocShoppingDomain) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsStr.null", "\u53c2\u6570\u9519\u8bef");
        }
        if (ListUtil.isEmpty(ocShoppingDomain.getShoppingpackageList())) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsStr.null", "\u5305\u88f9\u4fe1\u606f\u4e3a\u7a7a");
        }
        OcShoppingpackgeDomain ocShoppingpackgeDomain = ocShoppingDomain.getShoppingpackageList().get(0);
        List<OcShoppingGoodsDomain> ocShoppingGoodsDomainList = ocShoppingpackgeDomain.getShoppingGoodsList();
        if (ListUtil.isEmpty(ocShoppingGoodsDomainList)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsStr.null", "\u8d2d\u7269\u8f66\u5546\u54c1\u4e3a\u7a7a");
        }
        for (OcShoppingGoodsDomain goodsDomain : ocShoppingGoodsDomainList) {
            this.updateShoppingGoods(goodsDomain);
        }
        this.ocShoppingpackgeService.updateshoppingpackge(ocShoppingpackgeDomain);
        this.updateShopping(ocShoppingDomain);
    }

    @Override
    public void updateShoppingGoodsSortBatch(List<OcShoppingGoodsDomain> shopGoodsList) throws ApiException {
        if (ListUtil.isEmpty(shopGoodsList)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.updateShoppingGoodsSortBatch", "\u53c2\u6570\u4e3a\u7a7a");
        }
        for (OcShoppingGoodsDomain goodsDomain : shopGoodsList) {
            OcShoppingGoods ocShoppingGoods = this.getShoppingGoods(goodsDomain.getShoppingGoodsId());
            if (ocShoppingGoods == null) {
                throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsNum.null", "\u6570\u636e\u4e0d\u5b58\u5728");
            }
            this.updateShoppingGoodsSort(ocShoppingGoods.getShoppingGoodsId(), goodsDomain.getGoodsSpec3(), goodsDomain.getGoodsSpec2(), goodsDomain.getGoodsProperty2(), goodsDomain.getGoodsCamount(), goodsDomain.getGoodsCweight(), goodsDomain.getGoodsProperty3(), goodsDomain.getGoodsContract());
        }
    }

    @Override
    public void deleteShoppingById(Integer shoppingId) throws ApiException {
        OcShopping ocShopping = this.getShoppingModelById(shoppingId);
        if (null == ocShopping) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShopping.ocShopping", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteShoppingModel(shoppingId);
    }

    static {
        lock = new Object();
    }
}

