/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.utils;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ReportCodeGenerator {
    private static final String PREFIX_SINGLE = "HDDT";
    private static final String PREFIX_STRATEGY = "ZLBB";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String generate(boolean isSingleProject) {
        String today;
        String prefix = isSingleProject ? PREFIX_SINGLE : PREFIX_STRATEGY;
        String key = ReportCodeGenerator.buildRedisKey(prefix, today = LocalDate.now().format(DATE_FORMATTER));
        Long seq = DisUtil.incr((String)key, (Long)1L);
        if (seq != null && seq == 1L) {
            DisUtil.setExpire((String)key, (int)2);
        }
        return ReportCodeGenerator.formatCode(prefix, today, seq);
    }

    private static String buildRedisKey(String prefix, String date) {
        return String.format("report:%s:%s", prefix, date);
    }

    private static String formatCode(String prefix, String date, long seq) {
        return String.format("%s%s%06d", prefix, date, seq);
    }

    public static void main(String[] args) {
        System.out.println(ReportCodeGenerator.generate(true));
        System.out.println(ReportCodeGenerator.generate(false));
        System.out.println(ReportCodeGenerator.generate(true));
    }
}

