/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.utils;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ReportCodeGenerator {
    private static final String PREFIX_SINGLE = "HDDT";
    private static final String PREFIX_STRATEGY = "ZLBB";
    private static final String PREFIX_REPLENISHMENT = "HDBH";
    private static final String PREFIX_PRICE = "HDPJ";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String generate(ReportType type) {
        String today;
        String prefix = type.getPrefix();
        String key = ReportCodeGenerator.buildRedisKey(prefix, today = LocalDate.now().format(DATE_FORMATTER));
        Long seq = DisUtil.incr((String)key, (Long)1L);
        if (seq == null) {
            throw new IllegalStateException("Failed to generate sequence from Redis for key: " + key);
        }
        if (seq == 1L) {
            DisUtil.setExpire((String)key, (int)3);
        }
        return ReportCodeGenerator.formatCode(prefix, today, seq);
    }

    private static String buildRedisKey(String prefix, String date) {
        return String.format("report:%s:%s", prefix, date);
    }

    private static String formatCode(String prefix, String date, long seq) {
        return String.format("%s%s%06d", prefix, date, seq);
    }

    public static void main(String[] args) {
        System.out.println(ReportCodeGenerator.generate(ReportType.SINGLE));
        System.out.println(ReportCodeGenerator.generate(ReportType.STRATEGY));
        System.out.println(ReportCodeGenerator.generate(ReportType.REPLENISHMENT));
        System.out.println(ReportCodeGenerator.generate(ReportType.PRICE));
    }

    public static enum ReportType {
        SINGLE("HDDT"),
        STRATEGY("ZLBB"),
        REPLENISHMENT("HDBH"),
        PRICE("HDPJ");

        private final String prefix;

        private ReportType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

