/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.ReplenishmentItemMapper;
import com.yqbsoft.laser.service.contract.dao.ReplenishmentOrderMapper;
import com.yqbsoft.laser.service.contract.domain.ReplenishmentOrderDomain;
import com.yqbsoft.laser.service.contract.model.ProjectReport;
import com.yqbsoft.laser.service.contract.model.ReplenishmentItem;
import com.yqbsoft.laser.service.contract.model.ReplenishmentOrder;
import com.yqbsoft.laser.service.contract.service.ReplenishmentOrderService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplenishmentOrderServiceImpl
extends BaseServiceImpl
implements ReplenishmentOrderService {
    private ReplenishmentOrderMapper replenishmentOrderMapper;
    private ReplenishmentItemMapper replenishmentItemMapper;

    @Override
    public ReplenishmentOrder save(ReplenishmentOrderDomain replenishmentOrderDomain) throws Exception {
        ReplenishmentOrder replenishmentOrder = new ReplenishmentOrder();
        BeanUtils.copyAllPropertys((Object)replenishmentOrder, (Object)replenishmentOrderDomain);
        if (replenishmentOrderDomain.getId() == null) {
            this.replenishmentOrderMapper.insert(replenishmentOrder);
        } else {
            this.replenishmentOrderMapper.updateByPrimaryKeySelective(replenishmentOrder);
        }
        return replenishmentOrder;
    }

    @Override
    public SupQueryResult<ReplenishmentOrder> queryReplenishmentOrderPage(Map<String, Object> param) throws Exception {
        List<ReplenishmentOrder> projectReports = this.replenishmentOrderMapper.query(param);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.replenishmentOrderMapper.count(param));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(projectReports);
        return queryResult;
    }

    @Override
    public ReplenishmentOrder getById(Long id) throws Exception {
        ReplenishmentOrder replenishmentOrder = this.replenishmentOrderMapper.selectByPrimaryKey(id);
        if (replenishmentOrder != null) {
            replenishmentOrder.setItems(this.getItemsByReplenishmentId(replenishmentOrder.getId()));
        }
        return replenishmentOrder;
    }

    @Override
    public ReplenishmentOrder audit(ReplenishmentOrderDomain replenishmentOrderDomain) throws Exception {
        ReplenishmentOrder replenishmentOrder = new ReplenishmentOrder();
        BeanUtils.copyAllPropertys((Object)replenishmentOrder, (Object)replenishmentOrderDomain);
        this.replenishmentOrderMapper.updateByPrimaryKey(replenishmentOrder);
        return replenishmentOrder;
    }

    @Override
    public ProjectReport reject(ReplenishmentOrderDomain replenishmentOrderDomain) throws Exception {
        return null;
    }

    private List<ReplenishmentItem> getItemsByReplenishmentId(Long replenishmentId) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("replenishmentId", replenishmentId);
        return this.replenishmentItemMapper.query(param);
    }

    private boolean isExist(String replenishmentCode) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("replenishmentCode", replenishmentCode);
        List<ReplenishmentOrder> list = this.replenishmentOrderMapper.query(param);
        return !list.isEmpty();
    }

    public void setReplenishmentOrderMapper(ReplenishmentOrderMapper replenishmentOrderMapper) {
        this.replenishmentOrderMapper = replenishmentOrderMapper;
    }

    public void setReplenishmentItemMapper(ReplenishmentItemMapper replenishmentItemMapper) {
        this.replenishmentItemMapper = replenishmentItemMapper;
    }
}

