/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.dao.PriceSheetMapper;
import com.yqbsoft.laser.service.contract.dao.ProjectReportItemMapper;
import com.yqbsoft.laser.service.contract.dao.ProjectReportItemOrderMapper;
import com.yqbsoft.laser.service.contract.dao.ProjectReportMapper;
import com.yqbsoft.laser.service.contract.domain.ProjectReportDomain;
import com.yqbsoft.laser.service.contract.domain.ProjectReportItemDomain;
import com.yqbsoft.laser.service.contract.domain.ProjectReportItemOrderDomain;
import com.yqbsoft.laser.service.contract.enums.ProjectReportStatus;
import com.yqbsoft.laser.service.contract.model.DuplicateCheckResult;
import com.yqbsoft.laser.service.contract.model.ProjectReport;
import com.yqbsoft.laser.service.contract.model.ProjectReportItem;
import com.yqbsoft.laser.service.contract.model.ProjectReportItemOrder;
import com.yqbsoft.laser.service.contract.model.SimilarReport;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.ProjectReportService;
import com.yqbsoft.laser.service.contract.utils.ProjectReportAssembler;
import com.yqbsoft.laser.service.contract.utils.ProjectReportItemAssembler;
import com.yqbsoft.laser.service.contract.utils.ProjectReportItemOrderAssembler;
import com.yqbsoft.laser.service.contract.utils.TextSimilarityUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public class ProjectReportServiceImpl
extends BaseServiceImpl
implements ProjectReportService {
    private static final Logger log = LoggerFactory.getLogger(ProjectReportServiceImpl.class);
    private ProjectReportMapper projectReportMapper;
    private ProjectReportItemMapper projectReportItemMapper;
    private ProjectReportItemOrderMapper projectReportItemOrderMapper;
    private PriceSheetMapper priceSheetMapper;
    private OcContractService ocContractService;

    @Override
    @Transactional
    public ProjectReport save(ProjectReportDomain projectReportDomain) throws Exception {
        ProjectReport pr = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.insert(pr);
        this.replaceItems(pr.getId(), projectReportDomain.getItems());
        return pr;
    }

    @Override
    public SupQueryResult<ProjectReport> listByType(Map<String, Object> param) throws Exception {
        log.info("===========ProjectReportServiceImpl===listByType= param {}", param);
        List<ProjectReport> projectReports = this.projectReportMapper.query(param);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.projectReportMapper.count(param));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(projectReports);
        return queryResult;
    }

    @Override
    public ProjectReport getById(Long id) throws Exception {
        ProjectReport pr = this.projectReportMapper.selectByPrimaryKey(id);
        if (pr == null) {
            return null;
        }
        List<ProjectReportItem> items = this.projectReportItemMapper.selectByReportId(id);
        if (items != null && !items.isEmpty()) {
            for (ProjectReportItem it : items) {
                log.info("=======ProjectReport=getById==it.getId()=={}", (Object)it.getId());
                List<ProjectReportItemOrder> orders = this.projectReportItemOrderMapper.selectByItemId(it.getId());
                log.info("==========orders=={}", (Object)JSONObject.toJSONString(orders));
                it.setItemOrders(orders);
            }
        }
        pr.setItems(items);
        log.info("===========ProjectReport==={}", (Object)JSONObject.toJSONString((Object)pr));
        return pr;
    }

    @Override
    public ProjectReport getReportById(Long id) throws Exception {
        return this.projectReportMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public ProjectReport submit(ProjectReportDomain projectReportDomain) throws Exception {
        ProjectReport pr = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.updateByPrimaryKeySelective(pr);
        if (projectReportDomain.getItems() != null) {
            this.replaceItems(pr.getId(), projectReportDomain.getItems());
        }
        return pr;
    }

    @Override
    @Transactional
    public ProjectReport reject(ProjectReportDomain projectReportDomain) throws Exception {
        ProjectReport updated = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.updateByPrimaryKeySelective(updated);
        return updated;
    }

    @Override
    @Transactional
    public ProjectReport approve(ProjectReportDomain projectReportDomain) throws Exception {
        ProjectReport updated = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.updateByPrimaryKeySelective(updated);
        return updated;
    }

    @Override
    public DuplicateCheckResult duplicateCheck(Long id) throws Exception {
        ProjectReport base = this.projectReportMapper.selectByPrimaryKey(id);
        if (base == null) {
            throw new IllegalArgumentException("\u62a5\u5907\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("province", base.getProvince());
        map.put("city", base.getCity());
        map.put("district", base.getDistrict());
        map.put("address", base.getAddressDetail());
        List<ProjectReport> candidates = this.projectReportMapper.query(map);
        ArrayList<SimilarReport> similarReports = new ArrayList<SimilarReport>();
        for (ProjectReport other : candidates) {
            double sim = TextSimilarityUtils.calcSimilarity(base, other);
            SimilarReport sr = new SimilarReport();
            sr.setReport(other);
            sr.setSimilarity(sim);
            similarReports.add(sr);
        }
        similarReports.sort((a, b) -> Double.compare(b.getSimilarity(), a.getSimilarity()));
        DuplicateCheckResult result = new DuplicateCheckResult();
        result.setBaseReport(base);
        result.setSimilarReports(similarReports);
        return result;
    }

    @Override
    public ProjectReport updateReport(ProjectReportDomain projectReportDomain) throws Exception {
        log.error("=========={}=========", (Object)projectReportDomain);
        ProjectReport updated = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.updateByPrimaryKeySelective(updated);
        if (projectReportDomain.getItems() != null) {
            this.replaceItems(updated.getId(), projectReportDomain.getItems());
        }
        return updated;
    }

    @Override
    public void updateReportPrice(List<ProjectReportItemDomain> projectReportItems) throws Exception {
        for (ProjectReportItemDomain itemDomain : projectReportItems) {
            this.projectReportItemMapper.updateByPrimaryKeySelective(ProjectReportItemAssembler.toEntity(itemDomain));
        }
    }

    @Override
    public void saveProjectReportItemOrders(List<ProjectReportItemDomain> projectReportItems) throws Exception {
    }

    @Override
    public void saveReportItemOrders(List<ProjectReportItemOrderDomain> projectReportItemOrderDomain) throws Exception {
        log.info("==========saveReportItemOrders==========={}=========", (Object)JSONObject.toJSONString(projectReportItemOrderDomain));
        List<ProjectReportItemOrder> orders = projectReportItemOrderDomain.stream().map(order -> {
            ProjectReportItemOrder orderItem = new ProjectReportItemOrder();
            BeanUtils.copyProperties((Object)order, (Object)orderItem);
            return orderItem;
        }).collect(Collectors.toList());
        this.projectReportItemOrderMapper.insertBatch(orders);
    }

    @Override
    public void batchUpdateStatusAndReason(List<ProjectReportDomain> reports) throws Exception {
        List<ProjectReport> list = reports.stream().map(item -> {
            ProjectReport pr = ProjectReportAssembler.toEntity(item);
            pr.setStatus(ProjectReportStatus.FOLLOWING.getCode());
            pr.setRefuseReason("");
            return pr;
        }).collect(Collectors.toList());
        this.projectReportMapper.batchUpdateStatusAndReason(list);
    }

    private void replaceItems(Long reportId, List<ProjectReportItemDomain> itemDomains) {
        this.projectReportItemOrderMapper.deleteByReportId(reportId);
        this.projectReportItemMapper.deleteByReportId(reportId);
        if (itemDomains == null || itemDomains.isEmpty()) {
            return;
        }
        for (ProjectReportItemDomain itemDomain : itemDomains) {
            ProjectReportItem itemEntity = ProjectReportItemAssembler.toEntity(itemDomain);
            itemEntity.setReportId(reportId);
            itemEntity.setCreatedAt(new Date());
            itemEntity.setUpdatedAt(new Date());
            itemEntity.setVersion(reportId.intValue());
            this.projectReportItemMapper.insert(itemEntity);
            if (itemDomain.getOrders() == null || itemDomain.getOrders().isEmpty()) continue;
            List<ProjectReportItemOrder> orders = itemDomain.getOrders().stream().map(ProjectReportItemOrderAssembler::toEntity).collect(Collectors.toList());
            for (ProjectReportItemOrder o : orders) {
                o.setReportItemId(itemEntity.getId());
                o.setOrderedQty(0);
            }
            this.projectReportItemOrderMapper.insertBatch(orders);
        }
    }

    public void setProjectReportMapper(ProjectReportMapper projectReportMapper) {
        this.projectReportMapper = projectReportMapper;
    }

    public void setProjectReportItemMapper(ProjectReportItemMapper projectReportItemMapper) {
        this.projectReportItemMapper = projectReportItemMapper;
    }

    public void setProjectReportItemOrderMapper(ProjectReportItemOrderMapper projectReportItemOrderMapper) {
        this.projectReportItemOrderMapper = projectReportItemOrderMapper;
    }

    public void setPriceSheetMapper(PriceSheetMapper priceSheetMapper) {
        this.priceSheetMapper = priceSheetMapper;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }
}

