/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.biz;

import com.yqbsoft.laser.service.contract.dao.OcApprovalBizSnapshotMapper;
import com.yqbsoft.laser.service.contract.dao.OcApprovalInstanceMapper;
import com.yqbsoft.laser.service.contract.dao.OcApprovalLogMapper;
import com.yqbsoft.laser.service.contract.enums.ApprovalTypeEnum;
import com.yqbsoft.laser.service.contract.handler.ApprovalBizHandler;
import com.yqbsoft.laser.service.contract.model.OcApprovalBizSnapshot;
import com.yqbsoft.laser.service.contract.model.OcApprovalDetail;
import com.yqbsoft.laser.service.contract.model.OcApprovalInstance;
import com.yqbsoft.laser.service.contract.model.OcApprovalLog;
import com.yqbsoft.laser.service.contract.requery.ApprovalApplyRequest;
import com.yqbsoft.laser.service.contract.requery.ApprovalApproveRequest;
import com.yqbsoft.laser.service.contract.requery.ApprovalRejectRequest;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApprovalServiceBiz {
    private final OcApprovalInstanceMapper instanceMapper;
    private final OcApprovalLogMapper logMapper;
    private final OcApprovalBizSnapshotMapper snapshotMapper;
    private final Map<String, ApprovalBizHandler> handlerMap;

    @Transactional
    public OcApprovalInstance applyApproval(ApprovalApplyRequest applyRequest) throws Exception {
        ApprovalBizHandler handler = this.getHandler(ApprovalTypeEnum.require(applyRequest.getApprovalType()));
        handler.validateBeforeApply(applyRequest.getBizId());
        List<OcApprovalInstance> existingList = this.instanceMapper.selectByBizId(applyRequest.getBizId());
        int nextVersion = 1;
        if (existingList != null && !existingList.isEmpty()) {
            nextVersion = existingList.stream().mapToInt(OcApprovalInstance::getApprovalVersion).max().orElse(0) + 1;
        }
        String snapshotJson = handler.buildBizSnapshot(applyRequest.getBizId());
        OcApprovalInstance instance = new OcApprovalInstance();
        instance.setApprovalType(applyRequest.getApprovalType());
        instance.setBizId(applyRequest.getBizId());
        instance.setBizType(handler.getBizType());
        instance.setApplyUserId(applyRequest.getApplyUserId());
        instance.setApplyUserName(applyRequest.getApplyUserName());
        instance.setApplyTime(new Date());
        instance.setStatus("PENDING");
        instance.setApprovalVersion(nextVersion);
        instance.setBizSnapshot(snapshotJson);
        instance.setApplyReason(applyRequest.getApplyReason());
        instance.setTenantId(applyRequest.getTenantId());
        this.instanceMapper.insert(instance);
        this.addLog(instance.getId(), "CREATE", applyRequest.getApplyUserId(), applyRequest.getApplyUserName(), "\u53d1\u8d77\u7b2c" + nextVersion + "\u6b21" + ApprovalTypeEnum.require(applyRequest.getApprovalType()).getDesc() + "\u5ba1\u6279");
        this.saveBizSnapshot(instance.getId(), applyRequest.getApprovalType(), snapshotJson);
        return instance;
    }

    @Transactional
    public void approve(ApprovalApproveRequest approveRequest) {
        OcApprovalInstance instance = this.instanceMapper.selectById(approveRequest.getApprovalId());
        instance.setStatus("APPROVED");
        instance.setResult("APPROVED");
        instance.setApproverId(approveRequest.getUserId());
        instance.setApproverName(approveRequest.getUserName());
        instance.setCommentText(approveRequest.getRemark());
        instance.setApproveTime(new Date());
        this.instanceMapper.updateStatus(instance);
        ApprovalBizHandler handler = this.getHandler(instance.getApprovalType());
        handler.onApproved(instance.getBizId());
        this.addLog(approveRequest.getApprovalId(), "APPROVE", approveRequest.getUserId(), approveRequest.getUserName(), approveRequest.getRemark());
        this.saveBizSnapshot(instance.getId(), instance.getApprovalType(), instance.getBizSnapshot());
    }

    @Transactional
    public void reject(ApprovalRejectRequest rejectRequest) {
        OcApprovalInstance instance = this.instanceMapper.selectById(rejectRequest.getApprovalId());
        if (!"PENDING".equals(instance.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u5ba1\u6279\u72b6\u6001\u4e0d\u53ef\u62d2\u7edd");
        }
        instance.setStatus("REJECTED");
        instance.setResult("REJECTED");
        instance.setApproverId(rejectRequest.getUserId());
        instance.setApproverName(rejectRequest.getUserName());
        instance.setCommentText(rejectRequest.getReason());
        instance.setApproveTime(new Date());
        this.instanceMapper.updateStatus(instance);
        ApprovalBizHandler handler = this.getHandler(instance.getApprovalType());
        handler.onRejected(instance.getBizId());
        this.addLog(rejectRequest.getApprovalId(), "REJECT", rejectRequest.getUserId(), rejectRequest.getUserName(), rejectRequest.getUserName());
        this.saveBizSnapshot(instance.getId(), instance.getApprovalType(), instance.getBizSnapshot());
    }

    public SupQueryResult<OcApprovalInstance> getApprovalList(Map<String, Object> map) {
        List<OcApprovalInstance> list = this.instanceMapper.query(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.instanceMapper.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    public OcApprovalDetail getApprovalDetail(Long approvalId) {
        OcApprovalInstance instance = this.instanceMapper.selectById(approvalId);
        List<OcApprovalBizSnapshot> snapshotList = this.snapshotMapper.selectByApprovalId(approvalId);
        String snapshotData = "";
        if (snapshotList != null && !snapshotList.isEmpty()) {
            OcApprovalBizSnapshot snapshot = snapshotList.get(0);
            snapshotData = snapshot.getSnapshotData();
        }
        OcApprovalDetail detail = new OcApprovalDetail();
        detail.setApprovalInstance(instance);
        detail.setSnapshotData(snapshotData);
        return detail;
    }

    private void saveBizSnapshot(Long approvalId, String snapshotType, String snapshotData) {
        OcApprovalBizSnapshot snapshot = new OcApprovalBizSnapshot();
        snapshot.setApprovalId(approvalId);
        snapshot.setSnapshotType(snapshotType);
        snapshot.setSnapshotData(snapshotData);
        snapshot.setCreateTime(new Date());
        this.snapshotMapper.insert(snapshot);
    }

    private void addLog(Long approvalId, String op, String userId, String userName, String detail) {
        OcApprovalLog log = new OcApprovalLog();
        log.setApprovalId(approvalId);
        log.setOperation(op);
        log.setOperatorId(userId);
        log.setOperatorName(userName);
        log.setDetail(detail);
        this.logMapper.insert(log);
    }

    private ApprovalBizHandler getHandler(ApprovalTypeEnum type) {
        String key = type.name().toLowerCase() + "Handler";
        ApprovalBizHandler handler = this.handlerMap.get(key);
        if (handler == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5ba1\u6279\u5904\u7406\u5668: " + type.name());
        }
        return handler;
    }

    private ApprovalBizHandler getHandler(String typeCode) {
        String key = typeCode.toLowerCase() + "Handler";
        ApprovalBizHandler handler = this.handlerMap.get(key);
        if (handler == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5ba1\u6279\u5904\u7406\u5668: " + typeCode);
        }
        return handler;
    }

    public ApprovalServiceBiz(OcApprovalInstanceMapper instanceMapper, OcApprovalLogMapper logMapper, OcApprovalBizSnapshotMapper snapshotMapper, Map<String, ApprovalBizHandler> handlerMap) {
        this.instanceMapper = instanceMapper;
        this.logMapper = logMapper;
        this.snapshotMapper = snapshotMapper;
        this.handlerMap = handlerMap;
    }
}

