/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.handler.ApprovalBizHandler;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="priceHandler")
public class PriceApprovalHandler
implements ApprovalBizHandler {
    private final OcContractService contractService;
    private final OcContractEngineService contractEngineService;

    @Override
    public String getBizType() {
        return "ORDER";
    }

    @Override
    public void validateBeforeApply(String bizId) {
    }

    @Override
    public String buildBizSnapshot(String bizId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", bizId);
        OcContractReDomain ocContract = this.contractService.getContractByCode(map);
        if (null == ocContract) {
            throw new IllegalArgumentException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01\u8ba2\u5355\u53f7\uff1a" + bizId);
        }
        return JSONObject.toJSONString((Object)ocContract);
    }

    @Override
    public void onApproved(String bizId) {
        this.contractEngineService.sendContractNext(bizId, "", null);
    }

    @Override
    public void onRejected(String bizId) {
        this.contractEngineService.sendContractBack(bizId, "", null);
    }

    public PriceApprovalHandler(OcContractService contractService, OcContractEngineService contractEngineService) {
        this.contractService = contractService;
        this.contractEngineService = contractEngineService;
    }
}

