/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.handler.ApprovalBizHandler;
import com.yqbsoft.laser.service.contract.model.OcApprovalInstance;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="priceHandler")
public class PriceApprovalHandler
implements ApprovalBizHandler {
    private static final Logger log = LoggerFactory.getLogger(PriceApprovalHandler.class);
    private final OcContractService contractService;
    private final OcContractEngineService contractEngineService;

    @Override
    public String getBizType() {
        return "ORDER";
    }

    @Override
    public String validateBeforeApply(String bizId) {
        OcContractReDomain ocContractReDomain = this.getContractByCode(bizId);
        return JSONObject.toJSONString((Object)ocContractReDomain);
    }

    @Override
    public void onApproved(OcApprovalInstance instance) {
        log.info("==============PriceApprovalHandler =========onApproved {}", (Object)instance.getBizId());
        this.handleContractStatus(instance.getBizId(), "3");
        this.contractEngineService.sendContractNext(instance.getBizId(), instance.getTenantId(), null);
    }

    @Override
    public void onRejected(OcApprovalInstance instance) {
        this.handleContractStatus(instance.getBizId(), "4");
        this.contractEngineService.sendContractBack(instance.getBizId(), instance.getTenantId(), null);
    }

    private OcContractReDomain getContractByCode(String bizId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", bizId);
        OcContractReDomain contract = this.contractService.getContractByCode(map);
        if (contract == null) {
            throw new IllegalArgumentException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01\u8ba2\u5355\u53f7\uff1a" + bizId);
        }
        return contract;
    }

    private void handleContractStatus(String bizId, String goodsPbillno) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", bizId);
        map.put("goodsPbillno", goodsPbillno);
        this.contractService.updateContractByCode(map);
    }

    public PriceApprovalHandler(OcContractService contractService, OcContractEngineService contractEngineService) {
        this.contractService = contractService;
        this.contractEngineService = contractEngineService;
    }
}

