/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.enums;

public enum ProjectReportStatus {
    DRAFT(1, "\u5236\u8ba2"),
    MARKETING_CHECK(2, "\u8425\u9500\u4e2d\u5fc3\u67e5\u91cd"),
    DEALER_CONFIRM(3, "\u7ecf\u9500\u5546\u786e\u8ba4"),
    FOLLOWING(4, "\u9879\u76ee\u8ddf\u8fdb"),
    BIDDING(5, "\u9879\u76ee\u6295\u6807"),
    SAMPLE_ROOM(6, "\u9879\u76ee\u6837\u677f\u95f4"),
    CONTRACTING(7, "\u5408\u540c\u6267\u884c"),
    FAILED(8, "\u5931\u8d25");

    private final int code;
    private final String desc;

    private ProjectReportStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ProjectReportStatus fromCode(int code) {
        for (ProjectReportStatus s : ProjectReportStatus.values()) {
            if (s.code != code) continue;
            return s;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u72b6\u6001: " + code);
    }

    public ProjectReportStatus next() {
        switch (this) {
            case DRAFT: {
                return MARKETING_CHECK;
            }
            case MARKETING_CHECK: {
                return DEALER_CONFIRM;
            }
            case DEALER_CONFIRM: {
                return FOLLOWING;
            }
            case FOLLOWING: {
                return BIDDING;
            }
            case BIDDING: {
                return SAMPLE_ROOM;
            }
            case SAMPLE_ROOM: {
                return CONTRACTING;
            }
        }
        throw new IllegalStateException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u524d\u8fdb: " + (Object)((Object)this));
    }

    public ProjectReportStatus previous() {
        switch (this) {
            case MARKETING_CHECK: {
                return DRAFT;
            }
            case DEALER_CONFIRM: {
                return MARKETING_CHECK;
            }
            case FOLLOWING: {
                return DEALER_CONFIRM;
            }
            case BIDDING: {
                return FOLLOWING;
            }
            case SAMPLE_ROOM: {
                return BIDDING;
            }
            case CONTRACTING: {
                return SAMPLE_ROOM;
            }
        }
        throw new IllegalStateException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u56de\u9000: " + (Object)((Object)this));
    }

    public boolean isFailed() {
        return this == FAILED;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

