/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.EngineeringContractMapper;
import com.yqbsoft.laser.service.contract.domain.EngineeringContractDomain;
import com.yqbsoft.laser.service.contract.domain.EngineeringContractReDomain;
import com.yqbsoft.laser.service.contract.model.EngineeringContract;
import com.yqbsoft.laser.service.contract.service.EngineeringContractService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EngineeringContractServiceImpl
extends BaseServiceImpl
implements EngineeringContractService {
    private static final String SYS_CODE = "oc.CONTRACT.EngineeringContractServiceImpl";
    private EngineeringContractMapper engineeringContractMapper;

    public void setEngineeringContractMapper(EngineeringContractMapper engineeringContractMapper) {
        this.engineeringContractMapper = engineeringContractMapper;
    }

    private Date getSysDate() {
        try {
            return this.engineeringContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkEngineeringContract(EngineeringContractDomain engineeringContractDomain) {
        if (null == engineeringContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)engineeringContractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEngineeringContractDefault(EngineeringContract engineeringContract) {
        if (null == engineeringContract) {
            return;
        }
        if (null == engineeringContract.getDataState()) {
            engineeringContract.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == engineeringContract.getGmtCreate()) {
            engineeringContract.setGmtCreate(date);
        }
        engineeringContract.setGmtModified(date);
        if (StringUtils.isBlank((String)engineeringContract.getEngineeringContractCode())) {
            engineeringContract.setEngineeringContractCode(this.getNo(null, "EngineeringContract", "engineeringContract", engineeringContract.getTenantCode()));
        }
    }

    private int getEngineeringContractMaxCode() {
        int code = 0;
        try {
            return this.engineeringContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.getEngineeringContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEngineeringContractUpdataDefault(EngineeringContract engineeringContract) {
        if (null == engineeringContract) {
            return;
        }
        engineeringContract.setGmtModified(this.getSysDate());
    }

    private void saveEngineeringContractModel(EngineeringContract engineeringContract) throws ApiException {
        if (null == engineeringContract) {
            return;
        }
        try {
            this.engineeringContractMapper.insert(engineeringContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.saveEngineeringContractModel.ex", (Throwable)e);
        }
    }

    private void saveEngineeringContractBatchModel(List<EngineeringContract> engineeringContractList) throws ApiException {
        if (null == engineeringContractList || engineeringContractList.isEmpty()) {
            return;
        }
        try {
            this.engineeringContractMapper.insertBatch(engineeringContractList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.saveEngineeringContractBatchModel.ex", (Throwable)e);
        }
    }

    private EngineeringContract getEngineeringContractModelById(Long engineeringContractId) {
        if (null == engineeringContractId) {
            return null;
        }
        try {
            return this.engineeringContractMapper.selectByPrimaryKey(engineeringContractId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.getEngineeringContractModelById", (Throwable)e);
            return null;
        }
    }

    private EngineeringContract getEngineeringContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.engineeringContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.getEngineeringContractModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEngineeringContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.engineeringContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.delEngineeringContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.delEngineeringContractModelByCode.num");
        }
    }

    private void deleteEngineeringContractModel(Long engineeringContractId) throws ApiException {
        if (null == engineeringContractId) {
            return;
        }
        int i = 0;
        try {
            i = this.engineeringContractMapper.deleteByPrimaryKey(engineeringContractId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.deleteEngineeringContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.deleteEngineeringContractModel.num");
        }
    }

    private void updateEngineeringContractModel(EngineeringContract engineeringContract) throws ApiException {
        if (null == engineeringContract) {
            return;
        }
        int i = 0;
        try {
            i = this.engineeringContractMapper.updateByPrimaryKey(engineeringContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateEngineeringContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateEngineeringContractModel.num");
        }
    }

    private void updateStateEngineeringContractModel(Long engineeringContractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == engineeringContractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("engineeringContractId", engineeringContractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.engineeringContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateStateEngineeringContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateStateEngineeringContractModel.null");
        }
    }

    private void updateStateEngineeringContractModelByCode(String tenantCode, String engineeringContractCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)engineeringContractCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("engineeringContractCode", engineeringContractCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.engineeringContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateStateEngineeringContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateStateEngineeringContractModelByCode.null");
        }
    }

    private EngineeringContract makeEngineeringContract(EngineeringContractDomain engineeringContractDomain, EngineeringContract engineeringContract) {
        if (null == engineeringContractDomain) {
            return null;
        }
        if (null == engineeringContract) {
            engineeringContract = new EngineeringContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)engineeringContract, (Object)engineeringContractDomain);
            return engineeringContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.makeEngineeringContract", (Throwable)e);
            return null;
        }
    }

    private EngineeringContractReDomain makeEngineeringContractReDomain(EngineeringContract engineeringContract) {
        if (null == engineeringContract) {
            return null;
        }
        EngineeringContractReDomain engineeringContractReDomain = new EngineeringContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)engineeringContractReDomain, (Object)engineeringContract);
            return engineeringContractReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.makeEngineeringContractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<EngineeringContract> queryEngineeringContractModelPage(Map<String, Object> parammap) {
        try {
            return this.engineeringContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.queryEngineeringContractModel", (Throwable)e);
            return null;
        }
    }

    private int countEngineeringContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.engineeringContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.EngineeringContractServiceImpl.countEngineeringContract", (Throwable)e);
        }
        return i;
    }

    private EngineeringContract createEngineeringContract(EngineeringContractDomain engineeringContractDomain) {
        String msg = this.checkEngineeringContract(engineeringContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.saveEngineeringContract.checkEngineeringContract", msg);
        }
        EngineeringContract engineeringContract = this.makeEngineeringContract(engineeringContractDomain, null);
        this.setEngineeringContractDefault(engineeringContract);
        return engineeringContract;
    }

    @Override
    public String saveEngineeringContract(EngineeringContractDomain engineeringContractDomain) throws ApiException {
        EngineeringContract engineeringContract = this.createEngineeringContract(engineeringContractDomain);
        this.saveEngineeringContractModel(engineeringContract);
        return engineeringContract.getEngineeringContractCode();
    }

    @Override
    public String saveEngineeringContractBatch(List<EngineeringContractDomain> engineeringContractDomainList) throws ApiException {
        if (null == engineeringContractDomainList || engineeringContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<EngineeringContract> engineeringContractList = new ArrayList<EngineeringContract>();
        String code = "";
        for (EngineeringContractDomain engineeringContractDomain : engineeringContractDomainList) {
            EngineeringContract engineeringContract = this.createEngineeringContract(engineeringContractDomain);
            code = engineeringContract.getEngineeringContractCode();
            engineeringContractList.add(engineeringContract);
        }
        this.saveEngineeringContractBatchModel(engineeringContractList);
        return code;
    }

    @Override
    public void updateEngineeringContractState(Long engineeringContractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == engineeringContractId) {
            return;
        }
        this.updateStateEngineeringContractModel(engineeringContractId, dataState, oldDataState, map);
    }

    @Override
    public void updateEngineeringContractStateByCode(String tenantCode, String engineeringContractCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)engineeringContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateEngineeringContractModelByCode(tenantCode, engineeringContractCode, dataState, oldDataState, map);
    }

    @Override
    public void updateEngineeringContract(EngineeringContractDomain engineeringContractDomain) throws ApiException {
        String msg = this.checkEngineeringContract(engineeringContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateEngineeringContract.checkEngineeringContract", msg);
        }
        EngineeringContract oldEngineeringContract = this.getEngineeringContractModelById(engineeringContractDomain.getEngineeringContractId());
        if (null == oldEngineeringContract) {
            throw new ApiException("oc.CONTRACT.EngineeringContractServiceImpl.updateEngineeringContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EngineeringContract engineeringContract = this.makeEngineeringContract(engineeringContractDomain, oldEngineeringContract);
        this.setEngineeringContractUpdataDefault(engineeringContract);
        this.updateEngineeringContractModel(engineeringContract);
    }

    @Override
    public EngineeringContract getEngineeringContract(Long engineeringContractId) {
        if (null == engineeringContractId) {
            return null;
        }
        return this.getEngineeringContractModelById(engineeringContractId);
    }

    @Override
    public void deleteEngineeringContract(Long engineeringContractId) throws ApiException {
        if (null == engineeringContractId) {
            return;
        }
        this.deleteEngineeringContractModel(engineeringContractId);
    }

    @Override
    public QueryResult<EngineeringContract> queryEngineeringContractPage(Map<String, Object> map) {
        List<EngineeringContract> engineeringContractList = this.queryEngineeringContractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEngineeringContract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(engineeringContractList);
        return queryResult;
    }

    @Override
    public EngineeringContract getEngineeringContractByCode(String tenantCode, String engineeringContractCode) throws ApiException {
        if (StringUtils.isBlank((String)engineeringContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("engineeringContractCode", engineeringContractCode);
        return this.getEngineeringContractModelByCode(map);
    }

    @Override
    public void deleteEngineeringContractByCode(String tenantCode, String engineeringContractCode) throws ApiException {
        if (StringUtils.isBlank((String)engineeringContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("engineeringContractCode", engineeringContractCode);
        this.delEngineeringContractModelByCode(map);
    }
}

