/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.factory;

import com.yqbsoft.laser.service.contract.core.PayChannel;
import com.yqbsoft.laser.service.contract.handler.payment.PaymentHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PaymentHandlerFactory {
    private final List<PaymentHandler> handlers;
    private Map<String, PaymentHandler> map;

    private void initIfNeeded() {
        if (this.map != null) {
            return;
        }
        this.map = this.handlers.stream().collect(Collectors.toMap(h -> {
            PayChannel ann = h.getClass().getAnnotation(PayChannel.class);
            if (ann == null) {
                throw new RuntimeException("Missing @PayChannel on handler: " + h.getClass().getName());
            }
            return ann.value().getCode();
        }, h -> h));
    }

    public PaymentHandler getHandler(String channel) {
        this.initIfNeeded();
        return this.map.get(channel);
    }

    public PaymentHandlerFactory(List<PaymentHandler> handlers) {
        this.handlers = handlers;
    }
}

