/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler.approval;

import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.handler.approval.ApprovalBizHandler;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractApprovalHandler
implements ApprovalBizHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractContractApprovalHandler.class);
    protected final OcContractService contractService;
    protected final OcContractEngineService contractEngineService;

    @Override
    public abstract String getBizType();

    protected OcContractReDomain getContractByCode(String bizId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", bizId);
        OcContractReDomain contract = this.contractService.getContractByCode(map);
        if (contract == null) {
            throw new IllegalArgumentException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01\u8ba2\u5355\u53f7\uff1a" + bizId);
        }
        return contract;
    }

    protected void handleContractStatus(String bizId, String goodsPbillno) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", bizId);
        map.put("goodsPbillno", goodsPbillno);
        this.contractService.updateContractByCode(map);
    }

    public AbstractContractApprovalHandler(OcContractService contractService, OcContractEngineService contractEngineService) {
        this.contractService = contractService;
        this.contractEngineService = contractEngineService;
    }
}

